/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.MissingResourceException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.ui.query.FindInQueryBar;
import org.netbeans.modules.bugtracking.ui.query.FindInQuerySupport;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponentScrollPane;
import org.netbeans.modules.bugtracking.ui.query.RepoPanel;
import org.netbeans.modules.bugtracking.ui.query.ViewportWidthAwarePanel;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.netbeans.modules.bugtracking.util.LogUtils;
import org.netbeans.modules.bugtracking.util.PlaceholderPanel;
import org.netbeans.modules.bugtracking.util.RepositoryComboSupport;
import org.openide.awt.Mnemonics;
import org.openide.util.Cancellable;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class QueryTopComponent
extends TopComponent
implements PropertyChangeListener,
FocusListener {
    private static QueryTopComponent instance;
    private static Set<QueryTopComponent> openQueries;
    private final FindInQuerySupport findInQuerySupport;
    private final RepoPanel repoPanel;
    private final JPanel jPanel2;
    private final LinkButton newButton;
    private final PlaceholderPanel panel;
    private final JComboBox repositoryComboBox;
    private final JScrollPane scrollPane;
    private QueryImpl[] savedQueries = null;
    private static final String PREFERRED_ID = "QueryTopComponent";
    private QueryImpl query;
    private static final Object LOCK;
    private RequestProcessor rp = new RequestProcessor("Bugtracking query", 1, true);
    private RequestProcessor.Task prepareTask;
    private RepositoryComboSupport rs;
    private File context;

    QueryTopComponent() {
        RepositoryRegistry.getInstance().addPropertyChangeListener(this);
        this.repositoryComboBox = new JComboBox();
        this.newButton = new LinkButton();
        JLabel title = new JLabel();
        Font titleFont = title.getFont();
        title.setFont(titleFont.deriveFont(1.7f * (float)titleFont.getSize()));
        title.setBorder(BorderFactory.createEmptyBorder(0, QueryTopComponent.getLeftContainerGap(title), 0, 0));
        this.repoPanel = new RepoPanel(this.repositoryComboBox, this.newButton);
        this.panel = new PlaceholderPanel();
        this.jPanel2 = new ViewportWidthAwarePanel(null){

            @Override
            protected void notifyChildrenOfVisibleWidth() {
                QueryTopComponent.this.repoPanel.setAvailableWidth(this.getAvailableWidth());
            }
        };
        this.jPanel2.setLayout(new BoxLayout(this.jPanel2, 1));
        this.jPanel2.add(QueryTopComponent.createVerticalStrut(null, title));
        this.jPanel2.add(title);
        this.jPanel2.add(QueryTopComponent.createVerticalStrut(title, this.repoPanel));
        this.jPanel2.add(this.repoPanel);
        this.jPanel2.add(QueryTopComponent.createVerticalStrut(this.repoPanel, this.panel));
        this.jPanel2.add(this.panel);
        title.setAlignmentX(0.0f);
        this.repoPanel.setAlignmentX(0.0f);
        this.panel.setAlignmentX(0.0f);
        this.scrollPane = new QueryTopComponentScrollPane(this.jPanel2);
        this.setLayout(new BoxLayout((Container)((Object)this), 1));
        this.add(this.scrollPane);
        this.findInQuerySupport = FindInQuerySupport.create(this);
        FindInQueryBar findBar = this.findInQuerySupport.getFindBar();
        findBar.setVisible(false);
        this.add(findBar);
        Mnemonics.setLocalizedText((JLabel)title, (String)QueryTopComponent.getBundleText("QueryTopComponent.findIssuesLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.newButton, (String)QueryTopComponent.getBundleText("QueryTopComponent.newButton.text_1"));
        this.repositoryComboBox.getAccessibleContext().setAccessibleDescription(QueryTopComponent.getBundleText("QueryTopComponent.repositoryComboBox.AccessibleContext.accessibleDescription"));
        this.newButton.getAccessibleContext().setAccessibleDescription(QueryTopComponent.getBundleText("QueryTopComponent.newButton.AccessibleContext.accessibleDescription"));
        Color editorBgColor = UIManager.getDefaults().getColor("EditorPane.background");
        this.repoPanel.setBackground(editorBgColor);
        this.panel.setBackground(editorBgColor);
        this.jPanel2.setBackground(editorBgColor);
        this.repoPanel.setNextFocusableComponent(this.newButton);
        int unitIncrement = (int)(1.5f * (float)titleFont.getSize() + 0.5f);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(unitIncrement);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(unitIncrement);
    }

    private static int getLeftContainerGap(JComponent comp) {
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        return layoutStyle.getContainerGap(comp, 7, null);
    }

    private static Component createVerticalStrut(JComponent above, JComponent below) {
        LayoutStyle layoutStyle = LayoutStyle.getInstance();
        int height = above == null ? layoutStyle.getContainerGap(below, 1, null) : (below == null ? layoutStyle.getContainerGap(above, 5, null) : layoutStyle.getPreferredGap(above, below, LayoutStyle.ComponentPlacement.RELATED, 5, null));
        return Box.createVerticalStrut(height);
    }

    public static Set<QueryTopComponent> getOpenQueries() {
        return openQueries;
    }

    public QueryImpl getQuery() {
        return this.query;
    }

    void init(QueryImpl query, RepositoryImpl defaultRepository, File context, boolean suggestedSelectionOnly) {
        this.query = query;
        this.context = context;
        this.setNameAndTooltip();
        if (suggestedSelectionOnly) {
            this.repositoryComboBox.setEnabled(false);
            this.newButton.setEnabled(false);
        }
        if (query != null) {
            if (query.isSaved()) {
                this.setSaved();
            } else if (!suggestedSelectionOnly) {
                this.rs = RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository.getRepository());
            }
            QueryController c = this.getController(query);
            this.panel.setComponent(c.getComponent());
            this.query.addPropertyChangeListener(this);
            this.findInQuerySupport.setQuery(query);
        } else {
            this.newButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryTopComponent.this.onNewClick();
                }
            });
            this.repositoryComboBox.addItemListener(new ItemListener(){

                @Override
                public void itemStateChanged(ItemEvent e) {
                    Object item;
                    if (e.getStateChange() == 1) {
                        Object item2 = e.getItem();
                        if (item2 instanceof Repository) {
                            QueryTopComponent.this.onRepoSelected();
                        }
                    } else if (e.getStateChange() == 2 && (item = e.getItem()) instanceof Repository) {
                        ((Repository)item).removePropertyChangeListener(QueryTopComponent.this);
                    }
                }
            });
            this.rs = defaultRepository == null ? RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, true) : RepositoryComboSupport.setup((JComponent)((Object)this), this.repositoryComboBox, defaultRepository.getRepository());
            this.newButton.addFocusListener(this);
            this.repositoryComboBox.addFocusListener(this);
        }
        Repository repo = null;
        if (query != null) {
            repo = query.getRepositoryImpl().getRepository();
        } else if (defaultRepository != null) {
            repo = defaultRepository.getRepository();
        }
        LogUtils.logBugtrackingUsage(repo, "ISSUE_QUERY");
    }

    private QueryController getController(QueryImpl query) {
        return query.getController();
    }

    private static String getBundleText(String key) {
        return NbBundle.getMessage(QueryTopComponent.class, (String)key);
    }

    public static synchronized QueryTopComponent getDefault() {
        if (instance == null) {
            instance = new QueryTopComponent();
        }
        return instance;
    }

    public static synchronized QueryTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(QueryTopComponent.class.getName()).warning("Cannot find QueryTopComponent component. It will not be located properly in the window system.");
            return QueryTopComponent.getDefault();
        }
        if (win instanceof QueryTopComponent) {
            return (QueryTopComponent)win;
        }
        Logger.getLogger(QueryTopComponent.class.getName()).warning("There seem to be multiple components with the 'QueryTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return QueryTopComponent.getDefault();
    }

    public static synchronized QueryTopComponent find(QueryImpl query) {
        for (QueryTopComponent tc : openQueries) {
            if (!query.equals(tc.getQuery())) continue;
            return tc;
        }
        return null;
    }

    public int getPersistenceType() {
        return 2;
    }

    public void componentOpened() {
        openQueries.add(this);
        if (this.query != null) {
            this.getController(this.query).opened();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} opened", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    public void componentClosed() {
        openQueries.remove(this);
        if (this.query != null) {
            this.query.removePropertyChangeListener(this);
            this.getController(this.query).closed();
        }
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        BugtrackingManager.LOG.log(Level.FINE, "{0} - {1} closed", new Object[]{this.getClass().getName(), this.query != null ? this.query.getDisplayName() : null});
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return this.query != null && this.query.getDisplayName() != null ? this.query.getDisplayName() : PREFERRED_ID;
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.query.saved")) {
            this.setSaved();
        } else if (evt.getPropertyName().equals("bugtracking.query.removed")) {
            if (this.query != null && this.query.isData(evt.getSource())) {
                this.closeInAwt();
            }
        } else if (evt.getPropertyName().equals("bugtracking.repository.queries.changed")) {
            this.updateSavedQueries();
        } else if (evt.getPropertyName().equals("bugtracking.repositories.changed")) {
            if (this.query != null) {
                Object cOld = evt.getOldValue();
                if (cOld != null && cOld instanceof Collection) {
                    RepositoryImpl thisRepo = this.query.getRepositoryImpl();
                    if (this.contains((Collection)cOld, thisRepo)) {
                        this.closeInAwt();
                    }
                } else if (cOld == null) {
                    RepositoryImpl thisRepo = this.query.getRepositoryImpl();
                    Collection<RepositoryImpl> knownRepos = RepositoryRegistry.getInstance().getKnownRepositories(true);
                    if (!this.contains(knownRepos, thisRepo)) {
                        this.closeInAwt();
                    }
                }
            }
            if (!this.repositoryComboBox.isEnabled()) {
                return;
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (QueryTopComponent.this.rs != null) {
                        QueryTopComponent.this.rs.refreshRepositoryModel();
                    }
                }
            });
        }
    }

    private boolean contains(Collection c, RepositoryImpl r) {
        for (Object o : c) {
            assert (o instanceof RepositoryImpl);
            if (!((RepositoryImpl)o).getId().equals(r.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public void focusGained(FocusEvent e) {
        Component c = e.getComponent();
        if (c instanceof JComponent) {
            Point p = SwingUtilities.convertPoint(c.getParent(), c.getLocation(), this.repoPanel);
            final Rectangle r = new Rectangle(p, c.getSize());
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryTopComponent.this.repoPanel.scrollRectToVisible(r);
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    private void closeInAwt() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryTopComponent.this.close();
            }
        });
    }

    private void onNewClick() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository();
        if (repoImpl != null) {
            Repository repo = repoImpl.getRepository();
            this.repositoryComboBox.addItem(repo);
            this.repositoryComboBox.setSelectedItem(repo);
        }
    }

    private void onRepoSelected() {
        if (this.prepareTask != null) {
            this.prepareTask.cancel();
        }
        Cancellable c = new Cancellable(){

            public boolean cancel() {
                if (QueryTopComponent.this.prepareTask != null) {
                    QueryTopComponent.this.prepareTask.cancel();
                }
                return true;
            }
        };
        final ProgressHandle handle = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_PreparingQuery"), (Cancellable)c);
        this.prepareTask = this.rp.post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    OwnerInfo ownerInfo;
                    handle.start();
                    RepositoryImpl repo = QueryTopComponent.this.getRepository();
                    if (repo == null) {
                        return;
                    }
                    repo.addPropertyChangeListener(QueryTopComponent.this);
                    if (QueryTopComponent.this.query != null) {
                        QueryTopComponent.this.query.removePropertyChangeListener(QueryTopComponent.this);
                    }
                    QueryTopComponent.this.query = repo.createNewQuery();
                    if (QueryTopComponent.this.query == null) {
                        return;
                    }
                    QueryTopComponent.this.findInQuerySupport.setQuery(QueryTopComponent.this.query);
                    if (QueryTopComponent.this.context != null && BugtrackingUtil.isNbRepository(repo.getUrl()) && (ownerInfo = KenaiUtil.getOwnerInfo(QueryTopComponent.this.context)) != null) {
                        QueryTopComponent.this.query.setContext(ownerInfo);
                    }
                    QueryTopComponent.this.query.addPropertyChangeListener(QueryTopComponent.this);
                    QueryTopComponent.this.updateSavedQueriesIntern(repo);
                    final QueryController addController = QueryTopComponent.this.getController(QueryTopComponent.this.query);
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            QueryTopComponent.this.panel.setComponent(addController.getComponent());
                            QueryTopComponent.this.focusFirstEnabledComponent();
                        }
                    });
                }
                finally {
                    handle.finish();
                    QueryTopComponent.this.prepareTask = null;
                }
            }
        });
    }

    private RepositoryImpl getRepository() {
        Object item = this.repositoryComboBox.getSelectedItem();
        if (item == null || !(item instanceof Repository)) {
            return null;
        }
        return APIAccessor.IMPL.getImpl((Repository)item);
    }

    private void focusFirstEnabledComponent() {
        this.repositoryComboBox.requestFocusInWindow();
        if (!this.repositoryComboBox.isEnabled()) {
            this.newButton.requestFocusInWindow();
            if (!this.newButton.isEnabled()) {
                this.newButton.transferFocus();
            }
        }
    }

    private void setNameAndTooltip() throws MissingResourceException {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (QueryTopComponent.this.query != null && QueryTopComponent.this.query.getDisplayName() != null) {
                    QueryTopComponent.this.setName(NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{QueryTopComponent.this.query.getRepositoryImpl().getDisplayName(), QueryTopComponent.this.query.getDisplayName()}));
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"LBL_QueryName", (Object[])new Object[]{QueryTopComponent.this.query.getRepositoryImpl().getDisplayName(), QueryTopComponent.this.query.getTooltip()}));
                } else {
                    QueryTopComponent.this.setName(NbBundle.getMessage(QueryTopComponent.class, (String)"CTL_QueryTopComponent"));
                    QueryTopComponent.this.setToolTipText(NbBundle.getMessage(QueryTopComponent.class, (String)"HINT_QueryTopComponent"));
                }
            }
        });
    }

    private void setSaved() {
        this.jPanel2.removeAll();
        this.jPanel2.add(this.panel);
        this.jPanel2.revalidate();
        this.jPanel2.repaint();
        this.setNameAndTooltip();
    }

    public void updateSavedQueries() {
        final RepositoryImpl repo = this.getRepository();
        if (repo == null) {
            return;
        }
        this.rp.post(new Runnable(){

            @Override
            public void run() {
                QueryTopComponent.this.updateSavedQueriesIntern(repo);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateSavedQueriesIntern(final RepositoryImpl repo) {
        QueryImpl[] finQueries;
        if (repo == null) {
            return;
        }
        BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} start", new Object[]{repo.getDisplayName()});
        Collection<QueryImpl> cq = repo.getQueries();
        QueryImpl[] queries = cq != null ? cq.toArray(new QueryImpl[cq.size()]) : new QueryImpl[]{};
        Object object = LOCK;
        synchronized (object) {
            Arrays.sort(queries, new QueryComparator());
            this.savedQueries = queries;
            finQueries = this.savedQueries;
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                QueryTopComponent.this.repoPanel.setQueries(finQueries);
                if (finQueries == null || finQueries.length == 0) {
                    BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} finnished. No queries.", new Object[]{repo.getDisplayName()});
                } else {
                    BugtrackingManager.LOG.log(Level.FINE, "updateSavedQueries for {0} finnished. {1} saved queries.", new Object[]{repo.getDisplayName(), QueryTopComponent.this.savedQueries.length});
                }
            }
        });
    }

    public boolean requestFocusInWindow() {
        return this.jPanel2.requestFocusInWindow();
    }

    static {
        openQueries = new HashSet<QueryTopComponent>();
        LOCK = new Object();
    }

    private class QueryComparator
    implements Comparator<QueryImpl> {
        private QueryComparator() {
        }

        @Override
        public int compare(QueryImpl q1, QueryImpl q2) {
            if (q1 == null && q2 == null) {
                return 0;
            }
            if (q1 == null) {
                return -1;
            }
            if (q2 == null) {
                return 1;
            }
            return q1.getDisplayName().compareTo(q2.getDisplayName());
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return QueryTopComponent.getDefault();
        }
    }
}

