/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.ui.query;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.PanelUI;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.ui.query.ViewportWidthAwarePanel;
import org.netbeans.modules.bugtracking.util.LinkButton;

class QueryLinksPanel
extends ViewportWidthAwarePanel
implements FocusListener {
    private static final int SEPARATOR_WIDTH = 2;
    private static final int SPACE_AROUND_SEPARATOR = 5;
    private static final int TOTAL_SEPARATOR_WIDTH = 12;
    private static final int INTERLINE_SPACING = 2;
    private RepositoryImpl repository;
    private QueryButton[] buttons;
    private Dimension[] buttonPrefSizes;
    private int[] baselines;
    private int[] rowNumbers;
    private int baseline = -1;
    private int rowHeight = -1;
    private int rowCount = 0;
    private Dimension prefSize;
    private boolean verticalMetricsKnown;

    public QueryLinksPanel() {
        super(null);
        this.setOpaque(false);
    }

    void setQueries(QueryImpl[] queries) {
        boolean queriesChanged;
        if (queries != null && queries.length == 0) {
            queries = null;
        }
        boolean bl = queriesChanged = this.buttons != null || queries != null;
        if (!queriesChanged) {
            return;
        }
        this.invalidateVerticalMetrics();
        this.invalidatePrefSize();
        if (this.buttons != null) {
            this.removeAll();
        }
        if (queries == null) {
            this.buttons = null;
            this.rowNumbers = null;
        } else {
            this.buttons = new QueryButton[queries.length];
            this.rowNumbers = new int[queries.length];
            QueryTopComponent queryTopC = (QueryTopComponent)((Object)SwingUtilities.getAncestorOfClass(QueryTopComponent.class, this));
            for (int i = 0; i < queries.length; ++i) {
                QueryImpl query = queries[i];
                query.addPropertyChangeListener(queryTopC);
                QueryButton button = new QueryButton(this.repository, query);
                button.setText(query.getDisplayName());
                button.addFocusListener(this);
                this.add(button);
                this.buttons[i] = button;
            }
        }
    }

    boolean isEmpty() {
        return this.buttons == null;
    }

    boolean isWrapped() {
        this.validatePrefSize();
        return this.rowCount > 1;
    }

    @Override
    protected void paintChildren(Graphics g) {
        super.paintChildren(g);
        if (this.buttons != null && this.buttons.length > 1) {
            Graphics sg = g.create();
            sg.setColor(Color.BLACK);
            Point tmpPoint = new Point();
            int lastRowNum = 0;
            for (int i = 1; i < this.buttons.length; ++i) {
                int rowNum = this.rowNumbers[i];
                if (rowNum == lastRowNum) {
                    int x = this.buttons[i].getLocation((Point)tmpPoint).x - 7;
                    int y = rowNum * (this.rowHeight + 2);
                    g.fillRect(x, y, 2, this.rowHeight);
                }
                lastRowNum = rowNum;
            }
        }
    }

    @Override
    public Dimension getPreferredSize() {
        this.validatePrefSize();
        return this.prefSize;
    }

    private void validatePrefSize() {
        if (this.prefSize == null) {
            this.computeLayout(false);
        }
    }

    @Override
    public void invalidate() {
        this.invalidatePrefSize();
        super.invalidate();
    }

    @Override
    protected void visibleWidthChanged(int newWidth) {
        super.visibleWidthChanged(newWidth);
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
            }
        });
        this.invalidate();
    }

    @Override
    public void setLayout(LayoutManager mgr) {
        if (mgr != null) {
            throw new UnsupportedOperationException("QueriesListPanel does not support layout managers.");
        }
    }

    @Override
    public void doLayout() {
        this.computeLayout(true);
    }

    private Dimension computeLayout(boolean setBounds) {
        int height;
        int width;
        Insets insets = this.getInsets();
        if (this.buttons == null) {
            width = insets.left + insets.right;
            height = insets.top + insets.bottom;
            this.rowCount = 0;
        } else {
            int endHorizPos;
            this.validateVerticalMetrics();
            int horizPos = insets.left;
            int horizPosLimit = this.getAvailableWidth() - insets.right;
            int rowBaseline = insets.top + this.baseline;
            int rowNum = 0;
            height = this.rowHeight;
            this.rowCount = 1;
            QueryButton button = this.buttons[0];
            int buttonBaseline = this.baselines[0];
            Dimension buttonPrefSize = this.buttonPrefSizes[0];
            int startHorizPos = horizPos;
            int maxEndHorizPos = endHorizPos = startHorizPos + buttonPrefSize.width;
            if (setBounds) {
                button.setBounds(startHorizPos, rowBaseline - buttonBaseline, buttonPrefSize.width, buttonPrefSize.height);
            }
            horizPos = endHorizPos;
            this.rowNumbers[0] = rowNum;
            for (int i = 1; i < this.buttons.length; ++i) {
                button = this.buttons[i];
                buttonBaseline = this.baselines[i];
                buttonPrefSize = this.buttonPrefSizes[i];
                startHorizPos = horizPos + 12;
                endHorizPos = startHorizPos + buttonPrefSize.width;
                if (endHorizPos > horizPosLimit) {
                    startHorizPos = insets.left;
                    endHorizPos = startHorizPos + buttonPrefSize.width;
                    rowBaseline += 2 + this.rowHeight;
                    height += 2 + this.rowHeight;
                    ++this.rowCount;
                    ++rowNum;
                }
                if (setBounds) {
                    button.setBounds(startHorizPos, rowBaseline - buttonBaseline, buttonPrefSize.width, buttonPrefSize.height);
                }
                maxEndHorizPos = Math.max(maxEndHorizPos, endHorizPos);
                horizPos = endHorizPos;
                this.rowNumbers[i] = rowNum;
            }
            width = maxEndHorizPos + insets.right;
        }
        this.prefSize = new Dimension(width, height);
        return this.prefSize;
    }

    @Override
    public int getBaseline(int width, int height) {
        return this.getBaseline();
    }

    int getBaseline() {
        this.validateVerticalMetrics();
        return this.baseline;
    }

    void validateVerticalMetrics() {
        if (this.verticalMetricsKnown) {
            return;
        }
        int maxAboveBaseline = 0;
        int maxBelowBaseline = 0;
        if (this.buttons == null) {
            this.baselines = null;
            this.buttonPrefSizes = null;
        } else {
            this.baselines = new int[this.buttons.length];
            this.buttonPrefSizes = new Dimension[this.buttons.length];
            for (int i = 0; i < this.buttons.length; ++i) {
                QueryButton button = this.buttons[i];
                Dimension buttonPrefSize = button.getPreferredSize();
                int aboveBaseline = button.getBaseline(buttonPrefSize.width, buttonPrefSize.height);
                int belowBaseline = buttonPrefSize.height - aboveBaseline;
                this.buttonPrefSizes[i] = buttonPrefSize;
                this.baselines[i] = aboveBaseline;
                maxAboveBaseline = Math.max(maxAboveBaseline, aboveBaseline);
                maxBelowBaseline = Math.max(maxBelowBaseline, belowBaseline);
            }
        }
        this.baseline = maxAboveBaseline;
        this.rowHeight = maxAboveBaseline + maxBelowBaseline;
        this.verticalMetricsKnown = true;
    }

    @Override
    public Component.BaselineResizeBehavior getBaselineResizeBehavior() {
        return Component.BaselineResizeBehavior.CONSTANT_ASCENT;
    }

    @Override
    protected void notifyChildrenOfVisibleWidth() {
    }

    @Override
    public void focusGained(FocusEvent e) {
        final Component c = e.getComponent();
        if (c instanceof JComponent) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    QueryLinksPanel.this.scrollRectToVisible(c.getBounds());
                }
            });
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
    }

    @Override
    public void setUI(PanelUI ui) {
        super.setUI(ui);
        this.invalidateUiDependentValues();
    }

    @Override
    protected void setUI(ComponentUI newUI) {
        super.setUI(newUI);
        this.invalidateUiDependentValues();
    }

    private void invalidateUiDependentValues() {
        this.invalidateVerticalMetrics();
    }

    private void invalidateVerticalMetrics() {
        this.verticalMetricsKnown = false;
        this.buttonPrefSizes = null;
        this.baseline = -1;
        this.baselines = null;
        this.rowHeight = 0;
    }

    private void invalidatePrefSize() {
        this.prefSize = null;
    }

    private class QueryButton
    extends LinkButton {
        public QueryButton(final RepositoryImpl repo, final QueryImpl query) {
            this.setText(query.getDisplayName());
            this.getAccessibleContext().setAccessibleDescription(query.getTooltip());
            this.setAction(new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    QueryAction.openQuery(query, repo);
                }
            });
        }
    }
}

