/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.tasklist;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.spi.TaskListIssueProvider;
import org.netbeans.modules.bugtracking.util.BugtrackingOwnerSupport;
import org.netbeans.spi.tasklist.PushTaskScanner;
import org.netbeans.spi.tasklist.Task;
import org.netbeans.spi.tasklist.TaskScanningScope;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

public final class TaskListProvider
extends PushTaskScanner {
    private static TaskListProvider instance;
    private PushTaskScanner.Callback callback;
    private TaskScanningScope scope;
    private WeakReference<TaskScanningScope> lastScope = new WeakReference<Object>(null);
    private static final Object SCOPE_LOCK;
    private static final String TASK_GROUP_NAME = "nb-tasklist-issue";
    private static final String TC_TASKLIST_ID = "TaskListTopComponent";
    private final WeakHashMap<TaskListIssueProvider.LazyIssue, Task> cachedTasks;
    private final WeakHashMap<TaskListIssueProvider, Set<TaskListIssueProvider.LazyIssue>> cachedIssues;
    private final WeakSet<TaskListIssueProvider.LazyIssue> validatedIssues;
    private final HashSet<TaskListIssueProvider> providersToValidate;
    private boolean providersInitialized;
    public static final Logger LOG;
    private final RequestProcessor.Task refreshTask = new RequestProcessor("IssuesToTaskListProvider", 1, true).create((Runnable)new RefreshTask());

    private TaskListProvider() {
        super(NbBundle.getMessage(TaskListProvider.class, (String)"LBL_TaskListProvider_DisplayName"), NbBundle.getMessage(TaskListProvider.class, (String)"LBL_TaskListProvider_Description"), null);
        this.cachedTasks = new WeakHashMap(10);
        this.cachedIssues = new WeakHashMap(5);
        this.providersToValidate = new HashSet(5);
        this.validatedIssues = new WeakSet(10);
    }

    public static synchronized TaskListProvider getInstance() {
        if (instance == null) {
            instance = new TaskListProvider();
            instance.refreshTasks(true);
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setScope(TaskScanningScope scope, PushTaskScanner.Callback callback) {
        Object object = SCOPE_LOCK;
        synchronized (object) {
            if (!this.providersInitialized) {
                DelegatingConnector[] connectors;
                LinkedList<TaskListIssueProvider> providers = new LinkedList<TaskListIssueProvider>();
                for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
                    TaskListIssueProvider provider;
                    Collection<RepositoryImpl> repos = RepositoryRegistry.getInstance().getRepositories(c.getID());
                    if (repos.isEmpty() || (provider = c.getTasklistProvider()) == null) continue;
                    providers.add(provider);
                }
                for (TaskListIssueProvider provider : providers) {
                    LOG.log(Level.FINER, "TaskListProvider.setScope: waking up {0}", provider.getClass().getName());
                }
                this.providersInitialized = true;
            }
            this.callback = callback;
            this.scope = scope;
            this.lastScope.clear();
        }
        this.refreshTasks(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(TaskListIssueProvider provider, boolean openTaskList, TaskListIssueProvider.LazyIssue ... issuesToAdd) {
        if (provider == null || issuesToAdd == null || issuesToAdd.length == 0) {
            LOG.log(Level.FINE, "TaskListProvider.add: provider: {0}, issuesToAdd: {1}", new Object[]{provider, issuesToAdd});
            return;
        }
        LOG.log(Level.FINE, "TaskListProvider.add: adding {0} for {1}, request to open: {2}", new Object[]{issuesToAdd.length, provider, openTaskList});
        WeakHashMap<TaskListIssueProvider, Set<TaskListIssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            Set<TaskListIssueProvider.LazyIssue> issues = this.cachedIssues.get(provider);
            if (issues == null) {
                issues = new HashSet<TaskListIssueProvider.LazyIssue>(5);
            }
            for (TaskListIssueProvider.LazyIssue issue : issuesToAdd) {
                issues.add(issue);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.add: issues for {0}: {1}", new Object[]{provider, issues});
            }
            this.cachedIssues.put(provider, issues);
            this.providersToValidate.add(provider);
        }
        if (openTaskList) {
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (LOG.isLoggable(Level.FINER)) {
                        LOG.finer("TaskListProvider.add: openning tasklist TC");
                    }
                    TopComponent tc = WindowManager.getDefault().findTopComponent(TaskListProvider.TC_TASKLIST_ID);
                    tc.open();
                    tc.requestVisible();
                }
            });
        }
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(TaskListIssueProvider provider, TaskListIssueProvider.LazyIssue ... issuesToRemove) {
        if (provider == null || issuesToRemove == null || issuesToRemove.length == 0) {
            LOG.log(Level.FINE, "TaskListProvider.remove: provider: {0}, issuesToRemove: {1}", new Object[]{provider, issuesToRemove});
            return;
        }
        LOG.log(Level.FINE, "TaskListProvider.remove: removing {0} for {1}", new Object[]{issuesToRemove.length, provider});
        WeakHashMap<TaskListIssueProvider, Set<TaskListIssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            Set<TaskListIssueProvider.LazyIssue> issues = this.cachedIssues.get(provider);
            if (issues != null) {
                for (TaskListIssueProvider.LazyIssue issue : issuesToRemove) {
                    issues.remove(issue);
                }
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.remove: issues for {0}: {1}", new Object[]{provider, issues == null ? "empty" : issues});
            }
        }
        this.removeCachedTasks(issuesToRemove);
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll(TaskListIssueProvider provider) {
        Set<TaskListIssueProvider.LazyIssue> issues;
        if (provider == null) {
            LOG.fine("TaskListProvider.removeAll: provider is null");
            return;
        }
        LOG.fine("TaskListProvider.removeAll: provider is null");
        WeakHashMap<TaskListIssueProvider, Set<TaskListIssueProvider.LazyIssue>> weakHashMap = this.cachedIssues;
        synchronized (weakHashMap) {
            issues = this.cachedIssues.remove(provider);
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.removeAll: issues for {0}: {1}", new Object[]{provider, this.cachedIssues.get(provider) == null ? "empty" : this.cachedIssues.get(provider)});
            }
        }
        if (issues != null) {
            this.removeCachedTasks(issues.toArray(new TaskListIssueProvider.LazyIssue[issues.size()]));
        }
        this.refreshTasks(false);
    }

    public void refresh() {
        this.refreshTasks(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeCachedTasks(TaskListIssueProvider.LazyIssue ... issues) {
        WeakHashMap<TaskListIssueProvider.LazyIssue, Task> weakHashMap = this.cachedTasks;
        synchronized (weakHashMap) {
            for (TaskListIssueProvider.LazyIssue issue : issues) {
                this.cachedTasks.remove(issue);
            }
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.removeCachedTasks: cached tasks: {0}", this.cachedTasks);
            }
        }
    }

    private Task createTask(final TaskListIssueProvider.LazyIssue lazyIssue, final WeakReference<TaskListIssueProvider> providerRef) {
        LinkedList<Action> actions = new LinkedList<Action>();
        ActionListener openIssueAL = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable(){

                    @Override
                    public void run() {
                        lazyIssue.open();
                    }
                });
            }
        };
        actions.add(new AbstractAction(NbBundle.getMessage(TaskListProvider.class, (String)"TaskListProvider.Action.remove.name")){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskListIssueProvider provider = (TaskListIssueProvider)providerRef.get();
                if (provider != null) {
                    LOG.log(Level.FINE, "TaskListProvider: removing issue {0}", lazyIssue.getName());
                    TaskListProvider.this.remove(provider, lazyIssue);
                    provider.removed(lazyIssue);
                }
            }
        });
        List<? extends Action> additionalActions = lazyIssue.getActions();
        if (additionalActions != null) {
            if (LOG.isLoggable(Level.FINER)) {
                LOG.log(Level.FINER, "TaskListProvider.createTask: provided actions {0}", additionalActions);
            }
            for (Action action : additionalActions) {
                if (action == null) continue;
                actions.add(action);
            }
        }
        Task task = Task.create((URL)lazyIssue.getUrl(), (String)TASK_GROUP_NAME, (String)lazyIssue.getName(), (ActionListener)openIssueAL, (Action[])actions.toArray(new AbstractAction[actions.size()]));
        this.cachedTasks.put(lazyIssue, task);
        if (LOG.isLoggable(Level.FINER)) {
            LOG.log(Level.FINER, "TaskListProvider.createTasks: cached tasks: {0}", this.cachedTasks);
        }
        lazyIssue.setValid(true);
        return task;
    }

    private void refreshTasks(boolean cancelRunningRefresh) {
        LOG.log(Level.FINER, "TaskListProvider.refreshTasks: cancel={0}", cancelRunningRefresh);
        if (cancelRunningRefresh) {
            this.refreshTask.cancel();
        }
        this.refreshTask.schedule(200);
    }

    private List<String> getRepositoriesFor(TaskScanningScope scope) {
        Project project;
        FileObject fo;
        ArrayList<Project> projects = scope.getLookup().lookupAll(Project.class);
        if ((projects == null || projects.isEmpty()) && (fo = (FileObject)scope.getLookup().lookup(FileObject.class)) != null && (project = FileOwnerQuery.getOwner((FileObject)fo)) != null) {
            ArrayList<Project> list = new ArrayList<Project>(1);
            list.add(project);
            projects = list;
        }
        LinkedList<String> repositoryUrls = new LinkedList<String>();
        if (!projects.isEmpty()) {
            for (Project p : projects) {
                if (Thread.interrupted()) {
                    return null;
                }
                long startTime = 0L;
                if (LOG.isLoggable(Level.FINER)) {
                    startTime = System.currentTimeMillis();
                }
                RepositoryImpl repository = BugtrackingOwnerSupport.getInstance().getRepository(p, false);
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "getRepositoriesFor: repository: {0} for {1} after {2}", new Object[]{repository, p, System.currentTimeMillis() - startTime});
                }
                if (repository == null) continue;
                repositoryUrls.add(repository.getUrl());
            }
        }
        return repositoryUrls;
    }

    private boolean isIssueFromRepository(TaskListIssueProvider.LazyIssue issue, Collection<String> repositoryUrls, Collection<String> allAssociatedRepositories) {
        String repositoryUrl = issue.getRepositoryUrl();
        boolean returnValue = false;
        if (repositoryUrl != null) {
            for (String url : repositoryUrls) {
                if (!repositoryUrl.equals(url)) continue;
                LOG.log(Level.FINE, "isIssueFromRepository: issue {0} under an allowed repository", issue);
                returnValue = true;
                break;
            }
            if (!returnValue && !allAssociatedRepositories.contains(repositoryUrl)) {
                LOG.log(Level.FINE, "isIssueFromRepository: issue {0} under a unassociated repository", issue);
                returnValue = true;
            }
        }
        return returnValue;
    }

    static {
        SCOPE_LOCK = new Object();
        LOG = Logger.getLogger("org.netbeans.modules.bugtracking.tasklist");
    }

    private class RefreshTask
    implements Runnable {
        private RefreshTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            List repositoryUrls;
            boolean scopeChanged;
            PushTaskScanner.Callback callback;
            TaskScanningScope scope;
            if (Thread.interrupted()) {
                return;
            }
            Object object = SCOPE_LOCK;
            synchronized (object) {
                scope = TaskListProvider.this.scope;
                callback = TaskListProvider.this.callback;
                boolean bl = scopeChanged = scope != TaskListProvider.this.lastScope.get();
                if (scopeChanged) {
                    LOG.finer("RefreshTask.run: scope has changed, running the full scan.");
                }
            }
            if (callback == null || scope == null) {
                return;
            }
            HashMap<TaskListIssueProvider.LazyIssue, Object> issuesToInclude = new HashMap<TaskListIssueProvider.LazyIssue, Object>();
            HashMap issuesToValidate = new HashMap();
            WeakHashMap weakHashMap = TaskListProvider.this.cachedIssues;
            synchronized (weakHashMap) {
                if (scopeChanged) {
                    TaskListProvider.this.providersToValidate.addAll(TaskListProvider.this.cachedIssues.keySet());
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: providers to validate: {0}", TaskListProvider.this.providersToValidate);
                }
                for (Map.Entry e : TaskListProvider.this.cachedIssues.entrySet()) {
                    if (TaskListProvider.this.providersToValidate.contains(e.getKey())) {
                        for (TaskListIssueProvider.LazyIssue issue : (Set)e.getValue()) {
                            issuesToValidate.put(issue, e.getKey());
                        }
                        continue;
                    }
                    for (TaskListIssueProvider.LazyIssue issue : (Set)e.getValue()) {
                        if (TaskListProvider.this.validatedIssues.contains((Object)issue)) {
                            issuesToInclude.put(issue, e.getKey());
                            continue;
                        }
                        issuesToValidate.put(issue, e.getKey());
                    }
                }
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: issues to validate: {0}", issuesToValidate);
                }
            }
            if (!issuesToValidate.isEmpty() && (repositoryUrls = TaskListProvider.this.getRepositoriesFor(scope)) != null) {
                Collection<String> allAssociatedRepositories = BugtrackingOwnerSupport.getInstance().getAllAssociatedUrls();
                if (LOG.isLoggable(Level.FINER)) {
                    LOG.log(Level.FINER, "RefreshTask.run: all associated repositories: {0}", allAssociatedRepositories);
                }
                for (Map.Entry e : issuesToValidate.entrySet()) {
                    if (TaskListProvider.this.isIssueFromRepository((TaskListIssueProvider.LazyIssue)e.getKey(), repositoryUrls, allAssociatedRepositories)) {
                        if (LOG.isLoggable(Level.FINER)) {
                            LOG.log(Level.FINER, "RefreshTask.run: issue {0} is valid under current scope", ((TaskListIssueProvider.LazyIssue)e.getKey()).getName());
                        }
                        issuesToInclude.put((TaskListIssueProvider.LazyIssue)e.getKey(), e.getValue());
                        continue;
                    }
                    if (!LOG.isLoggable(Level.FINER)) continue;
                    LOG.log(Level.FINER, "RefreshTask.run: issue {0} is invalid under current scope", ((TaskListIssueProvider.LazyIssue)e.getKey()).getName());
                }
            }
            LinkedList<Task> tasks = new LinkedList<Task>();
            for (Map.Entry e : issuesToInclude.entrySet()) {
                Task t;
                TaskListIssueProvider.LazyIssue issue;
                issue = (TaskListIssueProvider.LazyIssue)e.getKey();
                WeakHashMap weakHashMap2 = TaskListProvider.this.cachedTasks;
                synchronized (weakHashMap2) {
                    t = (Task)TaskListProvider.this.cachedTasks.get(issue);
                    if (t == null || !issue.isValid()) {
                        t = TaskListProvider.this.createTask(issue, new WeakReference(e.getValue()));
                    }
                }
                tasks.add(t);
            }
            if (Thread.interrupted()) {
                return;
            }
            WeakHashMap weakHashMap3 = TaskListProvider.this.cachedIssues;
            synchronized (weakHashMap3) {
                TaskListProvider.this.providersToValidate.clear();
                TaskListProvider.this.validatedIssues.clear();
                TaskListProvider.this.validatedIssues.addAll(issuesToInclude.keySet());
            }
            callback.setTasks(tasks);
            TaskListProvider.this.lastScope = new WeakReference<TaskScanningScope>(scope);
        }
    }
}

