/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.kenai.spi;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.net.PasswordAuthentication;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.JLabel;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiBugtrackingConnector;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiProject;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.kenai.spi.RepositoryUser;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.ui.query.QueryTopComponent;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;
import org.openide.nodes.Node;

public class KenaiUtil {
    public static KenaiAccessor[] getKenaiAccessors() {
        return BugtrackingManager.getInstance().getKenaiAccessors();
    }

    public static KenaiAccessor getKenaiAccessor(String url) {
        KenaiAccessor accessor = null;
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            if (!ka.isOwner(url)) continue;
            accessor = ka;
            break;
        }
        return accessor;
    }

    public static boolean isLoggedIn(URL url) {
        return KenaiUtil.isLoggedIn(url.toString());
    }

    public static boolean isLoggedIn(String url) {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            if (!ka.isLoggedIn(url)) continue;
            return true;
        }
        return false;
    }

    public static boolean isKenai(Repository repo) {
        return KenaiUtil.getKenaiProject(repo) != null;
    }

    public static PasswordAuthentication getPasswordAuthentication(String url, boolean forceLogin) {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            PasswordAuthentication pa = ka.getPasswordAuthentication(url, forceLogin);
            if (pa == null) continue;
            return pa;
        }
        return null;
    }

    public static Repository getRepository(String repositoryUrl) throws IOException {
        KenaiProject project = KenaiUtil.getKenaiProjectForRepository(repositoryUrl);
        return project != null ? KenaiUtil.getRepository(project) : null;
    }

    public static Repository getRepository(String url, String projectName) throws IOException {
        KenaiProject p = KenaiUtil.getKenaiProject(url, projectName);
        return p != null ? KenaiUtil.getRepository(p) : null;
    }

    public static Repository getRepository(KenaiProject project) {
        RepositoryImpl impl = KenaiRepositories.getInstance().getRepository(project);
        return impl != null ? impl.getRepository() : null;
    }

    public static Repository getRepository(KenaiProject project, boolean forceCreate) {
        RepositoryImpl impl = KenaiRepositories.getInstance().getRepository(project, forceCreate);
        return impl != null ? impl.getRepository() : null;
    }

    public static Collection<Repository> getRepositories(boolean pingOpenProjects) {
        return KenaiUtil.getRepositories(pingOpenProjects, false);
    }

    public static Collection<Repository> getRepositories(boolean pingOpenProjects, boolean onlyDashboardOpenProjects) {
        Collection<RepositoryImpl> impls = KenaiRepositories.getInstance().getRepositories(pingOpenProjects, onlyDashboardOpenProjects);
        ArrayList<Repository> ret = new ArrayList<Repository>(impls.size());
        for (RepositoryImpl impl : impls) {
            ret.add(impl.getRepository());
        }
        return ret;
    }

    public static Collection<Repository> getRepositories(String connectorId, boolean pingOpenProjects, boolean onlyDashboardOpenProjects) {
        Collection<RepositoryImpl> impls = KenaiRepositories.getInstance().getRepositories(pingOpenProjects, onlyDashboardOpenProjects);
        ArrayList<Repository> ret = new ArrayList<Repository>(impls.size());
        for (RepositoryImpl impl : impls) {
            if (!connectorId.equals(impl.getConnectorId())) continue;
            ret.add(impl.getRepository());
        }
        return ret;
    }

    public static Collection<RepositoryUser> getProjectMembers(KenaiProject kp) {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            try {
                Collection<RepositoryUser> projectMembers = ka.getProjectMembers(kp);
                if (projectMembers == null) continue;
                return projectMembers;
            }
            catch (IOException ex) {
                BugtrackingManager.LOG.log(Level.WARNING, null, ex);
            }
        }
        return Collections.EMPTY_LIST;
    }

    public static String getChatLink(String id) {
        return "ISSUE:" + id;
    }

    public static void refreshOpenedQueries() {
        Set<QueryTopComponent> tcs = QueryTopComponent.getOpenQueries();
        for (QueryTopComponent tc : tcs) {
            tc.updateSavedQueries();
        }
    }

    public static boolean isNetbeansKenaiRegistered() {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            if (!ka.isNetbeansKenaiRegistered()) continue;
            return true;
        }
        return false;
    }

    public static JLabel createUserWidget(String url, String userName, String host, String chatMessage) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor(url);
        assert (ka != null);
        return ka.createUserWidget(userName, host, chatMessage);
    }

    public static OwnerInfo getOwnerInfo(Node node) {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            OwnerInfo ownerInfo = ka.getOwnerInfo(node);
            if (ownerInfo == null) continue;
            return ownerInfo;
        }
        return null;
    }

    public static OwnerInfo getOwnerInfo(File file) {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            OwnerInfo ownerInfo = ka.getOwnerInfo(file);
            if (ownerInfo == null) continue;
            return ownerInfo;
        }
        return null;
    }

    public static void logKenaiUsage(String url, Object ... parameters) {
        KenaiAccessor ka = KenaiUtil.getKenaiAccessor(url);
        if (ka != null) {
            ka.logKenaiUsage(parameters);
        }
    }

    public static KenaiProject getKenaiProjectForRepository(String repositoryUrl) throws IOException {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            KenaiProject kp = ka.getKenaiProjectForRepository(repositoryUrl);
            if (kp == null) continue;
            return kp;
        }
        return null;
    }

    public static KenaiProject getKenaiProject(String url, String projectName) throws IOException {
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            KenaiProject kp = ka.getKenaiProject(url, projectName);
            if (kp == null) continue;
            return kp;
        }
        return null;
    }

    public static KenaiProject[] getDashboardProjects(boolean onlyOpened) {
        LinkedList<KenaiProject> projs = new LinkedList<KenaiProject>();
        for (KenaiAccessor ka : KenaiUtil.getKenaiAccessors()) {
            projs.addAll(Arrays.asList(ka.getDashboardProjects(onlyOpened)));
        }
        return projs.toArray(new KenaiProject[projs.size()]);
    }

    public static Repository findNBRepository() {
        DelegatingConnector[] connectors;
        for (DelegatingConnector c : connectors = BugtrackingManager.getInstance().getConnectors()) {
            KenaiBugtrackingConnector kenaiConnector;
            BugtrackingConnector bugtrackingConnector = c.getDelegate();
            if (!(bugtrackingConnector instanceof KenaiBugtrackingConnector) || (kenaiConnector = (KenaiBugtrackingConnector)bugtrackingConnector).getType() != KenaiBugtrackingConnector.BugtrackingType.BUGZILLA) continue;
            return kenaiConnector.findNBRepository();
        }
        return null;
    }

    public static void addRepository(Repository repository) {
        RepositoryRegistry.getInstance().addRepository(APIAccessor.IMPL.getImpl(repository));
    }

    public static KenaiProject getKenaiProject(Repository repository) {
        return (KenaiProject)APIAccessor.IMPL.getImpl(repository).getLookup().lookup(KenaiProject.class);
    }

    public static Query getAllIssuesQuery(Repository repository) {
        return APIAccessor.IMPL.getImpl(repository).getAllIssuesQuery();
    }

    public static Query getMyIssuesQuery(Repository repository) {
        return APIAccessor.IMPL.getImpl(repository).getMyIssuesQuery();
    }

    public static boolean needsLogin(Query query) {
        return APIAccessor.IMPL.getImpl(query).needsLogin();
    }

    public static KenaiBugtrackingConnector.BugtrackingType getType(Repository repo) {
        DelegatingConnector[] connectors;
        for (DelegatingConnector delegatingConnector : connectors = BugtrackingManager.getInstance().getConnectors()) {
            if (!delegatingConnector.getID().equals(APIAccessor.IMPL.getImpl(repo).getConnectorId())) continue;
            BugtrackingConnector bugtrackignConnector = delegatingConnector.getDelegate();
            assert (bugtrackignConnector instanceof KenaiBugtrackingConnector);
            return ((KenaiBugtrackingConnector)bugtrackignConnector).getType();
        }
        assert (false) : "no KenaiSupport available for repository [" + repo.getDisplayName() + "]";
        return null;
    }

    public static void closeQuery(Query query) {
        QueryAction.closeQuery(APIAccessor.IMPL.getImpl(query));
    }

    public static void createIssue(Repository repo) {
        IssueAction.createIssue(APIAccessor.IMPL.getImpl(repo));
    }

    public static void openNewQuery(Repository repository, boolean suggestedSelectionOnly) {
        QueryAction.openQuery(null, APIAccessor.IMPL.getImpl(repository), suggestedSelectionOnly);
    }

    public static void openQuery(Query query, Query.QueryMode mode, boolean suggestedSelectionOnly) {
        QueryImpl queryImpl = APIAccessor.IMPL.getImpl(query);
        queryImpl.open(suggestedSelectionOnly, mode);
    }

    public static Collection<Issue> getRecentIssues(Repository repo) {
        Collection<IssueImpl> c = BugtrackingUtil.getRecentIssues(APIAccessor.IMPL.getImpl(repo));
        ArrayList<Issue> ret = new ArrayList<Issue>(c.size());
        for (IssueImpl impl : c) {
            ret.add(impl.getIssue());
        }
        return ret;
    }

    public static Collection<Repository> getKnownRepositories(boolean b) {
        Collection<RepositoryImpl> c = BugtrackingUtil.getKnownRepositories(b);
        ArrayList<Repository> ret = new ArrayList<Repository>(c.size());
        for (RepositoryImpl impl : c) {
            ret.add(impl.getRepository());
        }
        return ret;
    }

    public static void addCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.addCacheListener(APIAccessor.IMPL.getImpl(issue), l);
    }

    public static void removeCacheListener(Issue issue, PropertyChangeListener l) {
        IssueCacheUtils.removeCacheListener(APIAccessor.IMPL.getImpl(issue), l);
    }

    public static boolean isOpen(Issue issue) {
        return BugtrackingUtil.isOpened(APIAccessor.IMPL.getImpl(issue));
    }

    public static boolean isShowing(Issue issue) {
        return BugtrackingUtil.isOpened(APIAccessor.IMPL.getImpl(issue));
    }
}

