/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.LayoutStyle;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.jira.DownloadPlugin;
import org.netbeans.modules.bugtracking.jira.MissingJiraSupportPanel;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.BugtrackingFactory;
import org.netbeans.modules.bugtracking.spi.RepositoryController;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.RepositoryProvider;
import org.netbeans.modules.bugtracking.util.LinkButton;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.HtmlBrowser;
import org.openide.awt.Mnemonics;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class JiraUpdater {
    private static JiraUpdater instance;
    private DelegatingConnector connector;

    private JiraUpdater() {
    }

    public static synchronized JiraUpdater getInstance() {
        if (instance == null) {
            instance = new JiraUpdater();
        }
        return instance;
    }

    public DelegatingConnector getConnector() {
        if (this.connector == null) {
            JiraProxyConector jpc = new JiraProxyConector();
            return new DelegatingConnector(jpc, "fake.jira.connector", NbBundle.getMessage(JiraUpdater.class, (String)"LBL_FakeJiraName"), NbBundle.getMessage(JiraUpdater.class, (String)"LBL_FakeJiraNameTooltip"), null);
        }
        return this.connector;
    }

    public void downloadAndInstall() {
        DownloadPlugin dp = new DownloadPlugin();
        dp.startDownload();
    }

    public static boolean notifyJiraDownload(String url) {
        final JButton download = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Download"));
        JButton cancel = new JButton(NbBundle.getMessage(DownloadPlugin.class, (String)"CTL_Action_Cancel"));
        URL openURL = null;
        if (url != null) {
            try {
                openURL = new URL(url);
            }
            catch (MalformedURLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        JPanel panel = JiraUpdater.createNotificationPanel(openURL);
        DialogDescriptor dd = new DialogDescriptor((Object)panel, NbBundle.getMessage(JiraUpdater.class, (String)"CTL_MissingJiraPlugin"), true, new Object[]{download, cancel}, (Object)download, 0, new HelpCtx(JiraUpdater.class), null);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                download.requestFocusInWindow();
            }
        });
        return DialogDisplayer.getDefault().notify((NotifyDescriptor)dd) == download;
    }

    private static JPanel createNotificationPanel(final URL url) {
        JPanel panel = new JPanel();
        JLabel msgLabel = new JLabel("<html>" + NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA"));
        LinkButton linkButton = new LinkButton();
        Mnemonics.setLocalizedText((AbstractButton)linkButton, (String)NbBundle.getMessage(JiraUpdater.class, (String)"MSG_PROJECT_NEEDS_JIRA_LINK"));
        if (url != null) {
            linkButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    HtmlBrowser.URLDisplayer displayer = HtmlBrowser.URLDisplayer.getDefault();
                    if (displayer != null) {
                        displayer.showURL(url);
                    } else {
                        BugtrackingManager.LOG.warning("No URLDisplayer found.");
                    }
                }
            });
        } else {
            linkButton.setVisible(false);
        }
        GroupLayout layout = new GroupLayout(panel);
        panel.setLayout(layout);
        layout.setHorizontalGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(msgLabel, -2, 470, Short.MAX_VALUE).addComponent(linkButton)).addContainerGap());
        layout.setVerticalGroup(layout.createSequentialGroup().addContainerGap().addComponent(msgLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(linkButton).addContainerGap(25, Short.MAX_VALUE));
        return panel;
    }

    private class JiraProxyController
    implements RepositoryController {
        private JPanel panel;

        private JiraProxyController() {
        }

        @Override
        public JComponent getComponent() {
            if (this.panel == null) {
                this.panel = this.createControllerPanel();
            }
            return this.panel;
        }

        @Override
        public HelpCtx getHelpCtx() {
            return new HelpCtx(this.getClass());
        }

        @Override
        public boolean isValid() {
            return false;
        }

        @Override
        public void applyChanges() throws IOException {
        }

        private JPanel createControllerPanel() {
            JPanel controllerPanel = new JPanel();
            JLabel pane = new JLabel();
            pane.setText(NbBundle.getMessage(JiraUpdater.class, (String)"MSG_NOT_YET_INSTALLED"));
            JButton downloadButton = new JButton();
            downloadButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    JiraUpdater.this.downloadAndInstall();
                }
            });
            Mnemonics.setLocalizedText((AbstractButton)downloadButton, (String)NbBundle.getMessage(MissingJiraSupportPanel.class, (String)"MissingJiraSupportPanel.downloadButton.text"));
            GroupLayout layout = new GroupLayout(controllerPanel);
            controllerPanel.setLayout(layout);
            layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(pane, -2, 100, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(downloadButton)));
            layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addComponent(pane).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(downloadButton)).addContainerGap()));
            return controllerPanel;
        }

        @Override
        public void populate() {
        }

        @Override
        public String getErrorMessage() {
            return null;
        }

        @Override
        public void addChangeListener(ChangeListener l) {
        }

        @Override
        public void removeChangeListener(ChangeListener l) {
        }
    }

    private class JiraProxyRepositoryProvider
    extends RepositoryProvider<Object, Object, Object> {
        private JiraProxyRepositoryProvider() {
        }

        @Override
        public Image getIcon(Object r) {
            return null;
        }

        @Override
        public RepositoryInfo getInfo(Object r) {
            return null;
        }

        @Override
        public Object[] getIssues(Object r, String ... id) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public void remove(Object r) {
        }

        @Override
        public RepositoryController getController(Object r) {
            return new JiraProxyController();
        }

        @Override
        public Object createIssue(Object r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Object createQuery(Object r) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public Collection<Object> getQueries(Object r) {
            return Collections.emptyList();
        }

        @Override
        public Collection<Object> simpleSearch(Object r, String criteria) {
            return Collections.emptyList();
        }

        @Override
        public Lookup getLookup(Object r) {
            return Lookup.EMPTY;
        }

        @Override
        public void removePropertyChangeListener(Object r, PropertyChangeListener listener) {
        }

        @Override
        public void addPropertyChangeListener(Object r, PropertyChangeListener listener) {
        }
    }

    private class JiraProxyConector
    extends BugtrackingConnector {
        private BugtrackingFactory<Object, Object, Object> f = new BugtrackingFactory();

        private JiraProxyConector() {
        }

        @Override
        public Repository createRepository() {
            return this.f.createRepository(this.f, new JiraProxyRepositoryProvider(), null, null);
        }

        @Override
        public Repository createRepository(RepositoryInfo info) {
            throw new UnsupportedOperationException("Not supported yet.");
        }
    }
}

