/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.jira;

import java.util.List;
import org.netbeans.api.autoupdate.OperationContainer;
import org.netbeans.api.autoupdate.UpdateElement;
import org.netbeans.api.autoupdate.UpdateManager;
import org.netbeans.api.autoupdate.UpdateUnit;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.modules.autoupdate.ui.api.PluginManager;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

class DownloadPlugin {
    private static final String JIRA_CNB = "org.netbeans.modules.jira";

    void startDownload() {
        final ProgressHandle ph = ProgressHandleFactory.createHandle((String)NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_LookingForJira"));
        RequestProcessor.getDefault().post(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ph.start();
                final UpdateElement[] updateElement = new UpdateElement[1];
                try {
                    List units = UpdateManager.getDefault().getUpdateUnits(new UpdateManager.TYPE[]{UpdateManager.TYPE.MODULE});
                    boolean installed = false;
                    for (UpdateUnit u : units) {
                        if (!u.getCodeName().equals(DownloadPlugin.JIRA_CNB)) continue;
                        List elements = u.getAvailableUpdates();
                        if (elements.isEmpty()) {
                            installed = true;
                            break;
                        }
                        updateElement[0] = (UpdateElement)elements.get(0);
                        break;
                    }
                    if (installed) {
                        DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_AlreadyInstalled"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        return;
                    }
                    if (updateElement[0] == null) {
                        DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_JiraNotFound"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        return;
                    }
                }
                finally {
                    ph.finish();
                }
                RequestProcessor.getDefault().post(new Runnable(){

                    @Override
                    public void run() {
                        OperationContainer oc = OperationContainer.createForInstall();
                        if (oc.canBeAdded(updateElement[0].getUpdateUnit(), updateElement[0])) {
                            oc.add(updateElement[0]);
                            PluginManager.openInstallWizard((OperationContainer)oc);
                        } else {
                            DownloadPlugin.notifyError(NbBundle.getMessage(DownloadPlugin.class, (String)"MSG_CannotBeInstalled"), NbBundle.getMessage(DownloadPlugin.class, (String)"LBL_Error"));
                        }
                    }
                });
            }
        });
    }

    private static void notifyError(String message, String title) {
        DownloadPlugin.notifyInDialog(message, title, 0, true);
    }

    private static void notifyInDialog(String message, String title, int messageType, boolean cancelVisible) {
        Object[] objectArray;
        if (cancelVisible) {
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = NotifyDescriptor.OK_OPTION;
            objectArray = objectArray2;
            objectArray2[1] = NotifyDescriptor.CANCEL_OPTION;
        } else {
            Object[] objectArray3 = new Object[1];
            objectArray = objectArray3;
            objectArray3[0] = NotifyDescriptor.OK_OPTION;
        }
        NotifyDescriptor nd = new NotifyDescriptor((Object)message, title, -1, messageType, objectArray, NotifyDescriptor.OK_OPTION);
        DialogDisplayer.getDefault().notifyLater(nd);
    }
}

