/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.awt.Color;
import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.BugtrackingConfig;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.issuetable.ColumnDescriptor;
import org.netbeans.modules.bugtracking.issuetable.Filter;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.issuetable.NodeTableModel;
import org.netbeans.modules.bugtracking.issuetable.QueryTableCellRenderer;
import org.netbeans.modules.bugtracking.issuetable.QueryTableHeaderRenderer;
import org.netbeans.modules.bugtracking.issuetable.SummaryTextFilter;
import org.netbeans.modules.bugtracking.issuetable.TableSorter;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.netbeans.modules.bugtracking.util.UIUtils;
import org.openide.awt.MouseUtils;
import org.openide.explorer.view.TreeTableView;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class IssueTable<Q>
implements MouseListener,
AncestorListener,
KeyListener,
PropertyChangeListener {
    private NodeTableModel tableModel;
    private JTable table;
    private JScrollPane component;
    private TableSorter sorter;
    private QueryImpl query;
    private ColumnDescriptor[] descriptors;
    private Filter allFilter;
    private Filter newOrChangedFilter;
    private Filter filter;
    private Filter[] filters;
    private Set<IssueNode> nodes = new HashSet<IssueNode>();
    private QueryTableHeaderRenderer queryTableHeaderRenderer;
    private RequestProcessor.Task storeColumnsTask;
    private final StoreColumnsHandler storeColumnsWidthHandler;
    private final JButton colsButton;
    private boolean savedQueryInitialized;
    private SummaryTextFilter textFilter;
    private static final String CONFIG_DELIMITER = "<=>";
    private static final Comparator<IssueNode.IssueProperty> nodeComparator = new Comparator<IssueNode.IssueProperty>(){

        @Override
        public int compare(IssueNode.IssueProperty p1, IssueNode.IssueProperty p2) {
            Integer sk1 = (Integer)p1.getValue("sortkey");
            if (sk1 != null) {
                Integer sk2 = (Integer)p2.getValue("sortkey");
                return sk2 != null ? sk1.compareTo(sk2) : 1;
            }
            try {
                return p1.compareTo(p2);
            }
            catch (Exception e) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, e);
                return 0;
            }
        }
    };
    private final Map<Cell, Set<CellAction>> cellActions = new HashMap<Cell, Set<CellAction>>();
    private TableColumnModelListener tcml = new TableColumnModelListener(){

        @Override
        public void columnAdded(TableColumnModelEvent e) {
        }

        @Override
        public void columnRemoved(TableColumnModelEvent e) {
        }

        @Override
        public void columnMoved(TableColumnModelEvent e) {
            int to;
            int from = e.getFromIndex();
            if (from == (to = e.getToIndex())) {
                return;
            }
            IssueTable.this.table.getTableHeader().getColumnModel().getColumn(from).setModelIndex(from);
            IssueTable.this.table.getTableHeader().getColumnModel().getColumn(to).setModelIndex(to);
            IssueTable.this.tableModel.moveColumn(from, to);
        }

        @Override
        public void columnSelectionChanged(ListSelectionEvent e) {
        }

        @Override
        public void columnMarginChanged(ChangeEvent e) {
            IssueTable.this.storeColumnsTask.schedule(1000);
        }
    };

    public IssueTable(Repository repository, Q q, ColumnDescriptor[] descriptors) {
        this(repository, q, descriptors, true);
    }

    public IssueTable(Repository repository, Q q, ColumnDescriptor[] descriptors, boolean includeObsoletes) {
        assert (q != null);
        assert (descriptors != null);
        assert (descriptors.length > 0);
        this.query = APIAccessor.IMPL.getImpl(repository).getQuery(q);
        this.descriptors = descriptors;
        this.query.addPropertyChangeListener(this);
        this.tableModel = new NodeTableModel();
        this.sorter = new TableSorter(this.tableModel, this);
        this.initFilters(includeObsoletes);
        this.sorter.setColumnComparator(Node.Property.class, nodeComparator);
        this.table = new JTable(this.sorter);
        this.sorter.setTableHeader(this.table.getTableHeader());
        this.table.setRowHeight(this.table.getRowHeight() * 6 / 5);
        this.component = new JScrollPane(this.table, 22, 31);
        this.component.getViewport().setBackground(this.table.getBackground());
        Color borderColor = UIManager.getColor("scrollpane_border");
        if (borderColor == null) {
            borderColor = UIManager.getColor("controlShadow");
        }
        this.component.setBorder(BorderFactory.createMatteBorder(1, 0, 0, 0, borderColor));
        ImageIcon ic = new ImageIcon(ImageUtilities.loadImage((String)"org/netbeans/modules/bugtracking/ui/resources/columns_16.png", (boolean)true));
        this.colsButton = new JButton(ic);
        this.colsButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TreeTableView.class, (String)"ACN_ColumnsSelector"));
        this.colsButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TreeTableView.class, (String)"ACD_ColumnsSelector"));
        this.colsButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                if (IssueTable.this.tableModel.selectVisibleColumns()) {
                    IssueTable.this.setDefaultColumnSizes();
                    IssueTable.this.storeColumnsTask.schedule(1000);
                }
            }
        });
        this.component.setCorner("UPPER_RIGHT_CORNER", this.colsButton);
        this.table.addMouseListener(this);
        this.table.addKeyListener(this);
        this.table.setDefaultRenderer(Node.Property.class, new QueryTableCellRenderer(this.query.getQuery(), this));
        this.queryTableHeaderRenderer = new QueryTableHeaderRenderer(this.table.getTableHeader().getDefaultRenderer(), this, this.query);
        this.table.getTableHeader().setDefaultRenderer(this.queryTableHeaderRenderer);
        this.table.addAncestorListener(this);
        this.table.getAccessibleContext().setAccessibleName(NbBundle.getMessage(IssueTable.class, (String)"ACSN_IssueTable"));
        this.table.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(IssueTable.class, (String)"ACSD_IssueTable"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                IssueTable.this.initColumns();
            }
        });
        this.table.getTableHeader().addMouseListener(new MouseListener(){

            @Override
            public void mouseClicked(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                IssueTable.this.table.getColumnModel().addColumnModelListener(IssueTable.this.tcml);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                IssueTable.this.table.getColumnModel().removeColumnModelListener(IssueTable.this.tcml);
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }
        });
        this.table.getInputMap(1).put(KeyStroke.getKeyStroke(121, 64), "org.openide.actions.PopupAction");
        UIUtils.fixFocusTraversalKeys(this.table);
        this.storeColumnsWidthHandler = new StoreColumnsHandler();
        this.storeColumnsTask = BugtrackingManager.getInstance().getRequestProcessor().create((Runnable)this.storeColumnsWidthHandler);
    }

    public Filter[] getDefinedFilters() {
        return this.filters;
    }

    public Filter getAllFilter() {
        return this.allFilter;
    }

    public Filter getNewOrChangedFilter() {
        return this.newOrChangedFilter;
    }

    public void resetFilterBySummary() {
        this.setFilterIntern(this.filter);
    }

    public void switchFilterBySummaryHighlight(boolean on) {
        assert (this.textFilter != null);
        if (this.textFilter == null) {
            return;
        }
        this.textFilter.setHighlighting(on);
        this.table.repaint();
    }

    public void setFilterBySummary(String searchText, boolean regular, boolean wholeWords, boolean matchCase) {
        if (this.textFilter == null) {
            this.textFilter = new SummaryTextFilter();
        }
        this.textFilter.setText(searchText, regular, wholeWords, matchCase);
        this.setFilterIntern(this.textFilter);
    }

    public void setRenderer(TableCellRenderer renderer) {
        this.table.setDefaultRenderer(Node.Property.class, renderer);
    }

    public TableCellRenderer getRenderer() {
        return this.table.getDefaultRenderer(Node.Property.class);
    }

    public void setFilter(Filter filter) {
        this.filter = filter;
        this.setFilterIntern(filter);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("bugtracking.query.saved")) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssueTable.this.initColumns();
                }
            });
        }
    }

    public JComponent getComponent() {
        return this.component;
    }

    public final void initColumns() {
        if (this.savedQueryInitialized) {
            return;
        }
        this.setModelProperties(this.query.isSaved());
        if (this.descriptors.length > 0) {
            Map<Integer, Integer> sorting = this.getColumnSorting();
            if (this.descriptors.length > 1) {
                for (int i = 0; i < this.descriptors.length; ++i) {
                    int visibleIdx = this.tableModel.getVisibleIndex(i);
                    Integer order = sorting.get(visibleIdx);
                    if (order != null) {
                        this.sorter.setSortingStatus(visibleIdx, order);
                        continue;
                    }
                    if (i == 0) {
                        this.sorter.setSortingStatus(0, 1);
                        continue;
                    }
                    this.sorter.setColumnComparator(i, null);
                    this.sorter.setSortingStatus(i, 0);
                }
            }
        }
        this.setDefaultColumnSizes();
        if (this.query.isSaved()) {
            this.savedQueryInitialized = true;
        }
    }

    void sortOrderChanged() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.sorter.getColumnCount(); ++i) {
            if (i > 0) {
                sb.append(CONFIG_DELIMITER);
            }
            sb.append(i).append(CONFIG_DELIMITER).append(this.sorter.getSortingStatus(i));
        }
        BugtrackingConfig.getInstance().storeColumnSorting(this.getColumnsKey(), sb.toString());
    }

    private Map<Integer, Integer> getColumnSorting() {
        String sortingString = BugtrackingConfig.getInstance().getColumnSorting(this.getColumnsKey());
        if (sortingString == null || sortingString.equals("")) {
            return Collections.EMPTY_MAP;
        }
        HashMap<Integer, Integer> map = new HashMap<Integer, Integer>();
        String[] sortingArray = sortingString.split(CONFIG_DELIMITER);
        for (int i = 0; i < sortingArray.length; i += 2) {
            try {
                map.put(Integer.parseInt(sortingArray[i]), Integer.parseInt(sortingArray[i + 1]));
                continue;
            }
            catch (NumberFormatException e) {
                BugtrackingManager.LOG.log(Level.FINE, null, e);
                continue;
            }
            catch (ArrayIndexOutOfBoundsException e) {
                BugtrackingManager.LOG.log(Level.FINE, null, e);
            }
        }
        return map;
    }

    private void initFilters(boolean includeObsoletes) {
        this.allFilter = Filter.getAllFilter(this.query);
        this.newOrChangedFilter = Filter.getNotSeenFilter(this.query);
        this.filters = includeObsoletes ? new Filter[]{this.allFilter, this.newOrChangedFilter, Filter.getObsoleteDateFilter(this.query), Filter.getAllButObsoleteDateFilter(this.query)} : new Filter[]{this.allFilter, this.newOrChangedFilter};
        this.filter = this.allFilter;
    }

    int getSeenColumnIdx() {
        return this.tableModel.getIndexForPropertyName("issue.seen");
    }

    int getRecentChangesColumnIdx() {
        return this.tableModel.getIndexForPropertyName("issue.recent_changes");
    }

    private void setFilterIntern(Filter filter) {
        ArrayList<IssueNode> filteredNodes = new ArrayList<IssueNode>(this.nodes.size());
        for (IssueNode node : this.nodes) {
            if (filter != null && !filter.accept(node)) continue;
            filteredNodes.add(node);
        }
        this.setTableModel(filteredNodes.toArray(new IssueNode[filteredNodes.size()]));
    }

    SummaryTextFilter getSummaryFilter() {
        return this.textFilter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addCellAction(int row, int column, Rectangle bounds, ActionListener l) {
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            Cell cell = new Cell(row, column);
            Set<CellAction> actions = this.cellActions.get(cell);
            if (actions == null) {
                actions = new HashSet<CellAction>(1);
                this.cellActions.put(cell, actions);
            }
            actions.add(new CellAction(bounds, l));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCellActions(int row, int column) {
        Cell cell = new Cell(row, column);
        Map<Cell, Set<CellAction>> map = this.cellActions;
        synchronized (map) {
            this.cellActions.remove(cell);
        }
    }

    void setDefaultColumnSizes() {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                int[] widths = BugtrackingConfig.getInstance().getColumnWidths(IssueTable.this.getColumnsKey());
                Map persistedColumnsMap = IssueTable.this.getPersistedColumnValues();
                if (persistedColumnsMap.size() > 0) {
                    TableColumnModel columnModel = IssueTable.this.table.getColumnModel();
                    int columnCount = columnModel.getColumnCount();
                    for (int i = 0; i < columnCount; ++i) {
                        String id = IssueTable.this.tableModel.getColumnId(i);
                        Integer w = (Integer)persistedColumnsMap.get(id);
                        if (w == null || w <= 0) continue;
                        this.setColumnWidth(i, w);
                    }
                } else if (widths != null && widths.length > 0) {
                    int columnCount = IssueTable.this.table.getColumnModel().getColumnCount();
                    for (int i = 0; i < widths.length && i < columnCount; ++i) {
                        int w = widths[i];
                        if (w <= 0) continue;
                        this.setColumnWidth(i, w);
                    }
                } else {
                    ColumnDescriptor[] visibleDescriptors = IssueTable.this.getVisibleDescriptors();
                    for (int i = 0; i < visibleDescriptors.length; ++i) {
                        ColumnDescriptor desc = visibleDescriptors[i];
                        int w = desc.getWidth();
                        if (w > 0) {
                            this.setColumnWidth(i, w);
                            continue;
                        }
                        if (w != 0) continue;
                        this.setWidthForFit(i);
                    }
                    if (IssueTable.this.query.isSaved()) {
                        int w = UIUtils.getColumnWidthInPixels(25, (JComponent)IssueTable.this.table);
                        this.setColumnWidth(IssueTable.this.getRecentChangesColumnIdx(), w);
                    }
                }
                if (IssueTable.this.query.isSaved()) {
                    int seenIdx = IssueTable.this.getSeenColumnIdx();
                    IssueTable.this.table.getColumnModel().getColumn(seenIdx).setMaxWidth(28);
                    IssueTable.this.table.getColumnModel().getColumn(seenIdx).setPreferredWidth(28);
                }
            }

            private void setColumnWidth(int i, int w) {
                IssueTable.this.table.getColumnModel().getColumn(i).setMinWidth(10);
                IssueTable.this.table.getColumnModel().getColumn(i).setMaxWidth(10000);
                IssueTable.this.table.getColumnModel().getColumn(i).setPreferredWidth(w);
            }

            private void setWidthForFit(int i) {
                TableColumn c = IssueTable.this.table.getColumnModel().getColumn(i);
                Component comp = IssueTable.this.queryTableHeaderRenderer.getTableCellRendererComponent(IssueTable.this.table, c.getHeaderValue(), false, false, 0, i);
                if (comp instanceof JLabel) {
                    JLabel label = (JLabel)comp;
                    int w = label.getPreferredSize().width;
                    if (w > -1) {
                        this.setColumnWidth(i, w);
                    }
                }
            }
        };
        if (EventQueue.isDispatchThread()) {
            r.run();
        } else {
            SwingUtilities.invokeLater(r);
        }
    }

    private ColumnDescriptor[] getVisibleDescriptors() {
        LinkedList<ColumnDescriptor> visible = new LinkedList<ColumnDescriptor>();
        for (ColumnDescriptor d : this.descriptors) {
            if (!d.isVisible()) continue;
            visible.add(d);
        }
        return visible.toArray(new ColumnDescriptor[visible.size()]);
    }

    @Override
    public void ancestorAdded(AncestorEvent event) {
        this.setDefaultColumnSizes();
    }

    @Override
    public void ancestorMoved(AncestorEvent event) {
    }

    @Override
    public void ancestorRemoved(AncestorEvent event) {
    }

    private void setModelProperties(boolean isSaved) {
        Map<String, Integer> persistedColumnsMap;
        ArrayList<ColumnDescriptor> properties = new ArrayList<ColumnDescriptor>(this.descriptors.length + (this.query.isSaved() ? 2 : 0));
        for (int i = 0; i < this.descriptors.length; ++i) {
            ColumnDescriptor desc = this.descriptors[i];
            properties.add(desc);
        }
        if (this.query.isSaved()) {
            properties.add(new RecentChangesDescriptor());
            properties.add(new SeenDescriptor());
        }
        if ((persistedColumnsMap = this.getPersistedColumnValues()).size() > 0) {
            for (ColumnDescriptor cd : properties) {
                cd.setVisible(persistedColumnsMap.containsKey(cd.getName()));
            }
        }
        this.descriptors = properties.toArray(new ColumnDescriptor[properties.size()]);
        this.tableModel.setProperties(this.descriptors);
    }

    private Map<String, Integer> getPersistedColumnValues() {
        String columns = BugtrackingConfig.getInstance().getColumns(this.getColumnsKey());
        String[] visibleColumns = columns.split(CONFIG_DELIMITER);
        if (visibleColumns.length <= 1) {
            return Collections.EMPTY_MAP;
        }
        HashMap<String, Integer> ret = new HashMap<String, Integer>();
        for (int i = 0; i < visibleColumns.length; i += 2) {
            try {
                ret.put(visibleColumns[i], Integer.parseInt(visibleColumns[i + 1]));
                continue;
            }
            catch (NumberFormatException nfe) {
                ret.put(visibleColumns[i], -1);
                BugtrackingManager.LOG.log(Level.WARNING, visibleColumns[i], nfe);
            }
        }
        return ret;
    }

    private void setTableModel(IssueNode[] nodes) {
        this.tableModel.setNodes((Node[])nodes);
    }

    void focus() {
        this.table.requestFocus();
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void mouseClicked(MouseEvent e) {
        int row = this.table.rowAtPoint(e.getPoint());
        int column = this.table.columnAtPoint(e.getPoint());
        if (SwingUtilities.isLeftMouseButton(e)) {
            if (row == -1) {
                return;
            }
            row = this.sorter.modelIndex(row);
            if (MouseUtils.isDoubleClick((MouseEvent)e)) {
                Action action = this.tableModel.getNodes()[row].getPreferredAction();
                if (action.isEnabled()) {
                    action.actionPerformed(new ActionEvent(this, 0, ""));
                }
            } else {
                Object issue;
                if (column == this.getSeenColumnIdx()) {
                    IssueNode in = (IssueNode)this.tableModel.getNodes()[row];
                    issue = (IssueImpl)in.getLookup().lookup(IssueImpl.class);
                    BugtrackingManager.getInstance().getRequestProcessor().post(new Runnable((IssueImpl)issue){
                        final /* synthetic */ IssueImpl val$issue;
                        {
                            this.val$issue = issueImpl;
                        }

                        @Override
                        public void run() {
                            IssueCacheUtils.switchSeen(this.val$issue);
                        }
                    });
                }
                CellAction[] actions = null;
                issue = this.cellActions;
                synchronized (issue) {
                    Cell cell = new Cell(row, column);
                    Set<CellAction> set = this.cellActions.get(cell);
                    actions = set != null ? set.toArray(new CellAction[set.size()]) : null;
                }
                if (actions != null) {
                    for (CellAction cellAction : actions) {
                        cellAction.actionPerformed(null);
                    }
                }
            }
        }
    }

    @Override
    public void keyTyped(KeyEvent e) {
        int row;
        if (e.getKeyChar() == '\n' && (row = this.table.getSelectedRow()) != -1) {
            row = this.sorter.modelIndex(row);
            Action action = this.tableModel.getNodes()[row].getPreferredAction();
            if (action.isEnabled()) {
                action.actionPerformed(new ActionEvent(this, 0, ""));
            }
        }
    }

    @Override
    public void keyPressed(KeyEvent e) {
        int row;
        if (e.getKeyChar() == '\n' && (row = this.table.getSelectedRow()) != -1) {
            e.consume();
        }
    }

    @Override
    public void keyReleased(KeyEvent e) {
    }

    public void addNode(final IssueNode node) {
        this.nodes.add(node);
        if (this.filter == null || this.filter.accept(node)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    IssueTable.this.tableModel.insertNode((Node)node);
                }
            });
        }
    }

    public void started() {
        this.nodes.clear();
        this.setTableModel(new IssueNode[0]);
    }

    private String getColumnsKey() {
        String name = this.query.getDisplayName();
        if (name == null) {
            name = "#find#issues#hitlist#table#";
        }
        return this.query.getRepositoryImpl().getId() + ":" + name;
    }

    private class StoreColumnsHandler
    implements Runnable {
        private StoreColumnsHandler() {
        }

        @Override
        public void run() {
            TableColumnModel cm = IssueTable.this.table.getColumnModel();
            int count = cm.getColumnCount();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < count; ++i) {
                sb.append(IssueTable.this.tableModel.getColumnId(i));
                sb.append(IssueTable.CONFIG_DELIMITER);
                sb.append(cm.getColumn(i).getWidth());
                if (i >= count - 1) continue;
                sb.append(IssueTable.CONFIG_DELIMITER);
            }
            BugtrackingConfig.getInstance().storeColumns(IssueTable.this.getColumnsKey(), sb.toString());
        }
    }

    private class RecentChangesDescriptor
    extends ColumnDescriptor<String> {
        public RecentChangesDescriptor() {
            super("issue.recent_changes", String.class, NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Recent"), NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Recent_Desc"), -1, true, true);
        }
    }

    private class SeenDescriptor
    extends ColumnDescriptor<Boolean> {
        public SeenDescriptor() {
            super("issue.seen", Boolean.class, "", NbBundle.getBundle(IssueTable.class).getString("CTL_Issue_Seen_Desc"), -1, true, true);
        }
    }

    private class Cell {
        private final int row;
        private final int column;

        public Cell(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Cell other = (Cell)obj;
            if (this.row != other.row) {
                return false;
            }
            return this.column == other.column;
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("row=");
            sb.append(this.row);
            sb.append(",column=");
            sb.append(this.column);
            sb.append("]");
            return sb.toString();
        }
    }

    private static class CellAction
    implements ActionListener {
        private final Rectangle bounds;
        private final ActionListener listener;

        public CellAction(Rectangle bounds, ActionListener listener) {
            this.bounds = bounds;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            CellAction other = (CellAction)obj;
            return this.bounds == other.bounds || this.bounds != null && this.bounds.equals(other.bounds);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[");
            sb.append("bounds=");
            sb.append(this.bounds);
            sb.append("]");
            return sb.toString();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.listener.actionPerformed(e);
        }
    }

    public static interface IssueTableProvider {
        public IssueTable getIssueTable();
    }
}

