/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.issuetable;

import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.issuetable.IssueNode;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;
import org.openide.util.NbBundle;

public abstract class Filter {
    private static Map<QueryImpl, Map<Class, Filter>> queryToFilter = new WeakHashMap<QueryImpl, Map<Class, Filter>>();

    public abstract String getDisplayName();

    public abstract boolean accept(IssueNode var1);

    public static Filter getAllFilter(QueryImpl query) {
        return Filter.getFilter(query, AllFilter.class);
    }

    public static Filter getNotSeenFilter(QueryImpl query) {
        return Filter.getFilter(query, NotSeenFilter.class);
    }

    public static Filter getNewFilter(QueryImpl query) {
        return Filter.getFilter(query, NewFilter.class);
    }

    public static Filter getObsoleteDateFilter(QueryImpl query) {
        return Filter.getFilter(query, ObsoleteDateFilter.class);
    }

    public static Filter getAllButObsoleteDateFilter(QueryImpl query) {
        return Filter.getFilter(query, AllButObsoleteDateFilter.class);
    }

    private static <T extends Filter> Filter getFilter(QueryImpl query, Class<T> clazz) {
        Filter filter;
        Map<Class, Filter> filters = queryToFilter.get(query);
        if (filters == null) {
            filters = new HashMap<Class, Filter>(5);
            queryToFilter.put(query, filters);
        }
        if ((filter = filters.get(clazz)) == null) {
            try {
                if (query == null) {
                    Constructor<T> c = clazz.getDeclaredConstructor(new Class[0]);
                    filter = (Filter)c.newInstance(new Object[0]);
                } else {
                    Constructor<T> c = clazz.getDeclaredConstructor(QueryImpl.class);
                    filter = (Filter)c.newInstance(query);
                }
            }
            catch (Exception ex) {
                BugtrackingManager.LOG.log(Level.SEVERE, null, ex);
            }
            filters.put(clazz, filter);
        }
        return filter;
    }

    private static boolean contains(QueryImpl query, String id) {
        return query.contains(id);
    }

    private static class AllButObsoleteDateFilter
    extends Filter {
        private final QueryImpl query;

        AllButObsoleteDateFilter(QueryImpl query) {
            this.query = query;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_AllButObsoleteIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return Filter.contains(this.query, node.getIssue().getID());
        }
    }

    private static class ObsoleteDateFilter
    extends Filter {
        private final QueryImpl query;

        ObsoleteDateFilter(QueryImpl query) {
            this.query = query;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_ObsoleteIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return !Filter.contains(this.query, node.getIssue().getID());
        }
    }

    private static class NewFilter
    extends Filter {
        private final QueryImpl query;

        NewFilter(QueryImpl query) {
            this.query = query;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_NewIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return IssueCacheUtils.getStatus(node.getIssue()) == 4;
        }
    }

    private static class NotSeenFilter
    extends Filter {
        private final QueryImpl query;

        NotSeenFilter(QueryImpl query) {
            this.query = query;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_UnseenIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return !IssueCacheUtils.wasSeen(node.getIssue()) && Filter.contains(this.query, node.getIssue().getID());
        }
    }

    private static class AllFilter
    extends Filter {
        private final QueryImpl query;

        AllFilter(QueryImpl query) {
            this.query = query;
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(Filter.class, (String)"LBL_AllIssuesFilter");
        }

        @Override
        public boolean accept(IssueNode node) {
            return Filter.contains(this.query, node.getIssue().getID());
        }
    }
}

