/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.util.Collection;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.RepositoryQueryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public final class RepositoryQuery {
    private static RepositoryQuery instance;

    private RepositoryQuery() {
    }

    public static synchronized RepositoryQuery getInstance() {
        if (instance == null) {
            instance = new RepositoryQuery();
        }
        return instance;
    }

    public Repository getRepository(FileObject fileObject, boolean askIfUnknown) {
        if (fileObject == null) {
            return null;
        }
        Collection<? extends RepositoryQueryImplementation> impls = this.getImplementations();
        for (RepositoryQueryImplementation repositoryQueryImplementation : impls) {
            Repository repo = repositoryQueryImplementation.getRepository(fileObject, askIfUnknown);
            if (repo == null) continue;
            return repo;
        }
        return null;
    }

    private Collection<? extends RepositoryQueryImplementation> getImplementations() {
        Collection result = Lookup.getDefault().lookupAll(RepositoryQueryImplementation.class);
        return result;
    }
}

