/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.RepositoryRegistry;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.kenai.KenaiRepositories;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiUtil;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public final class RepositoryManager {
    public static final String EVENT_REPOSITORIES_CHANGED = "bugtracking.repositories.changed";
    private static RepositoryManager instance;
    private static RepositoryRegistry registry;
    private PropertyChangeSupport changeSupport = new PropertyChangeSupport(this);

    private RepositoryManager() {
        registry = RepositoryRegistry.getInstance();
        RepositoryListener l = new RepositoryListener();
        registry.addPropertyChangeListener(l);
        KenaiRepositories.getInstance().addPropertyChangeListener(l);
    }

    public static synchronized RepositoryManager getInstance() {
        if (instance == null) {
            instance = new RepositoryManager();
        }
        return instance;
    }

    public void addPropertChangeListener(PropertyChangeListener l) {
        this.changeSupport.addPropertyChangeListener(l);
    }

    public void removePropertChangeListener(PropertyChangeListener l) {
        this.changeSupport.removePropertyChangeListener(l);
    }

    public Collection<Repository> getRepositories() {
        LinkedList<Repository> ret = new LinkedList<Repository>();
        ret.addAll(KenaiUtil.getRepositories(false, true));
        ret.addAll(this.toRepositories(registry.getRepositories()));
        return Collections.unmodifiableCollection(ret);
    }

    public Collection<Repository> getRepositories(String connectorId) {
        LinkedList<Repository> ret = new LinkedList<Repository>();
        ret.addAll(KenaiUtil.getRepositories(connectorId, false, true));
        ret.addAll(this.toRepositories(registry.getRepositories(connectorId)));
        return ret;
    }

    public Repository createRepository() {
        RepositoryImpl repoImpl = BugtrackingUtil.createRepository(false);
        return repoImpl != null ? repoImpl.getRepository() : null;
    }

    private Collection<Repository> toRepositories(Collection<RepositoryImpl> impls) {
        if (impls == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<Repository> ret = new ArrayList<Repository>(impls.size());
        for (RepositoryImpl repoImpl : impls) {
            ret.add(repoImpl.getRepository());
        }
        return ret;
    }

    private class RepositoryListener
    implements PropertyChangeListener {
        private RepositoryListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (RepositoryManager.EVENT_REPOSITORIES_CHANGED.equals(evt.getPropertyName())) {
                Collection newImpls = (Collection)evt.getNewValue();
                Collection oldImpls = (Collection)evt.getOldValue();
                RepositoryManager.this.changeSupport.firePropertyChange(RepositoryManager.EVENT_REPOSITORIES_CHANGED, oldImpls != null ? RepositoryManager.this.toRepositories(oldImpls) : null, newImpls != null ? RepositoryManager.this.toRepositories(newImpls) : null);
            }
        }
    }
}

