/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.awt.Image;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.QueryImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.APIAccessorImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public final class Repository {
    public static final String EVENT_QUERY_LIST_CHANGED = "bugtracking.repository.queries.changed";
    public static final String EVENT_ATTRIBUTES_CHANGED = "bugtracking.repository.attributes.changed";
    public static final String ATTRIBUTE_URL = "repository.attribute.url";
    public static final String ATTRIBUTE_DISPLAY_NAME = "repository.attribute.displayName";
    private static final Logger LOG = Logger.getLogger("org.netbeans.modules.bugtracking.Repository");
    private final RepositoryImpl<?, ?, ?> impl;

    <R, Q, I> Repository(RepositoryImpl<R, Q, I> impl) {
        this.impl = impl;
        if (LOG.isLoggable(Level.FINE)) {
            LOG.log(Level.FINE, "created repository {0} - repository: {1} - impl: {2}", new Object[]{this.getDisplayName(), this, impl});
        }
    }

    public Image getIcon() {
        return this.impl.getIcon();
    }

    public String getDisplayName() {
        return this.impl.getDisplayName();
    }

    public String getTooltip() {
        return this.impl.getTooltip();
    }

    public String getId() {
        return this.impl.getId();
    }

    public String getUrl() {
        return this.impl.getUrl();
    }

    public Collection<Query> getQueries() {
        Collection<QueryImpl> c = this.impl.getQueries();
        ArrayList<Query> ret = new ArrayList<Query>();
        for (QueryImpl q : c) {
            ret.add(q.getQuery());
        }
        return ret;
    }

    public boolean isMutable() {
        return this.impl.isMutable();
    }

    public void remove() {
        this.impl.remove();
    }

    public void edit() {
        BugtrackingUtil.editRepository(this);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public Issue[] getIssues(String ... ids) {
        Collection<IssueImpl> impls = this.impl.getIssueImpls(ids);
        ArrayList<Issue> ret = new ArrayList<Issue>(impls.size());
        for (IssueImpl issueImpl : impls) {
            ret.add(issueImpl.getIssue());
        }
        return ret.toArray(new Issue[ret.size()]);
    }

    <R, Q, I> RepositoryImpl<R, Q, I> getImpl() {
        return this.impl;
    }

    static {
        APIAccessorImpl.createAccesor();
    }
}

