/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking.api;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;
import org.netbeans.modules.bugtracking.ui.issue.cache.IssueCacheUtils;

public final class Issue {
    public static final String EVENT_ISSUE_REFRESHED = "issue.data_changed";
    private final IssueImpl impl;

    Issue(IssueImpl impl) {
        this.impl = impl;
    }

    public String getID() {
        return this.impl.getID();
    }

    public String getTooltip() {
        return this.impl.getTooltip();
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.impl.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.impl.removePropertyChangeListener(listener);
    }

    public boolean refresh() {
        return this.impl.refresh();
    }

    public String getDisplayName() {
        return this.impl.getDisplayName();
    }

    public String getShortenedDisplayName() {
        return this.impl.getShortenedDisplayName();
    }

    public void open() {
        this.impl.open();
    }

    public final void open(boolean refresh) {
        this.impl.open(refresh);
    }

    public static void open(Repository repository, String issueId) {
        if (issueId == null) {
            IssueAction.createIssue(repository.getImpl());
        } else {
            IssueAction.openIssue(repository.getImpl(), issueId);
        }
    }

    IssueImpl getImpl() {
        return this.impl;
    }

    public String getSummary() {
        return this.impl.getSummary();
    }

    public boolean isFinished() {
        return this.impl.isFinished();
    }

    public Status getStatus() {
        int status = IssueCacheUtils.getStatus(this.impl);
        switch (status) {
            case 2: {
                return Status.UPTODATE;
            }
            case 4: {
                return Status.NEW;
            }
            case 8: {
                return Status.MODIFIED;
            }
        }
        throw new IllegalStateException("Unexpected status value " + status);
    }

    public void attachPatch(File file, String description) {
        this.impl.attachPatch(file, description);
    }

    public void addComment(String msg, boolean closeAsFixed) {
        this.impl.addComment(msg, closeAsFixed);
    }

    public Repository getRepository() {
        return this.impl.getRepositoryImpl().getRepository();
    }

    public static enum Status {
        NEW,
        MODIFIED,
        UPTODATE;

    }
}

