/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Query;
import org.netbeans.modules.bugtracking.issuetable.IssueTable;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiQueryProvider;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.spi.QueryController;
import org.netbeans.modules.bugtracking.spi.QueryProvider;
import org.netbeans.modules.bugtracking.ui.query.QueryAction;
import org.netbeans.modules.bugtracking.util.BugtrackingUtil;

public final class QueryImpl<Q, I> {
    private final RepositoryImpl repository;
    private final QueryProvider<Q, I> queryProvider;
    private final IssueProvider<I> issueProvider;
    private Query query;
    private final Q data;

    QueryImpl(RepositoryImpl repository, QueryProvider<Q, I> queryProvider, IssueProvider<I> issueProvider, Q data) {
        this.queryProvider = queryProvider;
        this.issueProvider = issueProvider;
        this.data = data;
        this.repository = repository;
    }

    public synchronized Query getQuery() {
        if (this.query == null) {
            this.query = APIAccessor.IMPL.createQuery(this);
        }
        return this.query;
    }

    public RepositoryImpl getRepositoryImpl() {
        return this.repository;
    }

    public Collection<IssueImpl> getIssues() {
        Collection<I> issues = this.queryProvider.getIssues(this.data);
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(issues.size());
        for (I i : issues) {
            IssueImpl issue = this.repository.getIssue(i);
            ret.add(issue);
        }
        return ret;
    }

    public Collection<IssueImpl> getIssues(String criteria) {
        return Collections.unmodifiableCollection(BugtrackingUtil.getByIdOrSummary(this.getIssues(), criteria));
    }

    public static void openNew(RepositoryImpl repository) {
        QueryAction.openQuery(null, repository);
    }

    public void open(boolean suggestedSelectionOnly, Query.QueryMode mode) {
        switch (mode) {
            case SHOW_ALL: {
                this.queryProvider.getController(this.data).setMode(QueryController.QueryMode.SHOW_ALL);
                break;
            }
            case SHOW_NEW_OR_CHANGED: {
                this.queryProvider.getController(this.data).setMode(QueryController.QueryMode.SHOW_NEW_OR_CHANGED);
                break;
            }
            default: {
                throw new IllegalStateException("Unsupported mode " + (Object)((Object)mode));
            }
        }
        QueryAction.openQuery(this, this.repository, suggestedSelectionOnly);
    }

    public boolean isSaved() {
        return this.queryProvider.isSaved(this.data);
    }

    public void remove() {
        this.queryProvider.remove(this.data);
    }

    public String getTooltip() {
        return this.queryProvider.getTooltip(this.data);
    }

    public boolean contains(String id) {
        return this.queryProvider.contains(this.data, id);
    }

    public void refresh() {
        this.queryProvider.refresh(this.data);
    }

    public String getDisplayName() {
        return this.queryProvider.getDisplayName(this.data);
    }

    public QueryController getController() {
        return this.queryProvider.getController(this.data);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.queryProvider.addPropertyChangeListener(this.data, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.queryProvider.removePropertyChangeListener(this.data, listener);
    }

    public void setContext(OwnerInfo info) {
        assert (this.queryProvider instanceof KenaiQueryProvider);
        if (this.queryProvider instanceof KenaiQueryProvider) {
            ((KenaiQueryProvider)this.queryProvider).setOwnerInfo(this.data, info);
        }
    }

    public boolean needsLogin() {
        assert (this.queryProvider instanceof KenaiQueryProvider);
        if (this.queryProvider instanceof KenaiQueryProvider) {
            return ((KenaiQueryProvider)this.queryProvider).needsLogin(this.data);
        }
        return false;
    }

    public IssueTable getIssueTable() {
        QueryController controller = this.getController();
        if (controller instanceof IssueTable.IssueTableProvider) {
            return ((IssueTable.IssueTableProvider)((Object)controller)).getIssueTable();
        }
        return null;
    }

    public boolean isData(Object obj) {
        return this.data == obj;
    }
}

