/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.beans.PropertyChangeListener;
import java.io.File;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.api.Issue;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiIssueProvider;
import org.netbeans.modules.bugtracking.kenai.spi.OwnerInfo;
import org.netbeans.modules.bugtracking.spi.BugtrackingController;
import org.netbeans.modules.bugtracking.spi.IssueProvider;
import org.netbeans.modules.bugtracking.ui.issue.IssueAction;

public final class IssueImpl<I> {
    private static final int SHORT_DISP_NAME_LENGTH = 15;
    private Issue issue;
    private final RepositoryImpl repo;
    private final IssueProvider<I> issueProvider;
    private final I data;

    IssueImpl(RepositoryImpl repo, IssueProvider<I> issueProvider, I data) {
        this.issueProvider = issueProvider;
        this.data = data;
        this.repo = repo;
    }

    public synchronized Issue getIssue() {
        if (this.issue == null) {
            this.issue = APIAccessor.IMPL.createIssue(this);
        }
        return this.issue;
    }

    public void open() {
        IssueAction.openIssue(this, false);
    }

    public final void open(boolean refresh) {
        IssueAction.openIssue(this, refresh);
    }

    public String getShortenedDisplayName() {
        int limit;
        String displayName = this.getDisplayName();
        int length = displayName.length();
        if (length <= (limit = 15)) {
            return displayName;
        }
        String trimmed = displayName.substring(0, limit).trim();
        StringBuilder buf = new StringBuilder(limit + 4);
        buf.append(trimmed);
        if (length > limit + 1 && Character.isSpaceChar(displayName.charAt(limit))) {
            buf.append(' ');
        }
        buf.append("...");
        return buf.toString();
    }

    public RepositoryImpl getRepositoryImpl() {
        return this.repo;
    }

    IssueProvider getProvider() {
        return this.issueProvider;
    }

    public String getID() {
        return this.issueProvider.getID(this.data);
    }

    public String getSummary() {
        return this.issueProvider.getSummary(this.data);
    }

    public String getTooltip() {
        return this.issueProvider.getTooltip(this.data);
    }

    public void attachPatch(File file, String description) {
        this.issueProvider.attachPatch(this.data, file, description);
    }

    public void addComment(String comment, boolean closeAsFixed) {
        this.issueProvider.addComment(this.data, comment, closeAsFixed);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.issueProvider.addPropertyChangeListener(this.data, listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.issueProvider.removePropertyChangeListener(this.data, listener);
    }

    public boolean refresh() {
        return this.issueProvider.refresh(this.data);
    }

    public boolean isNew() {
        return this.issueProvider.isNew(this.data);
    }

    public boolean isFinished() {
        return this.issueProvider.isFinished(this.data);
    }

    public String getDisplayName() {
        return this.issueProvider.getDisplayName(this.data);
    }

    public void setContext(OwnerInfo info) {
        assert (this.issueProvider instanceof KenaiIssueProvider);
        if (this.issueProvider instanceof KenaiIssueProvider) {
            ((KenaiIssueProvider)this.issueProvider).setOwnerInfo(this.data, info);
        }
    }

    public BugtrackingController getController() {
        return this.issueProvider.getController(this.data);
    }
}

