/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.awt.Image;
import java.util.Map;
import java.util.logging.Level;
import org.netbeans.modules.bugtracking.BugtrackingManager;
import org.netbeans.modules.bugtracking.api.Repository;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.netbeans.modules.bugtracking.spi.IssueFinder;
import org.netbeans.modules.bugtracking.spi.RepositoryInfo;
import org.netbeans.modules.bugtracking.spi.TaskListIssueProvider;
import org.openide.util.ImageUtilities;

public class DelegatingConnector
extends BugtrackingConnector {
    private static final boolean OVERRIDE_REPOSITORY_MANAGEMENT = Boolean.getBoolean("org.netbeans.modules.bugtracking.connector.overrrideRepositoryManagement");
    private final Map<?, ?> map;
    private final String tooltip;
    private Image image;
    private final String id;
    private final String displayName;
    private final boolean providesRepositoryManagement;
    private BugtrackingConnector delegate;

    public static BugtrackingConnector create(Map<?, ?> map) {
        return new DelegatingConnector(map);
    }

    public DelegatingConnector(BugtrackingConnector delegate, String id, String displayName, String tooltip, Image image) {
        this.tooltip = tooltip;
        this.image = image;
        this.id = id;
        this.displayName = displayName;
        this.delegate = delegate;
        this.providesRepositoryManagement = true;
        this.map = null;
    }

    private DelegatingConnector(Map<?, ?> map) {
        this.map = map;
        this.tooltip = (String)map.get("tooltip");
        String path = (String)map.get("iconPath");
        this.image = path != null && !path.equals("") ? ImageUtilities.loadImage((String)path) : null;
        this.id = (String)map.get("id");
        this.displayName = (String)map.get("displayName");
        this.providesRepositoryManagement = (Boolean)map.get("providesRepositoryManagement");
        BugtrackingManager.LOG.log(Level.FINE, "Created DelegatingConnector for : {0}", map.get("displayName"));
    }

    public BugtrackingConnector getDelegate() {
        if (this.delegate == null) {
            assert (this.map != null);
            this.delegate = (BugtrackingConnector)this.map.get("delegate");
            if (this.delegate == null) {
                BugtrackingManager.LOG.log(Level.WARNING, "Couldn't create delegate for : {0}", this.map.get("displayName"));
            } else {
                BugtrackingManager.LOG.log(Level.FINE, "Created delegate for : {0}", this.map.get("displayName"));
            }
        }
        return this.delegate;
    }

    public String getTooltip() {
        return this.tooltip;
    }

    public Image getIcon() {
        return this.image;
    }

    public String getID() {
        return this.id;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public boolean providesRepositoryManagement() {
        return OVERRIDE_REPOSITORY_MANAGEMENT ? true : this.providesRepositoryManagement;
    }

    @Override
    public Repository createRepository(RepositoryInfo info) {
        BugtrackingConnector d = this.getDelegate();
        return d != null ? d.createRepository(info) : null;
    }

    @Override
    public IssueFinder getIssueFinder() {
        BugtrackingConnector d = this.getDelegate();
        return d != null ? d.getIssueFinder() : null;
    }

    @Override
    public Repository createRepository() {
        BugtrackingConnector d = this.getDelegate();
        return d != null ? d.createRepository() : null;
    }

    @Override
    public TaskListIssueProvider getTasklistProvider() {
        BugtrackingConnector d = this.getDelegate();
        return d != null ? d.getTasklistProvider() : null;
    }
}

