/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.bugtracking;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.bugtracking.APIAccessor;
import org.netbeans.modules.bugtracking.DelegatingConnector;
import org.netbeans.modules.bugtracking.IssueImpl;
import org.netbeans.modules.bugtracking.RepositoryImpl;
import org.netbeans.modules.bugtracking.kenai.spi.KenaiAccessor;
import org.netbeans.modules.bugtracking.kenai.spi.RecentIssue;
import org.netbeans.modules.bugtracking.spi.BugtrackingConnector;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.RequestProcessor;

public final class BugtrackingManager
implements LookupListener {
    private static BugtrackingManager instance;
    public static final Logger LOG;
    private RequestProcessor rp = new RequestProcessor("Bugtracking manager");
    private final Collection<BugtrackingConnector> connectors = new ArrayList<BugtrackingConnector>(2);
    private Lookup.Result<BugtrackingConnector> connectorsLookup;
    private Map<String, List<RecentIssue>> recentIssues;
    private KenaiAccessor[] kenaiAccessors;

    public static synchronized BugtrackingManager getInstance() {
        if (instance == null) {
            instance = new BugtrackingManager();
        }
        return instance;
    }

    private BugtrackingManager() {
    }

    public RequestProcessor getRequestProcessor() {
        return this.rp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DelegatingConnector[] getConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.refreshConnectors();
            }
            return this.connectors.toArray(new DelegatingConnector[this.connectors.size()]);
        }
    }

    public void resultChanged(LookupEvent ev) {
        this.refreshConnectors();
    }

    public List<IssueImpl> getRecentIssues(RepositoryImpl repo) {
        assert (repo != null);
        List<RecentIssue> l = this.getRecentIssues().get(repo.getId());
        if (l == null) {
            return Collections.EMPTY_LIST;
        }
        ArrayList<IssueImpl> ret = new ArrayList<IssueImpl>(l.size());
        for (RecentIssue recentIssue : l) {
            ret.add(APIAccessor.IMPL.getImpl(recentIssue.getIssue()));
        }
        return ret;
    }

    public void addRecentIssue(RepositoryImpl repo, IssueImpl issue) {
        assert (repo != null && issue != null);
        if (issue.getID() == null) {
            return;
        }
        List<RecentIssue> l = this.getRecentIssues().get(repo.getId());
        if (l == null) {
            l = new LinkedList<RecentIssue>();
            this.getRecentIssues().put(repo.getId(), l);
        }
        for (RecentIssue i : l) {
            if (!i.getIssue().getID().equals(issue.getID())) continue;
            l.remove(i);
            break;
        }
        l.add(0, new RecentIssue(issue.getIssue(), System.currentTimeMillis()));
        if (LOG.isLoggable(Level.FINE)) {
            SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            for (RecentIssue ri : l) {
                LOG.log(Level.FINE, "recent issue: [{0}, {1}, {2}]", new Object[]{APIAccessor.IMPL.getImpl(ri.getIssue()).getRepositoryImpl().getDisplayName(), ri.getIssue().getID(), f.format(new Date(ri.getTimestamp()))});
            }
        }
    }

    public Map<String, List<RecentIssue>> getAllRecentIssues() {
        return Collections.unmodifiableMap(this.getRecentIssues());
    }

    public KenaiAccessor[] getKenaiAccessors() {
        if (this.kenaiAccessors == null) {
            Collection coll = Lookup.getDefault().lookupAll(KenaiAccessor.class);
            this.kenaiAccessors = coll.toArray(new KenaiAccessor[coll.size()]);
        }
        return this.kenaiAccessors;
    }

    private Map<String, List<RecentIssue>> getRecentIssues() {
        if (this.recentIssues == null) {
            this.recentIssues = new HashMap<String, List<RecentIssue>>();
        }
        return this.recentIssues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshConnectors() {
        Collection<BugtrackingConnector> collection = this.connectors;
        synchronized (collection) {
            if (this.connectorsLookup == null) {
                this.connectorsLookup = Lookup.getDefault().lookup(new Lookup.Template(BugtrackingConnector.class));
                this.connectorsLookup.addLookupListener((LookupListener)this);
            }
            Collection conns = this.connectorsLookup.allInstances();
            if (LOG.isLoggable(Level.FINER)) {
                for (BugtrackingConnector c : conns) {
                    DelegatingConnector dc = c instanceof DelegatingConnector ? (DelegatingConnector)c : new DelegatingConnector(c, "Unknown", "Unknown", "Unknown", null);
                    LOG.log(Level.FINER, "registered provider: {0}", dc.getDisplayName());
                }
            }
            this.connectors.clear();
            this.connectors.addAll(conns);
        }
    }

    DelegatingConnector getConnector(String connectorId) {
        assert (connectorId != null);
        for (DelegatingConnector c : this.getConnectors()) {
            if (!connectorId.equals(c.getID())) continue;
            return c;
        }
        return null;
    }

    static {
        LOG = Logger.getLogger("org.netbeans.modules.bugtracking.BugtrackingManager");
    }
}

