/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.client.rest.wizard;

import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.ElementFilter;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.api.java.source.JavaSource;
import org.netbeans.api.java.source.Task;
import org.netbeans.modules.web.client.rest.wizard.ModelAttribute;
import org.netbeans.modules.web.client.rest.wizard.ModelGenerator;
import org.netbeans.modules.web.client.rest.wizard.RestPanel;
import org.netbeans.modules.web.client.rest.wizard.RouterGenerator;
import org.netbeans.modules.websvc.rest.model.api.RestServiceDescription;
import org.openide.filesystems.FileObject;

class JSClientGenerator {
    static final String TABLESORTER_URL = "http://mottie.github.com/tablesorter/";
    private static final Logger LOG = Logger.getLogger(JSClientGenerator.class.getName());
    private static final String PATH = "javax.ws.rs.Path";
    private static final String PATH_PARAM = "javax.ws.rs.PathParam";
    private static final String GET = "javax.ws.rs.GET";
    private static final String PUT = "javax.ws.rs.PUT";
    private static final String POST = "javax.ws.rs.POST";
    private static final String DELETE = "javax.ws.rs.DELETE";
    private static final String PRODUCES = "javax.ws.rs.Produces";
    private static final String CONSUMES = "javax.ws.rs.Consumes";
    private static final String JSON = "application/json";
    private static final String XML_ROOT_ELEMENT = "javax.xml.bind.annotation.XmlRootElement";
    private RestServiceDescription myDescription;
    private RestPanel.JsUi myUi;
    private StringBuilder myModels;
    private StringBuilder myRouters;
    private StringBuilder myHeader;
    private StringBuilder myContent;
    private StringBuilder mySidebar;
    private StringBuilder myTmplCreate;
    private StringBuilder myTmplList;
    private StringBuilder myTmplDetails;
    private Set<String> myEntities = new HashSet<String>();
    private boolean isModelGenerated;
    private int myModelsCount;
    private boolean hasUi;

    private JSClientGenerator(RestServiceDescription description, RestPanel.JsUi ui) {
        this.myDescription = description;
        this.myUi = ui;
    }

    static JSClientGenerator create(RestServiceDescription description, RestPanel.JsUi ui) {
        return new JSClientGenerator(description, ui);
    }

    public Map<String, String> generate() {
        FileObject restSource = this.myDescription.getFile();
        if (restSource == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        this.myModels = new StringBuilder();
        this.myRouters = new StringBuilder();
        this.myContent = new StringBuilder();
        this.myHeader = new StringBuilder();
        this.mySidebar = new StringBuilder();
        this.myTmplCreate = new StringBuilder();
        this.myTmplList = new StringBuilder();
        this.myTmplDetails = new StringBuilder();
        JavaSource javaSource = JavaSource.forFileObject((FileObject)restSource);
        final String restClass = this.myDescription.getClassName();
        Task<CompilationController> task = new Task<CompilationController>(){

            public void run(CompilationController controller) throws Exception {
                controller.toPhase(JavaSource.Phase.ELEMENTS_RESOLVED);
                LinkedList<ExecutableElement> getMethods = new LinkedList<ExecutableElement>();
                LinkedList<ExecutableElement> postMethods = new LinkedList<ExecutableElement>();
                LinkedList<ExecutableElement> putMethods = new LinkedList<ExecutableElement>();
                LinkedList<ExecutableElement> deleteMethods = new LinkedList<ExecutableElement>();
                TypeElement restResource = controller.getElements().getTypeElement(restClass);
                List<ExecutableElement> methods = ElementFilter.methodsIn(restResource.getEnclosedElements());
                for (ExecutableElement method : methods) {
                    List<? extends AnnotationMirror> annotations = method.getAnnotationMirrors();
                    if (JSClientGenerator.getAnnotation(annotations, JSClientGenerator.DELETE) != null) {
                        deleteMethods.add(method);
                        continue;
                    }
                    if (!JSClientGenerator.this.hasJsonMedia(annotations)) continue;
                    if (JSClientGenerator.getAnnotation(annotations, JSClientGenerator.GET) != null) {
                        getMethods.add(method);
                        continue;
                    }
                    if (JSClientGenerator.getAnnotation(annotations, JSClientGenerator.POST) != null) {
                        postMethods.add(method);
                        continue;
                    }
                    if (JSClientGenerator.getAnnotation(annotations, JSClientGenerator.PUT) == null) continue;
                    putMethods.add(method);
                }
                try {
                    JSClientGenerator.this.handleRestMethods(controller, getMethods, postMethods, putMethods, deleteMethods);
                }
                catch (IOException e) {
                    LOG.log(Level.WARNING, null, e);
                }
            }
        };
        try {
            Future future = javaSource.runWhenScanFinished((Task)task, true);
            future.get();
        }
        catch (IOException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (InterruptedException e) {
            LOG.log(Level.INFO, null, e);
        }
        catch (ExecutionException e) {
            LOG.log(Level.INFO, null, e);
        }
        if (!this.isModelGenerated) {
            this.myModels.append("// No JSON media type is detected in GET RESTful methods\n");
        }
        result.put("models", this.myModels.toString());
        result.put("routers", this.myRouters.toString());
        result.put("header", this.myHeader.toString());
        result.put("sidebar", this.mySidebar.toString());
        result.put("content", this.myContent.toString());
        result.put("tpl_create", this.myTmplCreate.toString());
        result.put("tpl_list_item", this.myTmplList.toString());
        result.put("tpl_details", this.myTmplDetails.toString());
        if (this.hasUi()) {
            result.put("ui", Boolean.TRUE.toString());
        }
        return result;
    }

    boolean hasUi() {
        return this.hasUi;
    }

    private void handleRestMethods(CompilationController controller, List<ExecutableElement> getMethods, List<ExecutableElement> postMethods, List<ExecutableElement> putMethods, List<ExecutableElement> deleteMethods) throws IOException {
        Element returnElement;
        TypeMirror returnType;
        ExecutableElement method;
        String path;
        HashMap<String, ExecutableElement> noParamGetMethods = new HashMap<String, ExecutableElement>();
        HashMap<String, ExecutableElement> oneParamGetMethods = new HashMap<String, ExecutableElement>();
        for (ExecutableElement method2 : getMethods) {
            List<? extends VariableElement> parameters = method2.getParameters();
            if (parameters.size() > 1) continue;
            AnnotationMirror annotation = JSClientGenerator.getAnnotation(method2, PATH);
            String path2 = this.getValue(annotation);
            if (parameters.isEmpty()) {
                if (path2 == null) {
                    path2 = "";
                }
                noParamGetMethods.put(path2, method2);
                continue;
            }
            VariableElement param = parameters.get(0);
            annotation = JSClientGenerator.getAnnotation(param, PATH_PARAM);
            if (annotation == null) continue;
            String pathNoParam = this.removeParamTemplate(path2, this.getValue(annotation));
            oneParamGetMethods.put(pathNoParam, method2);
        }
        HashMap<String, String> fqn2Path = new HashMap<String, String>();
        for (Map.Entry entry : noParamGetMethods.entrySet()) {
            path = (String)entry.getKey();
            method = (ExecutableElement)entry.getValue();
            returnType = method.getReturnType();
            returnElement = controller.getTypes().asElement(returnType);
            TypeMirror entityCollectionType = this.getCollectionType(returnType, controller);
            if (entityCollectionType == null && returnElement instanceof TypeElement) {
                if (JSClientGenerator.getAnnotation(returnElement, XML_ROOT_ELEMENT) == null) continue;
                EnumMap<HttpRequests, String> paths = new EnumMap<HttpRequests, String>(HttpRequests.class);
                paths.put(HttpRequests.POST, this.parseNoIdPath(postMethods, returnType, controller));
                paths.put(HttpRequests.PUT, this.parseNoIdPath(putMethods, returnType, controller));
                paths.put(HttpRequests.DELETE, this.parseNoIdPath(deleteMethods, returnType, controller));
                this.generate((TypeElement)returnElement, path, null, paths, Collections.<HttpRequests, Boolean>emptyMap(), controller);
                continue;
            }
            Element entityType = controller.getTypes().asElement(entityCollectionType);
            if (!(entityType instanceof TypeElement)) continue;
            String fqn = ((TypeElement)entityType).getQualifiedName().toString();
            fqn2Path.put(fqn, path);
        }
        for (Map.Entry entry : oneParamGetMethods.entrySet()) {
            path = (String)entry.getKey();
            method = (ExecutableElement)entry.getValue();
            returnType = method.getReturnType();
            returnElement = controller.getTypes().asElement(returnType);
            if (!(returnElement instanceof TypeElement) || JSClientGenerator.getAnnotation(returnElement, XML_ROOT_ELEMENT) == null) continue;
            String fqn = ((TypeElement)returnElement).getQualifiedName().toString();
            String collectionPath = (String)fqn2Path.get(fqn);
            EnumMap<HttpRequests, String> paths = new EnumMap<HttpRequests, String>(HttpRequests.class);
            EnumMap<HttpRequests, Boolean> ids = new EnumMap<HttpRequests, Boolean>(HttpRequests.class);
            this.parsePath(postMethods, returnType, paths, ids, HttpRequests.POST, controller);
            this.parsePath(putMethods, returnType, paths, ids, HttpRequests.PUT, controller);
            this.parsePath(deleteMethods, returnType, paths, ids, HttpRequests.DELETE, controller);
            this.generate((TypeElement)returnElement, path, collectionPath, paths, ids, controller);
        }
    }

    private String parseNoIdPath(List<ExecutableElement> methods, TypeMirror type, CompilationController controller) {
        for (ExecutableElement method : methods) {
            List<? extends VariableElement> parameters = method.getParameters();
            boolean matches = false;
            if (parameters.size() == 0) {
                matches = true;
            } else {
                if (parameters.size() != 1) continue;
                VariableElement param = parameters.get(0);
                if (controller.getTypes().isSameType(param.asType(), type)) {
                    matches = true;
                }
            }
            if (!matches) continue;
            AnnotationMirror annotation = JSClientGenerator.getAnnotation(method, PATH);
            if (annotation == null) {
                return "";
            }
            return this.getValue(annotation);
        }
        return null;
    }

    private void parsePath(List<ExecutableElement> methods, TypeMirror type, EnumMap<HttpRequests, String> paths, EnumMap<HttpRequests, Boolean> ids, HttpRequests request, CompilationController controller) {
        for (ExecutableElement method : methods) {
            List<? extends VariableElement> parameters = method.getParameters();
            boolean matches = false;
            String pathParam = null;
            if (parameters.size() == 1) {
                VariableElement param = parameters.get(0);
                if (controller.getTypes().isSameType(param.asType(), type)) {
                    matches = true;
                } else if (JSClientGenerator.getAnnotation(param, PATH_PARAM) != null) {
                    pathParam = this.getValue(JSClientGenerator.getAnnotation(param, PATH_PARAM));
                    matches = true;
                    ids.put(request, Boolean.TRUE);
                }
            } else {
                if (parameters.size() != 2) continue;
                VariableElement param1 = parameters.get(0);
                VariableElement param2 = parameters.get(1);
                if (JSClientGenerator.getAnnotation(param1, PATH_PARAM) != null) {
                    pathParam = this.getValue(JSClientGenerator.getAnnotation(param1, PATH_PARAM));
                    if (controller.getTypes().isSameType(param2.asType(), type)) {
                        matches = true;
                    }
                } else if (controller.getTypes().isSameType(param1.asType(), type) && JSClientGenerator.getAnnotation(param2, PATH_PARAM) != null) {
                    pathParam = this.getValue(JSClientGenerator.getAnnotation(param2, PATH_PARAM));
                    matches = true;
                }
                if (matches) {
                    ids.put(request, Boolean.TRUE);
                }
            }
            if (!matches) continue;
            AnnotationMirror annotation = JSClientGenerator.getAnnotation(method, PATH);
            if (annotation == null) {
                paths.put(request, "");
                break;
            }
            String path = this.getValue(annotation);
            if (pathParam != null) {
                path = this.removeParamTemplate(path, pathParam);
            }
            paths.put(request, path);
            break;
        }
    }

    private void generate(TypeElement entity, String path, String collectionPath, Map<HttpRequests, String> httpPaths, Map<HttpRequests, Boolean> useIds, CompilationController controller) throws IOException {
        this.isModelGenerated = true;
        ModelGenerator generator = new ModelGenerator(this.myDescription, this.myModels, this.myEntities, this.myUi);
        generator.generateModel(entity, path, collectionPath, httpPaths, useIds, controller);
        this.generateRouter(entity, path, collectionPath, httpPaths, controller, generator);
    }

    private void generateRouter(TypeElement entity, String path, String collectionPath, Map<HttpRequests, String> httpPaths, CompilationController controller, ModelGenerator modelGenerator) {
        if (this.myModelsCount > 0) {
            this.myRouters.append("/*");
        }
        String name = "AppRouter";
        if (this.myModelsCount > 0) {
            name = name + this.myModelsCount;
        }
        RouterGenerator generator = new RouterGenerator(this.myRouters, name, modelGenerator);
        generator.generateRouter(entity, path, collectionPath, httpPaths, controller);
        if (this.myModelsCount == 0) {
            this.myHeader.append("<div id='");
            this.myHeader.append(generator.getHeaderId());
            this.myHeader.append("'></div>\n");
            if (generator.getSideBarId() != null) {
                this.generateCollection(generator);
            }
            this.generateContent(generator);
            if (generator.getCreateTemplate() != null) {
                this.myTmplCreate.append("<script type='text/template' id='");
                this.myTmplCreate.append(generator.getCreateTemplate());
                this.myTmplCreate.append("'>\n");
                this.myTmplCreate.append("<!--\n");
                this.myTmplCreate.append("\tPut your controls to create new entity here.\n\n");
                this.myTmplCreate.append("\tClass 'new' is used to listen on events in JS code.\n");
                this.myTmplCreate.append("-->\n");
                this.myTmplCreate.append("<button class='new'>Create</button>\n");
                this.myTmplCreate.append("</script>\n");
            }
            if (generator.getListItemTemplate() != null) {
                if (generator.useUi()) {
                    this.generateHeadTemplate(generator);
                }
                this.myTmplList.append("<script type='text/template' id='");
                this.myTmplList.append(generator.getListItemTemplate());
                this.myTmplList.append("'>\n");
                this.generateItemContent(generator);
                this.myTmplList.append("</script>\n");
            }
            if (generator.getDetailsTemplate() != null) {
                this.myTmplDetails.append("<script type='text/template' id='");
                this.myTmplDetails.append(generator.getDetailsTemplate());
                this.myTmplDetails.append("'>\n");
                this.myTmplDetails.append("<div>\n");
                String idAttribute = null;
                if (generator.useUi()) {
                    this.myTmplDetails.append("<table>\n<tbody>\n");
                }
                if (modelGenerator.getIdAttribute() != null) {
                    idAttribute = modelGenerator.getIdAttribute().getName();
                    if (generator.useUi()) {
                        this.myTmplDetails.append("<tr><td>Id</td>\n<td>\n");
                    } else {
                        this.myTmplDetails.append("<label>Id:</label>\n");
                    }
                    this.myTmplDetails.append("<input type='text' id='");
                    this.myTmplDetails.append(idAttribute);
                    this.myTmplDetails.append("' name='id' value='<%= typeof(");
                    this.myTmplDetails.append(idAttribute);
                    this.myTmplDetails.append(")!== \"undefined\" ? ");
                    this.myTmplDetails.append(idAttribute);
                    this.myTmplDetails.append(" : \"\" %>'  />\n");
                    if (generator.useUi()) {
                        this.myTmplDetails.append("</td>\n</tr>\n");
                    }
                }
                String nameAttribute = modelGenerator.getDisplayNameAlias();
                if (!generator.useUi()) {
                    if (nameAttribute != null && !nameAttribute.equals(idAttribute)) {
                        this.myTmplDetails.append("<label>Name:</label>\n");
                        this.myTmplDetails.append("<input type='text' id='");
                        this.myTmplDetails.append(nameAttribute);
                        this.myTmplDetails.append("' name='");
                        this.myTmplDetails.append(nameAttribute);
                        this.myTmplDetails.append("' value='<%= ");
                        this.myTmplDetails.append(nameAttribute);
                        this.myTmplDetails.append(" %>'/>\n");
                    }
                    this.myTmplDetails.append("<!--\n");
                    this.myTmplDetails.append("\tPut your editing controls for model\n");
                    this.myTmplDetails.append("attribute data (text fields, ...) here\n");
                }
                Set<ModelAttribute> attributes = modelGenerator.getAttributes();
                for (ModelAttribute attribute : attributes) {
                    String attrName = attribute.getName();
                    if (!generator.useUi() && attrName.equals(nameAttribute) || attrName.equals(idAttribute)) continue;
                    if (generator.useUi()) {
                        this.myTmplDetails.append("<tr>\n<td>");
                    } else {
                        this.myTmplDetails.append("<label>");
                    }
                    this.myTmplDetails.append(attrName);
                    if (generator.useUi()) {
                        this.myTmplDetails.append("</td><td>");
                    } else {
                        this.myTmplDetails.append(":</label>\n");
                    }
                    this.myTmplDetails.append("<input type='text' id='");
                    this.myTmplDetails.append(attrName);
                    this.myTmplDetails.append("' name='");
                    this.myTmplDetails.append(attrName);
                    this.myTmplDetails.append("' value='<%= ");
                    this.myTmplDetails.append(attrName);
                    this.myTmplDetails.append(" %>'/>");
                    if (!generator.useUi()) continue;
                    this.myTmplDetails.append("</td></tr>\n");
                }
                if (generator.useUi()) {
                    this.myTmplDetails.append("</tbody>\n</table>\n");
                } else {
                    this.myTmplDetails.append("-->\n");
                }
                this.myTmplDetails.append("<!--\n");
                this.myTmplDetails.append("\tPut your controls to create new entity here.\n");
                this.myTmplDetails.append("\tClasses 'save' and 'delete' are used ");
                this.myTmplDetails.append("to listen on events in JS code.\n");
                this.myTmplDetails.append("-->\n");
                this.myTmplDetails.append("<button  class='save'>Save</button>\n");
                this.myTmplDetails.append("<button  class='delete'>Delete</button>\n");
                this.myTmplDetails.append("</div>\n");
                this.myTmplDetails.append("</script>\n");
            }
        } else {
            this.myRouters.append("*/");
        }
        ++this.myModelsCount;
    }

    private void generateHeadTemplate(RouterGenerator generator) {
        this.myTmplList.append("<script type='text/template' id='");
        this.myTmplList.append(generator.getTableHeadId());
        this.myTmplList.append("'>\n<thead>\n<tr>\n");
        if (generator.getModelGenerator().getIdAttribute() != null) {
            String id = generator.getModelGenerator().getIdAttribute().getName();
            this.myTmplList.append("<th>");
            this.myTmplList.append(id);
            this.myTmplList.append("</th>\n");
        }
        Set<ModelAttribute> attributes = generator.getModelGenerator().getAttributes();
        for (ModelAttribute attribute : attributes) {
            this.myTmplList.append("<th>");
            this.myTmplList.append(attribute.getName());
            this.myTmplList.append("</th>\n");
        }
        this.myTmplList.append("</tr>\n</thead>\n</script>\n");
    }

    private void generateItemContent(RouterGenerator generator) {
        if (generator.useUi()) {
            if (generator.getModelGenerator().getIdAttribute() != null) {
                String id = generator.getModelGenerator().getIdAttribute().getName();
                this.myTmplList.append("<td><a href='#<%= ");
                this.myTmplList.append(id);
                this.myTmplList.append(" %>'><%= ");
                this.myTmplList.append(id);
                this.myTmplList.append(" %></a></td>\n");
            }
            Set<ModelAttribute> attributes = generator.getModelGenerator().getAttributes();
            for (ModelAttribute attribute : attributes) {
                this.myTmplList.append("<td><%= ");
                this.myTmplList.append(attribute.getName());
                this.myTmplList.append(" %></td>\n");
            }
        } else {
            this.myTmplList.append("<!-- modify output display name for item here");
            this.myTmplList.append(" or change displayName in the JS model code -->\n");
            if (generator.getModelGenerator().getIdAttribute() != null) {
                this.myTmplList.append("<a href='#<%= ");
                this.myTmplList.append(generator.getModelGenerator().getIdAttribute().getName());
                this.myTmplList.append(" %>'><%= displayName %></a>\n");
            } else {
                this.myTmplList.append("<%= displayName %>\n");
            }
        }
    }

    private void generateCollection(RouterGenerator generator) {
        if (generator.useUi()) {
            this.hasUi = true;
            this.mySidebar.append("<table id='");
            this.mySidebar.append(generator.getSideBarId());
            this.mySidebar.append("' class='tablesorter-blue'>\n</table>\n");
            this.mySidebar.append("<div class='pager' id='pager'>\n");
            this.mySidebar.append("<img src='");
            this.mySidebar.append(TABLESORTER_URL);
            this.mySidebar.append("addons/pager/icons/first.png' class='first' ");
            this.mySidebar.append("alt='First'/>\n");
            this.mySidebar.append("<img src='");
            this.mySidebar.append(TABLESORTER_URL);
            this.mySidebar.append("addons/pager/icons/prev.png' class='prev' ");
            this.mySidebar.append("alt='Prev'/>\n");
            this.mySidebar.append("<span class='pagedisplay'></span>");
            this.mySidebar.append(" <!-- this can be any element, including an input -->\n");
            this.mySidebar.append("<img src='");
            this.mySidebar.append(TABLESORTER_URL);
            this.mySidebar.append("addons/pager/icons/next.png' class='next' ");
            this.mySidebar.append("alt='Next'/>\n");
            this.mySidebar.append("<img src='");
            this.mySidebar.append(TABLESORTER_URL);
            this.mySidebar.append("addons/pager/icons/last.png' class='last' ");
            this.mySidebar.append("alt='Last'/>\n");
            this.mySidebar.append("<select class='pagesize'>\n");
            this.mySidebar.append("<option selected='selected' value='10'>");
            this.mySidebar.append("10</option>\n");
            this.mySidebar.append("<option value='20'>20</option>\n");
            this.mySidebar.append("<option value='30'>30</option>\n");
            this.mySidebar.append("<option value='40'>40</option>\n");
            this.mySidebar.append("</select>\n</div>\n<br>\n");
        } else {
            this.mySidebar.append("<div id='");
            this.mySidebar.append(generator.getSideBarId());
            this.mySidebar.append("'></div>\n");
        }
    }

    private void generateContent(RouterGenerator generator) {
        this.myContent.append("<div id='");
        this.myContent.append(generator.getContentId());
        this.myContent.append("'></div>\n");
    }

    private String removeParamTemplate(String path, String param) {
        int index = path.indexOf(123);
        String template = path;
        if (index == -1) {
            return path;
        }
        template = path.substring(index + 1).trim();
        int lastIndex = template.lastIndexOf(125);
        if (lastIndex == -1) {
            return path;
        }
        if (!(template = template.substring(0, lastIndex).trim()).startsWith(param)) {
            return path;
        }
        if ((template = template.substring(param.length()).trim()).length() == 0 || template.charAt(0) == ':') {
            return path.substring(0, index);
        }
        return path;
    }

    private TypeMirror getCollectionType(TypeMirror type, CompilationController controller) {
        TypeElement collectionElement = controller.getElements().getTypeElement(Collection.class.getName());
        TypeMirror collectionType = controller.getTypes().erasure(collectionElement.asType());
        TypeMirror erasure = controller.getTypes().erasure(type);
        if (!controller.getTypes().isSubtype(erasure, collectionType)) {
            return null;
        }
        List<? extends TypeMirror> supers = controller.getTypes().directSupertypes(type);
        for (TypeMirror typeMirror : supers) {
            erasure = controller.getTypes().erasure(typeMirror);
            if (controller.getTypes().isSameType(erasure, collectionType)) {
                return this.getParameterType(typeMirror);
            }
            TypeMirror found = this.getCollectionType(typeMirror, controller);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    private TypeMirror getParameterType(TypeMirror type) {
        if (type instanceof DeclaredType) {
            List<? extends TypeMirror> typeArguments = ((DeclaredType)type).getTypeArguments();
            if (typeArguments.size() == 0) {
                return null;
            }
            return typeArguments.get(0);
        }
        return null;
    }

    private String getValue(AnnotationMirror annotation) {
        if (annotation == null) {
            return null;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = annotation.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            Object val;
            ExecutableElement annotationMethod = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!annotationMethod.getSimpleName().contentEquals("value") || (val = value.getValue()) == null) continue;
            return val.toString();
        }
        return null;
    }

    private boolean hasJsonMedia(List<? extends AnnotationMirror> annotations) {
        AnnotationMirror mimeTypeDecl;
        AnnotationMirror consumes = JSClientGenerator.getAnnotation(annotations, CONSUMES);
        AnnotationMirror produces = JSClientGenerator.getAnnotation(annotations, PRODUCES);
        AnnotationMirror annotationMirror = mimeTypeDecl = consumes == null ? produces : consumes;
        if (mimeTypeDecl == null) {
            return false;
        }
        Map<? extends ExecutableElement, ? extends AnnotationValue> elementValues = mimeTypeDecl.getElementValues();
        for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : elementValues.entrySet()) {
            ExecutableElement annotationMethod = entry.getKey();
            AnnotationValue value = entry.getValue();
            if (!annotationMethod.getSimpleName().contentEquals("value")) continue;
            Object mediaType = value.getValue();
            if (mediaType instanceof List) {
                List types = (List)mediaType;
                for (Object type : types) {
                    if (!(type instanceof AnnotationValue) || !JSON.equals(mediaType = ((AnnotationValue)type).getValue())) continue;
                    return true;
                }
                continue;
            }
            if (!JSON.equals(mediaType)) continue;
            return true;
        }
        return false;
    }

    static AnnotationMirror getAnnotation(List<? extends AnnotationMirror> annotations, String annotation) {
        for (AnnotationMirror annotationMirror : annotations) {
            TypeElement annotationDecl;
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement) || !(annotationDecl = (TypeElement)annotationElement).getQualifiedName().contentEquals(annotation)) continue;
            return annotationMirror;
        }
        return null;
    }

    static AnnotationMirror getAnnotation(Element element, String annotation) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        return JSClientGenerator.getAnnotation(annotations, annotation);
    }

    private Map<String, AnnotationMirror> getAnnotions(Element element) {
        List<? extends AnnotationMirror> annotations = element.getAnnotationMirrors();
        HashMap<String, AnnotationMirror> map = new HashMap<String, AnnotationMirror>();
        for (AnnotationMirror annotationMirror : annotations) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (!(annotationElement instanceof TypeElement)) continue;
            TypeElement annotationDecl = (TypeElement)annotationElement;
            map.put(annotationDecl.getQualifiedName().toString(), annotationMirror);
        }
        return map;
    }

    static enum HttpRequests {
        POST("create"),
        PUT("update"),
        DELETE("delete");

        private String myBackboneMethod;

        private HttpRequests(String method) {
            this.myBackboneMethod = method;
        }

        public String toString() {
            return this.myBackboneMethod;
        }
    }

    static enum MethodType {
        GET,
        SET;

    }
}

