/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.api.BrandingUtils;
import org.netbeans.modules.apisupport.project.api.ManifestManager;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.BrandingSupport;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.apisupport.MavenNbModuleImpl;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ContextAwareAction;
import org.openide.util.EditableProperties;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class OpenBrandingEditorAction
extends AbstractAction
implements ContextAwareAction {
    private final Lookup context;
    private static final RequestProcessor RP = new RequestProcessor(OpenBrandingEditorAction.class);

    public OpenBrandingEditorAction() {
        this(Lookup.EMPTY);
    }

    private OpenBrandingEditorAction(Lookup context) {
        super(Bundle.LBL_OpenBrandingEditor());
        this.putValue("hideWhenDisabled", true);
        this.context = context;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        RP.post(new Runnable(){

            @Override
            public void run() {
                final Project project = (Project)OpenBrandingEditorAction.this.context.lookup(Project.class);
                final MavenProject mavenProject = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
                final BrandingModel model = OpenBrandingEditorAction.createBrandingModel(project, OpenBrandingEditorAction.this.brandingPath(project));
                final boolean hasAppProject = MavenNbModuleImpl.findAppProject(project) != null;
                final boolean hasExternalPlatform = MavenNbModuleImpl.findIDEInstallation(project) != null;
                EventQueue.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        if (!hasAppProject && !hasExternalPlatform) {
                            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)Bundle.OpenBrandingEditorAction_Error_NoApplication(), 0);
                            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                            return;
                        }
                        BrandingUtils.openBrandingEditor((String)mavenProject.getName(), (Project)project, (BrandingModel)model);
                    }
                });
            }
        });
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new OpenBrandingEditorAction(actionContext);
    }

    @Override
    public boolean isEnabled() {
        Project project = (Project)this.context.lookup(Project.class);
        if (project == null) {
            return false;
        }
        NbMavenProject mproject = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
        if (mproject == null) {
            return false;
        }
        return project.getProjectDirectory().getFileObject(this.brandingPath(project)) != null;
    }

    private String brandingPath(Project mavenProject) {
        String brandingPath = PluginPropertyUtils.getPluginProperty((Project)mavenProject, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)"brandingSources", (String)"branding", null);
        return brandingPath != null ? brandingPath : "src/main/nbm-branding";
    }

    private static BrandingModel createBrandingModel(final Project p, final String brandingPath) {
        BrandingModel model = new BrandingModel(){

            public Project getProject() {
                return p;
            }

            protected File getProjectDirectoryFile() {
                return FileUtil.toFile((FileObject)p.getProjectDirectory());
            }

            protected BrandingSupport createBranding() throws IOException {
                return new GenericBrandingSupport(p, brandingPath);
            }

            protected boolean isBrandingEnabledRefresh() {
                return true;
            }

            protected String loadName() {
                return null;
            }

            protected String loadTitle() {
                return null;
            }
        };
        model.init();
        return model;
    }

    private static class GenericBrandingSupport
    extends BrandingSupport {
        private final Project p;
        private Map<String, BrandableModuleImpl> modules;

        GenericBrandingSupport(Project p, String brandingPath) throws IOException {
            super(p, brandingPath);
            this.p = p;
        }

        protected BrandingSupport.BrandableModule findBrandableModule(String moduleCodeNameBase) {
            return this.modules.get(moduleCodeNameBase);
        }

        public Set<File> getBrandableJars() {
            HashSet<File> jars = new HashSet<File>();
            for (BrandableModuleImpl m : this.modules.values()) {
                jars.add(m.jar);
            }
            return jars;
        }

        protected Set<BrandingSupport.BrandableModule> loadModules() throws IOException {
            if (this.modules != null) {
                return null;
            }
            this.modules = new HashMap<String, BrandableModuleImpl>();
            PlatformJarProvider pjp = (PlatformJarProvider)this.p.getLookup().lookup(PlatformJarProvider.class);
            if (pjp != null) {
                for (File jar : pjp.getPlatformJars()) {
                    ManifestManager mfm = ManifestManager.getInstanceFromJAR((File)jar);
                    String cnb = mfm.getCodeNameBase();
                    if (cnb == null) continue;
                    this.modules.put(cnb, new BrandableModuleImpl(cnb, jar));
                }
            }
            return new HashSet<BrandingSupport.BrandableModule>(this.modules.values());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Map<String, String> localizingBundle(BrandingSupport.BrandableModule moduleEntry) {
            File jar = ((BrandableModuleImpl)moduleEntry).jar;
            ManifestManager mfm = ManifestManager.getInstanceFromJAR((File)jar);
            String localizingBundle = mfm.getLocalizingBundle();
            if (localizingBundle == null) {
                return Collections.emptyMap();
            }
            EditableProperties props = new EditableProperties(false);
            try {
                InputStream is = new URL("jar:" + Utilities.toURI((File)jar) + "!/" + localizingBundle).openStream();
                try {
                    props.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException x) {
                Exceptions.printStackTrace((Throwable)x);
            }
            return props;
        }

        private static class BrandableModuleImpl
        implements BrandingSupport.BrandableModule {
            private final String cnb;
            private final File jar;

            BrandableModuleImpl(String cnb, File jar) {
                this.cnb = cnb;
                this.jar = jar;
            }

            public String getCodeNameBase() {
                return this.cnb;
            }

            public File getJarLocation() {
                return this.jar;
            }

            public boolean equals(Object obj) {
                if (!(obj instanceof BrandableModuleImpl)) {
                    return false;
                }
                BrandableModuleImpl o = (BrandableModuleImpl)obj;
                return this.cnb.equals(o.cnb) && this.jar.equals(o.jar);
            }

            public int hashCode() {
                return this.cnb.hashCode();
            }

            public String toString() {
                return this.cnb;
            }

            public String getRelativePath() {
                String base = this.cnb.equals("org.netbeans.bootstrap") ? "boot" : (this.cnb.equals("org.netbeans.core.startup") ? "core" : this.cnb.replace('.', '-'));
                String dir = this.cnb.matches("org[.](netbeans[.]bootstrap|openide[.](modules|util(|[.]lookup)))") ? "lib" : (this.cnb.matches("org[.](netbeans[.]core[.]startup|openide[.]filesystems)") ? "core" : "modules");
                return dir + '/' + base + ".jar";
            }
        }
    }
}

