/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.beans.PropertyVetoException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.DefaultArtifact;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.DefaultArtifactHandler;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.apisupport.project.api.LayerHandle;
import org.netbeans.modules.apisupport.project.spi.LayerUtil;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.spi.PlatformJarProvider;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.apisupport.AdaptNbVersion;
import org.netbeans.modules.maven.apisupport.ExamineManifest;
import org.netbeans.modules.maven.embedder.EmbedderFactory;
import org.netbeans.modules.maven.indexer.api.NBVersionInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryInfo;
import org.netbeans.modules.maven.indexer.api.RepositoryPreferences;
import org.netbeans.modules.maven.indexer.api.RepositoryQueries;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.Utilities;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.spi.project.AuxiliaryProperties;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.XMLFileSystem;
import org.openide.modules.SpecificationVersion;
import org.openide.util.RequestProcessor;

public class MavenNbModuleImpl
implements NbModuleProvider {
    private Project project;
    private DependencyAdder dependencyAdder = new DependencyAdder();
    private static final RequestProcessor RP = new RequestProcessor(MavenNbModuleImpl.class);
    private RequestProcessor.Task tsk = RP.create((Runnable)this.dependencyAdder);
    public static final String NETBEANS_REPO_ID = "netbeans";
    private static final String PROP_NETBEANS_INSTALL = "netbeans.installation";
    public static final String GROUPID_MOJO = "org.codehaus.mojo";
    public static final String NBM_PLUGIN = "nbm-maven-plugin";

    public MavenNbModuleImpl(Project project) {
        this.project = project;
    }

    static RepositoryInfo netbeansRepo() {
        return RepositoryPreferences.getInstance().getRepositoryInfoById(NETBEANS_REPO_ID);
    }

    private File getModuleXmlLocation() {
        File rel;
        String file = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"descriptor", null, null);
        if (file == null) {
            file = "src/main/nbm/module.xml";
        }
        if (!(rel = new File(file)).isAbsolute()) {
            rel = new File(FileUtil.toFile((FileObject)this.project.getProjectDirectory()), file);
        }
        return FileUtil.normalizeFile((File)rel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Xpp3Dom getModuleDom() throws UnsupportedEncodingException, IOException, XmlPullParserException {
        File file = this.getModuleXmlLocation();
        if (!file.exists()) {
            return null;
        }
        FileInputStream is = new FileInputStream(file);
        InputStreamReader reader = new InputStreamReader((InputStream)is, "UTF-8");
        try {
            Xpp3Dom xpp3Dom = Xpp3DomBuilder.build((Reader)reader);
            return xpp3Dom;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public String getSpecVersion() {
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        String specVersion = AdaptNbVersion.adaptVersion(watch.getMavenProject().getVersion(), "spec");
        return specVersion;
    }

    public String getCodeNameBase() {
        String codename = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"codeNameBase", (String)"manifest", null);
        if (codename == null) {
            try {
                Xpp3Dom cnb;
                Xpp3Dom dom = this.getModuleDom();
                if (dom != null && (cnb = dom.getChild("codeNameBase")) != null) {
                    String val = cnb.getValue();
                    int slash = val.indexOf(47);
                    if (slash > -1) {
                        val = val.substring(0, slash);
                    }
                    return val;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MavenProject prj = ((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject();
            codename = prj.getGroupId() + "." + prj.getArtifactId();
            codename = codename.replaceAll("-", ".");
        }
        return codename;
    }

    public String getSourceDirectoryPath() {
        return "src/main/java";
    }

    public String getTestSourceDirectoryPath() {
        return "src/test/java";
    }

    public FileObject getSourceDirectory() {
        FileObject fo = this.project.getProjectDirectory().getFileObject(this.getSourceDirectoryPath());
        if (fo == null) {
            try {
                fo = FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getSourceDirectoryPath());
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        return fo;
    }

    public FileObject getManifestFile() {
        String manifest = PluginPropertyUtils.getPluginProperty((Project)this.project, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"sourceManifestFile", (String)"manifest", null);
        if (manifest != null) {
            return FileUtilities.convertStringToFileObject((String)manifest);
        }
        String path = "src/main/nbm/manifest.mf";
        try {
            Xpp3Dom cnb;
            Xpp3Dom dom = this.getModuleDom();
            if (dom != null && (cnb = dom.getChild("manifest")) != null) {
                path = cnb.getValue();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.project.getProjectDirectory().getFileObject(path);
    }

    public String getResourceDirectoryPath(boolean isTest) {
        String defaultValue;
        List res;
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        if (isTest) {
            res = watch.getMavenProject().getTestResources();
            defaultValue = "src/test/resources";
        } else {
            res = watch.getMavenProject().getResources();
            defaultValue = "src/main/resources";
        }
        for (Resource resource : res) {
            FileObject fo = FileUtilities.convertStringToFileObject((String)resource.getDirectory());
            if (fo == null || !FileUtil.isParentOf((FileObject)this.project.getProjectDirectory(), (FileObject)fo)) continue;
            return FileUtil.getRelativePath((FileObject)this.project.getProjectDirectory(), (FileObject)fo);
        }
        return defaultValue;
    }

    public void addDependencies(NbModuleProvider.ModuleDependency[] dependencies) throws IOException {
        for (NbModuleProvider.ModuleDependency mdep : dependencies) {
            MavenProject mp;
            String nbVersion;
            List versions;
            List lst;
            Iterator i$;
            File platformFile;
            String codeNameBase = mdep.getCodeNameBase();
            SpecificationVersion version = mdep.getVersion();
            String artifactId = codeNameBase.replaceAll("\\.", "-");
            NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
            if (this.hasDependency(codeNameBase)) continue;
            Dependency dep = null;
            RepositoryInfo nbrepo = MavenNbModuleImpl.netbeansRepo();
            if (nbrepo != null && (platformFile = this.lookForModuleInPlatform(artifactId)) != null && (i$ = (lst = RepositoryQueries.findBySHA1Result((File)platformFile, Collections.singletonList(nbrepo)).getResults()).iterator()).hasNext()) {
                NBVersionInfo elem = (NBVersionInfo)i$.next();
                dep = new Dependency();
                dep.setArtifactId(elem.getArtifactId());
                dep.setGroupId(elem.getGroupId());
                dep.setVersion(elem.getVersion());
            }
            if (dep == null) {
                dep = new Dependency();
                dep.setGroupId("org.netbeans.api");
                dep.setArtifactId(artifactId);
                if (version != null) {
                    dep.setVersion(version.toString());
                } else {
                    for (Dependency d : watch.getMavenProject().getModel().getDependencies()) {
                        if (!"org.netbeans.api".equals(d.getGroupId())) continue;
                        dep.setVersion(d.getVersion());
                    }
                }
            }
            if (dep.getVersion() == null && nbrepo != null && !(versions = RepositoryQueries.getVersionsResult((String)"org.netbeans.cluster", (String)"platform", Collections.singletonList(nbrepo)).getResults()).isEmpty()) {
                dep.setVersion(((NBVersionInfo)versions.get(0)).getVersion());
            }
            if (dep.getVersion() == null) {
                dep.setVersion("99.99");
            }
            if (mdep.isTestDependency()) {
                dep.setScope("test");
            }
            String string = nbVersion = (mp = watch.getMavenProject()).getProperties() != null ? mp.getProperties().getProperty("netbeans.version") : null;
            if (nbVersion != null && nbVersion.equals(dep.getVersion())) {
                dep.setVersion("${netbeans.version}");
            }
            this.dependencyAdder.addDependency(dep);
        }
        this.dependencyAdder.run();
    }

    public File getModuleJarLocation() {
        return null;
    }

    public boolean hasDependency(String codeNameBase) throws IOException {
        String artifactId = codeNameBase.replaceAll("\\.", "-");
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        Set set = watch.getMavenProject().getDependencyArtifacts();
        if (set != null) {
            for (Artifact art : set) {
                if (!art.getGroupId().startsWith("org.netbeans") || !art.getArtifactId().equals(artifactId)) continue;
                return true;
            }
        }
        return false;
    }

    public String getReleaseDirectoryPath() {
        return "src/main/release";
    }

    public FileObject getReleaseDirectory() throws IOException {
        Utilities.performPOMModelOperations((FileObject)this.project.getProjectDirectory().getFileObject("pom.xml"), Collections.singletonList(new ModelOperation<POMModel>(){

            public void performOperation(POMModel model) {
                Plugin nbmPlugin;
                Build build = model.getProject().getBuild();
                if (build != null && (nbmPlugin = build.findPluginById(MavenNbModuleImpl.GROUPID_MOJO, MavenNbModuleImpl.NBM_PLUGIN)) != null) {
                    Configuration configuration = nbmPlugin.getConfiguration();
                    if (configuration == null) {
                        configuration = model.getFactory().createConfiguration();
                        nbmPlugin.setConfiguration(configuration);
                    }
                    POMExtensibilityElement resources = ModelUtils.getOrCreateChild((POMComponent)configuration, (String)"nbmResources", (POMModel)model);
                    boolean needed = true;
                    block0: for (POMExtensibilityElement configurationElement : resources.getExtensibilityElements()) {
                        if (!configurationElement.getQName().getLocalPart().equals("nbmResource")) continue;
                        for (POMExtensibilityElement dir : configurationElement.getExtensibilityElements()) {
                            if (!dir.getQName().getLocalPart().equals("directory") || !dir.getElementText().equals(MavenNbModuleImpl.this.getReleaseDirectoryPath())) continue;
                            needed = false;
                            break block0;
                        }
                    }
                    if (needed) {
                        POMExtensibilityElement dir = model.getFactory().createPOMExtensibilityElement(new QName("directory"));
                        dir.setElementText(MavenNbModuleImpl.this.getReleaseDirectoryPath());
                        POMExtensibilityElement res = model.getFactory().createPOMExtensibilityElement(new QName("nbmResource"));
                        res.addExtensibilityElement(dir);
                        resources.addExtensibilityElement(res);
                    }
                }
            }
        }));
        return FileUtil.createFolder((FileObject)this.project.getProjectDirectory(), (String)this.getReleaseDirectoryPath());
    }

    public File getClassesDirectory() {
        return new File(((NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getBuild().getOutputDirectory());
    }

    public String getProjectFilePath() {
        return "pom.xml";
    }

    public SpecificationVersion getDependencyVersion(String codenamebase) throws IOException {
        String artifactId = codenamebase.replaceAll("\\.", "-");
        NbMavenProject watch = (NbMavenProject)this.project.getLookup().lookup(NbMavenProject.class);
        for (Artifact art : watch.getMavenProject().getArtifacts()) {
            File jar;
            if (!art.getGroupId().startsWith("org.netbeans") || !art.getArtifactId().equals(artifactId) || !(jar = art.getFile()).isFile()) continue;
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(jar);
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() == null) continue;
            return new SpecificationVersion(exa.getSpecVersion());
        }
        for (Artifact art : watch.getMavenProject().getArtifacts()) {
            Artifact art2;
            File jar;
            if (!art.getGroupId().startsWith("org.netbeans") || (jar = (art2 = EmbedderFactory.getProjectEmbedder().getLocalRepository().find((Artifact)new DefaultArtifact("org.netbeans.api", artifactId, art.getVersion(), null, "jar", null, (ArtifactHandler)new DefaultArtifactHandler("jar")))).getFile()) == null || !jar.isFile()) continue;
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(jar);
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() == null) continue;
            return new SpecificationVersion(exa.getSpecVersion());
        }
        File fil = this.lookForModuleInPlatform(artifactId);
        if (fil != null) {
            ExamineManifest exa = new ExamineManifest();
            exa.setJarFile(fil);
            try {
                exa.checkFile();
            }
            catch (MojoExecutionException x) {
                throw new IOException(x);
            }
            if (exa.getSpecVersion() != null) {
                return new SpecificationVersion(exa.getSpecVersion());
            }
        }
        return null;
    }

    private File lookForModuleInPlatform(String artifactId) {
        File actPlatform = this.getActivePlatformLocation();
        if (actPlatform != null) {
            DirectoryScanner walk = new DirectoryScanner();
            walk.setBasedir(actPlatform);
            walk.setIncludes(new String[]{"**/" + artifactId + ".jar"});
            walk.scan();
            String[] candidates = walk.getIncludedFiles();
            assert (candidates != null && candidates.length <= 1);
            if (candidates.length > 0) {
                return new File(actPlatform, candidates[0]);
            }
        }
        return null;
    }

    private File getActivePlatformLocation() {
        File platformDir = this.findPlatformFolder();
        if (platformDir != null && platformDir.isDirectory()) {
            return platformDir;
        }
        platformDir = MavenNbModuleImpl.findIDEInstallation(this.project);
        if (platformDir != null && platformDir.isDirectory()) {
            return platformDir;
        }
        return null;
    }

    @CheckForNull
    static File findIDEInstallation(Project project) {
        String installProp = ((NbMavenProject)project.getLookup().lookup(NbMavenProject.class)).getMavenProject().getProperties().getProperty(PROP_NETBEANS_INSTALL);
        if (installProp == null) {
            installProp = PluginPropertyUtils.getPluginProperty((Project)project, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"netbeansInstallation", (String)"run-ide", (String)PROP_NETBEANS_INSTALL);
        }
        if (installProp != null) {
            return FileUtilities.convertStringToFile((String)installProp);
        }
        return null;
    }

    static Project findAppProject(Project nbmProject) {
        NbMavenProject mp = (NbMavenProject)nbmProject.getLookup().lookup(NbMavenProject.class);
        if (mp == null) {
            return null;
        }
        String groupId = mp.getMavenProject().getGroupId();
        String artifactId = mp.getMavenProject().getArtifactId();
        Project candidate = null;
        for (Project p : OpenProjects.getDefault().getOpenProjects()) {
            NbMavenProject mp2 = (NbMavenProject)p.getLookup().lookup(NbMavenProject.class);
            if (mp2 == null || !"nbm-application".equals(mp2.getPackagingType())) continue;
            for (Artifact dep : mp2.getMavenProject().getArtifacts()) {
                if (!dep.getGroupId().equals(groupId) || !dep.getArtifactId().equals(artifactId)) continue;
                if (candidate != null) {
                    return null;
                }
                candidate = p;
            }
        }
        return candidate;
    }

    private File findPlatformFolder() {
        Project appProject = MavenNbModuleImpl.findAppProject(this.project);
        if (appProject == null) {
            return null;
        }
        NbMavenProject watch = (NbMavenProject)appProject.getLookup().lookup(NbMavenProject.class);
        if (watch == null) {
            return null;
        }
        String outputDir = PluginPropertyUtils.getPluginProperty((Project)appProject, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"outputDirectory", (String)"cluster-app", null);
        if (null == outputDir) {
            outputDir = "target";
        }
        String brandingToken = PluginPropertyUtils.getPluginProperty((Project)appProject, (String)GROUPID_MOJO, (String)NBM_PLUGIN, (String)"brandingToken", (String)"cluster-app", (String)"netbeans.branding.token");
        return FileUtilities.resolveFilePath((File)FileUtil.toFile((FileObject)appProject.getProjectDirectory()), (String)(outputDir + File.separator + brandingToken));
    }

    public FileSystem getEffectiveSystemFilesystem() throws IOException {
        FileSystem projectLayer = LayerHandle.forProject((Project)this.project).layer(false);
        ArrayList<XMLFileSystem> platformLayers = new ArrayList<XMLFileSystem>();
        PlatformJarProvider pjp = (PlatformJarProvider)this.project.getLookup().lookup(PlatformJarProvider.class);
        if (pjp != null) {
            ArrayList urls = new ArrayList();
            for (File jar : pjp.getPlatformJars()) {
                urls.addAll(LayerUtil.layersOf((File)jar));
            }
            XMLFileSystem xmlfs = new XMLFileSystem();
            try {
                xmlfs.setXmlUrls(urls.toArray(new URL[urls.size()]));
            }
            catch (PropertyVetoException x) {
                throw new IOException(x);
            }
            platformLayers.add(xmlfs);
        }
        return LayerUtil.mergeFilesystems((FileSystem)projectLayer, platformLayers);
    }

    public static class RemoveOldPathToNbApplicationModule
    extends ProjectOpenedHook {
        private final Project p;

        public RemoveOldPathToNbApplicationModule(Project p) {
            this.p = p;
        }

        protected void projectOpened() {
            AuxiliaryProperties aux = (AuxiliaryProperties)this.p.getLookup().lookup(AuxiliaryProperties.class);
            if (aux != null) {
                aux.put("pathToNbApplicationModule", null, true);
            }
        }

        protected void projectClosed() {
        }
    }

    private class DependencyAdder
    implements Runnable {
        List<Dependency> toAdd = new ArrayList<Dependency>();

        private DependencyAdder() {
        }

        private synchronized void addDependency(Dependency dep) {
            this.toAdd.add(dep);
        }

        @Override
        public void run() {
            FileObject fo = MavenNbModuleImpl.this.project.getProjectDirectory().getFileObject("pom.xml");
            final DependencyAdder monitor = this;
            ModelOperation<POMModel> operation = new ModelOperation<POMModel>(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void performOperation(POMModel model) {
                    DependencyAdder dependencyAdder = monitor;
                    synchronized (dependencyAdder) {
                        for (Dependency dep : DependencyAdder.this.toAdd) {
                            org.netbeans.modules.maven.model.pom.Dependency mdlDep = ModelUtils.checkModelDependency((POMModel)model, (String)dep.getGroupId(), (String)dep.getArtifactId(), (boolean)true);
                            mdlDep.setVersion(dep.getVersion());
                            if (dep.getScope() == null) continue;
                            mdlDep.setScope(dep.getScope());
                        }
                        DependencyAdder.this.toAdd.clear();
                    }
                }
            };
            Utilities.performPOMModelOperations((FileObject)fo, Collections.singletonList(operation));
            ((NbMavenProject)MavenNbModuleImpl.this.project.getLookup().lookup(NbMavenProject.class)).synchronousDependencyDownload();
        }
    }
}

