/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.net.URI;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.text.JTextComponent;
import org.apache.maven.artifact.versioning.ComparableVersion;
import org.apache.maven.project.MavenProject;
import org.netbeans.api.annotations.common.SuppressWarnings;
import org.netbeans.api.project.Project;
import org.netbeans.api.queries.CollocationQuery;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.ModelUtils;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.PluginPropertyUtils;
import org.netbeans.modules.maven.api.customizer.ModelHandle2;
import org.netbeans.modules.maven.api.customizer.support.CheckBoxUpdater;
import org.netbeans.modules.maven.api.customizer.support.TextComponentUpdater;
import org.netbeans.modules.maven.apisupport.Bundle;
import org.netbeans.modules.maven.model.ModelOperation;
import org.netbeans.modules.maven.model.pom.Build;
import org.netbeans.modules.maven.model.pom.Configuration;
import org.netbeans.modules.maven.model.pom.POMComponent;
import org.netbeans.modules.maven.model.pom.POMExtensibilityElement;
import org.netbeans.modules.maven.model.pom.POMModel;
import org.netbeans.modules.maven.model.pom.Plugin;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class InstallerPanel
extends JPanel {
    private static final String PROP_LICENSE = "installerLicenseFile";
    private static final String PROP_LINUX = "installerOsLinux";
    private static final String PROP_MAC = "installerOsMacosx";
    private static final String PROP_PACK200 = "installerPack200Enable";
    private static final String PROP_SOLARIS = "installerOsSolaris";
    private static final String PROP_WINDOWS = "installerOsWindows";
    private static final String GOAL = "build-installers";
    private final ProjectCustomizer.Category category;
    private final Project project;
    private final ModelHandle2 handle;
    private JLabel jLabel2;
    private JSeparator jSeparator1;
    private JSeparator jSeparator2;
    private JButton licenseButton;
    private JTextField licenseField;
    private JLabel licenseLabel;
    private JCheckBox linuxCheckBox;
    private JCheckBox macCheckBox;
    private JCheckBox pack200CheckBox;
    private JLabel pack200Info;
    private JCheckBox solarisCheckBox;
    private JCheckBox windowsCheckBox;

    private InstallerPanel(ProjectCustomizer.Category category, Project project, ModelHandle2 handle) {
        this.category = category;
        this.project = project;
        this.handle = handle;
        this.initComponents();
        new BooleanPropUpdater(PROP_WINDOWS, true, this.windowsCheckBox);
        new BooleanPropUpdater(PROP_SOLARIS, true, this.solarisCheckBox);
        new BooleanPropUpdater(PROP_LINUX, true, this.linuxCheckBox);
        new BooleanPropUpdater(PROP_MAC, true, this.macCheckBox);
        new StringPropUpdater(PROP_LICENSE, this.licenseField, this.licenseLabel);
        new BooleanPropUpdater(PROP_PACK200, true, this.pack200CheckBox);
    }

    private void initComponents() {
        this.jLabel2 = new JLabel();
        this.windowsCheckBox = new JCheckBox();
        this.linuxCheckBox = new JCheckBox();
        this.macCheckBox = new JCheckBox();
        this.solarisCheckBox = new JCheckBox();
        this.jSeparator1 = new JSeparator();
        this.licenseLabel = new JLabel();
        this.licenseField = new JTextField();
        this.licenseButton = new JButton();
        this.pack200CheckBox = new JCheckBox();
        this.jSeparator2 = new JSeparator();
        this.pack200Info = new JLabel();
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.Platforms.Label"));
        Mnemonics.setLocalizedText((AbstractButton)this.windowsCheckBox, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelWindows"));
        Mnemonics.setLocalizedText((AbstractButton)this.linuxCheckBox, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelLinux"));
        Mnemonics.setLocalizedText((AbstractButton)this.macCheckBox, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelMacOS"));
        Mnemonics.setLocalizedText((AbstractButton)this.solarisCheckBox, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelSolaris"));
        this.licenseLabel.setLabelFor(this.licenseField);
        Mnemonics.setLocalizedText((JLabel)this.licenseLabel, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.licenseLabel.text"));
        Mnemonics.setLocalizedText((AbstractButton)this.licenseButton, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.licenseButton.text"));
        this.licenseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                InstallerPanel.this.licenseButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.pack200CheckBox, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.pack200checkBox.text"));
        Mnemonics.setLocalizedText((JLabel)this.pack200Info, (String)NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.Pack200.Description.Text"));
        this.pack200Info.setVerticalAlignment(1);
        this.pack200Info.setFocusable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jSeparator1, -1, 780, Short.MAX_VALUE).addGroup(layout.createSequentialGroup().addComponent(this.jLabel2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.windowsCheckBox).addComponent(this.linuxCheckBox).addComponent(this.macCheckBox).addComponent(this.solarisCheckBox)).addGap(53, 509, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.licenseLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseField).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.licenseButton).addContainerGap()))).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.pack200CheckBox, -1, 772, Short.MAX_VALUE).addContainerGap()).addComponent(this.jSeparator2, -1, 780, Short.MAX_VALUE))).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(31, 31, 31).addComponent(this.pack200Info, -1, 749, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.windowsCheckBox).addComponent(this.jLabel2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.linuxCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.macCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.solarisCheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jSeparator1, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.licenseLabel).addComponent(this.licenseField, -2, -1, -2).addComponent(this.licenseButton)).addGap(6, 6, 6).addComponent(this.jSeparator2, -2, 10, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.pack200CheckBox).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.pack200Info, -1, 26, Short.MAX_VALUE).addGap(99, 99, 99)));
        this.jLabel2.getAccessibleContext().setAccessibleName(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.Platforms.Label"));
        this.windowsCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelWindows.AccessibleContext.accessible"));
        this.linuxCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelLinux.AccessibleContext.accessible"));
        this.macCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelMacOS.AccessibleContext.accessible"));
        this.solarisCheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.OSLabelSolaris.AccessibleContext.accessible"));
        this.pack200CheckBox.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(InstallerPanel.class, (String)"InstallerPanel.jCheckBox5.AccessibleContext.accessibleDescription"));
    }

    private void licenseButtonActionPerformed(ActionEvent evt) {
        File dir = FileUtil.toFile((FileObject)this.project.getProjectDirectory());
        if (dir == null) {
            return;
        }
        JFileChooser jfc = new JFileChooser(dir);
        if (jfc.showOpenDialog(this.licenseButton) == 0) {
            File license = jfc.getSelectedFile();
            this.licenseField.setText(FileUtilities.relativizeFile((File)dir, (File)license));
            if (CollocationQuery.areCollocated((URI)Utilities.toURI((File)license), (URI)Utilities.toURI((File)dir))) {
                this.category.setErrorMessage(null);
            } else {
                this.category.setErrorMessage(Bundle.InstallerPanel_not_collocated());
            }
        }
    }

    private static Configuration config(POMModel pomModel) {
        Configuration config;
        Plugin nbmPlugin;
        Build build = pomModel.getProject().getBuild();
        if (build == null) {
            build = pomModel.getFactory().createBuild();
            pomModel.getProject().setBuild(build);
        }
        if ((nbmPlugin = build.findPluginById("org.codehaus.mojo", "nbm-maven-plugin")) == null) {
            nbmPlugin = pomModel.getFactory().createPlugin();
            nbmPlugin.setGroupId("org.codehaus.mojo");
            nbmPlugin.setArtifactId("nbm-maven-plugin");
            nbmPlugin.setExtensions(Boolean.TRUE);
            build.addPlugin(nbmPlugin);
        }
        if ((config = nbmPlugin.getConfiguration()) == null) {
            config = pomModel.getFactory().createConfiguration();
            nbmPlugin.setConfiguration(config);
        }
        return config;
    }

    public static class Provider
    implements ProjectCustomizer.CompositeCategoryProvider {
        public ProjectCustomizer.Category createCategory(Lookup context) {
            String version;
            Project project = (Project)context.lookup(Project.class);
            NbMavenProject watcher = (NbMavenProject)project.getLookup().lookup(NbMavenProject.class);
            if (watcher != null && "nbm-application".equalsIgnoreCase(watcher.getPackagingType()) && (version = PluginPropertyUtils.getPluginVersion((MavenProject)watcher.getMavenProject(), (String)"org.codehaus.mojo", (String)"nbm-maven-plugin")) != null && new ComparableVersion(version).compareTo(new ComparableVersion("3.7-SNAPSHOT")) >= 0) {
                return ProjectCustomizer.Category.create((String)"Installer", (String)Bundle.LBL_InstallerPanel(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            }
            return null;
        }

        public JComponent createComponent(ProjectCustomizer.Category category, Lookup context) {
            return new InstallerPanel(category, (Project)context.lookup(Project.class), (ModelHandle2)context.lookup(ModelHandle2.class));
        }
    }

    private class StringPropUpdater
    extends TextComponentUpdater
    implements ModelOperation<POMModel> {
        private final String property;
        private String modifiedValue;
        private String pomValue;

        StringPropUpdater(String property, JTextComponent comp, JLabel label) {
            super(comp, label);
            this.property = property;
            this.pomValue = PluginPropertyUtils.getPluginProperty((Project)InstallerPanel.this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)property, (String)InstallerPanel.GOAL, null);
        }

        public String getValue() {
            if (this.modifiedValue != null) {
                return this.modifiedValue;
            }
            return this.pomValue != null ? this.pomValue : "";
        }

        public String getDefaultValue() {
            return "";
        }

        public void setValue(String value) {
            if (Utilities.compareObjects((Object)value, (Object)this.getValue())) {
                return;
            }
            if (value == null) {
                value = this.getDefaultValue();
            }
            this.modifiedValue = value;
            InstallerPanel.this.handle.removePOMModification((ModelOperation)this);
            if (this.pomValue == null || !this.pomValue.equals(this.modifiedValue)) {
                InstallerPanel.this.handle.addPOMModification((ModelOperation)this);
            }
        }

        public void performOperation(POMModel model) {
            Configuration config = InstallerPanel.config(model);
            POMExtensibilityElement e = ModelUtils.getOrCreateChild((POMComponent)config, (String)this.property, (POMModel)config.getModel());
            if (this.modifiedValue == null || this.modifiedValue.isEmpty()) {
                config.removeExtensibilityElement(e);
            } else {
                e.setElementText(this.modifiedValue);
            }
        }
    }

    private class BooleanPropUpdater
    extends CheckBoxUpdater
    implements ModelOperation<POMModel> {
        private final String property;
        private final boolean dflt;
        private Boolean modifiedValue;
        private final String pomValue;

        BooleanPropUpdater(String property, boolean dflt, JCheckBox comp) {
            super(comp);
            this.property = property;
            this.dflt = dflt;
            this.pomValue = PluginPropertyUtils.getPluginProperty((Project)InstallerPanel.this.project, (String)"org.codehaus.mojo", (String)"nbm-maven-plugin", (String)property, (String)InstallerPanel.GOAL, null);
        }

        @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"})
        public Boolean getValue() {
            if (this.modifiedValue != null) {
                return this.modifiedValue;
            }
            return this.pomValue != null ? Boolean.valueOf(this.pomValue) : null;
        }

        public boolean getDefaultValue() {
            return this.dflt;
        }

        public void setValue(Boolean value) {
            if (Utilities.compareObjects((Object)value, (Object)this.getValue())) {
                return;
            }
            this.modifiedValue = value;
            InstallerPanel.this.handle.removePOMModification((ModelOperation)this);
            if (this.pomValue == null || !this.pomValue.equals(this.modifiedValue)) {
                InstallerPanel.this.handle.addPOMModification((ModelOperation)this);
            }
        }

        public void performOperation(POMModel model) {
            Configuration config = InstallerPanel.config(model);
            if (this.modifiedValue != null) {
                config.setSimpleParameter(this.property, this.modifiedValue != null ? Boolean.toString(this.modifiedValue) : Boolean.toString(this.getDefaultValue()));
            } else {
                POMExtensibilityElement e = ModelUtils.getOrCreateChild((POMComponent)config, (String)this.property, (POMModel)config.getModel());
                config.removeExtensibilityElement(e);
            }
        }
    }
}

