/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.apisupport;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.Project;
import org.netbeans.modules.maven.api.classpath.ProjectSourcesClassPathProvider;
import org.netbeans.modules.maven.api.output.OutputProcessor;
import org.netbeans.modules.maven.api.output.OutputUtils;
import org.netbeans.modules.maven.api.output.OutputVisitor;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.windows.OutputListener;

public class IDEOutputListenerProvider
implements OutputProcessor {
    private static final String[] EXECGOALS = new String[]{"mojo-execute#nbm:run-ide", "mojo-execute#nbm:run-platform"};
    private Project project;
    private ClassPath classpath;

    public IDEOutputListenerProvider(Project proj) {
        this.project = proj;
    }

    private ClassPath createCP(Project prj, HashSet<Project> parents) {
        parents.add(prj);
        ArrayList<ClassPath> list = new ArrayList<ClassPath>();
        ProjectSourcesClassPathProvider cpp = (ProjectSourcesClassPathProvider)prj.getLookup().lookup(ProjectSourcesClassPathProvider.class);
        ClassPath[] cp = cpp.getProjectClassPaths("classpath/execute");
        list.addAll(Arrays.asList(cp));
        SubprojectProvider spp = (SubprojectProvider)prj.getLookup().lookup(SubprojectProvider.class);
        if (spp != null) {
            for (Project sub : spp.getSubprojects()) {
                ClassPath c;
                if (parents.contains(sub) || (c = this.createCP(sub, parents)) == null) continue;
                list.add(c);
            }
        }
        if (list.size() > 0) {
            return ClassPathSupport.createProxyClassPath((ClassPath[])list.toArray(new ClassPath[list.size()]));
        }
        return null;
    }

    public void processLine(String line, OutputVisitor visitor) {
        if (this.classpath == null) {
            return;
        }
        OutputListener list = OutputUtils.matchStackTraceLine((String)line, (ClassPath)this.classpath);
        if (list != null) {
            visitor.setOutputListener(list);
        }
    }

    public String[] getRegisteredOutputSequences() {
        return EXECGOALS;
    }

    public void sequenceStart(String sequenceId, OutputVisitor visitor) {
        this.classpath = this.createCP(this.project, new HashSet<Project>());
    }

    public void sequenceEnd(String sequenceId, OutputVisitor visitor) {
        this.classpath = null;
    }

    public void sequenceFail(String sequenceId, OutputVisitor visitor) {
        this.classpath = null;
    }
}

