/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.search.impl.spi;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.search.MatchingFileData;
import org.netbeans.modules.cnd.search.SearchParams;
import org.netbeans.modules.cnd.search.SearchResult;
import org.netbeans.modules.cnd.search.impl.UnixFindBasedSearcher;
import org.netbeans.modules.cnd.search.ui.SearchResultNode;
import org.netbeans.modules.cnd.search.ui.SearchResultPropertySet;
import org.netbeans.modules.cnd.search.util.OutlineSupport;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.NativeProcess;
import org.netbeans.modules.nativeexecution.api.NativeProcessBuilder;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.ProcessUtils;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.netbeans.spi.search.provider.DefaultSearchResultsDisplayer;
import org.netbeans.spi.search.provider.SearchComposition;
import org.netbeans.spi.search.provider.SearchProvider;
import org.netbeans.spi.search.provider.SearchResultsDisplayer;
import org.netbeans.swing.etable.ETable;
import org.openide.explorer.view.OutlineView;
import org.openide.filesystems.FileObject;
import org.openide.nodes.Node;
import org.openide.util.Cancellable;
import org.openide.util.RequestProcessor;

public final class CNDSearchComposition
extends SearchComposition<SearchResult> {
    private static final RequestProcessor RP = new RequestProcessor(CNDSearchComposition.class.getName(), 2);
    private final AtomicBoolean terminated = new AtomicBoolean(false);
    private final SearchParams params;
    private DefaultSearchResultsDisplayer<SearchResult> displayer;
    private final String title;
    private final SearchProvider.Presenter presenter;
    private Cancellable cancel;

    public CNDSearchComposition(String title, SearchProvider.Presenter presenter, SearchParams params) {
        this.title = title;
        this.presenter = presenter;
        this.params = params;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(SearchListener listener) {
        try {
            for (SearchRoot root : this.params.getSearchRoots()) {
                this.searchInRoot(root, listener);
            }
        }
        catch (Exception e) {
            listener.generalError((Throwable)e);
        }
        finally {
            this.terminate();
        }
    }

    public void terminate() {
        if (this.terminated.compareAndSet(false, true) && this.cancel != null) {
            this.cancel.cancel();
            this.cancel = null;
        }
    }

    public boolean isTerminated() {
        return this.terminated.get();
    }

    public synchronized SearchResultsDisplayer<SearchResult> getSearchResultsDisplayer() {
        if (this.displayer == null) {
            this.displayer = SearchResultsDisplayer.createDefault((SearchResultsDisplayer.NodeDisplayer)new DisplayerHelper(), (SearchComposition)this, (SearchProvider.Presenter)this.presenter, (String)this.title);
            this.displayer.getVisualComponent();
            OutlineView view = this.displayer.getOutlineView();
            view.setPropertyColumns(SearchResultPropertySet.getNamesAndDisplayNames());
            OutlineSupport.get(CNDSearchComposition.class).installFor((ETable)view.getOutline());
        }
        return this.displayer;
    }

    private void searchInRoot(SearchRoot root, final SearchListener listener) {
        UnixFindBasedSearcher find;
        if (this.isTerminated()) {
            return;
        }
        final ExecutionEnvironment env = FileSystemProvider.getExecutionEnvironment((FileObject)root.getFileObject());
        if (!ConnectionManager.getInstance().isConnectedTo(env)) {
            return;
        }
        if (env.isRemote() && HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)env)) {
            return;
        }
        try {
            find = HostInfoUtils.getHostInfo((ExecutionEnvironment)env).getOSFamily().isUnix() ? new UnixFindBasedSearcher(root, this.params) : null;
        }
        catch (Exception ex) {
            return;
        }
        if (find == null) {
            return;
        }
        NativeProcessBuilder npb = NativeProcessBuilder.newProcessBuilder((ExecutionEnvironment)env);
        npb.setExecutable(find.getCommand()).setArguments(find.getCommandArguments());
        try {
            final NativeProcess process = npb.call();
            Runnable readOutputTask = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            String line;
                            BufferedReader br = ProcessUtils.getReader((InputStream)process.getInputStream(), (boolean)env.isRemote());
                            while (!CNDSearchComposition.this.isTerminated() && (line = br.readLine()) != null) {
                                MatchingFileData data = find.processOutputLine(line.trim());
                                if (data == null) continue;
                                CNDSearchComposition.this.displayer.addMatchingObject((Object)new SearchResult(env, data));
                            }
                        }
                        catch (IOException ex) {
                            if (CNDSearchComposition.this.isTerminated()) break block3;
                            listener.generalError((Throwable)ex);
                        }
                    }
                }
            };
            Runnable readErrorTask = new Runnable(){

                @Override
                public void run() {
                    block3: {
                        try {
                            String line;
                            BufferedReader br = ProcessUtils.getReader((InputStream)process.getErrorStream(), (boolean)env.isRemote());
                            while (!CNDSearchComposition.this.isTerminated() && (line = br.readLine()) != null) {
                                Throwable ex = new Throwable(line);
                                listener.generalError(ex);
                            }
                        }
                        catch (IOException ex) {
                            if (CNDSearchComposition.this.isTerminated()) break block3;
                            listener.generalError((Throwable)ex);
                        }
                    }
                }
            };
            final RequestProcessor.Task outTask = RP.post(readOutputTask);
            final RequestProcessor.Task errTask = RP.post(readErrorTask);
            this.cancel = new Cancellable(){

                public boolean cancel() {
                    process.destroy();
                    outTask.cancel();
                    errTask.cancel();
                    outTask.waitFinished();
                    errTask.waitFinished();
                    return true;
                }
            };
            process.waitFor();
        }
        catch (InterruptedException ex) {
        }
        catch (IOException ex) {
            listener.generalError((Throwable)ex);
        }
    }

    private static class DisplayerHelper
    extends SearchResultsDisplayer.NodeDisplayer<SearchResult> {
        private DisplayerHelper() {
        }

        public Node matchToNode(SearchResult result) {
            return new SearchResultNode(result);
        }
    }
}

