/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.api.BrandingUtils;
import org.netbeans.modules.apisupport.project.api.Util;
import org.netbeans.modules.apisupport.project.spi.BrandingModel;
import org.netbeans.modules.apisupport.project.spi.ExecProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.ApisupportAntUIUtils;
import org.netbeans.modules.apisupport.project.ui.Bundle;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizer;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.HarnessVersion;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.ActionProgress;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.ui.support.CommonProjectActions;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.ProjectSensitiveActions;
import org.openide.awt.DynamicMenuContent;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileObject;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.RequestProcessor;
import org.openide.util.Task;
import org.openide.util.TaskListener;
import org.openide.util.actions.Presenter;

public final class SuiteActions
implements ActionProvider,
ExecProject {
    private static final String COMMAND_BRANDING = "branding";
    private static final String COMMAND_BUILD_JNLP = "build-jnlp";
    private static final String COMMAND_BUILD_MAC = "build-mac";
    private static final String COMMAND_BUILD_OSGI = "build-osgi";
    private static final String COMMAND_BUILD_OSGI_OBR = "build-osgi-obr";
    private static final String COMMAND_BUILD_ZIP = "build-zip";
    private static final String COMMAND_DEBUG_JNLP = "debug-jnlp";
    private static final String COMMAND_DEBUG_OSGI = "debug-osgi";
    private static final String COMMAND_NBMS = "nbms";
    private static final String COMMAND_PROFILE_OSGI = "profile-osgi";
    private static final String COMMAND_RUN_JNLP = "run-jnlp";
    private static final String COMMAND_RUN_OSGI = "run-osgi";
    private static final String SUITE_ACTIONS_TYPE = "org-netbeans-modules-apisupport-project-suite";
    private static final String SUITE_ACTIONS_PATH = "Projects/org-netbeans-modules-apisupport-project-suite/Actions";
    private static final String SUITE_PACKAGE_ACTIONS_TYPE = "org-netbeans-modules-apisupport-project-suite-package";
    private static final String SUITE_PACKAGE_ACTIONS_PATH = "Projects/org-netbeans-modules-apisupport-project-suite-package/Actions";
    private static final String SUITE_JNLP_ACTIONS_TYPE = "org-netbeans-modules-apisupport-project-suite-jnlp";
    private static final String SUITE_JNLP_ACTIONS_PATH = "Projects/org-netbeans-modules-apisupport-project-suite-jnlp/Actions";
    private static final String SUITE_OSGI_ACTIONS_TYPE = "org-netbeans-modules-apisupport-project-suite-osgi";
    private static final String SUITE_OSGI_ACTIONS_PATH = "Projects/org-netbeans-modules-apisupport-project-suite-osgi/Actions";
    private static final RequestProcessor RP = new RequestProcessor(SuiteActions.class);
    private static final Map<String, HarnessVersion> MINIMUM_HARNESS_VERSION = new HashMap<String, HarnessVersion>();
    private final SuiteProject project;
    private static final int PROMPT_FOR_APP_NAME_MODE_JNLP = 0;
    private static final int PROMPT_FOR_APP_NAME_MODE_ZIP = 1;

    public Task execute(String ... args) throws IOException {
        StringBuilder sb = new StringBuilder();
        for (String r : args) {
            sb.append(r).append(' ');
        }
        Properties p = new Properties();
        p.setProperty("run.args", sb.substring(0, sb.length() - 1));
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])new String[]{"run"}, (Properties)p);
    }

    static Action[] getProjectActions(SuiteProject project) {
        return CommonProjectActions.forType((String)SUITE_ACTIONS_TYPE);
    }

    public static Action packageMenu() {
        return new SubMenuAction(Bundle.SUITE_ACTION_package_menu(), Arrays.asList(CommonProjectActions.forType((String)SUITE_PACKAGE_ACTIONS_TYPE)));
    }

    public static Action buildZip() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BUILD_ZIP, (String)Bundle.SUITE_ACTION_zip(), null);
    }

    public static Action nbms() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_NBMS, (String)Bundle.SUITE_ACTION_nbms(), null);
    }

    public static Action buildMac() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BUILD_MAC, (String)Bundle.SUITE_ACTION_mac(), null);
    }

    public static Action jnlpMenu() {
        return new SubMenuAction(Bundle.SUITE_ACTION_jnlp_menu(), Arrays.asList(CommonProjectActions.forType((String)SUITE_JNLP_ACTIONS_TYPE)));
    }

    public static Action buildJnlp() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BUILD_JNLP, (String)Bundle.SUITE_ACTION_build_jnlp(), null);
    }

    public static Action runJnlp() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_RUN_JNLP, (String)Bundle.SUITE_ACTION_run_jnlp(), null);
    }

    public static Action debugJnlp() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_DEBUG_JNLP, (String)Bundle.SUITE_ACTION_debug_jnlp(), null);
    }

    public static Action osgiMenu() {
        return new SubMenuAction(Bundle.SUITE_ACTION_osgi_menu(), Arrays.asList(CommonProjectActions.forType((String)SUITE_OSGI_ACTIONS_TYPE)));
    }

    public static Action buildOsgi() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BUILD_OSGI, (String)Bundle.SUITE_ACTION_build_osgi(), null);
    }

    public static Action buildOsgiObr() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BUILD_OSGI_OBR, (String)Bundle.SUITE_ACTION_build_osgi_obr(), null);
    }

    public static Action runOsgi() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_RUN_OSGI, (String)Bundle.SUITE_ACTION_run_osgi(), null);
    }

    public static Action debugOsgi() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_DEBUG_OSGI, (String)Bundle.SUITE_ACTION_debug_osgi(), null);
    }

    public static Action branding() {
        return ProjectSensitiveActions.projectCommandAction((String)COMMAND_BRANDING, (String)Bundle.SUITE_ACTION_branding(), null);
    }

    public SuiteActions(SuiteProject project) {
        this.project = project;
    }

    public String[] getSupportedActions() {
        ArrayList<String> actions = new ArrayList<String>(Arrays.asList("build", "clean", "rebuild", "run", "debug", "test", COMMAND_BUILD_ZIP, COMMAND_BUILD_JNLP, COMMAND_RUN_JNLP, COMMAND_DEBUG_JNLP, COMMAND_BUILD_OSGI, COMMAND_BUILD_OSGI_OBR, COMMAND_RUN_OSGI, COMMAND_DEBUG_OSGI, COMMAND_PROFILE_OSGI, COMMAND_BUILD_MAC, COMMAND_NBMS, "profile", COMMAND_BRANDING, "rename", "move", "delete"));
        return actions.toArray(new String[actions.size()]);
    }

    public boolean isActionEnabled(String command, Lookup context) throws IllegalArgumentException {
        if (COMMAND_BRANDING.equals(command)) {
            return this.project.getEvaluator().getProperty("branding.token") != null;
        }
        if ("delete".equals(command) || "rename".equals(command) || "move".equals(command)) {
            return true;
        }
        if (Arrays.asList(this.getSupportedActions()).contains(command)) {
            NbPlatform plaf;
            HarnessVersion min = MINIMUM_HARNESS_VERSION.get(command);
            if (min != null && ((plaf = this.project.getPlatform(true)) == null || plaf.getHarnessVersion().compareTo(min) < 0)) {
                return false;
            }
            return SuiteActions.findBuildXml(this.project) != null;
        }
        throw new IllegalArgumentException(command);
    }

    public void invokeAction(String command, Lookup context) throws IllegalArgumentException {
        if (!ModuleActions.canRunNoLock(command, this.project.getTestUserDirLockFile())) {
            return;
        }
        if ("delete".equals(command)) {
            DefaultProjectOperations.performDefaultDeleteOperation((Project)this.project);
        } else if ("rename".equals(command)) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, null);
        } else if ("move".equals(command)) {
            DefaultProjectOperations.performDefaultMoveOperation((Project)this.project);
        } else if (COMMAND_BRANDING.equals(command)) {
            final ActionProgress listener = ActionProgress.start((Lookup)context);
            Runnable runnable = new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        final SuiteProperties properties = new SuiteProperties(SuiteActions.this.project, SuiteActions.this.project.getHelper(), SuiteActions.this.project.getEvaluator(), SuiteUtils.getSubProjects(SuiteActions.this.project));
                        final BrandingModel model = properties.getBrandingModel();
                        EventQueue.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                BrandingUtils.openBrandingEditor((String)Bundle.Title_BrandingEditor(properties.getProjectDisplayName()), (Project)SuiteActions.this.project, (BrandingModel)model);
                            }
                        });
                    }
                    finally {
                        listener.finished(true);
                    }
                }
            };
            RP.post(runnable);
        } else {
            HarnessVersion v;
            NbPlatform plaf = this.project.getPlatform(false);
            if (plaf != null && (v = plaf.getHarnessVersion()) != HarnessVersion.UNKNOWN) {
                for (Project p : ((SubprojectProvider)this.project.getLookup().lookup(SubprojectProvider.class)).getSubprojects()) {
                    if (v.compareTo(((NbModuleProject)p).getMinimumHarnessVersion()) >= 0) continue;
                    ModuleActions.promptForNewerHarness();
                    return;
                }
            }
            ExecutorTask task = null;
            try {
                task = this.invokeActionImpl(command, context);
            }
            catch (IOException e) {
                Util.err.notify((Throwable)e);
            }
            if (task != null) {
                final ActionProgress listener = ActionProgress.start((Lookup)context);
                task.addTaskListener(new TaskListener(){

                    public void taskFinished(Task task) {
                        listener.finished(((ExecutorTask)task).result() == 0);
                    }
                });
            }
        }
    }

    @CheckForNull
    public ExecutorTask invokeActionImpl(String command, Lookup context) throws IllegalArgumentException, IOException {
        String[] targetNames;
        Properties p = new Properties();
        if (command.equals("build")) {
            targetNames = new String[]{"build"};
        } else if (command.equals("clean")) {
            targetNames = new String[]{"clean"};
        } else if (command.equals("rebuild")) {
            targetNames = new String[]{"clean", "build"};
        } else if (command.equals("test")) {
            targetNames = new String[]{"test"};
        } else if (command.equals(COMMAND_BUILD_ZIP)) {
            if (this.promptForAppName(1)) {
                return null;
            }
            targetNames = new String[]{COMMAND_BUILD_ZIP};
        } else if (command.equals(COMMAND_BUILD_JNLP)) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{COMMAND_BUILD_JNLP};
        } else if (command.equals(COMMAND_RUN_JNLP)) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{COMMAND_RUN_JNLP};
        } else if (command.equals(COMMAND_DEBUG_JNLP)) {
            if (this.promptForAppName(0)) {
                return null;
            }
            targetNames = new String[]{COMMAND_DEBUG_JNLP};
        } else {
            targetNames = new String[]{command};
        }
        ModuleActions.setRunArgsIde(this.project, this.project.getEvaluator(), command, p);
        return ActionUtils.runTarget((FileObject)SuiteActions.findBuildXml(this.project), (String[])targetNames, (Properties)p);
    }

    private static FileObject findBuildXml(SuiteProject project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    private boolean promptForAppName(int mode) {
        String msg;
        String name = this.project.getEvaluator().getProperty("app.name");
        if (name != null) {
            return false;
        }
        switch (mode) {
            case 0: {
                msg = Bundle.ERR_app_name_jnlp();
                break;
            }
            case 1: {
                msg = Bundle.ERR_app_name_zip();
                break;
            }
            default: {
                throw new AssertionError(mode);
            }
        }
        if (ApisupportAntUIUtils.showAcceptCancelDialog(Bundle.TITLE_app_name(), msg, Bundle.LBL_configure_app_name(), Bundle.ACSD_configure_app_name(), null, 2)) {
            SuiteCustomizer cpi = (SuiteCustomizer)this.project.getLookup().lookup(SuiteCustomizer.class);
            cpi.showCustomizer("Application", "standaloneApp");
        }
        return true;
    }

    static {
        MINIMUM_HARNESS_VERSION.put("test", HarnessVersion.V61);
        MINIMUM_HARNESS_VERSION.put(COMMAND_NBMS, HarnessVersion.V50u1);
        MINIMUM_HARNESS_VERSION.put(COMMAND_BUILD_MAC, HarnessVersion.V55u1);
        MINIMUM_HARNESS_VERSION.put(COMMAND_BUILD_OSGI, HarnessVersion.V69);
        MINIMUM_HARNESS_VERSION.put(COMMAND_BUILD_OSGI_OBR, HarnessVersion.V69);
        MINIMUM_HARNESS_VERSION.put(COMMAND_RUN_OSGI, HarnessVersion.V69);
        MINIMUM_HARNESS_VERSION.put(COMMAND_DEBUG_OSGI, HarnessVersion.V69);
        MINIMUM_HARNESS_VERSION.put(COMMAND_PROFILE_OSGI, HarnessVersion.V69);
    }

    private static class SubMenuAction
    extends AbstractAction
    implements ContextAwareAction {
        private final String label;
        private final List<? extends Action> entries;

        SubMenuAction(String label, List<? extends Action> entries) {
            this.label = label;
            this.entries = entries;
        }

        public Action createContextAwareInstance(final Lookup ctx) {
            class A
            extends AbstractAction
            implements Presenter.Popup {
                A() {
                }

                @Override
                public void actionPerformed(ActionEvent e) {
                    assert (false);
                }

                public JMenuItem getPopupPresenter() {
                    class Menu
                    extends JMenu
                    implements DynamicMenuContent {
                        Menu() {
                            super(SubMenuAction.this.label);
                        }

                        public JComponent[] getMenuPresenters() {
                            return new JComponent[]{this};
                        }

                        public JComponent[] synchMenuPresenters(JComponent[] items) {
                            return this.getMenuPresenters();
                        }
                    }
                    Menu m = new Menu();
                    for (Action entry : SubMenuAction.this.entries) {
                        if (entry instanceof ContextAwareAction) {
                            entry = ((ContextAwareAction)entry).createContextAwareInstance(ctx);
                        }
                        m.add(entry);
                    }
                    return m;
                }
            }
            return new A();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            assert (false);
        }
    }
}

