/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.memory;

import java.util.logging.Level;
import org.netbeans.lib.profiler.results.AbstractDataFrameProcessor;
import org.netbeans.lib.profiler.results.ProfilingResultListener;
import org.netbeans.lib.profiler.results.memory.MemoryProfilingResultsListener;

public class MemoryDataFrameProcessor
extends AbstractDataFrameProcessor {
    @Override
    public void doProcessDataFrame(byte[] buffer) {
        int curPos = 0;
        int bufSize = buffer.length;
        int n = -1;
        do {
            byte eventType = buffer[curPos++];
            switch (eventType) {
                case 12: {
                    char classId = (char)((buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF);
                    long objSize = ((long)buffer[curPos++] & 0xFFL) << 32 | ((long)buffer[curPos++] & 0xFFL) << 24 | ((long)buffer[curPos++] & 0xFFL) << 16 | ((long)buffer[curPos++] & 0xFFL) << 8 | (long)buffer[curPos++] & 0xFFL;
                    int depth = (buffer[curPos++] & 0xFF) << 16 | (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Allocation stack trace: classId=" + classId + ", objSize=" + objSize + ", depth=" + depth);
                    }
                    int[] methodIds = new int[depth];
                    for (int i = 0; i < depth; ++i) {
                        methodIds[i] = (buffer[curPos++] & 0xFF) << 24 | (buffer[curPos++] & 0xFF) << 16 | (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    }
                    this.fireAllocStackTrace(classId, objSize, methodIds);
                    break;
                }
                case 14: {
                    char c;
                    char classId = (char)((buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF);
                    char objEpoch = (char)((buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF);
                    if (objEpoch > c) {
                        c = objEpoch;
                    }
                    long objectId = ((long)classId & 0xFFFFL) << 48 | ((long)objEpoch & 0xFFFFL) << 32 | ((long)buffer[curPos++] & 0xFFL) << 24 | ((long)buffer[curPos++] & 0xFFL) << 16 | ((long)buffer[curPos++] & 0xFFL) << 8 | (long)buffer[curPos++] & 0xFFL;
                    long objSize = ((long)buffer[curPos++] & 0xFFL) << 32 | ((long)buffer[curPos++] & 0xFFL) << 24 | ((long)buffer[curPos++] & 0xFFL) << 16 | ((long)buffer[curPos++] & 0xFFL) << 8 | (long)buffer[curPos++] & 0xFFL;
                    int depth = (buffer[curPos++] & 0xFF) << 16 | (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Liveness stack trace: classId=" + classId + ", objectId=" + objectId + ", objEpoch=" + objEpoch + ", objSize=" + objSize + ", depth=" + depth);
                    }
                    int[] methodIds = new int[depth];
                    for (int i = 0; i < depth; ++i) {
                        methodIds[i] = (buffer[curPos++] & 0xFF) << 24 | (buffer[curPos++] & 0xFF) << 16 | (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    }
                    this.fireLivenessStackTrace(classId, objectId, objEpoch, objSize, methodIds);
                    break;
                }
                case 15: {
                    char c;
                    char classId = (char)((buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF);
                    char objEpoch = (char)((buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF);
                    if (objEpoch > c) {
                        c = objEpoch;
                    }
                    long objectId = ((long)classId & 0xFFFFL) << 48 | ((long)objEpoch & 0xFFFFL) << 32 | ((long)buffer[curPos++] & 0xFFL) << 24 | ((long)buffer[curPos++] & 0xFFL) << 16 | ((long)buffer[curPos++] & 0xFFL) << 8 | (long)buffer[curPos++] & 0xFFL;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("GC Performed: classId=" + classId + ", objectId=" + objectId + ", objEpoch=" + objEpoch);
                    }
                    this.fireGCPerformed(classId, objectId, objEpoch);
                    break;
                }
                case 10: {
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profiling data reset");
                    }
                    this.fireReset();
                    break;
                }
                case 26: {
                    int id = (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    long timeStamp = ((long)buffer[curPos++] & 0xFFL) << 48 | ((long)buffer[curPos++] & 0xFFL) << 40 | ((long)buffer[curPos++] & 0xFFL) << 32 | ((long)buffer[curPos++] & 0xFFL) << 24 | ((long)buffer[curPos++] & 0xFFL) << 16 | ((long)buffer[curPos++] & 0xFFL) << 8 | (long)buffer[curPos++] & 0xFFL;
                    int threadId = (buffer[curPos++] & 0xFF) << 8 | buffer[curPos++] & 0xFF;
                    if (LOGGER.isLoggable(Level.FINEST)) {
                        LOGGER.finest("Profile Point Hit " + id + ", threadId=" + id + ", timeStamp=" + timeStamp);
                    }
                    this.fireProfilingPoint(threadId, id, timeStamp);
                    break;
                }
                default: {
                    LOGGER.severe("*** Profiler Engine: internal error: got unknown event type in MemoryDataFrameProcessor: " + eventType + " at " + curPos);
                }
            }
        } while (curPos < bufSize);
    }

    private void fireAllocStackTrace(final char classId, final long objSize, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                try {
                    ((MemoryProfilingResultsListener)listener).onAllocStackTrace(classId, objSize, methodIds);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void fireGCPerformed(final char classId, final long objectId, final int objEpoch) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((MemoryProfilingResultsListener)listener).onGcPerformed(classId, objectId, objEpoch);
            }
        });
    }

    private void fireLivenessStackTrace(final char classId, final long objectId, final int objEpoch, final long objSize, final int[] methodIds) {
        this.foreachListener(new AbstractDataFrameProcessor.ListenerFunctor(){

            @Override
            public void execute(ProfilingResultListener listener) {
                ((MemoryProfilingResultsListener)listener).onLivenessStackTrace(classId, objectId, objEpoch, objSize, methodIds);
            }
        });
    }
}

