/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu.cct;

import java.util.Stack;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.profiler.ProfilerClient;
import org.netbeans.lib.profiler.global.InstrumentationFilter;
import org.netbeans.lib.profiler.global.ProfilingSessionStatus;
import org.netbeans.lib.profiler.results.RuntimeCCTNodeProcessor;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainerFree;
import org.netbeans.lib.profiler.results.cpu.TimingAdjusterOld;
import org.netbeans.lib.profiler.results.cpu.cct.CCTResultsFilter;
import org.netbeans.lib.profiler.results.cpu.cct.nodes.MethodCPUCCTNode;

public class CCTFlattener
extends RuntimeCCTNodeProcessor.PluginAdapter {
    private static final Logger LOGGER = Logger.getLogger(CCTFlattener.class.getName());
    private final Object containerGuard = new Object();
    private FlatProfileContainer container;
    private ProfilerClient client;
    private Stack parentStack;
    private int[] invDiff;
    private int[] invPM;
    private int[] nCalleeInvocations;
    private long[] timePM0;
    private long[] timePM1;
    private int nMethods;
    private CCTResultsFilter currentFilter = null;

    public CCTFlattener(ProfilerClient client, CCTResultsFilter filter) {
        this.client = client;
        this.parentStack = new Stack();
        this.currentFilter = filter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FlatProfileContainer getFlatProfile() {
        Object object = this.containerGuard;
        synchronized (object) {
            return this.container;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStart() {
        ProfilingSessionStatus status = this.client.getStatus();
        this.nMethods = status.getNInstrMethods();
        this.timePM0 = new long[this.nMethods];
        this.timePM1 = new long[status.collectingTwoTimeStamps() ? this.nMethods : 0];
        this.invPM = new int[this.nMethods];
        this.invDiff = new int[this.nMethods];
        this.nCalleeInvocations = new int[this.nMethods];
        this.parentStack.clear();
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onStop() {
        ProfilingSessionStatus status = this.client.getStatus();
        long wholeGraphTime0 = 0L;
        long wholeGraphTime1 = 0L;
        long totalNInv = 0L;
        for (int i = 0; i < this.nMethods; ++i) {
            double time = TimingAdjusterOld.getInstance(status).adjustTime(this.timePM0[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], false);
            if (time < 0.0) {
                time = 0.0;
            }
            this.timePM0[i] = (long)time;
            if (i > 0) {
                wholeGraphTime0 = (long)((double)wholeGraphTime0 + time);
            }
            if (status.collectingTwoTimeStamps()) {
                time = TimingAdjusterOld.getInstance(status).adjustTime(this.timePM1[i], this.invPM[i] + this.invDiff[i], this.nCalleeInvocations[i] + this.invDiff[i], true);
                this.timePM1[i] = (long)time;
                if (i > 0) {
                    wholeGraphTime1 = (long)((double)wholeGraphTime1 + time);
                }
            }
            totalNInv += (long)this.invPM[i];
        }
        Object object = this.containerGuard;
        synchronized (object) {
            this.container = new FlatProfileContainerFree(status, this.timePM0, this.timePM1, this.invPM, new char[0], wholeGraphTime0, wholeGraphTime1, this.invPM.length);
        }
        this.timePM1 = null;
        this.timePM0 = null;
        this.nCalleeInvocations = null;
        this.invDiff = null;
        this.invPM = null;
        this.parentStack.clear();
    }

    @Override
    public void onNode(MethodCPUCCTNode node) {
        int parentMethodId;
        String jvmClassName;
        boolean filteredOut;
        int nodeMethodId = node.getMethodId();
        ProfilingSessionStatus status = this.client.getStatus();
        InstrumentationFilter filter = this.client.getSettings().getInstrumentationFilter();
        MethodCPUCCTNode currentParent = this.parentStack.isEmpty() ? null : (MethodCPUCCTNode)this.parentStack.peek();
        boolean bl = filteredOut = node.getFilteredStatus() == 2;
        if (!(filteredOut || this.client.getSettings().getCPUProfilingType() != 2 && node.getFilteredStatus() != 1 || filter.passesFilter(jvmClassName = status.getInstrMethodClasses()[nodeMethodId].replace('.', '/')))) {
            filteredOut = true;
        }
        if (!filteredOut && this.currentFilter != null) {
            filteredOut = !this.currentFilter.passesFilter();
        }
        int n = parentMethodId = currentParent != null ? currentParent.getMethodId() : -1;
        if (LOGGER.isLoggable(Level.FINEST)) {
            LOGGER.log(Level.FINEST, "Processing runtime node: {0}.{1}; filtered={2}, time={3}, CPU time={4}", new Object[]{status.getInstrMethodClasses()[nodeMethodId], status.getInstrMethodNames()[nodeMethodId], filteredOut, node.getNetTime0(), node.getNetTime1()});
            String parentInfo = currentParent != null ? status.getInstrMethodClasses()[parentMethodId] + "." + status.getInstrMethodNames()[parentMethodId] : "none";
            LOGGER.log(Level.FINEST, "Currently used parent: {0}", parentInfo);
        }
        if (filteredOut) {
            if (currentParent != null && !currentParent.isRoot()) {
                int n2 = parentMethodId;
                this.invDiff[n2] = this.invDiff[n2] + node.getNCalls();
                int n3 = parentMethodId;
                this.timePM0[n3] = this.timePM0[n3] + node.getNetTime0();
                if (status.collectingTwoTimeStamps()) {
                    int n4 = parentMethodId;
                    this.timePM1[n4] = this.timePM1[n4] + node.getNetTime1();
                }
            }
        } else {
            int n5 = nodeMethodId;
            this.timePM0[n5] = this.timePM0[n5] + node.getNetTime0();
            if (status.collectingTwoTimeStamps()) {
                int n6 = nodeMethodId;
                this.timePM1[n6] = this.timePM1[n6] + node.getNetTime1();
            }
            int n7 = nodeMethodId;
            this.invPM[n7] = this.invPM[n7] + node.getNCalls();
            if (currentParent != null && !currentParent.isRoot()) {
                int n8 = parentMethodId;
                this.nCalleeInvocations[n8] = this.nCalleeInvocations[n8] + node.getNCalls();
            }
            currentParent = node;
        }
        this.parentStack.push(node);
    }

    @Override
    public void onBackout(MethodCPUCCTNode node) {
        this.parentStack.pop();
    }
}

