/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.ExportDataDumper;
import org.netbeans.lib.profiler.results.FilterSortSupport;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;

public class PrestimeCPUCCTNodeBacked
extends PrestimeCPUCCTNode {
    private static NumberFormat percentFormat = null;
    protected int selfCompactDataOfs;
    protected Set<Integer> compactDataOfs;
    protected int nChildren;
    private int methodID;
    private int nCalls;
    private long sleepTime0;
    private long totalTime0;
    private long totalTime1;
    private long waitTime0;

    public PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode parent, int compactDataOfs) {
        super(container, parent);
        this.selfCompactDataOfs = compactDataOfs;
        this.compactDataOfs = new HashSet<Integer>();
        this.compactDataOfs.add(this.selfCompactDataOfs);
        this.container = container;
        this.nChildren = container.getNChildrenForNodeOfs(compactDataOfs);
        this.methodID = container.getMethodIdForNodeOfs(compactDataOfs);
        this.nCalls = container.getNCallsForNodeOfs(compactDataOfs);
        this.sleepTime0 = container.getSleepTime0ForNodeOfs(compactDataOfs);
        this.totalTime0 = container.getTotalTime0ForNodeOfs(compactDataOfs);
        if (container.collectingTwoTimeStamps) {
            this.totalTime1 = container.getTotalTime1ForNodeOfs(compactDataOfs);
        }
        this.waitTime0 = container.getWaitTime0ForNodeOfs(compactDataOfs);
    }

    protected PrestimeCPUCCTNodeBacked(CPUCCTContainer container, PrestimeCPUCCTNode[] children) {
        super(container, null);
        this.setThreadNode();
        this.children = children;
        this.nChildren = children.length;
        for (int i = 0; i < this.nChildren; ++i) {
            children[i].parent = this;
        }
    }

    PrestimeCPUCCTNodeBacked() {
    }

    public PrestimeCPUCCTNodeBacked createRootCopy() {
        PrestimeCPUCCTNodeBacked copy = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
        copy.parent = null;
        copy.compactDataOfs.clear();
        copy.compactDataOfs.addAll(this.compactDataOfs);
        copy.children = null;
        copy.nChildren = this.nChildren;
        copy.methodID = this.methodID;
        copy.nCalls = this.nCalls;
        copy.sleepTime0 = this.sleepTime0;
        copy.totalTime0 = this.totalTime0;
        copy.totalTime1 = this.totalTime1;
        copy.waitTime0 = this.waitTime0;
        return copy;
    }

    @Override
    public CCTNode getChild(int index) {
        this.getChildren();
        if (index < this.children.length) {
            return this.children[index];
        }
        return null;
    }

    @Override
    public CCTNode[] getChildren() {
        if (this.nChildren == 0) {
            return null;
        }
        if (this.children != null) {
            return this.children;
        }
        ArrayList<PrestimeCPUCCTNodeBacked> childrenL = new ArrayList<PrestimeCPUCCTNodeBacked>();
        PrestimeCPUCCTNodeBacked filtered = null;
        FilterSortSupport.Configuration config = this.container.getCPUResSnapshot().getFilterSortInfo(this);
        for (int ofs : this.compactDataOfs) {
            int chcount = this.container.getNChildrenForNodeOfs(ofs);
            for (int i = 0; i < chcount; ++i) {
                PrestimeCPUCCTNodeBacked ch = new PrestimeCPUCCTNodeBacked(this.container, this, this.container.getChildOfsForNodeOfs(ofs, i));
                if (FilterSortSupport.passesFilter(config, ch.getNodeName())) {
                    int chindex = childrenL.indexOf(ch);
                    if (chindex != -1) {
                        ((PrestimeCPUCCTNodeBacked)childrenL.get(chindex)).merge(ch);
                        continue;
                    }
                    childrenL.add(ch);
                    continue;
                }
                if (filtered == null) {
                    filtered = ch;
                    ch.setFilteredNode();
                    childrenL.add(filtered);
                    continue;
                }
                filtered.merge(ch);
            }
        }
        if (this.hasSelfTimeChild()) {
            PrestimeCPUCCTNodeBacked selfTimeChild = new PrestimeCPUCCTNodeBacked(this.container, this.parent, this.selfCompactDataOfs);
            selfTimeChild.setSelfTimeNode();
            childrenL.add(selfTimeChild);
        }
        if (this.isFilteredNode() && filtered != null && childrenL.size() == 1) {
            this.children = (PrestimeCPUCCTNode[])filtered.getChildren();
            this.nChildren = this.children == null ? 0 : this.children.length;
            this.compactDataOfs = filtered.compactDataOfs;
        } else {
            this.nChildren = childrenL.size();
            this.children = childrenL.toArray(new PrestimeCPUCCTNode[this.nChildren]);
        }
        this.sortChildren(config.getSortBy(), config.getSortOrder());
        return this.children;
    }

    private boolean hasSelfTimeChild() {
        return !this.isThreadNode() && !this.isFilteredNode() && this.compactDataOfs.size() == 1;
    }

    protected void merge(PrestimeCPUCCTNodeBacked node) {
        this.children = null;
        this.nChildren += node.nChildren;
        this.nCalls += node.nCalls;
        this.sleepTime0 += node.sleepTime0;
        this.totalTime0 += node.totalTime0;
        this.totalTime1 += node.totalTime1;
        this.waitTime0 += node.waitTime0;
    }

    @Override
    protected void resetChildren() {
        if (this.compactDataOfs != null) {
            this.compactDataOfs.clear();
            this.compactDataOfs.add(this.selfCompactDataOfs);
            this.nChildren = this.container.getNChildrenForNodeOfs(this.selfCompactDataOfs);
        }
        if (this.children == null) {
            return;
        }
        if (!this.isThreadNode() || this.parent != null) {
            this.children = null;
        } else {
            super.resetChildren();
        }
    }

    @Override
    public void setSelfTimeNode() {
        super.setSelfTimeNode();
        this.nChildren = 0;
        this.children = null;
        int ofs = this.selfCompactDataOfs;
        this.totalTime0 = this.container.getSelfTime0ForNodeOfs(ofs);
        if (this.container.collectingTwoTimeStamps) {
            this.totalTime1 = this.container.getSelfTime1ForNodeOfs(ofs);
        }
    }

    @Override
    public int getMethodId() {
        return this.methodID;
    }

    @Override
    public int getNCalls() {
        return this.nCalls;
    }

    @Override
    public int getNChildren() {
        if (this.getChildren() == null) {
            return 0;
        }
        return this.nChildren;
    }

    @Override
    public long getSleepTime0() {
        return this.sleepTime0;
    }

    @Override
    public int getThreadId() {
        return this.container.getThreadId();
    }

    @Override
    public long getTotalTime0() {
        return this.totalTime0;
    }

    @Override
    public float getTotalTime0InPerCent() {
        float result = (float)(this.container.getWholeGraphNetTime0() > 0L ? (double)this.totalTime0 / (double)this.container.getWholeGraphNetTime0() * 100.0 : 0.0);
        return result < 100.0f ? result : 100.0f;
    }

    @Override
    public long getTotalTime1() {
        return this.totalTime1;
    }

    @Override
    public float getTotalTime1InPerCent() {
        return (float)(this.container.getWholeGraphNetTime1() > 0L ? (double)this.totalTime1 / (double)this.container.getWholeGraphNetTime1() * 100.0 : 0.0);
    }

    @Override
    public long getWaitTime0() {
        return this.waitTime0;
    }

    @Override
    public void sortChildren(int sortBy, boolean sortOrder) {
        this.container.getCPUResSnapshot().saveSortParams(sortBy, sortOrder, this);
        if (this.nChildren == 0 || this.children == null) {
            return;
        }
        this.doSortChildren(sortBy, sortOrder);
    }

    public void exportXMLData(ExportDataDumper eDD, String indent) {
        String newline = System.getProperty("line.separator");
        StringBuffer result = new StringBuffer(indent + "<node>" + newline);
        result.append(indent).append(" <Name>").append(this.replaceHTMLCharacters(this.getNodeName())).append("</Name>").append(newline);
        result.append(indent).append(" <Parent>").append(this.replaceHTMLCharacters(this.getParent() == null ? "none" : ((PrestimeCPUCCTNodeBacked)this.getParent()).getNodeName())).append("</Parent>").append(newline);
        result.append(indent).append(" <Time_Relative>").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</Time_Relative>").append(newline);
        result.append(indent).append(" <Time>").append(this.getTotalTime0()).append("</Time>").append(newline);
        result.append(indent).append(" <Invocations>").append(this.getNCalls()).append("</Invocations>").append(newline);
        eDD.dumpData(result);
        if (this.children != null) {
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportXMLData(eDD, indent + "  ");
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i]).exportXMLData(eDD, indent + "  ");
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
        result = new StringBuffer(indent + "</node>");
        eDD.dumpData(result);
    }

    public void exportHTMLData(ExportDataDumper eDD, int depth) {
        int i;
        StringBuffer result = new StringBuffer("<tr><td class=\"method\"><pre class=\"method\">.");
        for (i = 0; i < depth; ++i) {
            result.append(".");
        }
        result.append(this.replaceHTMLCharacters(this.getNodeName())).append("</pre></td><td class=\"right\">").append(percentFormat.format((double)this.getTotalTime0InPerCent() / 100.0)).append("</td><td class=\"right\">").append(this.getTotalTime0()).append("</td><td class=\"right\">").append(this.getNCalls()).append("</td></tr>");
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportHTMLData(eDD, depth + 1);
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i2 = 0; i2 < this.nChildren; ++i2) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i2]).exportHTMLData(eDD, depth + 1);
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
    }

    private String replaceHTMLCharacters(String s) {
        StringBuilder sb = new StringBuilder();
        int len = s.length();
        block6: for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            switch (c) {
                case '<': {
                    sb.append("&lt;");
                    continue block6;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block6;
                }
                case '&': {
                    sb.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block6;
                }
                default: {
                    sb.append(c);
                }
            }
        }
        return sb.toString();
    }

    public void exportCSVData(String separator, int depth, ExportDataDumper eDD) {
        int i;
        StringBuffer result = new StringBuffer();
        String newLine = "\r\n";
        String quote = "\"";
        String indent = " ";
        result.append(quote);
        for (i = 0; i < depth; ++i) {
            result.append(indent);
        }
        result.append(this.getNodeName()).append(quote).append(separator);
        result.append(quote).append(this.getTotalTime0InPerCent()).append(quote).append(separator);
        result.append(quote).append(this.getTotalTime0()).append(quote).append(separator);
        result.append(quote).append(this.getNCalls()).append(quote).append(newLine);
        eDD.dumpData(result);
        if (this.children != null) {
            for (i = 0; i < this.nChildren; ++i) {
                ((PrestimeCPUCCTNodeBacked)this.children[i]).exportCSVData(separator, depth + 1, eDD);
            }
        } else if (this.nChildren > 0) {
            int tempNChildren = this.nChildren;
            PrestimeCPUCCTNode[] tempChildren = (PrestimeCPUCCTNode[])this.getChildren();
            this.children = null;
            for (int i2 = 0; i2 < this.nChildren; ++i2) {
                ((PrestimeCPUCCTNodeBacked)tempChildren[i2]).exportCSVData(separator, depth + 1, eDD);
            }
            tempChildren = null;
            this.nChildren = tempNChildren;
        }
    }

    public static void setPercentFormat(NumberFormat percentFormat) {
        PrestimeCPUCCTNodeBacked.percentFormat = percentFormat;
    }
}

