/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;

public class DiffFlatProfileContainer
extends FlatProfileContainer {
    private final String[] names;
    private final double wholeGraphNetTime0;
    private final double wholeGraphNetTime1;
    private final long minTime;
    private final long maxTime;

    static DiffFlatProfileContainer create(FlatProfileContainer c1, FlatProfileContainer c2) {
        String name;
        int i;
        boolean collectingTwoTimeStamps = c1.collectingTwoTimeStamps && c2.collectingTwoTimeStamps;
        HashSet<String> names1 = new HashSet<String>();
        int rows1 = c1.timeInMcs0.length;
        for (int i2 = 0; i2 < rows1; ++i2) {
            names1.add(c1.getMethodNameAtRow(i2));
        }
        HashMap<String, Integer> names2 = new HashMap<String, Integer>();
        int rows2 = c2.timeInMcs0.length;
        for (int i3 = 0; i3 < rows2; ++i3) {
            names2.put(c2.getMethodNameAtRow(i3), i3);
        }
        int pointer = 0;
        long[] timesInMcs0 = new long[rows1 + rows2];
        long[] timesInMcs1 = collectingTwoTimeStamps ? new long[rows1 + rows2] : null;
        int[] nInvocations = new int[rows1 + rows2];
        String[] names = new String[rows1 + rows2];
        int[] methodIDs = new int[rows1 + rows2];
        for (i = 0; i < rows1; ++i) {
            name = c1.getMethodNameAtRow(i);
            timesInMcs0[pointer] = -c1.timeInMcs0[i];
            if (collectingTwoTimeStamps) {
                timesInMcs1[pointer] = -c1.timeInMcs1[i];
            }
            nInvocations[pointer] = -c1.nInvocations[i];
            names[pointer] = name;
            methodIDs[pointer] = c1.methodIds[i];
            Integer i2 = (Integer)names2.get(name);
            if (i2 != null) {
                int n = pointer;
                timesInMcs0[n] = timesInMcs0[n] + c2.timeInMcs0[i2];
                if (collectingTwoTimeStamps) {
                    int n2 = pointer;
                    timesInMcs1[n2] = timesInMcs1[n2] + c2.timeInMcs1[i2];
                }
                int n3 = pointer;
                nInvocations[n3] = nInvocations[n3] + c2.nInvocations[i2];
            }
            ++pointer;
        }
        for (i = 0; i < rows2; ++i) {
            name = c2.getMethodNameAtRow(i);
            if (names1.contains(name)) continue;
            timesInMcs0[pointer] = c2.timeInMcs0[i];
            if (collectingTwoTimeStamps) {
                timesInMcs1[pointer] = c2.timeInMcs1[i];
            }
            nInvocations[pointer] = c2.nInvocations[i];
            names[pointer] = name;
            methodIDs[pointer] = -c2.methodIds[i];
            ++pointer;
        }
        double wholeGraphNetTime0 = c2.getWholeGraphNetTime0() - c1.getWholeGraphNetTime0();
        double wholeGraphNetTime1 = c2.getWholeGraphNetTime1() - c1.getWholeGraphNetTime1();
        return new DiffFlatProfileContainer(collectingTwoTimeStamps, Arrays.copyOf(timesInMcs0, pointer), collectingTwoTimeStamps ? Arrays.copyOf(timesInMcs1, pointer) : null, Arrays.copyOf(nInvocations, pointer), Arrays.copyOf(names, pointer), Arrays.copyOf(methodIDs, pointer), pointer, wholeGraphNetTime0, wholeGraphNetTime1);
    }

    private DiffFlatProfileContainer(boolean collectingTwoTimeStamps, long[] timeInMcs0, long[] timeInMcs1, int[] nInvocations, String[] names, int[] methodIDs, int nMethods, double wholeGraphNetTime0, double wholeGraphNetTime1) {
        super(timeInMcs0, timeInMcs1, nInvocations, null, nMethods);
        this.collectingTwoTimeStamps = collectingTwoTimeStamps;
        this.names = names;
        this.wholeGraphNetTime0 = wholeGraphNetTime0;
        this.wholeGraphNetTime1 = wholeGraphNetTime1;
        long minTimeX = Long.MAX_VALUE;
        long maxTimeX = Long.MIN_VALUE;
        this.nRows = nMethods;
        this.methodIds = methodIDs;
        for (int i = 0; i < this.nRows; ++i) {
            minTimeX = Math.min(minTimeX, timeInMcs0[i]);
            maxTimeX = Math.max(maxTimeX, timeInMcs0[i]);
            this.nTotalInvocations += (long)nInvocations[i];
        }
        if (minTimeX > 0L && maxTimeX > 0L) {
            minTimeX = 0L;
        } else if (minTimeX < 0L && maxTimeX < 0L) {
            maxTimeX = 0L;
        }
        this.minTime = minTimeX;
        this.maxTime = maxTimeX;
    }

    @Override
    public String getMethodNameAtRow(int row) {
        return this.names[row];
    }

    @Override
    public double getWholeGraphNetTime0() {
        return this.wholeGraphNetTime0;
    }

    @Override
    public double getWholeGraphNetTime1() {
        return this.wholeGraphNetTime1;
    }

    public long getMinTime() {
        return this.minTime;
    }

    public long getMaxTime() {
        return this.maxTime;
    }

    @Override
    protected void swap(int a, int b) {
        String name = this.names[a];
        this.names[a] = this.names[b];
        this.names[b] = name;
    }
}

