/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.results.cpu;

import org.netbeans.lib.profiler.results.CCTNode;
import org.netbeans.lib.profiler.results.cpu.CPUCCTContainer;
import org.netbeans.lib.profiler.results.cpu.CPUResultsSnapshot;
import org.netbeans.lib.profiler.results.cpu.DiffCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.DiffFlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.FlatProfileContainer;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNode;
import org.netbeans.lib.profiler.results.cpu.PrestimeCPUCCTNodeBacked;

public class CPUResultsDiff
extends CPUResultsSnapshot {
    private final CPUResultsSnapshot snapshot1;
    private final CPUResultsSnapshot snapshot2;

    public CPUResultsDiff(CPUResultsSnapshot snapshot1, CPUResultsSnapshot snapshot2) {
        this.snapshot1 = snapshot1;
        this.snapshot2 = snapshot2;
    }

    @Override
    public boolean isCollectingTwoTimeStamps() {
        return this.snapshot1.collectingTwoTimeStamps && this.snapshot2.collectingTwoTimeStamps;
    }

    @Override
    public CPUCCTContainer getContainerForThread(int threadId, int view) {
        return this.snapshot1.getContainerForThread(threadId, view);
    }

    @Override
    public DiffFlatProfileContainer getFlatProfile(int threadId, int view) {
        FlatProfileContainer fpc1 = this.snapshot1.getFlatProfile(threadId, view);
        FlatProfileContainer fpc2 = this.snapshot2.getFlatProfile(threadId, view);
        return DiffFlatProfileContainer.create(fpc1, fpc2);
    }

    @Override
    public String[] getInstrMethodClasses(int view) {
        return this.snapshot1.getInstrMethodClasses(view);
    }

    @Override
    public String[] getInstrMethodNames() {
        return this.snapshot1.getInstrMethodNames();
    }

    @Override
    public String[] getInstrMethodSignatures() {
        return this.snapshot1.getInstrMethodSignatures();
    }

    @Override
    public String[] getMethodClassNameAndSig(int methodId, int view) {
        return methodId < 0 ? this.snapshot2.getMethodClassNameAndSig(-methodId, view) : this.snapshot1.getMethodClassNameAndSig(methodId, view);
    }

    @Override
    public int getNInstrMethods() {
        return this.snapshot1.getNInstrMethods();
    }

    @Override
    public int getNThreads() {
        return this.snapshot1.getNThreads();
    }

    @Override
    public PrestimeCPUCCTNode getReverseCCT(int threadId, int methodId, int view) {
        return null;
    }

    @Override
    public PrestimeCPUCCTNode getRootNode(int view) {
        PrestimeCPUCCTNodeBacked root1 = (PrestimeCPUCCTNodeBacked)this.snapshot1.getRootNode(view);
        PrestimeCPUCCTNodeBacked root2 = (PrestimeCPUCCTNodeBacked)this.snapshot2.getRootNode(view);
        return new DiffCPUCCTNode(root1, root2);
    }

    public long getBound(int view) {
        CCTNode[] children;
        long bound = Long.MIN_VALUE;
        PrestimeCPUCCTNode root = this.getRootNode(view);
        for (CCTNode child : children = root.getChildren()) {
            bound = Math.max(bound, Math.abs(((PrestimeCPUCCTNode)child).getTotalTime0()));
        }
        return bound;
    }

    @Override
    public void filterForward(String filter, int filterType, PrestimeCPUCCTNodeBacked root) {
        PrestimeCPUCCTNodeBacked node2;
        PrestimeCPUCCTNodeBacked node1 = ((DiffCPUCCTNode)root).node1;
        if (node1 != null) {
            this.snapshot1.filterForward(filter, filterType, node1);
        }
        if ((node2 = ((DiffCPUCCTNode)root).node2) != null) {
            this.snapshot2.filterForward(filter, filterType, node2);
        }
        super.filterForward(filter, filterType, root);
    }

    @Override
    public void saveSortParams(int sortBy, boolean sortOrder, CCTNode node) {
        PrestimeCPUCCTNodeBacked node2;
        PrestimeCPUCCTNodeBacked node1 = ((DiffCPUCCTNode)node).node1;
        if (node1 != null) {
            this.snapshot1.saveSortParams(sortBy, sortOrder, node1);
        }
        if ((node2 = ((DiffCPUCCTNode)node).node2) != null) {
            this.snapshot2.saveSortParams(sortBy, sortOrder, node2);
        }
        super.saveSortParams(sortBy, sortOrder, node);
    }

    @Override
    public int[] getThreadIds() {
        return this.snapshot1.getThreadIds();
    }

    @Override
    public String getThreadNameForId(int threadId) {
        return this.snapshot1.getThreadNameForId(threadId);
    }

    @Override
    public String[] getThreadNames() {
        return this.snapshot1.getThreadNames();
    }
}

