/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.lib.profiler.heap;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.netbeans.lib.profiler.heap.ClassDump;
import org.netbeans.lib.profiler.heap.HprofHeap;
import org.netbeans.lib.profiler.heap.Instance;
import org.netbeans.lib.profiler.heap.JavaClass;
import org.netbeans.lib.profiler.heap.LongBuffer;
import org.netbeans.lib.profiler.heap.LongMap;
import org.netbeans.lib.profiler.heap.ObjectFieldValue;

class DominatorTree {
    private static final int BUFFER_SIZE = 8192;
    private static final int ADDITIONAL_IDS_THRESHOLD = 30;
    private HprofHeap heap;
    private LongBuffer multipleParents;
    private LongBuffer revertedMultipleParents;
    private LongBuffer currentMultipleParents;
    private Map<Long, Long> map;
    private Set dirtySet = Collections.EMPTY_SET;
    private Map canContainItself;
    private Map nearestGCRootCache = new NearestGCRootCache(400000);

    DominatorTree(HprofHeap h, LongBuffer multiParents) {
        this.heap = h;
        this.currentMultipleParents = this.multipleParents = multiParents;
        this.map = new HashMap<Long, Long>(multiParents.getSize());
        try {
            this.revertedMultipleParents = multiParents.revertBuffer();
        }
        catch (IOException ex) {
            throw new IllegalArgumentException(ex.getLocalizedMessage(), ex);
        }
    }

    synchronized void computeDominators() {
        boolean changed = true;
        try {
            boolean igonoreDirty;
            do {
                this.currentMultipleParents.rewind();
                igonoreDirty = !changed;
                changed = this.computeOneLevel(igonoreDirty);
                this.switchParents();
            } while (changed || !igonoreDirty);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        this.deleteBuffers();
        this.dirtySet = Collections.EMPTY_SET;
    }

    private boolean computeOneLevel(boolean ignoreDirty) throws IOException {
        boolean changed = false;
        HashSet<Long> newDirtySet = new HashSet<Long>(this.map.size() / 10);
        ArrayList<Long> additionalIds = new ArrayList<Long>();
        int additionalIndex = 0;
        while (true) {
            Long instanceIdObj;
            Long oldIdomObj;
            long instanceId;
            if ((instanceId = this.readLong()) == 0L) {
                if (additionalIndex >= additionalIds.size()) {
                    if (additionalIndex <= 0) break;
                    break;
                }
                instanceId = (Long)additionalIds.get(additionalIndex++);
            }
            if ((oldIdomObj = this.map.get(instanceIdObj = new Long(instanceId))) != null && (oldIdomObj == 0L || !ignoreDirty && !this.dirtySet.contains(oldIdomObj) && !this.dirtySet.contains(instanceIdObj))) continue;
            LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceId);
            List refs = entry.getReferences();
            Iterator refIt = refs.iterator();
            Long newIdomIdObj = (Long)refIt.next();
            boolean dirty = false;
            while (refIt.hasNext() && newIdomIdObj != 0L) {
                Long refIdObj = (Long)refIt.next();
                newIdomIdObj = this.intersect(newIdomIdObj, refIdObj);
            }
            if (oldIdomObj == null) {
                this.map.put(instanceIdObj, newIdomIdObj);
                newDirtySet.add(newIdomIdObj);
                changed = true;
                continue;
            }
            if (oldIdomObj.longValue() == newIdomIdObj.longValue()) continue;
            newDirtySet.add(oldIdomObj);
            newDirtySet.add(newIdomIdObj);
            this.map.put(instanceIdObj, newIdomIdObj);
            if (this.dirtySet.size() < 30) {
                this.updateAdditionalIds(instanceId, additionalIds);
            }
            changed = true;
        }
        this.dirtySet = newDirtySet;
        return changed;
    }

    private void updateAdditionalIds(long instanceId, List<Long> additionalIds) {
        Instance i = this.heap.getInstanceByID(instanceId);
        if (i != null) {
            for (Object v : i.getFieldValues()) {
                long idp;
                Long idO;
                Long idomO;
                Instance val;
                if (!(v instanceof ObjectFieldValue) || (val = ((ObjectFieldValue)v).getInstance()) == null || (idomO = this.map.get(idO = new Long(idp = val.getInstanceId()))) == null || idomO == 0L) continue;
                additionalIds.add(idO);
            }
        }
    }

    private void deleteBuffers() {
        this.multipleParents.delete();
        this.revertedMultipleParents.delete();
    }

    private long readLong() throws IOException {
        return this.currentMultipleParents.readLong();
    }

    long getIdomId(long instanceId, LongMap.Entry entry) {
        Long idomEntry = this.map.get(new Long(instanceId));
        if (idomEntry != null) {
            return idomEntry;
        }
        if (entry == null) {
            entry = this.heap.idToOffsetMap.get(instanceId);
        }
        return entry.getNearestGCRootPointer();
    }

    boolean hasInstanceInChain(int tag, Instance i) {
        if (tag == 35) {
            return false;
        }
        ClassDump javaClass = (ClassDump)i.getJavaClass();
        if (this.canContainItself == null) {
            this.canContainItself = new HashMap(this.heap.getAllClasses().size() / 2);
        }
        if (tag == 33) {
            Boolean canContain = (Boolean)this.canContainItself.get(javaClass);
            if (canContain == null) {
                canContain = javaClass.canContainItself();
                this.canContainItself.put(javaClass, canContain);
            }
            if (!canContain.booleanValue()) {
                return false;
            }
        }
        long instanceId = i.getInstanceId();
        long idom = this.getIdomId(instanceId);
        while (idom != 0L) {
            Instance ip = this.heap.getInstanceByID(idom);
            JavaClass cls = ip.getJavaClass();
            if (javaClass.equals(cls)) {
                return true;
            }
            idom = this.getIdomId(idom);
        }
        return false;
    }

    private Long getNearestGCRootPointer(Long instanceIdLong) {
        Long nearestGCLong = (Long)this.nearestGCRootCache.get(instanceIdLong);
        if (nearestGCLong != null) {
            return nearestGCLong;
        }
        LongMap.Entry entry = this.heap.idToOffsetMap.get(instanceIdLong);
        Long nearestGC = entry.getNearestGCRootPointer();
        this.nearestGCRootCache.put(instanceIdLong, nearestGC);
        return nearestGC;
    }

    private Long getIdomId(Long instanceIdLong) {
        Long idomObj = this.map.get(instanceIdLong);
        if (idomObj != null) {
            return idomObj;
        }
        return this.getNearestGCRootPointer(instanceIdLong);
    }

    private Long intersect(Long idomIdObj, Long refIdObj) {
        if (idomIdObj.longValue() == refIdObj.longValue()) {
            return idomIdObj;
        }
        if (idomIdObj == 0L || refIdObj == 0L) {
            return 0L;
        }
        HashSet<Long> leftIdoms = new HashSet<Long>(200);
        HashSet<Long> rightIdoms = new HashSet<Long>(200);
        Long leftIdomObj = idomIdObj;
        Long rightIdomObj = refIdObj;
        leftIdoms.add(leftIdomObj);
        rightIdoms.add(rightIdomObj);
        while (true) {
            if (leftIdomObj != 0L) {
                if (rightIdoms.contains(leftIdomObj = this.getIdomId(leftIdomObj))) {
                    return leftIdomObj;
                }
                leftIdoms.add(leftIdomObj);
            }
            if (rightIdomObj == 0L) continue;
            if (leftIdoms.contains(rightIdomObj = this.getIdomId(rightIdomObj))) {
                return rightIdomObj;
            }
            rightIdoms.add(rightIdomObj);
        }
    }

    private void switchParents() {
        this.currentMultipleParents = this.currentMultipleParents == this.revertedMultipleParents ? this.multipleParents : this.revertedMultipleParents;
    }

    private void printObjs(List<Long> changedIds, List<Long> oldDomIds, List<Long> newDomIds, List<Boolean> addedByDirtySet, List<Long> changedIdx) {
        if (changedIds.size() > 20) {
            return;
        }
        TreeMap<Integer, String> m = new TreeMap<Integer, String>();
        for (int i = 0; i < changedIds.size(); ++i) {
            Long iid = changedIds.get(i);
            Long oldDom = oldDomIds.get(i);
            Long newDom = newDomIds.get(i);
            Long index = changedIdx.get(i);
            Boolean addedByDirt = addedByDirtySet.get(i);
            Instance ii = this.heap.getInstanceByID(iid);
            int number = ii.getInstanceNumber();
            String text = "Index: " + index + (addedByDirt != false ? " New " : " Old ") + this.printInstance(iid);
            text = text + " OldDom " + this.printInstance(oldDom);
            text = text + " NewDom: " + this.printInstance(newDom);
            m.put(number, text);
        }
        for (Integer in : m.keySet()) {
            System.out.println((String)m.get(in));
        }
    }

    String printInstance(Long instanceid) {
        if (instanceid == null || instanceid == 0L) {
            return "null";
        }
        Instance ii = this.heap.getInstanceByID(instanceid);
        return ii.getJavaClass().getName() + "#" + ii.getInstanceNumber();
    }

    private static final class NearestGCRootCache
    extends LinkedHashMap {
        private final int maxSize;

        private NearestGCRootCache(int size) {
            super(size, 0.75f, true);
            this.maxSize = size;
        }

        protected boolean removeEldestEntry(Map.Entry eldest) {
            return this.size() > this.maxSize;
        }
    }
}

