/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.source;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.Collection;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.StyledDocument;
import org.netbeans.api.lexer.InputAttributes;
import org.netbeans.api.lexer.Language;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.cnd.api.lexer.CndLexerUtilities;
import org.netbeans.cnd.api.lexer.CppTokenId;
import org.netbeans.cnd.api.lexer.Filter;
import org.netbeans.cnd.api.lexer.FortranTokenId;
import org.netbeans.core.api.multiview.MultiViews;
import org.netbeans.modules.cnd.source.SourceDataObject;
import org.netbeans.modules.cnd.source.spi.CndPaneProvider;
import org.netbeans.modules.cnd.source.spi.CndSourcePropertiesProvider;
import org.netbeans.modules.cnd.support.ReadOnlySupport;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.spi.editor.guards.GuardedEditorSupport;
import org.netbeans.spi.editor.guards.GuardedSectionsFactory;
import org.netbeans.spi.editor.guards.GuardedSectionsProvider;
import org.openide.awt.UndoRedo;
import org.openide.cookies.CloseCookie;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.PrintCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.loaders.DataObject;
import org.openide.loaders.MultiDataObject;
import org.openide.nodes.Node;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.InstanceContent;
import org.openide.util.lookup.Lookups;
import org.openide.windows.CloneableOpenSupport;

public class CppEditorSupport
extends DataEditorSupport
implements EditCookie,
EditorCookie,
EditorCookie.Observable,
OpenCookie,
CloseCookie,
PrintCookie,
ReadOnlySupport {
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            CppEditorSupport.this.saveDocument();
            CppEditorSupport.this.getDataObject().setModified(false);
        }

        public String toString() {
            return CppEditorSupport.this.getDataObject().getPrimaryFile().getNameExt();
        }
    };
    private final InstanceContent ic;
    private boolean readonly;
    private static final String EXTRA_DOCUMENT_PROPERTIES = "EXTRA_DOCUMENT_PROPERTIES";

    public CppEditorSupport(SourceDataObject obj, Node nodeDelegate) {
        super((DataObject)obj, null, (CloneableEditorSupport.Env)new Environment((DataObject)obj));
        this.ic = obj.getInstanceContent();
        if (nodeDelegate != null) {
            this.ic.add((Object)nodeDelegate);
        }
    }

    protected boolean notifyModified() {
        if (!super.notifyModified()) {
            return false;
        }
        this.addSaveCookie();
        return true;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        this.removeSaveCookie();
    }

    protected boolean asynchronousOpen() {
        return true;
    }

    private void addSaveCookie() {
        this.ic.add((Object)this.saveCookie);
    }

    private void removeSaveCookie() {
        this.ic.remove((Object)this.saveCookie);
    }

    public boolean isReadOnly() {
        return this.readonly;
    }

    public void setReadOnly(boolean readOnly) {
        this.readonly = readOnly;
    }

    UndoRedo.Manager getUndoRedoImpl() {
        return super.getUndoRedo();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadFromStreamToKit(StyledDocument doc, InputStream stream, EditorKit kit) throws IOException, BadLocationException {
        DataObject dao = this.getDataObject();
        FileObject fo = dao.getPrimaryFile();
        boolean resetLS = true;
        if (CndFileUtils.isLocalFileSystem((FileSystem)fo.getFileSystem())) {
            resetLS = false;
        } else {
            int ch;
            InputStream in = fo.getInputStream();
            block6: while ((ch = in.read()) != -1) {
                switch (ch) {
                    case 10: 
                    case 13: {
                        resetLS = false;
                        break block6;
                    }
                    default: {
                        continue block6;
                    }
                }
            }
            in.close();
        }
        GuardedSectionsProvider guardedProvider = this.getGuardedSectionsProvider(doc, kit);
        if (guardedProvider == null) {
            super.loadFromStreamToKit(doc, stream, kit);
        } else {
            Charset cs = FileEncodingQuery.getEncoding((FileObject)fo);
            Reader reader = guardedProvider.createGuardedReader(stream, cs);
            try {
                kit.read(reader, (Document)doc, 0);
            }
            finally {
                reader.close();
            }
        }
        if (resetLS) {
            doc.putProperty("__EndOfLine__", "\n");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveFromKitToStream(StyledDocument doc, EditorKit kit, OutputStream stream) throws IOException, BadLocationException {
        GuardedSectionsProvider guardedProvider = this.getGuardedSectionsProvider(doc, kit);
        if (guardedProvider != null) {
            Charset cs = FileEncodingQuery.getEncoding((FileObject)this.getDataObject().getPrimaryFile());
            Writer writer = guardedProvider.createGuardedWriter(stream, cs);
            try {
                kit.write(writer, (Document)doc, 0, doc.getLength());
            }
            finally {
                writer.close();
            }
        } else {
            super.saveFromKitToStream(doc, kit, stream);
        }
    }

    private StyledDocument setupSlowDocumentProperties(StyledDocument doc) {
        assert (!SwingUtilities.isEventDispatchThread());
        if (doc != null && !Boolean.TRUE.equals(doc.getProperty(EXTRA_DOCUMENT_PROPERTIES))) {
            Language language = (Language)doc.getProperty(Language.class);
            assert (language != null) : "no language for " + doc;
            if (language != null) {
                InputAttributes lexerAttrs = (InputAttributes)doc.getProperty(InputAttributes.class);
                assert (lexerAttrs != null) : "no language attributes for " + doc;
                if (lexerAttrs == null) {
                    lexerAttrs = new InputAttributes();
                    doc.putProperty(InputAttributes.class, lexerAttrs);
                }
                Filter<?> filter = CppEditorSupport.getDefaultFilter(language, doc);
                assert (filter != null) : "no language filter for " + doc + " with language " + language;
                if (filter != null) {
                    lexerAttrs.setValue(language, (Object)"lexer-filter", filter, true);
                }
            }
            PropertiesProviders.addProperty(this.getDataObject(), doc);
            doc.putProperty(EXTRA_DOCUMENT_PROPERTIES, Boolean.TRUE);
        }
        return doc;
    }

    private static Filter<?> getDefaultFilter(Language<?> language, Document doc) {
        if (language == CppTokenId.languageHeader()) {
            return CndLexerUtilities.getHeaderCppFilter();
        }
        if (language == CppTokenId.languageC()) {
            return CndLexerUtilities.getGccCFilter();
        }
        if (language == CppTokenId.languagePreproc()) {
            return CndLexerUtilities.getPreprocFilter();
        }
        if (language == FortranTokenId.languageFortran()) {
            return CndLexerUtilities.getFortranFilter();
        }
        if (language == CppTokenId.languageCpp()) {
            return CndLexerUtilities.getGccCppFilter();
        }
        return null;
    }

    private GuardedSectionsProvider getGuardedSectionsProvider(StyledDocument doc, EditorKit kit) {
        GuardedSectionsFactory gsf;
        Object o = doc.getProperty(GuardedSectionsProvider.class);
        if (o instanceof GuardedSectionsProvider) {
            return (GuardedSectionsProvider)o;
        }
        String mimeType = kit.getContentType();
        CndUtils.assertTrueInConsole((mimeType != null ? 1 : 0) != 0, (String)"unexpected null content type");
        if (mimeType != null && (gsf = GuardedSectionsFactory.find((String)mimeType)) != null) {
            GuardedSectionsProvider gsp = gsf.create((GuardedEditorSupport)new GuardedEditorSupportImpl(doc));
            doc.putProperty(GuardedSectionsProvider.class, gsp);
            return gsp;
        }
        return null;
    }

    protected String documentID() {
        DataObject dataObject = this.getDataObject();
        if (dataObject != null && dataObject.isValid()) {
            return dataObject.getPrimaryFile().getNameExt();
        }
        return "";
    }

    protected CloneableEditorSupport.Pane createPane() {
        CloneableEditorSupport.Pane pane;
        CndPaneProvider paneProvider = (CndPaneProvider)Lookup.getDefault().lookup(CndPaneProvider.class);
        if (paneProvider != null && (pane = paneProvider.createPane(this)) != null) {
            return pane;
        }
        return (CloneableEditorSupport.Pane)MultiViews.createCloneableMultiView((String)this.getDataObject().getPrimaryFile().getMIMEType(), (Serializable)this.getDataObject());
    }

    protected StyledDocument createStyledDocument(EditorKit kit) {
        StyledDocument doc = super.createStyledDocument(kit);
        if (!SwingUtilities.isEventDispatchThread()) {
            this.setupSlowDocumentProperties(doc);
        }
        return doc;
    }

    public Task prepareDocument() {
        Task task = super.prepareDocument();
        if (!SwingUtilities.isEventDispatchThread()) {
            this.setupSlowDocumentProperties(super.getDocument());
        }
        return task;
    }

    private static class Environment
    extends DataEditorSupport.Env {
        private static final long serialVersionUID = 3035543168452715818L;

        public Environment(DataObject obj) {
            super(obj);
        }

        protected FileObject getFile() {
            return this.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            ReadOnlySupport readOnly = (ReadOnlySupport)this.getDataObject().getLookup().lookup(ReadOnlySupport.class);
            if (readOnly != null && readOnly.isReadOnly()) {
                throw new IOException();
            }
            return ((MultiDataObject)this.getDataObject()).getPrimaryEntry().takeLock();
        }

        public CloneableOpenSupport findCloneableOpenSupport() {
            return (CloneableOpenSupport)this.getDataObject().getLookup().lookup(CppEditorSupport.class);
        }
    }

    private static class GuardedEditorSupportImpl
    implements GuardedEditorSupport {
        private final StyledDocument doc;

        public GuardedEditorSupportImpl(StyledDocument doc) {
            this.doc = doc;
        }

        public StyledDocument getDocument() {
            return this.doc;
        }
    }

    private static final class PropertiesProviders {
        private static final Collection<? extends CndSourcePropertiesProvider> providers = Lookups.forPath((String)"CND/CndSourcePropertiesProvider").lookupAll(CndSourcePropertiesProvider.class);

        private PropertiesProviders() {
        }

        static void addProperty(DataObject dobj, StyledDocument doc) {
            assert (!SwingUtilities.isEventDispatchThread());
            for (CndSourcePropertiesProvider cndSourcePropertiesProvider : providers) {
                cndSourcePropertiesProvider.addProperty(dobj, doc);
            }
        }
    }
}

