/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractButton;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SourceFoldersDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileObjectFilter;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.CndUIUtilities;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class SourceFilesPanel
extends JPanel {
    private final Color defaultTextFieldFg;
    private List<FolderEntry> sourceData = new ArrayList<FolderEntry>();
    private List<FolderEntry> testData = new ArrayList<FolderEntry>();
    private SourceFileTable sourceFileTable = null;
    private SourceFileTable testFileTable = null;
    private String baseDir;
    private String wd;
    private final SourceFoldersDescriptorPanel controller;
    private final Project project;
    private String lastSelectedPath;
    private JButton addButton;
    private JButton deleteButton;
    private JLabel excludePatternLabel;
    private JTextField excludePatternTextField;
    private JList list;
    private JScrollPane scrollPane;
    private JLabel seeAlsoLabel;
    private JLabel sourceFilesLabel;

    public SourceFilesPanel(Project project) {
        this.controller = null;
        this.project = project;
        this.initComponents();
        this.defaultTextFieldFg = this.excludePatternTextField.getForeground();
        this.init();
    }

    SourceFilesPanel(SourceFoldersDescriptorPanel controller) {
        this.controller = controller;
        this.project = null;
        this.initComponents();
        this.defaultTextFieldFg = this.excludePatternTextField.getForeground();
        this.init();
    }

    private void init() {
        this.scrollPane.getViewport().setBackground(Color.WHITE);
        this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFilesPanelAD"));
        this.addButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("AddButtonAD"));
        this.deleteButton.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("DeleteButtonAD"));
        this.refresh();
        this.initFocus();
        this.excludePatternTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                SourceFilesPanel.this.update();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                SourceFilesPanel.this.update();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                SourceFilesPanel.this.update();
            }
        });
    }

    private void update() {
        String excludeStr = this.excludePatternTextField.getText();
        try {
            Pattern.compile(excludeStr);
            this.excludePatternTextField.setForeground(this.defaultTextFieldFg);
        }
        catch (PatternSyntaxException ex) {
            this.excludePatternTextField.setForeground(Color.RED);
        }
        if (this.controller != null) {
            this.controller.stateChanged(null);
        }
    }

    public void setSeed(String baseDir, String wd) {
        this.baseDir = baseDir;
        this.wd = wd;
    }

    public void setFoldersFilter(String regex) {
        this.excludePatternTextField.setText(regex);
    }

    public String getFoldersFilter() {
        return this.excludePatternTextField.getText();
    }

    public FileObjectFilter getFileFilter() {
        Pattern excludePattern = null;
        String excludeStr = this.excludePatternTextField.getText().trim();
        if (!excludeStr.isEmpty()) {
            try {
                excludePattern = Pattern.compile(excludeStr.trim());
            }
            catch (PatternSyntaxException patternSyntaxException) {
                // empty catch block
            }
        }
        if (excludePattern == null) {
            excludePattern = Pattern.compile("^$");
        }
        return new RegexpExcludeFileFilter(excludePattern);
    }

    public final void initFocus() {
        CndUIUtilities.requestFocus((Component)this.addButton);
    }

    public List<FolderEntry> getSourceListData() {
        return this.sourceData;
    }

    public List<FolderEntry> getTestListData() {
        return this.testData;
    }

    private void validateSelection() {
        this.addButton.setEnabled(true);
        if (this.sourceData.isEmpty() || this.sourceFileTable.getSelectedRow() < 0) {
            this.deleteButton.setEnabled(false);
        } else {
            this.deleteButton.setEnabled(true);
        }
    }

    private void refresh() {
        this.sourceFileTable = new SourceFileTable(this.sourceData, SourceFilesPanel.getString("TABLE_COLUMN_SOURCE_TXT"));
        this.scrollPane.setViewportView(this.sourceFileTable);
        this.sourceFilesLabel.setLabelFor(this.sourceFileTable);
        this.validateSelection();
    }

    private void initComponents() {
        this.sourceFilesLabel = new JLabel();
        this.scrollPane = new JScrollPane();
        this.list = new JList();
        this.addButton = new JButton();
        this.deleteButton = new JButton();
        this.excludePatternLabel = new JLabel();
        this.excludePatternTextField = new JTextField();
        this.seeAlsoLabel = new JLabel();
        this.setPreferredSize(new Dimension(450, 350));
        this.sourceFilesLabel.setLabelFor(this.list);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.sourceFilesLabel, (String)bundle.getString("SourceFileFoldersLbl"));
        this.scrollPane.setViewportView(this.list);
        Mnemonics.setLocalizedText((AbstractButton)this.addButton, (String)bundle.getString("AddButtonTxt"));
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFilesPanel.this.addButtonActionPerformed(evt);
            }
        });
        Mnemonics.setLocalizedText((AbstractButton)this.deleteButton, (String)bundle.getString("DeleteButtonTxt"));
        this.deleteButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SourceFilesPanel.this.deleteButtonActionPerformed(evt);
            }
        });
        this.excludePatternLabel.setLabelFor(this.excludePatternTextField);
        Mnemonics.setLocalizedText((JLabel)this.excludePatternLabel, (String)NbBundle.getMessage(SourceFilesPanel.class, (String)"SourceFilesPanel.excludePatternLabel.text"));
        this.seeAlsoLabel.setText(NbBundle.getMessage(SourceFilesPanel.class, (String)"SourceFilesPanel.seeAlsoLabel.text"));
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.excludePatternLabel).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.scrollPane, -1, 341, Short.MAX_VALUE).addComponent(this.excludePatternTextField, GroupLayout.Alignment.TRAILING, -1, 341, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.deleteButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE).addComponent(this.addButton, GroupLayout.Alignment.TRAILING, -1, -1, Short.MAX_VALUE))).addGroup(layout.createSequentialGroup().addComponent(this.seeAlsoLabel).addContainerGap(104, Short.MAX_VALUE)).addGroup(layout.createSequentialGroup().addComponent(this.sourceFilesLabel).addContainerGap(97, Short.MAX_VALUE)));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.sourceFilesLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.addButton).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.deleteButton)).addComponent(this.scrollPane, -1, 240, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.excludePatternLabel).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.excludePatternTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.seeAlsoLabel).addContainerGap()));
    }

    private void deleteFile(List<FolderEntry> data, SourceFileTable table) {
        int index = table.getSelectedRow();
        if (index < 0 || index >= data.size()) {
            return;
        }
        data.remove(index);
        this.refresh();
        if (data.size() > 0) {
            if (data.size() > index) {
                table.getSelectionModel().setSelectionInterval(index, index);
            } else {
                table.getSelectionModel().setSelectionInterval(index - 1, index - 1);
            }
        }
    }

    private void deleteButtonActionPerformed(ActionEvent evt) {
        this.deleteFile(this.sourceData, this.sourceFileTable);
    }

    private void addFile(List<FolderEntry> data) {
        String seed = null;
        if (this.lastSelectedPath != null) {
            seed = this.lastSelectedPath;
        }
        if (seed == null) {
            if (this.wd != null && this.wd.length() > 0 && !CndPathUtilitities.isPathAbsolute((CharSequence)this.wd)) {
                seed = this.baseDir + File.separator + this.wd;
            } else if (this.wd != null) {
                seed = this.wd;
            } else if (this.baseDir != null) {
                seed = this.baseDir;
            } else if (this.controller != null) {
                seed = (String)this.controller.getWizardDescriptor().getProperty("nativeProjDir");
            }
        }
        String title = SourceFilesPanel.getString("FOLDER_CHOOSER_TITLE_TXT");
        String buttonText = SourceFilesPanel.getString("FOLDER_CHOOSER_BUTTON_TXT");
        JFileChooser fileChooser = this.project != null ? NewProjectWizardUtils.createFileChooser(this.project, title, buttonText, 1, null, seed, true) : NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), title, buttonText, 1, null, seed, true);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        if (!fileChooser.getSelectedFile().exists() || !fileChooser.getSelectedFile().isDirectory()) {
            return;
        }
        File file = fileChooser.getSelectedFile();
        this.lastSelectedPath = file.getAbsolutePath();
        FileObject fo = CndFileUtils.toFileObject((File)file);
        data.add(new FolderEntry(fo, CndPathUtilitities.toAbsoluteOrRelativePath((String)this.baseDir, (String)fileChooser.getSelectedFile().getPath())));
        this.refresh();
    }

    private void addButtonActionPerformed(ActionEvent evt) {
        this.addFile(this.sourceData);
    }

    private static String getString(String s) {
        return NbBundle.getMessage(SourceFilesPanel.class, (String)s);
    }

    private final class MyTableModel
    extends DefaultTableModel {
        private List<FolderEntry> data;
        private String columnTitle;

        public MyTableModel(List<FolderEntry> data, String columnTitle) {
            this.data = data;
            this.columnTitle = columnTitle;
        }

        @Override
        public String getColumnName(int col) {
            return " " + this.columnTitle;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            if (this.data == null) {
                return 0;
            }
            return this.data.size();
        }

        @Override
        public Object getValueAt(int row, int col) {
            if (this.data == null) {
                return null;
            }
            return this.data.get(row).getFolderName();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return false;
        }
    }

    private final class SourceFileTable
    extends JTable {
        public SourceFileTable(List<FolderEntry> data, String columnTitle) {
            this.setModel(new MyTableModel(data, columnTitle));
            ((DefaultTableCellRenderer)this.getTableHeader().getDefaultRenderer()).setHorizontalAlignment(2);
            this.getSelectionModel().setSelectionMode(0);
            this.getSelectionModel().addListSelectionListener(new TargetSelectionListener());
            this.getAccessibleContext().setAccessibleDescription(SourceFilesPanel.getString("SourceFileTableAD"));
        }

        @Override
        public boolean getShowHorizontalLines() {
            return false;
        }

        @Override
        public boolean getShowVerticalLines() {
            return false;
        }
    }

    private static final class RegexpExcludeFileFilter
    implements FileObjectFilter {
        private final Pattern excludePattern;

        public RegexpExcludeFileFilter(Pattern excludeFilter) {
            this.excludePattern = excludeFilter;
        }

        public boolean accept(FileObject pathname) {
            return !this.excludePattern.matcher(pathname.getNameExt()).find();
        }
    }

    private class TargetSelectionListener
    implements ListSelectionListener {
        private TargetSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent e) {
            if (e.getValueIsAdjusting()) {
                return;
            }
            SourceFilesPanel.this.validateSelection();
        }
    }
}

