/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.text.html.HTMLEditorKit;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.ui.ToolsCacheManager;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModeDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.cnd.utils.ui.EditableComboBox;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;
import org.openide.util.RequestProcessor;

public class SelectModePanel
extends JPanel {
    private final SelectModeDescriptorPanel controller;
    private volatile boolean initialized = false;
    private static final String SOURCES_FILE_KEY = "sourcesField";
    private ExecutionEnvironment env;
    private FileSystem fileSystem;
    private static final RequestProcessor RP = new RequestProcessor("SelectModePanel", 1);
    private static final byte noMessage = 0;
    private static final byte notFolder = 1;
    private static final byte cannotReadFolder = 2;
    private static final byte cannotWriteFolder = 3;
    private static final byte alreadyNbPoject = 4;
    private static final byte notFoundMakeAndConfigure = 5;
    private static final byte notRoot = 6;
    private byte messageKind = 0;
    private JRadioButton advancedMode;
    private ButtonGroup buttonGroup1;
    private JComboBox hostComboBox;
    private JLabel hostLabel;
    private JPanel instructionPanel;
    private JTextPane instructions;
    private JScrollPane jScrollPane1;
    private JLabel modeLabel;
    private JRadioButton simpleMode;
    private JButton sourceBrowseButton;
    private JComboBox sourceFolder;
    private JLabel sourceFolderLabel;
    private JComboBox toolchainComboBox;
    private JLabel toolchainLabel;

    public SelectModePanel(SelectModeDescriptorPanel controller) {
        this.controller = controller;
        this.initComponents();
        this.instructions.setEditorKit(new HTMLEditorKit());
        this.instructions.setBackground(this.instructionPanel.getBackground());
        this.disableHostSensitiveComponents();
        this.addListeners();
    }

    private void addListeners() {
        ((EditableComboBox)this.sourceFolder).addChangeListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String path = ((EditableComboBox)SelectModePanel.this.sourceFolder).getText();
                FileObject fileObject = path.isEmpty() ? null : SelectModePanel.this.fileSystem.findResource(path);
                SelectModePanel.this.controller.getWizardStorage().setSourcesFileObject(fileObject);
                SelectModePanel.this.updateInstruction();
            }
        });
        this.simpleMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.advancedMode.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SelectModePanel.this.controller.getWizardStorage().setMode(SelectModePanel.this.simpleMode.isSelected());
                SelectModePanel.this.updateInstruction();
            }
        });
        this.updateInstruction();
    }

    private void updateInstruction() {
        if (this.simpleMode.isSelected()) {
            String tool = "Makefile";
            String toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Make");
            if (this.controller.getWizardStorage() != null) {
                String configure = this.controller.getWizardStorage().getConfigure();
                if (configure != null) {
                    toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_Configure");
                    tool = configure;
                    String normalizedPath = CndFileUtils.normalizeAbsolutePath((String)configure);
                    FileObject fo = CndFileUtils.toFileObject((CharSequence)normalizedPath);
                    if (fo != null && fo.isValid()) {
                        String mimeType = fo.getMIMEType();
                        if ("text/x-cmake".equals(mimeType)) {
                            toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_CMake");
                            tool = "cmake";
                        } else if ("text/x-qtproject".equals(mimeType)) {
                            toolsInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionExtraText_QMake");
                            tool = "qmake";
                        }
                    }
                } else {
                    String makefile = this.controller.getWizardStorage().getMake();
                    if (makefile != null) {
                        tool = makefile;
                    }
                }
            }
            String modeInfo = NbBundle.getMessage(SelectModePanel.class, (String)"SimpleModeButtonText", (Object)tool);
            Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)modeInfo);
            this.instructions.setText(NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeSimpleInstructionText", (Object)toolsInfo));
        } else {
            this.instructions.setText(NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeAdvancedInstructionText"));
        }
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.instructionPanel = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.instructions = new JTextPane();
        this.simpleMode = new JRadioButton();
        this.advancedMode = new JRadioButton();
        this.modeLabel = new JLabel();
        this.toolchainComboBox = new JComboBox();
        this.toolchainLabel = new JLabel();
        this.hostComboBox = new JComboBox();
        this.hostLabel = new JLabel();
        this.sourceFolderLabel = new JLabel();
        this.sourceBrowseButton = new JButton();
        this.sourceFolder = new EditableComboBox();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.instructionPanel.setLayout(new BorderLayout());
        this.jScrollPane1.setBorder(null);
        this.jScrollPane1.setPreferredSize(new Dimension(200, 200));
        this.instructions.setBorder(null);
        this.instructions.setEditable(false);
        this.instructions.setFocusable(false);
        this.instructions.setOpaque(false);
        this.jScrollPane1.setViewportView(this.instructions);
        this.instructionPanel.add((Component)this.jScrollPane1, "Center");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.buttonGroup1.add(this.simpleMode);
        this.simpleMode.setSelected(true);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.simpleMode, (String)bundle.getString("SimpleModeButtonText"));
        this.simpleMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.simpleMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.simpleMode, gridBagConstraints);
        this.buttonGroup1.add(this.advancedMode);
        Mnemonics.setLocalizedText((AbstractButton)this.advancedMode, (String)bundle.getString("AdvancedModeButtonText"));
        this.advancedMode.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.advancedMode.setMargin(new Insets(0, 0, 0, 0));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.advancedMode, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.modeLabel, (String)bundle.getString("SelectModeLabelText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.modeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.toolchainComboBox, gridBagConstraints);
        this.toolchainLabel.setLabelFor(this.toolchainComboBox);
        Mnemonics.setLocalizedText((JLabel)this.toolchainLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_TOOLCHAIN"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.toolchainLabel, gridBagConstraints);
        this.hostComboBox.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent evt) {
                SelectModePanel.this.hostComboBoxItemStateChanged(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.hostComboBox, gridBagConstraints);
        this.hostLabel.setLabelFor(this.hostComboBox);
        Mnemonics.setLocalizedText((JLabel)this.hostLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"LBL_HOST"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 8, 0);
        this.add((Component)this.hostLabel, gridBagConstraints);
        this.sourceFolderLabel.setLabelFor(this.sourceFolder);
        Mnemonics.setLocalizedText((JLabel)this.sourceFolderLabel, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_SOURCES_FOLDER"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceFolderLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.sourceBrowseButton, (String)NbBundle.getMessage(SelectModePanel.class, (String)"SELECT_MODE_BROWSE_PROJECT_FOLDER"));
        this.sourceBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                SelectModePanel.this.sourceBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 0, 0, 4);
        this.add((Component)this.sourceBrowseButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.add((Component)this.sourceFolder, gridBagConstraints);
    }

    private void hostComboBoxItemStateChanged(ItemEvent evt) {
        if (!this.initialized) {
            return;
        }
        if (evt.getStateChange() == 1) {
            ServerRecord newItem = (ServerRecord)evt.getItem();
            PanelProjectLocationVisual.updateToolchains(this.toolchainComboBox, newItem);
            this.controller.fireChangeEvent();
        }
    }

    private void sourceBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = ((EditableComboBox)this.sourceFolder).getText();
        String approveButtonText = NbBundle.getMessage(SelectModePanel.class, (String)"SOURCES_DIR_BUTTON_TXT");
        String title = NbBundle.getMessage(SelectModePanel.class, (String)"SOURCES_DIR_CHOOSER_TITLE_TXT");
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), title, approveButtonText, 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        File selectedFile = fileChooser.getSelectedFile();
        if (selectedFile != null) {
            String path = selectedFile.getPath();
            ((EditableComboBox)this.sourceFolder).setText(path);
        }
    }

    void read(WizardDescriptor wizardDescriptor) {
        this.initialized = false;
        this.updateControls();
        this.env = (ExecutionEnvironment)wizardDescriptor.getProperty("REMOTE_FILE_ENV");
        if (this.env != null) {
            wizardDescriptor.putProperty("hostUID", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.env));
        } else {
            this.env = ExecutionEnvironmentFactory.getLocal();
        }
        this.fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)this.env);
        ((EditableComboBox)this.sourceFolder).setStorage(SOURCES_FILE_KEY, NbPreferences.forModule(SelectModePanel.class));
        String binary = "";
        ((EditableComboBox)this.sourceFolder).read(binary);
        String hostUID = (String)wizardDescriptor.getProperty("hostUID");
        CompilerSet cs = (CompilerSet)wizardDescriptor.getProperty("toolchain");
        boolean isDefaultCompilerSet = Boolean.TRUE.equals(wizardDescriptor.getProperty("toolchainDefault"));
        RP.post((Runnable)new PanelProjectLocationVisual.DevHostsInitializer(hostUID, cs, isDefaultCompilerSet, false, (ToolsCacheManager)wizardDescriptor.getProperty("ToolsCacheManager")){

            @Override
            public void updateComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean isDefaultCompilerSet, boolean enabled) {
                boolean enableHost = enabled;
                if (SelectModePanel.this.controller.isFullRemote()) {
                    enableHost = false;
                }
                SelectModePanel.this.enableHostSensitiveComponents(records, srToSelect, csToSelect, isDefaultCompilerSet, enableHost, enabled);
            }
        });
    }

    void updateControls() {
        this.updateInstruction();
    }

    void enableControls(boolean enable) {
        this.advancedMode.setEnabled(enable);
        this.simpleMode.setEnabled(enable);
    }

    private ExecutionEnvironment getSelectedExecutionEnvironment() {
        Object obj = this.hostComboBox.getSelectedItem();
        if (obj != null && obj instanceof ServerRecord) {
            ServerRecord sr = (ServerRecord)obj;
            return sr.getExecutionEnvironment();
        }
        return ServerList.getDefaultRecord().getExecutionEnvironment();
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.simpleMode.isSelected()) {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        } else {
            wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        wizardDescriptor.putProperty("simpleModeFolder", (Object)((EditableComboBox)this.sourceFolder).getText().trim());
        ((EditableComboBox)this.sourceFolder).setStorage(SOURCES_FILE_KEY, NbPreferences.forModule(SelectModePanel.class));
        ((EditableComboBox)this.sourceFolder).store();
        String folderPath = ((EditableComboBox)this.sourceFolder).getText().trim();
        if (CndPathUtilitities.isPathAbsolute((CharSequence)folderPath)) {
            String normalizeAbsolutePath = RemoteFileUtil.normalizeAbsolutePath((String)folderPath, (ExecutionEnvironment)this.env);
            FSPath path = new FSPath(this.fileSystem, normalizeAbsolutePath);
            wizardDescriptor.putProperty("projdir", (Object)path);
        }
        wizardDescriptor.putProperty("readOnlyToolchain", (Object)Boolean.TRUE);
        ExecutionEnvironment ee = this.getSelectedExecutionEnvironment();
        wizardDescriptor.putProperty("hostUID", (Object)ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ee));
        this.controller.getWizardStorage().setExecutionEnvironment(ee);
        Object tc = this.toolchainComboBox.getSelectedItem();
        if (tc != null && tc instanceof PanelProjectLocationVisual.ToolCollectionItem) {
            PanelProjectLocationVisual.ToolCollectionItem item = (PanelProjectLocationVisual.ToolCollectionItem)tc;
            wizardDescriptor.putProperty("toolchain", (Object)item.getCompilerSet());
            wizardDescriptor.putProperty("toolchainDefault", (Object)item.isDefaultCompilerSet());
            this.controller.getWizardStorage().setCompilerSet(item.getCompilerSet());
            this.controller.getWizardStorage().setDefaultCompilerSet(item.isDefaultCompilerSet());
        }
        wizardDescriptor.putProperty("nativeProjFO", (Object)this.controller.getWizardStorage().getSourcesFileObject());
        FileObject fo = this.controller.getWizardStorage().getSourcesFileObject();
        wizardDescriptor.putProperty("nativeProjDir", (Object)(fo == null ? null : fo.getPath()));
        this.initialized = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    boolean valid() {
        block54: {
            block63: {
                block55: {
                    block52: {
                        block62: {
                            block53: {
                                block50: {
                                    block61: {
                                        block51: {
                                            block48: {
                                                block60: {
                                                    block49: {
                                                        block46: {
                                                            block59: {
                                                                block47: {
                                                                    block44: {
                                                                        block58: {
                                                                            block45: {
                                                                                block42: {
                                                                                    block57: {
                                                                                        block43: {
                                                                                            block40: {
                                                                                                block56: {
                                                                                                    block41: {
                                                                                                        this.messageKind = 0;
                                                                                                        path = ((EditableComboBox)this.sourceFolder).getText().trim();
                                                                                                        if (path.length() != 0) break block40;
                                                                                                        var2_2 = false;
                                                                                                        if (this.messageKind <= 0) break block41;
                                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                                                                                        break block56;
                                                                                                    }
                                                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                                    if (this.simpleMode.isSelected()) {
                                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                                                                                    } else {
                                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                                                                                    }
                                                                                                }
                                                                                                return var2_2;
                                                                                            }
                                                                                            if (CndPathUtilitities.isPathAbsolute((CharSequence)path)) break block42;
                                                                                            this.messageKind = 1;
                                                                                            var2_3 = false;
                                                                                            if (this.messageKind <= 0) break block43;
                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                                                                            break block57;
                                                                                        }
                                                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                                        if (this.simpleMode.isSelected()) {
                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                                                                        } else {
                                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                                                                        }
                                                                                    }
                                                                                    return var2_3;
                                                                                }
                                                                                projectDirFO = this.fileSystem.findResource(path);
                                                                                if (projectDirFO != null && projectDirFO.isValid()) break block44;
                                                                                this.messageKind = 1;
                                                                                var3_6 = false;
                                                                                if (this.messageKind <= 0) break block45;
                                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                                                                break block58;
                                                                            }
                                                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                            if (this.simpleMode.isSelected()) {
                                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                                                            } else {
                                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                                                            }
                                                                        }
                                                                        return var3_6;
                                                                    }
                                                                    if (projectDirFO.isFolder()) break block46;
                                                                    this.messageKind = 1;
                                                                    var3_7 = false;
                                                                    if (this.messageKind <= 0) break block47;
                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                                                    break block59;
                                                                }
                                                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                                if (this.simpleMode.isSelected()) {
                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                                                } else {
                                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                                                }
                                                            }
                                                            return var3_7;
                                                        }
                                                        if (projectDirFO.canRead()) break block48;
                                                        this.messageKind = (byte)2;
                                                        var3_8 = false;
                                                        if (this.messageKind <= 0) break block49;
                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                                        break block60;
                                                    }
                                                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                                    if (this.simpleMode.isSelected()) {
                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                                    } else {
                                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                                    }
                                                }
                                                return var3_8;
                                            }
                                            if (!this.simpleMode.isSelected()) ** GOTO lbl137
                                            if (projectDirFO.canWrite()) break block50;
                                            this.messageKind = (byte)3;
                                            var3_9 = false;
                                            if (this.messageKind <= 0) break block51;
                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                            break block61;
                                        }
                                        this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                                        if (this.simpleMode.isSelected()) {
                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                                        } else {
                                            this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                                        }
                                    }
                                    return var3_9;
                                }
                                nbProjFO = projectDirFO.getFileObject("nbproject");
                                if (nbProjFO == null || !nbProjFO.isValid()) break block52;
                                this.messageKind = (byte)4;
                                var4_13 = false;
                                if (this.messageKind <= 0) break block53;
                                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                                break block62;
                            }
                            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                            if (this.simpleMode.isSelected()) {
                                this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                            } else {
                                this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                            }
                        }
                        return var4_13;
                    }
                    if (ProjectManager.getDefault().findProject(projectDirFO) == null) break block54;
                    this.messageKind = (byte)4;
                    var4_14 = false;
                    if (this.messageKind <= 0) break block55;
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
                    break block63;
                }
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                if (this.simpleMode.isSelected()) {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                }
            }
            return var4_14;
        }
        try {
            block64: {
                break block64;
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (ConfigureUtils.findConfigureScript(this.controller.getWizardStorage().getSourcesFileObject()) != null) {
                nbProjFO = true;
                return nbProjFO;
            }
            makeFO = ConfigureUtils.findMakefile(this.controller.getWizardStorage().getSourcesFileObject());
            if (makeFO != null) {
                this.controller.getWizardStorage().setMake(makeFO);
                var4_16 = true;
                return var4_16;
            }
            if (this.simpleMode.isSelected()) {
                this.messageKind = (byte)5;
                var4_17 = false;
                return var4_17;
            }
            var4_18 = true;
            return var4_18;
        }
        catch (Throwable ex) {
            ex.printStackTrace(System.err);
            this.messageKind = (byte)2;
            var3_12 = false;
            return var3_12;
        }
        catch (Throwable var5_19) {
            throw var5_19;
        }
        finally {
            if (this.messageKind > 0) {
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)("SelectModeError" + this.messageKind), (Object)path));
            } else {
                this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", null);
                if (this.simpleMode.isSelected()) {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", (Object)NbBundle.getMessage(SelectModePanel.class, (String)"CleanInfoMessageSimpleMode"));
                } else {
                    this.controller.getWizardDescriptor().putProperty("WizardPanel_warningMessage", null);
                }
            }
        }
    }

    private void disableHostSensitiveComponents() {
        PanelProjectLocationVisual.disableHostsInfo(this.hostComboBox, this.toolchainComboBox);
        this.advancedMode.setEnabled(false);
        this.simpleMode.setEnabled(false);
    }

    private void enableHostSensitiveComponents(Collection<ServerRecord> records, ServerRecord srToSelect, CompilerSet csToSelect, boolean isDefaultCompilerSet, boolean enableHost, boolean enableToolchain) {
        PanelProjectLocationVisual.updateToolchainsComponents(this.hostComboBox, this.toolchainComboBox, records, srToSelect, csToSelect, isDefaultCompilerSet, enableHost, enableToolchain);
        this.advancedMode.setEnabled(true);
        this.simpleMode.setEnabled(true);
        this.updateInstruction();
        this.initialized = true;
        this.controller.fireChangeEvent();
    }
}

