/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.api.remote.ServerList;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectWizardPanels;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ConfigureUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.SelectModePanel;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.filesystems.FileSystem;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class SelectModeDescriptorPanel
implements ProjectWizardPanels.MakeModePanel<WizardDescriptor>,
ProjectWizardPanels.NamedPanel,
ChangeListener {
    private WizardDescriptor wizardDescriptor;
    private SelectModePanel component;
    private String name;
    private final MyWizardStorage wizardStorage;
    private boolean isValid = false;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public SelectModeDescriptorPanel() {
        this.name = NbBundle.getMessage(SelectModePanel.class, (String)"SelectModeName");
        this.wizardStorage = new MyWizardStorage();
    }

    @Override
    public String getName() {
        return this.name;
    }

    public SelectModePanel getComponent() {
        if (this.component == null) {
            this.component = new SelectModePanel(this);
            this.component.setName(this.name);
        }
        return this.component;
    }

    public HelpCtx getHelp() {
        return new HelpCtx("NewMakeWizardP0");
    }

    public boolean isValid() {
        return this.isValid;
    }

    private void validate() {
        this.isValid = this.component.valid();
        this.fireChangeEvent();
    }

    private void setMode(boolean isSimple) {
        if (isSimple) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        } else {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.FALSE);
        }
        this.validate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener l) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> it;
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            it = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        ChangeEvent ev = new ChangeEvent(this);
        while (it.hasNext()) {
            it.next().stateChanged(ev);
        }
    }

    WizardDescriptor getWizardDescriptor() {
        return this.wizardDescriptor;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        Object o = this.component.getClientProperty("WizardPanel_contentData");
        String[] names = (String[])o;
        String[] res = Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode")) ? new String[]{names[0]} : new String[]{names[0], "..."};
        this.component.putClientProperty("WizardPanel_contentData", res);
        this.fireChangeEvent();
    }

    public boolean isFinishPanel() {
        return Boolean.TRUE.equals(this.wizardDescriptor.getProperty("simpleMode"));
    }

    public void readSettings(WizardDescriptor settings) {
        this.wizardDescriptor = settings;
        if (this.wizardDescriptor.getProperty("simpleMode") == null) {
            this.wizardDescriptor.putProperty("simpleMode", (Object)Boolean.TRUE);
        }
        this.getComponent().read(this.wizardDescriptor);
    }

    public void storeSettings(WizardDescriptor settings) {
        this.getComponent().store(settings);
    }

    @Override
    public ProjectWizardPanels.WizardStorage getWizardStorage() {
        return this.wizardStorage;
    }

    @Override
    public void setFinishPanel(boolean isFinishPanel) {
    }

    boolean isFullRemote() {
        return this.wizardDescriptor.getProperty("REMOTE_FILE_ENV") != null;
    }

    private static class WizardDescriptorAdapter
    extends WizardDescriptor {
        private ProjectWizardPanels.WizardStorage storage;

        public WizardDescriptorAdapter(ProjectWizardPanels.WizardStorage storage) {
            this.storage = storage;
        }

        public synchronized Object getProperty(String name) {
            if ("realFlags".equals(name)) {
                return this.storage.getRealFlags();
            }
            if ("buildProject".equals(name)) {
                if (this.storage.isBuildProject()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("setMain".equals(name)) {
                if (this.storage.isSetMain()) {
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
            if ("simpleMode".equals(name)) {
                return Boolean.TRUE;
            }
            if ("makefileName".equals(name)) {
                return this.storage.getMake();
            }
            if ("configureName".equals(name)) {
                return this.storage.getConfigure();
            }
            if ("hostUID".equals(name)) {
                return ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)this.storage.getExecutionEnvironment());
            }
            if ("sourceHostEnv".equals(name)) {
                return this.storage.getSourceExecutionEnvironment();
            }
            if ("toolchain".equals(name)) {
                return this.storage.getCompilerSet();
            }
            if ("toolchainDefault".equals(name)) {
                return this.storage.isDefaultCompilerSet();
            }
            if ("nativeProjDir".equals(name)) {
                return this.storage.getSourcesFileObject().getPath();
            }
            if ("nativeProjFO".equals(name)) {
                return this.storage.getSourcesFileObject();
            }
            if ("projdir".equals(name)) {
                try {
                    return new FSPath(this.storage.getSourcesFileObject().getFileSystem(), this.storage.getSourcesFileObject().getPath());
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            }
            return super.getProperty(name);
        }
    }

    private class MyWizardStorage
    implements ProjectWizardPanels.WizardStorage {
        private String projectPath = "";
        private FileObject sourceFileObject;
        private String flags = "";
        private boolean setMain = true;
        private boolean buildProject = true;
        private CompilerSet cs;
        private boolean defaultCompilerSet;
        private ExecutionEnvironment buildEnv = ServerList.getDefaultRecord().getExecutionEnvironment();
        private ExecutionEnvironment sourceEnv = NewProjectWizardUtils.getDefaultSourceEnvironment();
        private FileObject makefileFO;

        @Override
        public WizardDescriptor getAdapter() {
            return new WizardDescriptorAdapter(this);
        }

        @Override
        public void setMode(boolean isSimple) {
            SelectModeDescriptorPanel.this.setMode(isSimple);
        }

        @Override
        public String getProjectPath() {
            return this.projectPath;
        }

        @Override
        public FileObject getSourcesFileObject() {
            return this.sourceFileObject;
        }

        @Override
        public void setProjectPath(String path) {
            this.projectPath = path.trim();
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public void setSourcesFileObject(FileObject fileObject) {
            this.sourceFileObject = fileObject;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public String getConfigure() {
            if (this.sourceFileObject != null) {
                return ConfigureUtils.findConfigureScript(this.sourceFileObject);
            }
            if (SelectModeDescriptorPanel.this.wizardDescriptor != null) {
                ExecutionEnvironment env = (ExecutionEnvironment)SelectModeDescriptorPanel.this.wizardDescriptor.getProperty("REMOTE_FILE_ENV");
                if (env == null) {
                    env = ExecutionEnvironmentFactory.getLocal();
                }
                FileSystem fileSystem = FileSystemProvider.getFileSystem((ExecutionEnvironment)env);
                return ConfigureUtils.findConfigureScript(fileSystem.findResource(this.projectPath));
            }
            return null;
        }

        @Override
        public String getMake() {
            return this.makefileFO == null ? null : this.makefileFO.getPath();
        }

        @Override
        public void setMake(FileObject makefileFO) {
            this.makefileFO = makefileFO;
        }

        @Override
        public String getFlags() {
            return this.flags;
        }

        @Override
        public String getRealFlags() {
            return ConfigureUtils.getConfigureArguments(this.buildEnv, this.cs, this.getConfigure(), this.flags);
        }

        @Override
        public void setFlags(String flags) {
            this.flags = flags;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public boolean isSetMain() {
            return this.setMain;
        }

        @Override
        public void setSetMain(boolean setMain) {
            this.setMain = setMain;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public boolean isBuildProject() {
            return this.buildProject;
        }

        @Override
        public void setBuildProject(boolean buildProject) {
            this.buildProject = buildProject;
            SelectModeDescriptorPanel.this.validate();
        }

        @Override
        public void setCompilerSet(CompilerSet cs) {
            this.cs = cs;
        }

        @Override
        public CompilerSet getCompilerSet() {
            return this.cs;
        }

        @Override
        public void setExecutionEnvironment(ExecutionEnvironment ee) {
            this.buildEnv = ee;
        }

        @Override
        public ExecutionEnvironment getExecutionEnvironment() {
            return this.buildEnv;
        }

        @Override
        public ExecutionEnvironment getSourceExecutionEnvironment() {
            return this.sourceEnv;
        }

        @Override
        public void setSourceExecutionEnvironment(ExecutionEnvironment sourceEnv) {
            this.sourceEnv = sourceEnv;
        }

        @Override
        public void setDefaultCompilerSet(boolean defaultCompilerSet) {
            this.defaultCompilerSet = defaultCompilerSet;
        }

        @Override
        public boolean isDefaultCompilerSet() {
            return this.defaultCompilerSet;
        }
    }
}

