/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import java.util.StringTokenizer;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.makeproject.ui.wizards.FolderEntry;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelProjectLocationVisual;
import org.netbeans.modules.cnd.makeproject.ui.wizards.ParserConfigurationDescriptorPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.netbeans.modules.cnd.utils.ui.ListEditorPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class ParserConfigurationPanel
extends JPanel
implements HelpCtx.Provider {
    private final ParserConfigurationDescriptorPanel controller;
    private boolean first = true;
    private boolean enableBuildArtifacts;
    private JPanel artifactsPanel;
    private JRadioButton automaticButton;
    private JButton buildLogButton;
    private JLabel buildLogLabel;
    private JTextField buildLogTextField;
    private ButtonGroup buttonGroup1;
    private JLabel codeModelLabel;
    private JPanel codeModelPanel;
    private JButton includeEditButton;
    private JLabel includeLabel;
    private JTextField includeTextField;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JLabel jLabel2;
    private JPanel jPanel1;
    private JButton macroEditButton;
    private JTextField macroTextField;
    private JRadioButton manualButton;

    ParserConfigurationPanel(ParserConfigurationDescriptorPanel sourceFoldersDescriptorPanel) {
        this.initComponents();
        this.controller = sourceFoldersDescriptorPanel;
        this.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_LABEL_AD"));
        this.includeEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("INCLUDE_BROWSE_BUTTON_AD"));
        this.macroTextField.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_LABEL_AD"));
        this.macroEditButton.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("MACRO_EDIT_BUTTON_AD"));
        this.buildLogTextField.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ParserConfigurationPanel.this.update(e);
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ParserConfigurationPanel.this.update(e);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ParserConfigurationPanel.this.update(e);
            }
        });
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NewMakeWizardP4");
    }

    private void update(DocumentEvent e) {
        this.controller.stateChanged(null);
    }

    void read(WizardDescriptor settings) {
        this.manualButton.setEnabled(true);
        this.automaticButton.setEnabled(true);
        this.automaticButton.setSelected(true);
        if (!"true".equals(settings.getProperty("runConfigure")) && !"true".equals(settings.getProperty("makeProject"))) {
            this.enableBuildArtifacts = true;
            Object property = settings.getProperty("buildLog");
            if (property instanceof String) {
                this.buildLogTextField.setText(property.toString());
            }
        } else {
            this.enableBuildArtifacts = false;
        }
        this.togglePanel(false);
        if (this.first) {
            this.first = false;
            ArrayList roots = (ArrayList)settings.getProperty("sourceFoldersList");
            if (roots != null) {
                StringBuilder buf = new StringBuilder();
                for (FolderEntry folder : roots) {
                    FileObject[] listFiles;
                    FileObject dir;
                    if (buf.length() > 0) {
                        buf.append(';');
                    }
                    if ((dir = folder.getFileObject()) == null) continue;
                    buf.append(RemoteFileUtil.getAbsolutePath((FileObject)dir));
                    if (!dir.isFolder() || (listFiles = dir.getChildren()) == null) continue;
                    for (FileObject sub : listFiles) {
                        if (!sub.isFolder() || !sub.getNameExt().toLowerCase().endsWith("include")) continue;
                        buf.append(';');
                        buf.append(RemoteFileUtil.getAbsolutePath((FileObject)sub));
                    }
                }
                this.includeTextField.setText(buf.toString());
            }
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        if (this.manualButton.isSelected()) {
            wizardDescriptor.putProperty("includeTextField", (Object)this.includeTextField.getText());
            wizardDescriptor.putProperty("macroTextField", (Object)this.macroTextField.getText());
            wizardDescriptor.putProperty("manualCA", (Object)"true");
            wizardDescriptor.putProperty("buildLog", (Object)"");
        } else {
            wizardDescriptor.putProperty("includeTextField", (Object)"");
            wizardDescriptor.putProperty("macroTextField", (Object)"");
            wizardDescriptor.putProperty("manualCA", (Object)"false");
            if (this.enableBuildArtifacts) {
                wizardDescriptor.putProperty("buildLog", (Object)this.buildLogTextField.getText());
            } else {
                wizardDescriptor.putProperty("buildLog", (Object)"");
            }
        }
        wizardDescriptor.putProperty("consolidationLevel", (Object)"file");
    }

    boolean valid(WizardDescriptor settings) {
        String path;
        if (this.enableBuildArtifacts && !this.manualButton.isSelected() && !(path = this.buildLogTextField.getText().trim()).isEmpty()) {
            boolean exists;
            File file = new File(path);
            boolean bl = exists = file.exists() && file.canRead();
            if (!exists) {
                settings.putProperty("WizardPanel_errorMessage", (Object)ParserConfigurationPanel.getString("BUILD_LOG_NOT_EXISTS"));
            }
            return exists;
        }
        return true;
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.automaticButton = new JRadioButton();
        this.artifactsPanel = new JPanel();
        this.buildLogLabel = new JLabel();
        this.buildLogTextField = new JTextField();
        this.buildLogButton = new JButton();
        this.manualButton = new JRadioButton();
        this.codeModelPanel = new JPanel();
        this.codeModelLabel = new JLabel();
        this.includeLabel = new JLabel();
        this.includeTextField = new JTextField();
        this.includeEditButton = new JButton();
        this.jLabel2 = new JLabel();
        this.macroTextField = new JTextField();
        this.macroEditButton = new JButton();
        this.jPanel1 = new JPanel();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.setMinimumSize(new Dimension(300, 158));
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.buttonGroup1.add(this.automaticButton);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((AbstractButton)this.automaticButton, (String)bundle.getString("ParserAutomaticConfiguration"));
        this.automaticButton.setMargin(new Insets(0, 0, 0, 0));
        this.automaticButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParserConfigurationPanel.this.automaticButtonActionPerformed(evt);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.automaticButton, gridBagConstraints);
        this.automaticButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserAutomaticConfiguration_AD"));
        this.artifactsPanel.setLayout(new GridBagLayout());
        this.buildLogLabel.setLabelFor(this.buildLogTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildLogLabel, (String)NbBundle.getMessage(ParserConfigurationPanel.class, (String)"BUILD_LOG_TEXT_FIELD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        this.artifactsPanel.add((Component)this.buildLogLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.artifactsPanel.add((Component)this.buildLogTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buildLogButton, (String)NbBundle.getMessage(ParserConfigurationPanel.class, (String)"BUILD_LOG_BROWSE_BUTTON"));
        this.buildLogButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParserConfigurationPanel.this.buildLogButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.artifactsPanel.add((Component)this.buildLogButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.artifactsPanel, gridBagConstraints);
        this.buttonGroup1.add(this.manualButton);
        Mnemonics.setLocalizedText((AbstractButton)this.manualButton, (String)bundle.getString("ParserManualConfiguration"));
        this.manualButton.setMargin(new Insets(0, 0, 0, 0));
        this.manualButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParserConfigurationPanel.this.manualButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        this.add((Component)this.manualButton, gridBagConstraints);
        this.manualButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"ParserManualConfiguration_AD"));
        this.codeModelPanel.setLayout(new GridBagLayout());
        this.codeModelLabel.setText(bundle.getString("CODEMODEL_LABEL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.codeModelLabel, gridBagConstraints);
        this.includeLabel.setLabelFor(this.includeTextField);
        Mnemonics.setLocalizedText((JLabel)this.includeLabel, (String)bundle.getString("INCLUDE_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 17;
        this.codeModelPanel.add((Component)this.includeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.includeEditButton, (String)bundle.getString("INCLUDE_BROWSE_BUTTON_TXT"));
        this.includeEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParserConfigurationPanel.this.includeEditButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 0, 0);
        this.codeModelPanel.add((Component)this.includeEditButton, gridBagConstraints);
        this.jLabel2.setLabelFor(this.macroTextField);
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)bundle.getString("MACRO_LABEL_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        this.codeModelPanel.add((Component)this.jLabel2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.macroEditButton, (String)bundle.getString("MACRO_EDIT_BUTTON_TXT"));
        this.macroEditButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                ParserConfigurationPanel.this.macroEditButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.codeModelPanel.add((Component)this.macroEditButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 12, 0, 0);
        this.add((Component)this.codeModelPanel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.jPanel1, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(bundle.getString("SourceFoldersInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        this.instructionsTextArea.getAccessibleContext().setAccessibleName(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AN"));
        this.instructionsTextArea.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(ParserConfigurationPanel.class, (String)"INFO_AREA_AD"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(24, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
    }

    private void automaticButtonActionPerformed(ActionEvent evt) {
        this.togglePanel(false);
        this.update((DocumentEvent)null);
    }

    private void manualButtonActionPerformed(ActionEvent evt) {
        this.togglePanel(true);
        this.update((DocumentEvent)null);
    }

    private void togglePanel(boolean manual) {
        for (Component component : this.codeModelPanel.getComponents()) {
            component.setEnabled(manual);
        }
        if (this.enableBuildArtifacts) {
            this.artifactsPanel.setVisible(true);
            for (Component component : this.artifactsPanel.getComponents()) {
                component.setEnabled(!manual);
            }
        } else {
            this.artifactsPanel.setVisible(false);
        }
        if (manual) {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("SourceFoldersInstructions"));
        } else {
            this.instructionsTextArea.setText(ParserConfigurationPanel.getString("DiscoveryInstructions"));
        }
    }

    private void macroEditButtonActionPerformed(ActionEvent evt) {
        StringTokenizer tokenizer = new StringTokenizer(this.macroTextField.getText(), "; ");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken().trim());
        }
        MacrosListPanel panel = new MacrosListPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel((JPanel)((Object)panel)), "Macro Definitions");
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            List newList = panel.getListData();
            StringBuilder macros = new StringBuilder();
            for (int i = 0; i < newList.size(); ++i) {
                if (i > 0) {
                    macros.append(";");
                }
                macros.append((String)newList.get(i));
            }
            this.macroTextField.setText(macros.toString());
        }
    }

    private void includeEditButtonActionPerformed(ActionEvent evt) {
        StringTokenizer tokenizer = new StringTokenizer(this.includeTextField.getText(), ";");
        ArrayList<String> list = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            list.add(tokenizer.nextToken());
        }
        IncludesListPanel panel = new IncludesListPanel(list);
        DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)this.addOuterPanel((JPanel)((Object)panel)), ParserConfigurationPanel.getString("INCLUDE_DIRIRECTORIES_TXT"));
        DialogDisplayer.getDefault().notify((NotifyDescriptor)dialogDescriptor);
        if (dialogDescriptor.getValue() == DialogDescriptor.OK_OPTION) {
            List newList = panel.getListData();
            StringBuilder includes = new StringBuilder();
            for (int i = 0; i < newList.size(); ++i) {
                if (i > 0) {
                    includes.append(";");
                }
                includes.append((String)newList.get(i));
            }
            this.includeTextField.setText(includes.toString());
        }
    }

    private void buildLogButtonActionPerformed(ActionEvent evt) {
        String seed = this.buildLogTextField.getText().length() > 0 ? this.buildLogTextField.getText() : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), ParserConfigurationPanel.getString("BUILD_LOG_CHOOSER_TITLE_TXT"), ParserConfigurationPanel.getString("BUILD_LOG_CHOOSER_BUTTON_TXT"), 0, new FileFilter[]{new LogFileFilter()}, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilitities.normalizeSlashes((String)path);
        this.buildLogTextField.setText(path);
    }

    private JPanel addOuterPanel(JPanel innerPanel) {
        JPanel outerPanel = new JPanel();
        outerPanel.getAccessibleContext().setAccessibleDescription(ParserConfigurationPanel.getString("DIALOG_AD"));
        outerPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(12, 12, 12, 12);
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        outerPanel.add((Component)innerPanel, gridBagConstraints);
        outerPanel.setPreferredSize(new Dimension(500, 250));
        return outerPanel;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(PanelProjectLocationVisual.class, (String)s);
    }

    private class LogFileFilter
    extends FileFilter {
        @Override
        public String getDescription() {
            return ParserConfigurationPanel.getString("FILECHOOSER_BUILD_LOG_FILEFILTER");
        }

        @Override
        public boolean accept(File f) {
            if (f != null) {
                if (f.isDirectory()) {
                    return true;
                }
                return f.getName().endsWith(".log");
            }
            return false;
        }
    }

    private static class MacrosListPanel
    extends ListEditorPanel<String> {
        public MacrosListPanel(List<String> objects) {
            super(objects);
            this.getDefaultButton().setVisible(false);
        }

        public String addAction() {
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("ADD_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return null;
            }
            String newS = notifyDescriptor.getInputText().trim();
            return newS;
        }

        public String getListLabelText() {
            return ParserConfigurationPanel.getString("MACROS_LIST_TXT");
        }

        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("MACROS_LIST_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public String copyAction(String o) {
            return o;
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText().trim();
            this.replaceElement(o, newS, i);
        }
    }

    private class IncludesListPanel
    extends ListEditorPanel<String> {
        public IncludesListPanel(List<String> objects) {
            super(objects);
            this.getDefaultButton().setVisible(false);
        }

        public String addAction() {
            JFileChooser fileChooser;
            int ret;
            String seed = null;
            if (FileChooser.getCurrentChooserFile() != null) {
                seed = FileChooser.getCurrentChooserFile().getPath();
            }
            if (seed == null) {
                seed = System.getProperty("user.home");
            }
            if ((ret = (fileChooser = NewProjectWizardUtils.createFileChooser(ParserConfigurationPanel.this.controller.getWizardDescriptor(), ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_TITLE_TXT"), ParserConfigurationPanel.getString("INCLUDE_DIR_DIALOG_BUTTON_TXT"), 1, null, seed, true)).showOpenDialog((Component)((Object)this))) == 1) {
                return null;
            }
            String itemPath = fileChooser.getSelectedFile().getPath();
            itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath);
            return itemPath;
        }

        public String getListLabelText() {
            return ParserConfigurationPanel.getString("DIR_LIST_TXT");
        }

        public char getListLabelMnemonic() {
            return ParserConfigurationPanel.getString("DIR_LIST_MN").charAt(0);
        }

        public String getAddButtonText() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_TXT");
        }

        public char getAddButtonMnemonics() {
            return ParserConfigurationPanel.getString("ADD_BUTTON_MN").charAt(0);
        }

        public String getRenameButtonText() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_TXT");
        }

        public char getRenameButtonMnemonics() {
            return ParserConfigurationPanel.getString("EDIT_BUTTON_MN").charAt(0);
        }

        public String copyAction(String o) {
            return o;
        }

        public void editAction(String o, int i) {
            String s = o;
            NotifyDescriptor.InputLine notifyDescriptor = new NotifyDescriptor.InputLine(ParserConfigurationPanel.getString("EDIT_DIALOG_LABEL_TXT"), ParserConfigurationPanel.getString("EDIT_DIALOG_TITLE_TXT"));
            notifyDescriptor.setInputText(s);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)notifyDescriptor);
            if (notifyDescriptor.getValue() != NotifyDescriptor.OK_OPTION) {
                return;
            }
            String newS = notifyDescriptor.getInputText().trim();
            this.replaceElement(o, newS, i);
        }
    }
}

