/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.io.IOException;
import java.util.NoSuchElementException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.makeproject.api.ProjectGenerator;
import org.netbeans.modules.cnd.makeproject.api.wizards.ProjectWizardPanels;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewMakeProjectWizardIterator;
import org.netbeans.modules.cnd.makeproject.ui.wizards.PanelConfigureProject;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.WizardDescriptor;
import org.openide.loaders.DataObject;
import org.openide.loaders.TemplateWizard;
import org.openide.util.NbBundle;

public class MakeSampleProjectIterator
implements WizardDescriptor.ProgressInstantiatingIterator<WizardDescriptor> {
    private static final long serialVersionUID = 4L;
    private transient int index = 0;
    private transient WizardDescriptor.Panel<WizardDescriptor> panel;
    private transient TemplateWizard wiz;
    private static ResourceBundle bundle;

    static Object create() {
        return new MakeSampleProjectIterator();
    }

    public void addChangeListener(ChangeListener changeListener) {
    }

    public void removeChangeListener(ChangeListener changeListener) {
    }

    public WizardDescriptor.Panel<WizardDescriptor> current() {
        return this.panel;
    }

    public boolean hasNext() {
        return false;
    }

    public boolean hasPrevious() {
        return false;
    }

    public void initialize(WizardDescriptor wizard) {
        int i = 0;
        this.wiz = (TemplateWizard)wizard;
        String name = this.wiz.getTemplate().getNodeDelegate().getName();
        if (name != null) {
            name = name.replaceAll(" ", "");
        }
        this.wiz.putProperty("name", (Object)name);
        String wizardTitle = MakeSampleProjectIterator.getString("SAMPLE_PROJECT") + name;
        String wizardTitleACSD = MakeSampleProjectIterator.getString("SAMPLE_PROJECT_ACSD");
        this.panel = MakeSampleProjectIterator.getPanel(-1, name, wizardTitle, wizardTitleACSD, false);
        String[] steps = new String[1];
        JComponent jc = (JComponent)this.panel.getComponent();
        steps[i] = ((ProjectWizardPanels.NamedPanel)this.panel).getName();
        jc.putClientProperty("WizardPanel_contentData", steps);
        jc.putClientProperty("WizardPanel_contentSelectedIndex", i);
    }

    public static ProjectWizardPanels.MakeSamplePanel<WizardDescriptor> getPanel(int wizardtype, String name, String wizardTitle, String wizardACSD, boolean fullRemote) {
        return new PanelConfigureProject(name, wizardtype, wizardTitle, wizardACSD, fullRemote);
    }

    public void uninitialize(WizardDescriptor templateWizard) {
        this.panel = null;
        this.index = -1;
        this.wiz.putProperty("projdir", null);
        this.wiz.putProperty("name", null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<?> instantiate(ProgressHandle handle) throws IOException {
        try {
            handle.start();
            Set<DataObject> set = this.instantiate();
            return set;
        }
        finally {
            handle.finish();
        }
    }

    public Set<DataObject> instantiate() throws IOException {
        FSPath projectLocation = (FSPath)this.wiz.getProperty("projdir");
        String name = (String)this.wiz.getProperty("name");
        String hostUID = (String)this.wiz.getProperty("hostUID");
        if (this.wiz.getProperty("REMOTE_FILE_ENV") != null) {
            hostUID = ExecutionEnvironmentFactory.toUniqueID((ExecutionEnvironment)ExecutionEnvironmentFactory.getLocal());
        }
        CompilerSet toolchain = (CompilerSet)this.wiz.getProperty("toolchain");
        boolean defaultToolchain = Boolean.TRUE.equals(this.wiz.getProperty("toolchainDefault"));
        ProjectGenerator.ProjectParameters prjParams = new ProjectGenerator.ProjectParameters(name, projectLocation);
        prjParams.setHostToolchain(hostUID, toolchain, defaultToolchain);
        return ProjectGenerator.createProjectFromTemplate(this.wiz.getTemplate().getPrimaryFile(), prjParams);
    }

    public String name() {
        return this.current().getComponent().getName();
    }

    public void nextPanel() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.index;
    }

    public void previousPanel() {
        if (!this.hasPrevious()) {
            throw new NoSuchElementException();
        }
        --this.index;
    }

    private static String getString(String s) {
        if (bundle == null) {
            bundle = NbBundle.getBundle(NewMakeProjectWizardIterator.class);
        }
        return bundle.getString(s);
    }
}

