/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.wizards;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.cnd.makeproject.ui.wizards.BuildActionsDescriptorPanel;
import org.netbeans.modules.cnd.makeproject.ui.wizards.NewProjectWizardUtils;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.FileFilterFactory;
import org.netbeans.modules.cnd.utils.ui.DocumentAdapter;
import org.netbeans.modules.cnd.utils.ui.FileChooser;
import org.openide.WizardDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class BuildActionsPanel
extends JPanel
implements HelpCtx.Provider {
    private final DocumentListener documentListener;
    private boolean valid = false;
    private final BuildActionsDescriptorPanel controller;
    private String makefileName = null;
    private static String DEF_WORKING_DIR = "";
    private static String DEF_BUILD_COMMAND = "${MAKE}";
    private static String DEF_CLEAN_COMMAND = "${MAKE} clean";
    private static String DEF_BUILD_COMMAND_FMT = "{0} -f {1}";
    private static String DEF_CLEAN_COMMAND_FMT = "{0} -f {1} clean";
    private JLabel buildCommandLabel;
    private JTextField buildCommandTextField;
    private JButton buildCommandWorkingDirBrowseButton;
    private JLabel buildCommandWorkingDirLabel;
    private JTextField buildCommandWorkingDirTextField;
    private JLabel cleanCommandLabel;
    private JTextField cleanCommandTextField;
    private JLabel group2Label;
    private JPanel instructionPanel;
    private JTextArea instructionsTextArea;
    private JButton outputBrowseButton;
    private JLabel outputLabel;
    private JTextField outputTextField;

    BuildActionsPanel(BuildActionsDescriptorPanel buildActionsDescriptorPanel) {
        this.initComponents();
        this.instructionsTextArea.setBackground(this.instructionPanel.getBackground());
        this.controller = buildActionsDescriptorPanel;
        this.documentListener = new DocumentAdapter(){

            protected void update(DocumentEvent e) {
                BuildActionsPanel.this.update();
            }
        };
        this.buildCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandWorkingDirTextField.getDocument().addDocumentListener(this.documentListener);
        this.cleanCommandTextField.getDocument().addDocumentListener(this.documentListener);
        this.outputTextField.getDocument().addDocumentListener(this.documentListener);
        this.buildCommandWorkingDirTextField.selectAll();
        this.buildCommandWorkingDirTextField.requestFocus();
        this.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_ACTIONS_PANEL_AD"));
        this.buildCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("BUILD_COMMAND_AD"));
        this.buildCommandWorkingDirTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_AD"));
        this.cleanCommandTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("CLEAN_COMMAND_AD"));
        this.outputTextField.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("OUTPUT_AD"));
        this.buildCommandWorkingDirBrowseButton.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("WORKING_DIR_BROWSE_BUTTON_AD"));
        this.outputBrowseButton.getAccessibleContext().setAccessibleDescription(BuildActionsPanel.getString("OUTPUT_BROWSE_BUTTON_AD"));
    }

    private void makefileFieldChanged() {
        File makefile = new File(this.makefileName);
        if (makefile.getParent() != null) {
            this.buildCommandWorkingDirTextField.setText(CndPathUtilitities.normalizeSlashes((String)makefile.getParent()));
            String buildCommand = MessageFormat.format(DEF_BUILD_COMMAND_FMT, DEF_BUILD_COMMAND, makefile.getName());
            String cleanCommand = MessageFormat.format(DEF_CLEAN_COMMAND_FMT, DEF_BUILD_COMMAND, makefile.getName());
            this.buildCommandTextField.setText(buildCommand);
            this.cleanCommandTextField.setText(cleanCommand);
        }
    }

    private void initFields() {
        this.buildCommandWorkingDirTextField.setText(DEF_WORKING_DIR);
        this.buildCommandTextField.setText(DEF_BUILD_COMMAND);
        this.cleanCommandTextField.setText(DEF_CLEAN_COMMAND);
        this.outputTextField.setText("");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(BuildActionsPanel.class);
    }

    private void update() {
        this.controller.stateChanged(null);
    }

    void read(WizardDescriptor wizardDescriptor) {
        String mn = (String)wizardDescriptor.getProperty("makefileName");
        if (this.makefileName == null || !this.makefileName.equals(mn)) {
            this.initFields();
            this.makefileName = mn;
            this.makefileFieldChanged();
        }
    }

    void store(WizardDescriptor wizardDescriptor) {
        wizardDescriptor.putProperty("buildCommandWorkingDirTextField", (Object)this.buildCommandWorkingDirTextField.getText());
        wizardDescriptor.putProperty("buildCommandTextField", (Object)this.buildCommandTextField.getText());
        wizardDescriptor.putProperty("cleanCommandTextField", (Object)this.cleanCommandTextField.getText());
        wizardDescriptor.putProperty("outputTextField", (Object)this.outputTextField.getText());
    }

    boolean valid(WizardDescriptor settings) {
        String msg;
        if (this.buildCommandWorkingDirTextField.getText().length() == 0) {
            msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"NOWORKINGDIR");
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
        }
        if (!(this.buildCommandWorkingDirTextField.getText().length() <= 0 || CndPathUtilitities.isPathAbsolute((CharSequence)this.buildCommandWorkingDirTextField.getText()) && NewProjectWizardUtils.fileExists(this.buildCommandWorkingDirTextField.getText(), this.controller.getWizardDescriptor()))) {
            msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"WORKINGDIRDOESNOTEXIST");
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
        }
        if (this.outputTextField.getText().length() > 0 && !CndPathUtilitities.isPathAbsolute((CharSequence)this.outputTextField.getText())) {
            msg = NbBundle.getMessage(BuildActionsPanel.class, (String)"BUILDRESULTNOTABSOLUTE");
            this.controller.getWizardDescriptor().putProperty("WizardPanel_errorMessage", (Object)msg);
        }
        return true;
    }

    private void initComponents() {
        this.buildCommandWorkingDirLabel = new JLabel();
        this.buildCommandWorkingDirTextField = new JTextField();
        this.buildCommandWorkingDirBrowseButton = new JButton();
        this.buildCommandLabel = new JLabel();
        this.buildCommandTextField = new JTextField();
        this.cleanCommandLabel = new JLabel();
        this.cleanCommandTextField = new JTextField();
        this.outputLabel = new JLabel();
        this.outputTextField = new JTextField();
        this.outputBrowseButton = new JButton();
        this.instructionPanel = new JPanel();
        this.instructionsTextArea = new JTextArea();
        this.group2Label = new JLabel();
        this.setPreferredSize(new Dimension(450, 350));
        this.setLayout(new GridBagLayout());
        this.buildCommandWorkingDirLabel.setLabelFor(this.buildCommandWorkingDirTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/wizards/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.buildCommandWorkingDirLabel, (String)bundle.getString("WORKING_DIR_LBL"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.buildCommandWorkingDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.buildCommandWorkingDirBrowseButton, (String)bundle.getString("WORKING_DIR_BROWSE_BUTTON_TXT"));
        this.buildCommandWorkingDirBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsPanel.this.buildCommandWorkingDirBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.buildCommandWorkingDirBrowseButton, gridBagConstraints);
        this.buildCommandLabel.setLabelFor(this.buildCommandTextField);
        Mnemonics.setLocalizedText((JLabel)this.buildCommandLabel, (String)bundle.getString("BUILD_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.buildCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.buildCommandTextField, gridBagConstraints);
        this.cleanCommandLabel.setLabelFor(this.cleanCommandTextField);
        Mnemonics.setLocalizedText((JLabel)this.cleanCommandLabel, (String)bundle.getString("CLEAN_COMMAND_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 0, 0, 0);
        this.add((Component)this.cleanCommandLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 4, 0, 0);
        this.add((Component)this.cleanCommandTextField, gridBagConstraints);
        this.outputLabel.setLabelFor(this.outputTextField);
        Mnemonics.setLocalizedText((JLabel)this.outputLabel, (String)bundle.getString("OUTPUT_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.outputLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.outputTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.outputBrowseButton, (String)bundle.getString("OUTPUT_BROWSE_BUTTON_TXT"));
        this.outputBrowseButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                BuildActionsPanel.this.outputBrowseButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 4, 0, 0);
        this.add((Component)this.outputBrowseButton, gridBagConstraints);
        this.instructionPanel.setLayout(new GridBagLayout());
        this.instructionsTextArea.setEditable(false);
        this.instructionsTextArea.setLineWrap(true);
        this.instructionsTextArea.setText(bundle.getString("BuildActionsInstructions"));
        this.instructionsTextArea.setWrapStyleWord(true);
        this.instructionsTextArea.setOpaque(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        this.instructionPanel.add((Component)this.instructionsTextArea, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.instructionPanel, gridBagConstraints);
        this.group2Label.setText(bundle.getString("GROUP2_LBL"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 0, 0, 0);
        this.add((Component)this.group2Label, gridBagConstraints);
    }

    private void outputBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = null;
        seed = this.outputTextField.getText().length() > 0 ? this.outputTextField.getText() : (this.buildCommandWorkingDirTextField.getText().length() > 0 ? this.buildCommandWorkingDirTextField.getText() : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home")));
        FileFilter[] filters = FileFilterFactory.getBinaryFilters();
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), BuildActionsPanel.getString("OUTPUT_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("OUTPUT_CHOOSER_BUTTON_TXT"), 0, filters, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = CndPathUtilitities.normalizeSlashes((String)fileChooser.getSelectedFile().getPath());
        this.outputTextField.setText(path);
    }

    private void buildCommandWorkingDirBrowseButtonActionPerformed(ActionEvent evt) {
        String seed = null;
        seed = this.buildCommandWorkingDirTextField.getText().length() > 0 ? this.buildCommandWorkingDirTextField.getText() : (FileChooser.getCurrentChooserFile() != null ? FileChooser.getCurrentChooserFile().getPath() : System.getProperty("user.home"));
        JFileChooser fileChooser = NewProjectWizardUtils.createFileChooser(this.controller.getWizardDescriptor(), BuildActionsPanel.getString("WORKING_DIR_CHOOSER_TITLE_TXT"), BuildActionsPanel.getString("WORKING_DIR_BUTTON_TXT"), 1, null, seed, false);
        int ret = fileChooser.showOpenDialog(this);
        if (ret == 1) {
            return;
        }
        String path = fileChooser.getSelectedFile().getPath();
        path = CndPathUtilitities.normalizeSlashes((String)path);
        this.buildCommandWorkingDirTextField.setText(path);
    }

    private static String getString(String s) {
        return NbBundle.getBundle(BuildActionsPanel.class).getString(s);
    }
}

