/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.options;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.makeproject.MakeOptions;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectOptions;
import org.netbeans.modules.cnd.utils.ui.NamedOption;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public class ProjectOptionsPanel
extends JPanel {
    private boolean changed;
    private ArrayList<JCheckBox> checkBoxes;
    private JLabel filePathLabel;
    private JTextArea filePathTxt;
    private JComboBox filePathcomboBox;
    private JLabel makeOptionsLabel;
    private JTextField makeOptionsTextField;
    private JLabel makeOptionsTxt;

    public ProjectOptionsPanel() {
        this.initComponents();
        this.initAdditionalComponents();
        this.filePathcomboBox.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("FILE_PATH_AD"));
        this.makeOptionsTextField.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("MAKE_OPTIONS_AD"));
        this.filePathTxt.getAccessibleContext().setAccessibleDescription(ProjectOptionsPanel.getString("FILE_PATH_TXT_AD"));
        this.filePathTxt.getAccessibleContext().setAccessibleName(ProjectOptionsPanel.getString("FILE_PATH_TXT_AN"));
        this.setName("TAB_ProjectsTab");
        Color c = this.getBackground();
        Color cc = new Color(c.getRed(), c.getGreen(), c.getBlue());
        this.filePathTxt.setBackground(cc);
    }

    public void update() {
        MakeOptions makeOptions = MakeOptions.getInstance();
        this.makeOptionsTextField.setText(makeOptions.getMakeOptions());
        this.filePathcomboBox.removeAllItems();
        for (MakeProjectOptions.PathMode pathMode : MakeProjectOptions.PathMode.values()) {
            this.filePathcomboBox.addItem(pathMode);
        }
        this.filePathcomboBox.setSelectedItem((Object)makeOptions.getPathMode());
        for (JCheckBox cb : this.checkBoxes) {
            NamedOption entry = (NamedOption)cb.getClientProperty("MakeOptionNamedEntity");
            cb.setSelected(NamedOption.getAccessor().getBoolean(entry.getName()));
        }
        this.changed = false;
    }

    public void applyChanges() {
        MakeOptions makeOptions = MakeOptions.getInstance();
        makeOptions.setMakeOptions(this.makeOptionsTextField.getText());
        makeOptions.setPathMode((MakeProjectOptions.PathMode)((Object)this.filePathcomboBox.getSelectedItem()));
        for (JCheckBox cb : this.checkBoxes) {
            NamedOption entry = (NamedOption)cb.getClientProperty("MakeOptionNamedEntity");
            NamedOption.getAccessor().setBoolean(entry.getName(), cb.isSelected());
        }
        this.changed = false;
    }

    public void cancel() {
        this.changed = false;
    }

    public boolean dataValid() {
        return true;
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void initAdditionalComponents() {
        GridBagConstraints gridBagConstraints;
        this.checkBoxes = new ArrayList();
        int row = 20;
        for (NamedOption entry : this.getEntries()) {
            JCheckBox wrapper = this.getWrapper(entry);
            this.checkBoxes.add(wrapper);
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = row++;
            gridBagConstraints.gridwidth = 0;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.insets = new Insets(0, 6, 6, 6);
            this.add((Component)wrapper, gridBagConstraints);
        }
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = row;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JSeparator(), gridBagConstraints);
    }

    private List<NamedOption> getEntries() {
        ArrayList<NamedOption> result = new ArrayList<NamedOption>();
        for (NamedOption option : Lookups.forPath((String)"CND/options/makeProject").lookupAll(NamedOption.class)) {
            if (!option.isVisible()) continue;
            result.add(option);
        }
        return result;
    }

    private JCheckBox getWrapper(NamedOption entry) {
        JCheckBox cb = new JCheckBox();
        Mnemonics.setLocalizedText((AbstractButton)cb, (String)entry.getDisplayName());
        if (entry.getDescription() != null) {
            cb.setToolTipText(entry.getDescription());
        }
        cb.setOpaque(false);
        cb.setSelected(NamedOption.getAccessor().getBoolean(entry.getName()));
        cb.putClientProperty("MakeOptionNamedEntity", entry);
        return cb;
    }

    private static String getString(String key) {
        return NbBundle.getMessage(ProjectOptionsPanel.class, (String)key);
    }

    private void initComponents() {
        this.makeOptionsLabel = new JLabel();
        this.makeOptionsTextField = new JTextField();
        this.makeOptionsTxt = new JLabel();
        this.filePathLabel = new JLabel();
        this.filePathcomboBox = new JComboBox();
        this.filePathTxt = new JTextArea();
        this.setLayout(new GridBagLayout());
        this.makeOptionsLabel.setLabelFor(this.makeOptionsTextField);
        ResourceBundle bundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/makeproject/ui/options/Bundle");
        Mnemonics.setLocalizedText((JLabel)this.makeOptionsLabel, (String)bundle.getString("MAKE_OPTIONS"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.makeOptionsLabel, gridBagConstraints);
        this.makeOptionsTextField.setColumns(45);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 4, 0, 6);
        this.add((Component)this.makeOptionsTextField, gridBagConstraints);
        this.makeOptionsTxt.setText(bundle.getString("MAKE_OPTIONS_TXT"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(4, 6, 0, 12);
        this.add((Component)this.makeOptionsTxt, gridBagConstraints);
        this.filePathLabel.setLabelFor(this.filePathcomboBox);
        Mnemonics.setLocalizedText((JLabel)this.filePathLabel, (String)bundle.getString("FILE_PATH"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(6, 6, 0, 0);
        this.add((Component)this.filePathLabel, gridBagConstraints);
        this.filePathcomboBox.setMinimumSize(new Dimension(75, 18));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(12, 4, 0, 6);
        this.add((Component)this.filePathcomboBox, gridBagConstraints);
        this.filePathTxt.setEditable(false);
        this.filePathTxt.setLineWrap(true);
        this.filePathTxt.setText(bundle.getString("FILE_PATH_MODE_TXT"));
        this.filePathTxt.setWrapStyleWord(true);
        this.filePathTxt.setBorder(null);
        this.filePathTxt.setMinimumSize(new Dimension(100, 60));
        this.filePathTxt.setPreferredSize(new Dimension(100, 60));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 10.0;
        gridBagConstraints.insets = new Insets(6, 6, 0, 6);
        this.add((Component)this.filePathTxt, gridBagConstraints);
    }
}

