/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Toolkit;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewProvider;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.RequestProcessor;
import org.openide.util.datatransfer.PasteType;

final class ViewItemPasteType
extends PasteType {
    private static final RequestProcessor RP = new RequestProcessor("ViewItemPasteType", 1);
    private final Folder toFolder;
    private final Folder fromFolder;
    private final Item fromItem;
    private final int type;
    private final MakeLogicalViewProvider provider;

    ViewItemPasteType(Folder toFolder, ViewItemNode viewItemNode, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.fromItem = viewItemNode.getItem();
        this.fromFolder = viewItemNode.getFolder();
        this.type = type;
        this.provider = provider;
    }

    ViewItemPasteType(Folder toFolder, Folder fromFolder, Item fromItem, int type, MakeLogicalViewProvider provider) {
        this.toFolder = toFolder;
        this.fromItem = fromItem;
        this.fromFolder = fromFolder;
        this.type = type;
        this.provider = provider;
    }

    private void copyItemConfigurations(ItemConfiguration[] newConfigurations, ItemConfiguration[] oldConfigurations) {
        if (newConfigurations == null || oldConfigurations == null) {
            return;
        }
        assert (newConfigurations.length == oldConfigurations.length);
        if (newConfigurations.length == 0 || oldConfigurations.length == 0) {
            return;
        }
        for (int i = 0; i < newConfigurations.length; ++i) {
            if (oldConfigurations[i] == null || newConfigurations[i] == null) continue;
            newConfigurations[i].assignValues(oldConfigurations[i]);
        }
    }

    public Transferable paste() throws IOException {
        RP.post(new Runnable(){

            @Override
            public void run() {
                try {
                    ViewItemPasteType.this.pasteImpl();
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        });
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    Transferable pasteImpl() throws IOException {
        if (!this.provider.gotMakeConfigurationDescriptor() || !this.provider.getMakeConfigurationDescriptor().okToChange()) {
            return null;
        }
        ItemConfiguration[] oldConfigurations = this.fromItem.getItemConfigurations();
        if (this.type == 2) {
            if (this.toFolder.getProject() == this.fromFolder.getProject()) {
                if (this.toFolder.isDiskFolder()) {
                    FileObject itemFO = this.fromItem.getFileObject();
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                    String newName = CndPathUtilitities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                    String itemPath = movedFileFO.getPath();
                    itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                    Item movedItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath));
                    if (movedItem == null) return null;
                    this.copyItemConfigurations(movedItem.getItemConfigurations(), oldConfigurations);
                    return null;
                } else {
                    if (!this.fromFolder.removeItem(this.fromItem)) return null;
                    this.toFolder.addItem(this.fromItem);
                    this.copyItemConfigurations(this.fromItem.getItemConfigurations(), oldConfigurations);
                }
                return null;
            } else {
                FileObject itemFO = this.fromItem.getFileObject();
                if (this.toFolder.isDiskFolder()) {
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                    String newName = CndPathUtilitities.createUniqueFileName((FileObject)toFolderFO, (String)itemFO.getName(), (String)itemFO.getExt());
                    FileObject movedFileFO = FileUtil.moveFile((FileObject)itemFO, (FileObject)toFolderFO, (String)newName);
                    if (!this.fromItem.getFolder().isDiskFolder() && !this.fromFolder.removeItemAction(this.fromItem)) return null;
                }
                if (this.toFolder.getConfigurationDescriptor().getBaseDirFileSystem().equals(itemFO.getFileSystem()) && (CndPathUtilitities.isPathAbsolute((CharSequence)this.fromItem.getPath()) || this.fromItem.getPath().startsWith(".."))) {
                    if (CndPathUtilitities.isPathAbsolute((CharSequence)this.fromItem.getPath())) {
                        if (!this.fromFolder.removeItem(this.fromItem)) return null;
                        this.toFolder.addItem(this.fromItem);
                        return null;
                    } else {
                        String originalFilePath = this.fromFolder.getProject().getProjectDirectory().getPath();
                        String newFilePath = this.toFolder.getProject().getProjectDirectory().getPath();
                        String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                        fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
                        String newPath = fromNewToOriginal + this.fromItem.getPath();
                        newPath = CndPathUtilitities.trimDotDot((String)newPath);
                        if (!this.fromFolder.removeItemAction(this.fromItem)) return null;
                        this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilitities.normalizeSlashes((String)newPath)));
                    }
                    return null;
                } else {
                    Project toProject = this.toFolder.getProject();
                    FileObject fo = this.fromItem.getFileObject();
                    String newName = CndPathUtilitities.createUniqueFileName((FileObject)toProject.getProjectDirectory(), (String)fo.getName(), (String)fo.getExt());
                    FileObject copy = fo.copy(toProject.getProjectDirectory(), newName, fo.getExt());
                    String newPath = CndPathUtilitities.toRelativePath((String)toProject.getProjectDirectory().getPath(), (String)copy.getPath());
                    if (!this.fromFolder.removeItemAction(this.fromItem)) return null;
                    fo.delete();
                    this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilitities.normalizeSlashes((String)newPath)));
                }
            }
            return null;
        } else {
            if (this.type != 1 && this.type != 0) return null;
            if (this.toFolder.getProject() == this.fromFolder.getProject()) {
                if ((CndPathUtilitities.isPathAbsolute((CharSequence)this.fromItem.getPath()) || this.fromItem.getPath().startsWith("..")) && !this.toFolder.isDiskFolder()) {
                    Toolkit.getDefaultToolkit().beep();
                    return null;
                } else {
                    FileObject fo = this.fromItem.getFileObject();
                    String ext = fo.getExt();
                    if (this.toFolder.isDiskFolder()) {
                        String toFolderPath = CndPathUtilitities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                        FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                        String newName = CndPathUtilitities.createUniqueFileName((FileObject)toFolderFO, (String)fo.getName(), (String)ext);
                        FileObject copiedFileObject = fo.copy(toFolderFO, newName, ext);
                        String itemPath = copiedFileObject.getPath();
                        itemPath = CndPathUtilitities.toRelativePath((String)this.toFolder.getConfigurationDescriptor().getBaseDir(), (String)itemPath);
                        Item copiedItemItem = this.toFolder.findItemByPath(itemPath = CndPathUtilitities.normalizeSlashes((String)itemPath));
                        if (copiedItemItem == null) return null;
                        this.copyItemConfigurations(copiedItemItem.getItemConfigurations(), oldConfigurations);
                        return null;
                    } else {
                        String parent = fo.getParent().getPath();
                        String newName = CndPathUtilitities.createUniqueFileName((FileObject)fo.getParent(), (String)fo.getName(), (String)ext);
                        fo.copy(fo.getParent(), newName, ext);
                        String newPath = parent + "/" + newName;
                        if (ext.length() > 0) {
                            newPath = newPath + "." + ext;
                        }
                        newPath = CndPathUtilitities.toRelativePath((String)this.fromFolder.getProject().getProjectDirectory().getPath(), (String)newPath);
                        Item newItem = Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilitities.normalizeSlashes((String)newPath));
                        this.toFolder.addItemAction(newItem);
                        this.copyItemConfigurations(newItem.getItemConfigurations(), oldConfigurations);
                    }
                }
                return null;
            } else {
                FileObject fo = this.fromItem.getFileObject();
                if (this.toFolder.isDiskFolder()) {
                    String ext = fo.getExt();
                    String toFolderPath = CndPathUtilitities.toAbsolutePath((FileObject)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject(), (String)this.toFolder.getRootPath());
                    FileObject toFolderFO = CndFileUtils.toFileObject((FileSystem)this.toFolder.getConfigurationDescriptor().getBaseDirFileObject().getFileSystem(), (CharSequence)toFolderPath);
                    String newName = CndPathUtilitities.createUniqueFileName((FileObject)toFolderFO, (String)fo.getName(), (String)ext);
                    fo.copy(toFolderFO, newName, ext);
                    return null;
                } else if (this.toFolder.getConfigurationDescriptor().getBaseDirFileSystem().equals(fo.getFileSystem()) && (CndPathUtilitities.isPathAbsolute((CharSequence)this.fromItem.getPath()) || this.fromItem.getPath().startsWith(".."))) {
                    if (CndPathUtilitities.isPathAbsolute((CharSequence)this.fromItem.getPath())) {
                        this.toFolder.addItem(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), this.fromItem.getPath()));
                        return null;
                    } else {
                        String originalFilePath = this.fromFolder.getProject().getProjectDirectory().getPath();
                        String newFilePath = this.toFolder.getProject().getProjectDirectory().getPath();
                        String fromNewToOriginal = CndPathUtilitities.getRelativePath((String)newFilePath, (String)originalFilePath) + "/";
                        fromNewToOriginal = CndPathUtilitities.normalizeSlashes((String)fromNewToOriginal);
                        String newPath = fromNewToOriginal + this.fromItem.getPath();
                        newPath = CndPathUtilitities.trimDotDot((String)newPath);
                        this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilitities.normalizeSlashes((String)newPath)));
                    }
                    return null;
                } else {
                    Project toProject = this.toFolder.getProject();
                    String ext = fo.getExt();
                    String newName = CndPathUtilitities.createUniqueFileName((FileObject)toProject.getProjectDirectory(), (String)fo.getName(), (String)ext);
                    fo.copy(toProject.getProjectDirectory(), newName, ext);
                    String newPath = newName;
                    if (ext.length() > 0) {
                        newPath = newPath + "." + ext;
                    }
                    this.toFolder.addItemAction(Item.createInFileSystem(this.provider.getMakeConfigurationDescriptor().getBaseDirFileSystem(), CndPathUtilitities.normalizeSlashes((String)newPath)));
                }
            }
        }
        return null;
    }
}

