/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.awt.Image;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import javax.swing.SwingWorker;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.DevelopmentHostConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.BaseMakeViewChildren;
import org.netbeans.modules.cnd.makeproject.ui.BrokenLinks;
import org.netbeans.modules.cnd.makeproject.ui.BrokenViewItemNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewRootNode;
import org.netbeans.modules.cnd.makeproject.ui.MakeLogicalViewRootNodeBroken;
import org.netbeans.modules.cnd.makeproject.ui.ProjectTabBridge;
import org.netbeans.modules.cnd.makeproject.ui.ViewItemNode;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.lookup.InstanceContent;

public class MakeLogicalViewProvider
implements LogicalViewProvider {
    private static final String brokenLinkBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenProjectBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenFolderBadgePath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif";
    private static final String brokenIncludeImgPath = "org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png";
    static final Image brokenLinkBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenLinkTxt");
    static final Image brokenProjectBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenProjectTxt");
    static final Image brokenFolderBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenProjectBadge.gif", "BrokenFolderTxt");
    static final Image brokenIncludeBadge = MakeLogicalViewProvider.loadToolTipImage("org/netbeans/modules/cnd/makeproject/ui/resources/brokenIncludeBadge.png", "BrokenIncludeTxt");
    static final String SUBTYPE = "x-org-netbeans-modules-cnd-makeproject-uidnd";
    static final String SUBTYPE_FOLDER = "x-org-netbeans-modules-cnd-makeproject-uidnd-folder";
    static final String MASK = "mask";
    static final RequestProcessor ANNOTATION_RP = new RequestProcessor("MakeLogicalViewProvider.AnnotationUpdater", 10);
    private final MakeProject project;
    private MakeLogicalViewRootNode projectRootNode;
    private final AtomicBoolean findPathMode = new AtomicBoolean(false);

    public MakeLogicalViewProvider(MakeProject project) {
        this.project = project;
        assert (project != null);
    }

    public Node createLogicalView() {
        if (this.gotMakeConfigurationDescriptor()) {
            MakeConfigurationDescriptor configurationDescriptor = this.getMakeConfigurationDescriptor();
            if (configurationDescriptor == null || configurationDescriptor.getState() == ConfigurationDescriptor.State.BROKEN || configurationDescriptor.getConfs().size() == 0) {
                return new MakeLogicalViewRootNodeBroken(this.project);
            }
            this.createRoot(configurationDescriptor);
            return this.projectRootNode;
        }
        this.createLoadingRoot();
        return this.projectRootNode;
    }

    private void createRoot(MakeConfigurationDescriptor configurationDescriptor) {
        InstanceContent ic = new InstanceContent();
        Folder logicalFolders = configurationDescriptor.getLogicalFolders();
        ic.add((Object)logicalFolders);
        this.addLookup(ic);
        this.projectRootNode = new MakeLogicalViewRootNode(logicalFolders, this, ic);
    }

    private void createLoadingRoot() {
        InstanceContent ic = new InstanceContent();
        this.addLookup(ic);
        this.projectRootNode = new MakeLogicalViewRootNode(null, this, ic);
    }

    private void addLookup(InstanceContent ic) {
        ic.add((Object)this.getProject());
        SearchInfoDefinition searchInfo = (SearchInfoDefinition)this.project.getLookup().lookup(SearchInfoDefinition.class);
        ic.add((Object)searchInfo);
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<MakeProject, FileObject>(){

            public FileObject convert(MakeProject obj) {
                return obj.getProjectDirectory();
            }

            public Class<? extends FileObject> type(MakeProject obj) {
                return FileObject.class;
            }

            public String id(MakeProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(MakeProject obj) {
                return obj.toString();
            }
        });
        ic.add((Object)this.project, (InstanceContent.Convertor)new InstanceContent.Convertor<MakeProject, DataObject>(){

            public DataObject convert(MakeProject obj) {
                try {
                    FileObject fo = obj.getProjectDirectory();
                    return fo == null ? null : DataObject.find((FileObject)fo);
                }
                catch (DataObjectNotFoundException ex) {
                    return null;
                }
            }

            public Class<? extends DataObject> type(MakeProject obj) {
                return DataObject.class;
            }

            public String id(MakeProject obj) {
                FileObject fo = obj.getProjectDirectory();
                return fo == null ? "" : fo.getPath();
            }

            public String displayName(MakeProject obj) {
                return obj.toString();
            }
        });
    }

    boolean isFindPathMode() {
        return this.findPathMode.get();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Node findPath(Node root, Object target) {
        Node returnNode = null;
        Project rootProject = (Project)root.getLookup().lookup(Project.class);
        if (rootProject == null) {
            return null;
        }
        if (target instanceof DataObject) {
            target = ((DataObject)target).getPrimaryFile();
        }
        if (!(target instanceof FileObject)) {
            return null;
        }
        FileObject fo = (FileObject)target;
        if (!this.gotMakeConfigurationDescriptor() || !fo.isValid()) {
            return null;
        }
        MakeConfigurationDescriptor makeConfigurationDescriptor = this.getMakeConfigurationDescriptor();
        Item item = makeConfigurationDescriptor.findItemByFileObject(fo);
        if (item == null && (item = makeConfigurationDescriptor.findExternalItemByPath(fo.getPath())) == null && (item = makeConfigurationDescriptor.findItemByPathSlowly(fo.getPath())) == null) {
            return null;
        }
        if (this.findPathMode.compareAndSet(false, true)) {
            try {
                Node folderNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
                if (folderNode != null) {
                    Item nodeItem;
                    Node[] nodes = folderNode.getChildren().getNodes(true);
                    int index = 0;
                    for (index = 0; index < nodes.length && (nodeItem = (Item)nodes[index].getValue("Item")) != item; ++index) {
                    }
                    if (nodes.length > 0 && index < nodes.length) {
                        returnNode = nodes[index];
                    }
                }
            }
            finally {
                this.findPathMode.set(false);
            }
        }
        return returnNode;
    }

    private static Node findFolderNode(Node root, Folder folder) {
        if (root.getValue("Folder") == folder) {
            return root;
        }
        Folder parent = folder.getParent();
        if (parent == null) {
            return root;
        }
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, parent);
        if (parentNode == null) {
            return null;
        }
        Node[] nodes = parentNode.getChildren().getNodes(true);
        for (int i = 0; i < nodes.length; ++i) {
            if (nodes[i].getValue("Folder") != folder) continue;
            return nodes[i];
        }
        return null;
    }

    private static Node findItemNode(Node root, Item item) {
        Node parentNode = MakeLogicalViewProvider.findFolderNode(root, item.getFolder());
        if (parentNode != null) {
            Node[] nodes = parentNode.getChildren().getNodes(true);
            for (int i = 0; i < nodes.length; ++i) {
                if (nodes[i].getValue("Item") != item) continue;
                return nodes[i];
            }
        }
        return null;
    }

    public static void setVisible(Project project, Folder folder) {
        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        Node projectRoot = MakeLogicalViewProvider.findProjectNode(rootNode, project);
        if (projectRoot == null) {
            return;
        }
        Node folderNode = MakeLogicalViewProvider.findFolderNode(projectRoot, folder);
        try {
            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(new Node[]{folderNode});
        }
        catch (Exception e) {
            // empty catch block
        }
    }

    public static void setVisible(final Project project, final Item[] items) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                        ArrayList<Node> nodes = new ArrayList<Node>();
                        for (int i = 0; i < items.length; ++i) {
                            Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                            if (root == null) continue;
                            nodes.add(MakeLogicalViewProvider.findItemNode(root, items[i]));
                        }
                        try {
                            ProjectTabBridge.getInstance().getExplorerManager().setSelectedNodes(nodes.toArray(new Node[0]));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                });
            }
        };
        BaseMakeViewChildren.postSetVisibleAction(runnable);
    }

    public static void checkForChangedName(final Project project) {
        if (CndUtils.isStandalone()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ProjectInformation pi;
                Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                if (root != null && (pi = ProjectUtils.getInformation((Project)project)) != null) {
                    root.setDisplayName(pi.getDisplayName());
                }
            }
        });
    }

    public static void checkForChangedViewItemNodes(final Project project, ConfigurationDescriptorProvider.Delta delta) {
        if (CndUtils.isStandalone()) {
            return;
        }
        if (delta.getAdded().isEmpty() && delta.getDeleted().isEmpty() && delta.getExcluded().isEmpty() && delta.getIncluded().isEmpty() && delta.getReplaced().isEmpty()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                MakeLogicalViewProvider.checkForChangedViewItemNodes(project);
            }
        });
    }

    public static void checkForChangedViewItemNodes(final Project project, Folder folder, final Item item) {
        if (CndUtils.isStandalone()) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Object o;
                Node node;
                if (item == null) {
                    MakeLogicalViewProvider.checkForChangedViewItemNodes(project);
                    return;
                }
                Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
                Node root = MakeLogicalViewProvider.findProjectNode(rootNode, project);
                if (root != null && (node = MakeLogicalViewProvider.findItemNode(root, item)) instanceof FilterNode && (o = node.getLookup().lookup(ViewItemNode.class)) != null) {
                    ((ChangeListener)o).stateChanged(null);
                }
            }
        });
    }

    private static void checkForChangedViewItemNodes(Project project) {
        Node rootNode = ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        MakeLogicalViewProvider.checkForChangedViewItemNodes(MakeLogicalViewProvider.findProjectNode(rootNode, project));
    }

    private static void checkForChangedViewItemNodes(Node root) {
        new ChangedViewItemNodesChecker(root).execute();
    }

    public static void refreshBrokenItems(Project project) {
        Node rootNode = MakeLogicalViewProvider.getRootNode();
        if (rootNode != null) {
            MakeLogicalViewProvider.refreshBrokenItemsImpl(MakeLogicalViewProvider.findProjectNode(rootNode, project));
        }
    }

    private static void refreshBrokenItemsImpl(Node root) {
        if (root != null) {
            if (root.isLeaf()) {
                BrokenViewItemNode brokenItem = (BrokenViewItemNode)((Object)root.getLookup().lookup(BrokenViewItemNode.class));
                if (brokenItem != null) {
                    brokenItem.refresh();
                }
            } else {
                for (Node node : root.getChildren().getNodes(true)) {
                    MakeLogicalViewProvider.refreshBrokenItemsImpl(node);
                }
            }
        }
    }

    private static Node getRootNode() {
        if (SwingUtilities.isEventDispatchThread()) {
            return ProjectTabBridge.getInstance().getExplorerManager().getRootContext();
        }
        final Node[] root = new Node[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                @Override
                public void run() {
                    root[0] = MakeLogicalViewProvider.getRootNode();
                }
            });
        }
        catch (InterruptedException ex) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return root[0];
    }

    private static Node findProjectNode(Node root, Project p) {
        Node[] n = root.getChildren().getNodes(true);
        Lookup.Template t = new Lookup.Template(null, null, (Object)p);
        for (int cntr = 0; cntr < n.length; ++cntr) {
            if (n[cntr].getLookup().lookupItem(t) == null) continue;
            return n[cntr];
        }
        return null;
    }

    public boolean hasBrokenLinks() {
        List<BrokenLinks.BrokenLink> errs = BrokenLinks.getBrokenLinks(this.project);
        return !errs.isEmpty();
    }

    private static Image loadToolTipImage(String imgResouce, String textResource) {
        Image img = ImageUtilities.loadImage((String)imgResouce);
        img = ImageUtilities.assignToolTipToImage((Image)img, (String)("<img src=\"" + MakeLogicalViewRootNode.class.getClassLoader().getResource(imgResouce) + "\">&nbsp;" + NbBundle.getMessage(MakeLogicalViewRootNode.class, (String)textResource)));
        return img;
    }

    static String getShortDescription(MakeProject project) {
        String prjDirDispName = FileUtil.getFileDisplayName((FileObject)project.getProjectDirectory());
        DevelopmentHostConfiguration devHost = project.getDevelopmentHostConfiguration();
        if (devHost == null || devHost.isLocalhost()) {
            return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node", (Object)prjDirDispName);
        }
        return NbBundle.getMessage(MakeLogicalViewProvider.class, (String)"HINT_project_root_node_on_host", (Object)prjDirDispName, (Object)devHost.getDisplayName(true));
    }

    MakeProject getProject() {
        return this.project;
    }

    MakeConfigurationDescriptor getMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        MakeConfigurationDescriptor makeConfigurationDescriptor = pdp.getConfigurationDescriptor();
        return makeConfigurationDescriptor;
    }

    boolean gotMakeConfigurationDescriptor() {
        ConfigurationDescriptorProvider pdp = (ConfigurationDescriptorProvider)this.project.getLookup().lookup(ConfigurationDescriptorProvider.class);
        return pdp.gotDescriptor();
    }

    private static class ChangedViewItemNodesChecker
    extends SwingWorker<Collection<ChangeListener>, Object> {
        private Node root = null;

        public ChangedViewItemNodesChecker(Node root) {
            this.root = root;
        }

        @Override
        protected Collection<ChangeListener> doInBackground() throws Exception {
            LinkedList<ChangeListener> result = new LinkedList<ChangeListener>();
            this.doWork(this.root, result);
            return result;
        }

        private void doWork(Node current, List<ChangeListener> result) {
            if (current != null) {
                for (Node node : current.getChildren().getNodes(true)) {
                    Object o;
                    this.doWork(node, result);
                    if (!(node instanceof FilterNode) || (o = node.getLookup().lookup(ViewItemNode.class)) == null) continue;
                    result.add((ChangeListener)o);
                }
            }
        }

        @Override
        protected void done() {
            try {
                for (ChangeListener listener : (Collection)this.get()) {
                    listener.stateChanged(null);
                }
            }
            catch (InterruptedException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ExecutionException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
    }
}

