/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.packaging;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.openide.util.NbBundle;

public class RPMPackager
implements PackagerDescriptor {
    public static final String PACKAGER_NAME = "RPM";

    @Override
    public String getName() {
        return PACKAGER_NAME;
    }

    @Override
    public String getDisplayName() {
        return RPMPackager.getString(PACKAGER_NAME);
    }

    @Override
    public boolean hasInfoList() {
        return true;
    }

    @Override
    public List<PackagerInfoElement> getDefaultInfoList(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        ArrayList<PackagerInfoElement> infoList = new ArrayList<PackagerInfoElement>();
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Summary", "Sumary...", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Name", packagingConfiguration.getOutputName(), true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Version", "1.0", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Release", "1", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "Group", "Applications/System", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "License", "BSD-type", true, true));
        infoList.add(new PackagerInfoElement(PACKAGER_NAME, "%description", "Description...", true, true));
        return infoList;
    }

    @Override
    public List<String> getOptionalInfoList() {
        ArrayList<String> entryComboBox = new ArrayList<String>();
        entryComboBox.add("Patch");
        entryComboBox.add("%changelog");
        entryComboBox.add("%pre");
        entryComboBox.add("%post");
        entryComboBox.add("%preun");
        entryComboBox.add("%postun");
        return entryComboBox;
    }

    @Override
    public String getDefaultOptions() {
        return "";
    }

    @Override
    public String getDefaultTool() {
        return "rpmbuild";
    }

    @Override
    public boolean isOutputAFolder() {
        return true;
    }

    @Override
    public String getOutputFileName(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return null;
    }

    @Override
    public String getOutputFileSuffix() {
        return null;
    }

    @Override
    public String getTopDir(MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) {
        return "/usr";
    }

    @Override
    public boolean supportsGroupAndOwner() {
        return true;
    }

    @Override
    public PackagerDescriptor.ShellSciptWriter getShellFileWriter() {
        return new ScriptWriter();
    }

    private static String getString(String s) {
        return NbBundle.getMessage(RPMPackager.class, (String)s);
    }

    public static class ScriptWriter
    implements PackagerDescriptor.ShellSciptWriter {
        @Override
        public void writeShellScript(BufferedWriter bw, MakeConfiguration makeConfiguration, PackagingConfiguration packagingConfiguration) throws IOException {
            this.writePackagingScriptBodyRPM(bw, makeConfiguration);
        }

        private void writePackagingScriptBodyRPM(BufferedWriter bw, MakeConfiguration conf) throws IOException {
            PackagingConfiguration packagingConfiguration = conf.getPackagingConfiguration();
            List<PackagerFileElement> fileList = packagingConfiguration.getFiles().getValue();
            String output = packagingConfiguration.getOutputValue();
            String tmprpmdir = "/tmp/cnd/rpms";
            bw.write("# Copy files and create directories and links\n");
            for (PackagerFileElement elem : fileList) {
                bw.write("cd \"${TOP}\"\n");
                if (elem.getType() == PackagerFileElement.FileType.FILE) {
                    String string = CndPathUtilitities.getDirName((String)conf.getPackagingConfiguration().expandMacros(elem.getTo()));
                    if (string != null && string.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + string + "\"\n");
                    }
                    bw.write("copyFileToTmpDir \"" + elem.getFrom() + "\" \"${NBTMPDIR}/" + elem.getTo() + "\" 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.DIRECTORY) {
                    bw.write("makeDirectory  \"${NBTMPDIR}/" + elem.getTo() + "\"" + " 0" + elem.getPermission() + "\n");
                } else if (elem.getType() == PackagerFileElement.FileType.SOFTLINK) {
                    String string = CndPathUtilitities.getDirName((String)elem.getTo());
                    String toName = CndPathUtilitities.getBaseName((String)elem.getTo());
                    if (string != null && string.length() >= 0) {
                        bw.write("makeDirectory \"${NBTMPDIR}/" + string + "\"" + "\n");
                    }
                    bw.write("cd \"${NBTMPDIR}/" + string + "\"" + "\n");
                    bw.write("ln -s \"" + elem.getFrom() + "\"" + " " + "\"" + toName + "\"" + "\n");
                } else if (elem.getType() != PackagerFileElement.FileType.UNKNOWN) assert (false);
                bw.write("\n");
            }
            bw.write("\n");
            bw.write("# Ensure proper rpm build environment\n");
            bw.write("RPMMACROS=~/.rpmmacros\n");
            bw.write("NBTOPDIR=" + tmprpmdir + "\n");
            bw.write("\n");
            bw.write("if [ ! -f ${RPMMACROS} ]\n");
            bw.write("then\n");
            bw.write("    touch ${RPMMACROS}\n");
            bw.write("fi\n");
            bw.write("\n");
            bw.write("TOPDIR=`grep _topdir ${RPMMACROS}`\n");
            bw.write("if [ \"$TOPDIR\" == \"\" ]\n");
            bw.write("then\n");
            bw.write("    echo \"**********************************************************************************************************\"\n");
            bw.write("    echo Warning: rpm build environment updated:\n");
            bw.write("    echo \\\"%_topdir ${NBTOPDIR}\\\" added to ${RPMMACROS}\n");
            bw.write("    echo \"**********************************************************************************************************\"\n");
            bw.write("    echo %_topdir ${NBTOPDIR} >> ${RPMMACROS}\n");
            bw.write("fi  \n");
            bw.write("mkdir -p ${NBTOPDIR}/RPMS\n");
            bw.write("\n");
            bw.write("# Create spec file\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("SPEC_FILE=${NBTMPDIR}/../${OUTPUT_BASENAME}.spec\n");
            bw.write("rm -f ${SPEC_FILE}\n");
            bw.write("\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("echo BuildRoot: ${TOP}/${NBTMPDIR} >> ${SPEC_FILE}\n");
            List<PackagerInfoElement> infoList = packagingConfiguration.getHeaderSubList(RPMPackager.PACKAGER_NAME);
            for (PackagerInfoElement packagerInfoElement : infoList) {
                if (packagerInfoElement.getName().startsWith("%")) {
                    bw.write("echo '" + packagerInfoElement.getName() + "' >> ${SPEC_FILE}\n");
                    String value = packagerInfoElement.getValue();
                    int i = 0;
                    int j = value.indexOf("\\n");
                    while (j >= 0) {
                        bw.write("echo '" + value.substring(i, j) + "' >> ${SPEC_FILE}\n");
                        i = j + 2;
                        j = value.indexOf("\\n", i);
                    }
                    if (i < value.length()) {
                        bw.write("echo '" + value.substring(i) + "' >> ${SPEC_FILE}\n");
                    }
                    bw.write("echo  >> ${SPEC_FILE}\n");
                    continue;
                }
                bw.write("echo '" + packagerInfoElement.getName() + ": " + packagingConfiguration.expandMacros(packagerInfoElement.getValue()) + "' >> ${SPEC_FILE}\n");
            }
            bw.write("echo '%files' >> ${SPEC_FILE}\n");
            for (PackagerFileElement packagerFileElement : fileList) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.FILE && packagerFileElement.getType() != PackagerFileElement.FileType.SOFTLINK) continue;
                bw.write("echo \\\"/" + packagerFileElement.getTo() + "\\\" >> ${SPEC_FILE}\n");
            }
            bw.write("echo '%dir' >> ${SPEC_FILE}\n");
            for (PackagerFileElement packagerFileElement : fileList) {
                if (packagerFileElement.getType() != PackagerFileElement.FileType.DIRECTORY) continue;
                bw.write("echo \\\"/" + packagerFileElement.getTo() + "\\\" >> ${SPEC_FILE}\n");
            }
            bw.write("\n");
            bw.write("# Create RPM Package\n");
            bw.write("cd \"${TOP}\"\n");
            bw.write("LOG_FILE=${NBTMPDIR}/../${OUTPUT_BASENAME}.log\n");
            if (packagingConfiguration.getOptionsValue().contains("--buildroot")) {
                bw.write(packagingConfiguration.getToolValue() + " " + packagingConfiguration.getOptionsValue() + " -bb ${SPEC_FILE} > ${LOG_FILE}\n");
            } else {
                bw.write(packagingConfiguration.getToolValue() + " --buildroot ${TOP}/${NBTMPDIR} " + packagingConfiguration.getOptionsValue() + " -bb ${SPEC_FILE} > ${LOG_FILE}\n");
            }
            bw.write("makeDirectory \"${NBTMPDIR}\"\n");
            bw.write("checkReturnCode\n");
            bw.write("cat ${LOG_FILE}\n");
            bw.write("RPM_PATH=`cat $LOG_FILE | grep '\\.rpm' | tail -1 |awk -F: '{ print $2 }'`\n");
            bw.write("RPM_NAME=`basename ${RPM_PATH}`\n");
            bw.write("mv ${RPM_PATH} " + packagingConfiguration.getOutputValue() + "\n");
            bw.write("checkReturnCode\n");
            bw.write("echo RPM: " + packagingConfiguration.getOutputValue() + "/" + "${RPM_NAME}" + "\n");
            bw.write("\n");
        }
    }
}

