/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations.ui;

import java.awt.Component;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.ui.utils.StringListPanel;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.nodes.PropertySupport;
import org.openide.util.HelpCtx;

public abstract class StringListNodeProp
extends PropertySupport<List> {
    private VectorConfiguration<String> configuration;
    private BooleanConfiguration inheritValues;
    private String[] texts;
    boolean addPathPanel;
    private HelpCtx helpCtx;

    public StringListNodeProp(VectorConfiguration<String> configuration, BooleanConfiguration inheritValues, String[] texts, boolean addPathPanel, HelpCtx helpCtx) {
        super(texts[0], List.class, texts[1], texts[2], true, true);
        this.configuration = configuration;
        this.inheritValues = inheritValues;
        this.texts = texts;
        this.addPathPanel = addPathPanel;
        this.helpCtx = helpCtx;
    }

    public String getHtmlDisplayName() {
        if (this.configuration.getModified()) {
            return "<b>" + this.getDisplayName();
        }
        return null;
    }

    public List getValue() {
        return this.configuration.getValue();
    }

    public void setValue(List v) {
        this.configuration.setValue(v);
    }

    public void restoreDefaultValue() {
        this.configuration.reset();
    }

    public boolean supportsDefaultValue() {
        return true;
    }

    public boolean isDefaultValue() {
        return this.configuration.getValue().isEmpty();
    }

    public PropertyEditor getPropertyEditor() {
        ArrayList<String> clone = new ArrayList<String>();
        clone.addAll(this.configuration.getValue());
        return new StringEditor(clone);
    }

    protected abstract List<String> convertToList(String var1);

    protected abstract String convertToString(List<String> var1);

    private class StringEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private List<String> value;
        private PropertyEnv env;

        public StringEditor(List<String> value) {
            this.value = value;
        }

        @Override
        public void setAsText(String text) {
            this.setValue(StringListNodeProp.this.convertToList(text.trim()));
        }

        @Override
        public String getAsText() {
            return StringListNodeProp.this.convertToString(this.value);
        }

        @Override
        public Component getCustomEditor() {
            String text = null;
            if (StringListNodeProp.this.inheritValues != null) {
                text = StringListNodeProp.this.texts[4];
            }
            return new StringListPanel(StringListNodeProp.this.texts[3], this.value, StringListNodeProp.this.addPathPanel, StringListNodeProp.this.inheritValues, text, this, this.env, StringListNodeProp.this.helpCtx);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv env) {
            this.env = env;
        }
    }
}

