/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.VersionException;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.configurations.CommonConfigurationXMLCodec;
import org.xml.sax.Attributes;

public class ItemXMLCodec
extends XMLDecoder
implements XMLEncoder {
    private ItemConfiguration item;
    public static final String ITEM_ELEMENT = "item";
    public static final String PATH_ATTR = "path";
    public static final String EXCLUDED_ATTR = "ex";
    public static final String TOOL_ATTR = "tool";
    public static final String FLAVOR_ATTR = "flavor";
    public static final String FLAVOR2_ATTR = "flavor2";
    public static final String EXCLUDED_ELEMENT = "excluded";
    public static final String TOOL_ELEMENT = "tool";
    public static final String ITEM_EXCLUDED_ELEMENT = "itemExcluded";
    public static final String ITEM_TOOL_ELEMENT = "itemTool";
    public static final String DEBUGGING_ELEMENT = "justfordebugging";
    public static final String TRUE_VALUE = "true";
    public static final String FALSE_VALUE = "false";

    public ItemXMLCodec(ItemConfiguration item) {
        this.item = item;
    }

    public String tag() {
        return this.item.getId();
    }

    public void start(Attributes atts) throws VersionException {
        String what = ITEM_ELEMENT;
        int maxVersion = 1;
        this.checkVersion(atts, what, maxVersion);
    }

    public void end() {
        this.item.clearChanged();
    }

    public void startElement(String element, Attributes atts) {
    }

    public void endElement(String element, String currentText) {
    }

    public void encode(XMLEncoderStream xes) {
        if (this.item.isDefaultConfiguration()) {
            return;
        }
        PredefinedToolKind tool = this.item.getTool();
        xes.elementOpen(ITEM_ELEMENT, new AttrValuePair[]{new AttrValuePair(PATH_ATTR, this.item.getItem().getPath()), new AttrValuePair(EXCLUDED_ATTR, "" + this.item.getExcluded().getValue()), new AttrValuePair("tool", "" + tool.ordinal()), new AttrValuePair(FLAVOR2_ATTR, "" + this.item.getLanguageFlavor().toExternal())});
        if (tool == PredefinedToolKind.CCompiler) {
            CommonConfigurationXMLCodec.writeCCompilerConfiguration(xes, this.item.getCCompilerConfiguration(), 2);
            if (this.item.isProCFile()) {
                CommonConfigurationXMLCodec.writeCustomToolConfiguration(xes, this.item.getCustomToolConfiguration());
            }
        } else if (tool == PredefinedToolKind.CCCompiler) {
            CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xes, this.item.getCCCompilerConfiguration(), 2);
            if (this.item.isProCFile()) {
                CommonConfigurationXMLCodec.writeCustomToolConfiguration(xes, this.item.getCustomToolConfiguration());
            }
        } else if (tool == PredefinedToolKind.FortranCompiler) {
            CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xes, this.item.getFortranCompilerConfiguration());
        } else if (tool == PredefinedToolKind.CustomTool) {
            CommonConfigurationXMLCodec.writeCustomToolConfiguration(xes, this.item.getCustomToolConfiguration());
        }
        xes.elementClose(ITEM_ELEMENT);
    }
}

