/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.RemoteFileUtil;
import org.netbeans.modules.cnd.api.xml.XMLDocReader;
import org.netbeans.modules.cnd.makeproject.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.configurations.AuxConfigurationXMLCodec;
import org.netbeans.modules.cnd.makeproject.configurations.ConfigurationXMLCodec;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.xml.sax.Attributes;

public class ConfigurationXMLReader
extends XMLDocReader {
    private static int DEPRECATED_VERSIONS = 26;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private final FileObject projectDirectory;
    private final Project project;
    private static final RequestProcessor REQUEST_PROCESSOR = new RequestProcessor("ConfigurationXMLReader", 10);
    private static final boolean TRACE_LONG_LOADING = false;

    public ConfigurationXMLReader(Project project, FileObject projectDirectory) {
        this.project = project;
        this.projectDirectory = projectDirectory;
    }

    public MakeConfigurationDescriptor read(final String relativeOffset) throws IOException {
        FileObject configurationBaseFO;
        FileObject xml;
        String tag;
        FileObject fo = this.projectDirectory.getFileObject("nbproject/configurations.xml");
        if (fo == null) {
            tag = "projectDescriptor";
            xml = this.projectDirectory.getFileObject("nbproject/projectDescriptor.xml");
        } else {
            tag = "configurationDescriptor";
            xml = fo;
        }
        if (xml == null) {
            this.displayErrorDialog();
            return null;
        }
        FileObject fileObject = configurationBaseFO = this.project == null ? this.projectDirectory : RemoteFileUtil.getProjectSourceBaseFileObject((Project)this.project);
        if (configurationBaseFO == null) {
            throw new FileNotFoundException("File does not exist");
        }
        final MakeConfigurationDescriptor configurationDescriptor = new MakeConfigurationDescriptor(this.projectDirectory, configurationBaseFO);
        RequestProcessor.Task task = REQUEST_PROCESSOR.post((Runnable)new NamedRunnable("Reading project configuraion"){

            protected void runImpl() {
                try {
                    if (ConfigurationXMLReader.this._read(relativeOffset, tag, xml, configurationDescriptor) == null) {
                        configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                    }
                }
                catch (IOException ex) {
                    configurationDescriptor.setState(ConfigurationDescriptor.State.BROKEN);
                }
            }
        });
        configurationDescriptor.setInitTask(task);
        return configurationDescriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ConfigurationDescriptor _read(String relativeOffset, String tag, FileObject xml, final MakeConfigurationDescriptor configurationDescriptor) throws IOException {
        int activeIndex;
        boolean success;
        ConfigurationXMLCodec decoder = new ConfigurationXMLCodec(tag, this.projectDirectory, configurationDescriptor, relativeOffset);
        this.registerXMLDecoder(decoder);
        InputStream inputStream = null;
        try {
            inputStream = xml.getInputStream();
            success = this.read(inputStream, xml.getPath());
            if (this.getMasterComment() != null && this.project instanceof MakeProject) {
                ((MakeProject)this.project).setConfigurationXMLComment(this.getMasterComment());
            }
        }
        finally {
            this.deregisterXMLDecoder(decoder);
            if (inputStream != null) {
                inputStream.close();
            }
        }
        if (!success) {
            this.displayErrorDialog();
            return null;
        }
        xml = this.projectDirectory.getFileObject("nbproject/private/configurations.xml");
        if (xml != null) {
            AuxConfigurationXMLCodec auxDecoder = new AuxConfigurationXMLCodec(tag, configurationDescriptor);
            this.registerXMLDecoder(auxDecoder);
            inputStream = null;
            try {
                inputStream = xml.getInputStream();
                success = this.read(inputStream, this.projectDirectory.getName());
            }
            finally {
                this.deregisterXMLDecoder(auxDecoder);
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            if (!success) {
                return null;
            }
        }
        if (this.project != null && (activeIndex = ((MakeProject)this.project).getActiveConfigurationIndexFromPrivateXML()) >= 0) {
            configurationDescriptor.getConfs().setActive(activeIndex);
        }
        Item[] projectItems = configurationDescriptor.getProjectItems();
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            for (Item item : projectItems) {
                if (item.getItemConfiguration(configuration) != null) continue;
                ItemConfiguration itemConfiguration = new ItemConfiguration(configuration, item);
                configuration.addAuxObject(itemConfiguration);
                if (configurationDescriptor.getVersion() < 88) continue;
                itemConfiguration.getExcluded().setValue(true);
            }
        }
        boolean schemeWithExcludedItems = false;
        if (configurationDescriptor.getVersion() >= 0 && configurationDescriptor.getVersion() < 88) {
            schemeWithExcludedItems = true;
        }
        this.prepareFoldersTask(configurationDescriptor, schemeWithExcludedItems);
        configurationDescriptor.setState(ConfigurationDescriptor.State.READY);
        boolean isMakefileProject = false;
        for (Configuration configuration : configurationDescriptor.getConfs().getConfigurations()) {
            MakeConfiguration makeConfiguration = (MakeConfiguration)configuration;
            if (!makeConfiguration.isMakefileConfiguration()) continue;
            isMakefileProject = true;
            break;
        }
        FileObject makeImpl = this.projectDirectory.getFileObject("nbproject/Makefile-impl.mk");
        configurationDescriptor.setModified(!isMakefileProject && makeImpl == null || relativeOffset != null);
        if (configurationDescriptor.getVersion() >= 0 && configurationDescriptor.getVersion() <= DEPRECATED_VERSIONS) {
            final String message = NbBundle.getMessage(ConfigurationXMLReader.class, (String)"OLD_VERSION_WARNING", (Object)this.projectDirectory.getPath());
            if (CndUtils.isStandalone()) {
                System.err.print(message);
                System.err.println(NbBundle.getMessage(ConfigurationXMLReader.class, (String)"OLD_VERSION_WARNING_AUTO"));
                configurationDescriptor.setModified();
            } else {
                Runnable warning = new Runnable(){

                    @Override
                    public void run() {
                        NotifyDescriptor nd = new NotifyDescriptor((Object)message, NbBundle.getMessage(ConfigurationXMLReader.class, (String)"CONVERT_DIALOG_TITLE"), 0, 3, null, NotifyDescriptor.YES_OPTION);
                        Object ret = DialogDisplayer.getDefault().notify(nd);
                        if (ret == NotifyDescriptor.YES_OPTION) {
                            configurationDescriptor.setModified();
                        }
                    }
                };
                SwingUtilities.invokeLater(warning);
            }
        }
        if (configurationDescriptor.isModified()) {
            configurationDescriptor.setVersion(88);
        }
        ConfigurationDescriptorProvider.recordMetrics("USG_PROJECT_OPEN_CND", configurationDescriptor);
        return configurationDescriptor;
    }

    private void displayErrorDialog() {
    }

    private void prepareFoldersTask(final MakeConfigurationDescriptor configurationDescriptor, final boolean oldSchemeWasRestored) {
        RequestProcessor.Task task = REQUEST_PROCESSOR.create(new Runnable(){
            private volatile boolean restoreInOldScheme;
            {
                this.restoreInOldScheme = oldSchemeWasRestored;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String postfix = configurationDescriptor.getBaseDir();
                String threadName = "Attach listeners and refresh content of all disk folders " + postfix;
                LOGGER.log(Level.FINE, "Start {0}", threadName);
                long time = System.currentTimeMillis();
                String oldName = Thread.currentThread().getName();
                try {
                    Thread.currentThread().setName(threadName);
                    List<Folder> firstLevelFolders = configurationDescriptor.getLogicalFolders().getFolders();
                    for (Folder f : firstLevelFolders) {
                        if (!f.isDiskFolder()) continue;
                        if (this.restoreInOldScheme) {
                            LOGGER.log(Level.FINE, "Restore based on old scheme {0}", f);
                            this.restoreInOldScheme = false;
                            f.refreshDiskFolderAfterRestoringOldScheme();
                        } else {
                            LOGGER.log(Level.FINE, "Restore based on new scheme {0}", f);
                            f.refreshDiskFolder();
                        }
                        f.attachListeners();
                    }
                    LOGGER.log(Level.FINE, "End attach listeners and refresh content of all disk folders, time {0}ms. {1}", new Object[]{System.currentTimeMillis() - time, postfix});
                }
                finally {
                    Thread.currentThread().setName(oldName);
                }
            }
        });
        configurationDescriptor.setFoldersTask(task);
    }

    protected String tag() {
        return null;
    }

    public void start(Attributes atts) {
    }

    public void end() {
    }

    public void startElement(String name, Attributes atts) {
    }

    public void endElement(String name, String currentText) {
    }
}

