/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.configurations;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.modules.cnd.api.xml.AttrValuePair;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoderStream;
import org.netbeans.modules.cnd.makeproject.api.MakeArtifact;
import org.netbeans.modules.cnd.makeproject.api.PackagerDescriptor;
import org.netbeans.modules.cnd.makeproject.api.PackagerFileElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerInfoElement;
import org.netbeans.modules.cnd.makeproject.api.PackagerManager;
import org.netbeans.modules.cnd.makeproject.api.configurations.ArchiverConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.AssemblerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.CodeAssistanceConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configurations;
import org.netbeans.modules.cnd.makeproject.api.configurations.CustomToolConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.FolderConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.FortranCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.ItemConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibrariesConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.LibraryItem;
import org.netbeans.modules.cnd.makeproject.api.configurations.LinkerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.api.configurations.PackagingConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.QmakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.RequiredProjectsConfiguration;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.HostInfo;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.openide.util.Exceptions;

public abstract class CommonConfigurationXMLCodec
extends XMLDecoder
implements XMLEncoder {
    public static final int VERSION_WITH_INVERTED_SERIALIZATION = 88;
    public static final int CURRENT_VERSION = 88;
    protected static final String PROJECT_DESCRIPTOR_ELEMENT = "projectDescriptor";
    protected static final String DEBUGGING_ELEMENT = "justfordebugging";
    public static final String CONFIGURATION_DESCRIPTOR_ELEMENT = "configurationDescriptor";
    protected static final String DEFAULT_CONF_ELEMENT = "defaultConf";
    public static final String CONFS_ELEMENT = "confs";
    public static final String CONF_ELEMENT = "conf";
    protected static final String DIRECTORY_PATH_ELEMENT = "directoryPath";
    protected static final String PATH_ELEMENT = "pElem";
    protected static final String FOLDER_PATH_ELEMENT = "folderPath";
    protected static final String SOURCE_FOLDERS_ELEMENT = "sourceFolders";
    protected static final String LOGICAL_FOLDER_ELEMENT = "logicalFolder";
    protected static final String DISK_FOLDER_ELEMENT = "df";
    protected static final String ITEM_PATH_ELEMENT = "itemPath";
    protected static final String ITEM_NAME_ELEMENT = "in";
    protected static final String PROJECT_MAKEFILE_ELEMENT = "projectmakefile";
    protected static final String REQUIRED_PROJECTS_ELEMENT = "requiredProjects";
    protected static final String SOURCE_ROOT_LIST_ELEMENT = "sourceRootList";
    protected static final String TEST_ROOT_LIST_ELEMENT = "testRootList";
    protected static final String SOURCE_FOLDERS_FILTER_ELEMENT = "sourceFolderFilter";
    protected static final String SOURCE_ENCODING_ELEMENT = "sourceEncoding";
    public static final String TOOLS_SET_ELEMENT = "toolsSet";
    public static final String DEVELOPMENT_SERVER_ELEMENT = "developmentServer";
    public static final String FIXED_SYNC_FACTORY_ELEMENT = "remoteSyncFactory";
    protected static final String REMOTE_MODE_ELEMENT = "remote-sources-mode";
    public static final String COMPILER_SET_ELEMENT = "compilerSet";
    protected static final String C_REQUIRED_ELEMENT = "cRequired";
    protected static final String CPP_REQUIRED_ELEMENT = "cppRequired";
    protected static final String FORTRAN_REQUIRED_ELEMENT = "fortranRequired";
    protected static final String ASSEMBLER_REQUIRED_ELEMENT = "assemblerRequired";
    public static final String PLATFORM_ELEMENT = "platform";
    protected static final String DEPENDENCY_CHECKING = "dependencyChecking";
    protected static final String REBUILD_PROP_CHANGED = "rebuildPropChanged";
    protected static final String NEO_CONF_ELEMENT = "neoConf";
    protected static final String COMPILE_TYPE_ELEMENT = "compileType";
    protected static final String EXT_CONF_ELEMENT = "extConf";
    protected static final String MAKEFILE_TYPE_ELEMENT = "makefileType";
    protected static final String MAKETOOL_ELEMENT = "makeTool";
    protected static final String BUILD_COMMAND_ELEMENT = "buildCommand";
    protected static final String BUILD_COMMAND_WORKING_DIR_ELEMENT = "buildCommandWorkingDir";
    protected static final String CLEAN_COMMAND_ELEMENT = "cleanCommand";
    protected static final String EXECUTABLE_PATH_ELEMENT = "executablePath";
    protected static final String COMMANDLINE_TOOL_ELEMENT = "commandlineTool";
    protected static final String ADDITIONAL_DEP_ELEMENT = "additionalDep";
    protected static final String ADDITIONAL_OPTIONS_ELEMENT = "additionalOptions";
    public static final String OUTPUT_ELEMENT = "output";
    protected static final String INHERIT_INC_VALUES_ELEMENT = "inheritIncValues";
    protected static final String INHERIT_PRE_VALUES_ELEMENT = "inheritPreValues";
    protected static final String INHERIT_UNDEF_VALUES_ELEMENT = "inheritUndefValues";
    protected static final String USE_LINKER_PKG_CONFIG_LIBRARIES = "useLinkerLibraries";
    protected static final String CODE_ASSISTANCE_ELEMENT = "codeAssistance";
    protected static final String BUILD_ANALAZYER_ELEMENT = "buildAnalyzer";
    protected static final String BUILD_ANALAZYER_TOOLS_ELEMENT = "buildAnalyzerTools";
    protected static final String CODE_ASSISTANCE_ENVIRONMENT_ELEMENT = "envVariables";
    protected static final String CODE_ASSISTANCE_TRANSIENT_MACROS_ELEMENT = "transientMacros";
    protected static final String INCLUDE_DIRECTORIES_ELEMENT = "includeDirectories";
    protected static final String INCLUDE_DIRECTORIES_ELEMENT2 = "incDir";
    protected static final String COMPILERTOOL_ELEMENT = "compilerTool";
    protected static final String DEBUGGING_SYMBOLS_ELEMENT = "debuggingSymbols";
    protected static final String OPTIMIZATION_LEVEL_ELEMENT = "optimizationLevel";
    protected static final String DEVELOPMENT_MODE_ELEMENT = "developmentMode";
    protected static final String COMMAND_LINE_ELEMENT = "commandLine";
    protected static final String STRIP_SYMBOLS_ELEMENT = "stripSymbols";
    protected static final String SIXTYFOUR_BITS_ELEMENT = "sixtyfourBits";
    protected static final String ARCHITECTURE_ELEMENT = "architecture";
    protected static final String STANDARD_ELEMENT = "standard";
    protected static final String PREPROCESSOR_ELEMENT = "preprocessor";
    protected static final String PREPROCESSOR_LIST_ELEMENT = "preprocessorList";
    protected static final String UNDEFS_LIST_ELEMENT = "undefinedList";
    protected static final String SUPRESS_WARNINGS_ELEMENT = "supressWarnings";
    protected static final String WARNING_LEVEL_ELEMENT = "warningLevel";
    protected static final String MT_LEVEL_ELEMENT = "mtLevel";
    protected static final String STANDARDS_EVOLUTION_ELEMENT = "standardsEvolution";
    protected static final String LANGUAGE_EXTENSION_ELEMENT = "languageExtension";
    protected static final String SUN_CCOMPILERTOOL_OLD_ELEMENT = "sunCCompilerTool";
    protected static final String CCOMPILERTOOL_ELEMENT = "cCompilerTool";
    protected static final String CCOMPILERTOOL_ELEMENT2 = "cTool";
    protected static final String CONFORMANCE_LEVEL_ELEMENT = "conformanceLevel";
    protected static final String CPP_STYLE_COMMENTS_ELEMENT = "cppstylecomments";
    protected static final String SUN_CCCOMPILERTOOL_OLD_ELEMENT = "sunCCCompilerTool";
    protected static final String CCCOMPILERTOOL_ELEMENT = "ccCompilerTool";
    protected static final String CCCOMPILERTOOL_ELEMENT2 = "ccTool";
    protected static final String COMPATIBILITY_MODE_ELEMENT = "compatibilityMode";
    protected static final String LIBRARY_LEVEL_ELEMENT = "libraryLevel";
    protected static final String FORTRANCOMPILERTOOL_ELEMENT = "fortranCompilerTool";
    protected static final String ASMTOOL_ELEMENT = "asmTool";
    protected static final String CUSTOMTOOL_ELEMENT = "customTool";
    protected static final String CUSTOMTOOL_COMMANDLINE_ELEMENT = "customToolCommandline";
    protected static final String CUSTOMTOOL_DESCRIPTION_ELEMENT = "customToolDescription";
    protected static final String CUSTOMTOOL_OUTPUTS_ELEMENT = "customToolOutputs";
    protected static final String CUSTOMTOOL_ADDITIONAL_DEP_ELEMENT = "customToolAdditionalDep";
    protected static final String LINKERTOOL_ELEMENT = "linkerTool";
    protected static final String LINKER_KPIC_ELEMENT = "linkerKpic";
    protected static final String LINKER_NORUNPATH_ELEMENT = "linkerNorunpath";
    protected static final String LINKER_ASSIGN_ELEMENT = "linkerAssign";
    protected static final String LINKER_ADD_LIB_ELEMENT = "linkerAddLib";
    protected static final String LINKER_DYN_SERCH_ELEMENT = "linkerDynSerch";
    protected static final String LINKER_LIB_ELEMENT = "linkerLib";
    protected static final String LINKER_LIB_ITEMS_ELEMENT = "linkerLibItems";
    protected static final String LINKER_LIB_PROJECT_ITEM_ELEMENT = "linkerLibProjectItem";
    protected static final String LINKER_LIB_STDLIB_ITEM_ELEMENT = "linkerLibStdlibItem";
    protected static final String LINKER_LIB_LIB_ITEM_ELEMENT = "linkerLibLibItem";
    protected static final String LINKER_LIB_FILE_ITEM_ELEMENT = "linkerLibFileItem";
    protected static final String LINKER_LIB_OPTION_ITEM_ELEMENT = "linkerOptionItem";
    public static final String MAKE_ARTIFACT_ELEMENT = "makeArtifact";
    protected static final String MAKE_ARTIFACT_PL_ELEMENT = "PL";
    protected static final String MAKE_ARTIFACT_CT_ELEMENT = "CT";
    protected static final String MAKE_ARTIFACT_CN_ELEMENT = "CN";
    protected static final String MAKE_ARTIFACT_AC_ELEMENT = "AC";
    protected static final String MAKE_ARTIFACT_BL_ELEMENT = "BL";
    protected static final String MAKE_ARTIFACT_WD_ELEMENT = "WD";
    protected static final String MAKE_ARTIFACT_BC_ELEMENT = "BC";
    protected static final String MAKE_ARTIFACT_CC_ELEMENT = "CC";
    public static final String MAKE_ARTIFACT_OP_ELEMENT = "OP";
    protected static final String ARCHIVERTOOL_ELEMENT = "archiverTool";
    protected static final String RANLIB_TOOL_ELEMENT = "ranlibTool";
    protected static final String ARCHIVERTOOL_RUN_RANLIB_ELEMENT = "runRanlib";
    protected static final String ARCHIVERTOOL_VERBOSE_ELEMENT = "archiverVerbose";
    protected static final String ARCHIVERTOOL_SUPRESS_ELEMENT = "archiverSupress";
    public static final String VERSION_ATTR = "version";
    protected static final String TYPE_ATTR = "type";
    protected static final String CUSTOMIZERID_ATTR = "customizerid";
    protected static final String KIND_ATTR = "kind";
    protected static final String NAME_ATTR = "name";
    protected static final String ROOT_ATTR = "root";
    protected static final String SET_ATTR = "set";
    protected static final String DISPLAY_NAME_ATTR = "displayName";
    protected static final String PROJECT_FILES_ATTR = "projectFiles";
    protected static final String VALUE_ATTR = "value";
    protected static final String MANDATORY_ATTR = "mandatory";
    protected static final String TO_ATTR = "to";
    protected static final String FROM_ATTR = "from";
    protected static final String PERM_ATTR = "perm";
    protected static final String OWNER_ATTR = "owner";
    protected static final String GROUP_ATTR = "group";
    protected static final String TRUE_VALUE = "true";
    protected static final String FALSE_VALUE = "false";
    protected static final String LIST_ELEMENT = "Elem";
    protected static final String VERBOSE_ELEMENT = "verbose";
    protected static final String PACK_ELEMENT = "packaging";
    protected static final String PACK_TYPE_ELEMENT = "packType";
    protected static final String PACK_FILES_LIST_ELEMENT = "packFileList";
    protected static final String PACK_FILE_LIST_ELEMENT = "packFileListElem";
    protected static final String PACK_INFOS_LIST_ELEMENT = "packInfoList";
    protected static final String PACK_INFO_LIST_ELEMENT = "packInfoListElem";
    protected static final String PACK_ADDITIONAL_INFOS_LIST_ELEMENT = "packAddInfosListElem";
    protected static final String PACK_TOPDIR_ELEMENT = "packTopDir";
    protected static final String QT_ELEMENT = "qt";
    protected static final String QT_DESTDIR_ELEMENT = "destdir";
    protected static final String QT_TARGET_ELEMENT = "target";
    protected static final String QT_VERSION_ELEMENT = "version";
    protected static final String QT_BUILD_MODE_ELEMENT = "buildMode";
    protected static final String QT_MODULES_ELEMENT = "modules";
    protected static final String QT_MOC_DIR_ELEMENT = "mocDir";
    protected static final String QT_RCC_DIR_ELEMENT = "rccDir";
    protected static final String QT_UI_DIR_ELEMENT = "uiDir";
    protected static final String QT_DEFS_LIST_ELEMENT = "defs";
    protected static final String QT_QMAKE_SPEC_ELEMENT = "qmakeSpec";
    private final ConfigurationDescriptor projectDescriptor;
    private final boolean publicLocation;
    public static final int PROJECT_LEVEL = 0;
    public static final int FOLDER_LEVEL = 1;
    public static final int ITEM_LEVEL = 2;
    private static final StringConverter EMPTY_CONVERTER = new StringConverter(){

        @Override
        public String convert(String orig) {
            return orig;
        }
    };

    protected CommonConfigurationXMLCodec(ConfigurationDescriptor projectDescriptor, boolean publicLocation) {
        this.projectDescriptor = projectDescriptor;
        this.publicLocation = publicLocation;
    }

    public void encode(XMLEncoderStream xes) {
        xes.elementOpen(CONFIGURATION_DESCRIPTOR_ELEMENT, 88);
        if (this.publicLocation) {
            this.writeLogicalFolders(xes);
            this.writeSourceRoots(xes);
        } else {
            this.writePrivatePhysicalFoldersForUnmanagedProject(xes);
        }
        xes.element(PROJECT_MAKEFILE_ELEMENT, ((MakeConfigurationDescriptor)this.projectDescriptor).getProjectMakefileName());
        this.writeConfsBlock(xes);
        xes.elementClose(CONFIGURATION_DESCRIPTOR_ELEMENT);
    }

    private void writeConfsBlock(XMLEncoderStream xes) {
        xes.elementOpen(CONFS_ELEMENT);
        Configurations confs = this.projectDescriptor.getConfs();
        for (int i = 0; i < confs.size(); ++i) {
            XMLEncoder encoder;
            ConfigurationAuxObject auxObject;
            int j;
            ConfigurationAuxObject[] profileAuxObjects;
            MakeConfiguration makeConfiguration = (MakeConfiguration)confs.getConf(i);
            if (makeConfiguration.isCustomConfiguration()) {
                xes.elementOpen(CONF_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + makeConfiguration.getName()), new AttrValuePair(TYPE_ATTR, "" + makeConfiguration.getConfigurationType().getValue()), new AttrValuePair(CUSTOMIZERID_ATTR, "" + makeConfiguration.getCustomizerId())});
            } else {
                xes.elementOpen(CONF_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + makeConfiguration.getName()), new AttrValuePair(TYPE_ATTR, "" + makeConfiguration.getConfigurationType().getValue())});
            }
            this.writeToolsSetBlock(xes, makeConfiguration);
            if (this.publicLocation) {
                if (makeConfiguration.isQmakeConfiguration()) {
                    this.writeQmakeConfiguration(xes, makeConfiguration.getQmakeConfiguration());
                }
                if (makeConfiguration.isMakefileConfiguration()) {
                    this.writeCodeAssistanceConfiguration(xes, makeConfiguration.getCodeAssistanceConfiguration());
                    this.writeMakefileProjectConfBlock(xes, makeConfiguration);
                } else {
                    this.writeCompiledProjectConfBlock(xes, makeConfiguration);
                }
                CommonConfigurationXMLCodec.writePackaging(xes, makeConfiguration.getPackagingConfiguration());
                profileAuxObjects = confs.getConf(i).getAuxObjects();
                for (j = 0; j < profileAuxObjects.length; ++j) {
                    auxObject = profileAuxObjects[j];
                    if (!this.publicallyVisible(auxObject)) continue;
                    encoder = auxObject.getXMLEncoder();
                    encoder.encode(xes);
                }
            } else {
                profileAuxObjects = confs.getConf(i).getAuxObjects();
                for (j = 0; j < profileAuxObjects.length; ++j) {
                    auxObject = profileAuxObjects[j];
                    if (auxObject.shared()) continue;
                    encoder = auxObject.getXMLEncoder();
                    encoder.encode(xes);
                }
            }
            xes.elementClose(CONF_ELEMENT);
        }
        xes.elementClose(CONFS_ELEMENT);
    }

    protected abstract void writeToolsSetBlock(XMLEncoderStream var1, MakeConfiguration var2);

    private void writeCompiledProjectConfBlock(XMLEncoderStream xes, MakeConfiguration makeConfiguration) {
        xes.elementOpen(COMPILE_TYPE_ELEMENT);
        CommonConfigurationXMLCodec.writeCCompilerConfiguration(xes, makeConfiguration.getCCompilerConfiguration(), 0);
        CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xes, makeConfiguration.getCCCompilerConfiguration(), 0);
        CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xes, makeConfiguration.getFortranCompilerConfiguration());
        CommonConfigurationXMLCodec.writeAsmCompilerConfiguration(xes, makeConfiguration.getAssemblerConfiguration());
        switch (makeConfiguration.getConfigurationType().getValue()) {
            case 1: 
            case 2: 
            case 4: 
            case 5: 
            case 7: 
            case 10: {
                CommonConfigurationXMLCodec.writeLinkerConfiguration(xes, makeConfiguration.getLinkerConfiguration());
                break;
            }
            case 3: 
            case 6: {
                CommonConfigurationXMLCodec.writeArchiverConfiguration(xes, makeConfiguration.getArchiverConfiguration());
            }
        }
        CommonConfigurationXMLCodec.writeRequiredProjects(xes, makeConfiguration.getRequiredProjectsConfiguration());
        xes.elementClose(COMPILE_TYPE_ELEMENT);
    }

    private void writeQmakeConfiguration(XMLEncoderStream xes, QmakeConfiguration qmake) {
        xes.elementOpen(QT_ELEMENT);
        if (qmake.getDestdir().getModified()) {
            xes.element(QT_DESTDIR_ELEMENT, qmake.getDestdirValue());
        }
        if (qmake.getTarget().getModified()) {
            xes.element(QT_TARGET_ELEMENT, qmake.getTargetValue());
        }
        if (qmake.getVersion().getModified()) {
            xes.element("version", qmake.getVersion().getValue());
        }
        if (qmake.getBuildMode().getModified()) {
            xes.element(QT_BUILD_MODE_ELEMENT, String.valueOf(qmake.getBuildMode().getValue()));
        }
        xes.element(QT_MODULES_ELEMENT, qmake.getEnabledModules());
        if (qmake.getMocDir().getModified()) {
            xes.element(QT_MOC_DIR_ELEMENT, qmake.getMocDir().getValue());
        }
        if (qmake.getRccDir().getModified()) {
            xes.element(QT_RCC_DIR_ELEMENT, qmake.getRccDir().getValue());
        }
        if (qmake.getUiDir().getModified()) {
            xes.element(QT_UI_DIR_ELEMENT, qmake.getUiDir().getValue());
        }
        if (qmake.getQmakeSpec().getModified()) {
            xes.element(QT_QMAKE_SPEC_ELEMENT, qmake.getQmakeSpec().getValue());
        }
        if (qmake.getCustomDefs().getModified()) {
            xes.elementOpen(QT_DEFS_LIST_ELEMENT);
            for (String line : qmake.getCustomDefs().getValue()) {
                xes.element(LIST_ELEMENT, line);
            }
            xes.elementClose(QT_DEFS_LIST_ELEMENT);
        }
        xes.elementClose(QT_ELEMENT);
    }

    private void writeMakefileProjectConfBlock(XMLEncoderStream xes, MakeConfiguration makeConfiguration) {
        xes.elementOpen(MAKEFILE_TYPE_ELEMENT);
        xes.elementOpen(MAKETOOL_ELEMENT);
        xes.element(BUILD_COMMAND_WORKING_DIR_ELEMENT, makeConfiguration.getMakefileConfiguration().getBuildCommandWorkingDir().getValue());
        xes.element(BUILD_COMMAND_ELEMENT, makeConfiguration.getMakefileConfiguration().getBuildCommand().getValue());
        xes.element(CLEAN_COMMAND_ELEMENT, makeConfiguration.getMakefileConfiguration().getCleanCommand().getValue());
        xes.element(EXECUTABLE_PATH_ELEMENT, makeConfiguration.getMakefileConfiguration().getOutput().getValue());
        CommonConfigurationXMLCodec.writeCCompilerConfiguration(xes, makeConfiguration.getCCompilerConfiguration(), 0);
        CommonConfigurationXMLCodec.writeCCCompilerConfiguration(xes, makeConfiguration.getCCCompilerConfiguration(), 0);
        CommonConfigurationXMLCodec.writeFortranCompilerConfiguration(xes, makeConfiguration.getFortranCompilerConfiguration());
        CommonConfigurationXMLCodec.writeAsmCompilerConfiguration(xes, makeConfiguration.getAssemblerConfiguration());
        xes.elementClose(MAKETOOL_ELEMENT);
        CommonConfigurationXMLCodec.writeRequiredProjects(xes, makeConfiguration.getRequiredProjectsConfiguration());
        xes.elementClose(MAKEFILE_TYPE_ELEMENT);
    }

    private void writePrivatePhysicalFoldersForUnmanagedProject(XMLEncoderStream xes) {
        Folder root = ((MakeConfigurationDescriptor)this.projectDescriptor).getLogicalFolders();
        boolean unmanaged = false;
        for (Folder folder : root.getFoldersAsArray()) {
            if (!folder.isDiskFolder()) continue;
            unmanaged = true;
            break;
        }
        if (!unmanaged) {
            return;
        }
        ArrayList<AttrValuePair> attrList = new ArrayList<AttrValuePair>();
        attrList.add(new AttrValuePair(NAME_ATTR, "" + root.getName()));
        attrList.add(new AttrValuePair(DISPLAY_NAME_ATTR, "" + root.getDisplayName()));
        attrList.add(new AttrValuePair(PROJECT_FILES_ATTR, "" + root.isProjectFiles()));
        if (root.getKind() == Folder.Kind.ROOT) {
            attrList.add(new AttrValuePair(KIND_ATTR, "" + (Object)((Object)root.getKind())));
        }
        if (root.getRoot() != null) {
            attrList.add(new AttrValuePair(ROOT_ATTR, "" + root.getRoot()));
        }
        xes.elementOpen(LOGICAL_FOLDER_ELEMENT, attrList.toArray(new AttrValuePair[attrList.size()]));
        Folder[] subfolders = root.getFoldersAsArray();
        for (int i = 0; i < subfolders.length; ++i) {
            if (!subfolders[i].isDiskFolder()) continue;
            this.writeDiskFolder(xes, subfolders[i], true);
        }
        Item[] items = root.getItemsAsArray();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            xes.element(ITEM_PATH_ELEMENT, item.getPath());
        }
        xes.elementClose(LOGICAL_FOLDER_ELEMENT);
    }

    private void writeLogicalFolders(XMLEncoderStream xes) {
        this.writeLogicalFolder(xes, ((MakeConfigurationDescriptor)this.projectDescriptor).getLogicalFolders(), 0);
    }

    private void writeLogicalFolder(XMLEncoderStream xes, Folder folder, int level) {
        Folder.Kind kind = folder.getKind();
        Folder.Kind storedKind = null;
        if (kind != null) {
            switch (kind) {
                case ROOT: 
                case TEST: 
                case IMPORTANT_FILES_FOLDER: 
                case TEST_LOGICAL_FOLDER: {
                    storedKind = kind;
                }
            }
        }
        ArrayList<AttrValuePair> attrList = new ArrayList<AttrValuePair>();
        attrList.add(new AttrValuePair(NAME_ATTR, "" + folder.getName()));
        attrList.add(new AttrValuePair(DISPLAY_NAME_ATTR, "" + folder.getDisplayName()));
        attrList.add(new AttrValuePair(PROJECT_FILES_ATTR, "" + folder.isProjectFiles()));
        if (storedKind != null) {
            attrList.add(new AttrValuePair(KIND_ATTR, "" + (Object)((Object)folder.getKind())));
        }
        if (folder.getRoot() != null) {
            attrList.add(new AttrValuePair(ROOT_ATTR, "" + folder.getRoot()));
        }
        xes.elementOpen(LOGICAL_FOLDER_ELEMENT, attrList.toArray(new AttrValuePair[attrList.size()]));
        Folder[] subfolders = folder.getFoldersAsArray();
        for (int i = 0; i < subfolders.length; ++i) {
            if (subfolders[i].isDiskFolder()) {
                this.writeDiskFolder(xes, subfolders[i], false);
                continue;
            }
            this.writeLogicalFolder(xes, subfolders[i], level + 1);
        }
        Item[] items = folder.getItemsAsArray();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            xes.element(ITEM_PATH_ELEMENT, item.getPath());
        }
        xes.elementClose(LOGICAL_FOLDER_ELEMENT);
    }

    private void writeDiskFolder(XMLEncoderStream xes, Folder folder, boolean privateLocation) {
        if (!privateLocation && !folder.hasAttributedItems()) {
            return;
        }
        ArrayList<AttrValuePair> attrList = new ArrayList<AttrValuePair>();
        if (folder.getRoot() != null) {
            attrList.add(new AttrValuePair(ROOT_ATTR, "" + folder.getRoot()));
        }
        attrList.add(new AttrValuePair(NAME_ATTR, "" + folder.getName()));
        xes.elementOpen(DISK_FOLDER_ELEMENT, attrList.toArray(new AttrValuePair[attrList.size()]));
        Folder[] subfolders = folder.getFoldersAsArray();
        for (int i = 0; i < subfolders.length; ++i) {
            this.writeDiskFolder(xes, subfolders[i], privateLocation);
        }
        Item[] items = folder.getItemsAsArray();
        for (int i = 0; i < items.length; ++i) {
            Item item = items[i];
            if (!privateLocation && !item.hasImportantAttributes()) continue;
            xes.element(ITEM_NAME_ELEMENT, item.getName());
        }
        xes.elementClose(DISK_FOLDER_ELEMENT);
    }

    private void writeSourceRoots(XMLEncoderStream xes) {
        MakeConfigurationDescriptor makeProjectDescriptor = (MakeConfigurationDescriptor)this.projectDescriptor;
        List<String> list = makeProjectDescriptor.getSourceRoots();
        if (list.size() > 0) {
            if (!makeProjectDescriptor.getFolderVisibilityQuery().getRegEx().equals("^(nbproject|build|test|tests)$")) {
                xes.element(SOURCE_FOLDERS_FILTER_ELEMENT, makeProjectDescriptor.getFolderVisibilityQuery().getRegEx());
            }
            xes.elementOpen(SOURCE_ROOT_LIST_ELEMENT);
            for (String l : list) {
                xes.element(LIST_ELEMENT, l);
            }
            xes.elementClose(SOURCE_ROOT_LIST_ELEMENT);
        }
        if ((list = makeProjectDescriptor.getTestRoots()).size() > 0) {
            xes.elementOpen(TEST_ROOT_LIST_ELEMENT);
            for (String l : list) {
                xes.element(LIST_ELEMENT, l);
            }
            xes.elementClose(TEST_ROOT_LIST_ELEMENT);
        }
    }

    public static void writeCCompilerConfiguration(XMLEncoderStream xes, CCompilerConfiguration cCompilerConfiguration, int kind) {
        ArrayList<String> sortedList;
        if (!cCompilerConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(CCOMPILERTOOL_ELEMENT2);
        if (cCompilerConfiguration.getDevelopmentMode().getModified()) {
            xes.element(DEVELOPMENT_MODE_ELEMENT, "" + cCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (cCompilerConfiguration.getStrip().getModified()) {
            xes.element(STRIP_SYMBOLS_ELEMENT, "" + cCompilerConfiguration.getStrip().getValue());
        }
        if (cCompilerConfiguration.getSixtyfourBits().getModified()) {
            xes.element(ARCHITECTURE_ELEMENT, "" + cCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (kind != 2 && cCompilerConfiguration.getCStandard().getModified()) {
            xes.element(STANDARD_ELEMENT, "" + cCompilerConfiguration.getCStandardExternal());
        }
        if (cCompilerConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, "" + cCompilerConfiguration.getTool().getValue());
        }
        if (cCompilerConfiguration.getIncludeDirectories().getModified()) {
            CommonConfigurationXMLCodec.writeDirectoriesWithConversion(xes, INCLUDE_DIRECTORIES_ELEMENT2, cCompilerConfiguration.getIncludeDirectories().getValue(), CommonConfigurationXMLCodec.getIncludeConverter(cCompilerConfiguration.getOwner()));
        }
        if (cCompilerConfiguration.getStandardsEvolution().getModified()) {
            xes.element(STANDARDS_EVOLUTION_ELEMENT, "" + cCompilerConfiguration.getStandardsEvolution().getValue());
        }
        if (cCompilerConfiguration.getLanguageExt().getModified()) {
            xes.element(LANGUAGE_EXTENSION_ELEMENT, "" + cCompilerConfiguration.getLanguageExt().getValue());
        }
        if (cCompilerConfiguration.getInheritIncludes().getModified()) {
            xes.element(INHERIT_INC_VALUES_ELEMENT, "" + cCompilerConfiguration.getInheritIncludes().getValue());
        }
        if (cCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + cCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (cCompilerConfiguration.getPreprocessorConfiguration().getModified()) {
            sortedList = new ArrayList<String>(cCompilerConfiguration.getPreprocessorConfiguration().getValue());
            CommonConfigurationXMLCodec.writeSortedListWithConversion(xes, PREPROCESSOR_LIST_ELEMENT, sortedList, CommonConfigurationXMLCodec.getMacroConverter(cCompilerConfiguration.getOwner()));
        }
        if (cCompilerConfiguration.getInheritPreprocessor().getModified()) {
            xes.element(INHERIT_PRE_VALUES_ELEMENT, "" + cCompilerConfiguration.getInheritPreprocessor().getValue());
        }
        if (cCompilerConfiguration.getUndefinedPreprocessorConfiguration().getModified()) {
            sortedList = new ArrayList<String>(cCompilerConfiguration.getUndefinedPreprocessorConfiguration().getValue());
            Collections.sort(sortedList);
            CommonConfigurationXMLCodec.writeList(xes, UNDEFS_LIST_ELEMENT, sortedList);
        }
        if (cCompilerConfiguration.getInheritUndefinedPreprocessor().getModified()) {
            xes.element(INHERIT_UNDEF_VALUES_ELEMENT, "" + cCompilerConfiguration.getInheritUndefinedPreprocessor().getValue());
        }
        if (cCompilerConfiguration.getUseLinkerLibraries().getModified()) {
            xes.element(USE_LINKER_PKG_CONFIG_LIBRARIES, "" + cCompilerConfiguration.getUseLinkerLibraries().getValue());
        }
        if (cCompilerConfiguration.getWarningLevel().getModified()) {
            xes.element(WARNING_LEVEL_ELEMENT, "" + cCompilerConfiguration.getWarningLevel().getValue());
        }
        if (cCompilerConfiguration.getMTLevel().getModified()) {
            xes.element(MT_LEVEL_ELEMENT, "" + cCompilerConfiguration.getMTLevel().getValue());
        }
        if (cCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(ADDITIONAL_DEP_ELEMENT, "" + cCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xes.elementClose(CCOMPILERTOOL_ELEMENT2);
    }

    public static void writeCCCompilerConfiguration(XMLEncoderStream xes, CCCompilerConfiguration ccCompilerConfiguration, int kind) {
        ArrayList<String> sortedList;
        if (!ccCompilerConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(CCCOMPILERTOOL_ELEMENT2);
        if (ccCompilerConfiguration.getDevelopmentMode().getModified()) {
            xes.element(DEVELOPMENT_MODE_ELEMENT, "" + ccCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (ccCompilerConfiguration.getStrip().getModified()) {
            xes.element(STRIP_SYMBOLS_ELEMENT, "" + ccCompilerConfiguration.getStrip().getValue());
        }
        if (ccCompilerConfiguration.getSixtyfourBits().getModified()) {
            xes.element(ARCHITECTURE_ELEMENT, "" + ccCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (kind != 2 && ccCompilerConfiguration.getCppStandard().getModified()) {
            xes.element(STANDARD_ELEMENT, "" + ccCompilerConfiguration.getCppStandardExternal());
        }
        if (ccCompilerConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, "" + ccCompilerConfiguration.getTool().getValue());
        }
        if (ccCompilerConfiguration.getIncludeDirectories().getModified()) {
            CommonConfigurationXMLCodec.writeDirectoriesWithConversion(xes, INCLUDE_DIRECTORIES_ELEMENT2, ccCompilerConfiguration.getIncludeDirectories().getValue(), CommonConfigurationXMLCodec.getIncludeConverter(ccCompilerConfiguration.getOwner()));
        }
        if (ccCompilerConfiguration.getStandardsEvolution().getModified()) {
            xes.element(STANDARDS_EVOLUTION_ELEMENT, "" + ccCompilerConfiguration.getStandardsEvolution().getValue());
        }
        if (ccCompilerConfiguration.getLanguageExt().getModified()) {
            xes.element(LANGUAGE_EXTENSION_ELEMENT, "" + ccCompilerConfiguration.getLanguageExt().getValue());
        }
        if (ccCompilerConfiguration.getInheritIncludes().getModified()) {
            xes.element(INHERIT_INC_VALUES_ELEMENT, "" + ccCompilerConfiguration.getInheritIncludes().getValue());
        }
        if (ccCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + ccCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (ccCompilerConfiguration.getPreprocessorConfiguration().getModified()) {
            sortedList = new ArrayList<String>(ccCompilerConfiguration.getPreprocessorConfiguration().getValue());
            CommonConfigurationXMLCodec.writeSortedListWithConversion(xes, PREPROCESSOR_LIST_ELEMENT, sortedList, CommonConfigurationXMLCodec.getMacroConverter(ccCompilerConfiguration.getOwner()));
        }
        if (ccCompilerConfiguration.getInheritPreprocessor().getModified()) {
            xes.element(INHERIT_PRE_VALUES_ELEMENT, "" + ccCompilerConfiguration.getInheritPreprocessor().getValue());
        }
        if (ccCompilerConfiguration.getUndefinedPreprocessorConfiguration().getModified()) {
            sortedList = new ArrayList<String>(ccCompilerConfiguration.getUndefinedPreprocessorConfiguration().getValue());
            Collections.sort(sortedList);
            CommonConfigurationXMLCodec.writeList(xes, UNDEFS_LIST_ELEMENT, sortedList);
        }
        if (ccCompilerConfiguration.getInheritUndefinedPreprocessor().getModified()) {
            xes.element(INHERIT_UNDEF_VALUES_ELEMENT, "" + ccCompilerConfiguration.getInheritUndefinedPreprocessor().getValue());
        }
        if (ccCompilerConfiguration.getUseLinkerLibraries().getModified()) {
            xes.element(USE_LINKER_PKG_CONFIG_LIBRARIES, "" + ccCompilerConfiguration.getUseLinkerLibraries().getValue());
        }
        if (ccCompilerConfiguration.getWarningLevel().getModified()) {
            xes.element(WARNING_LEVEL_ELEMENT, "" + ccCompilerConfiguration.getWarningLevel().getValue());
        }
        if (ccCompilerConfiguration.getMTLevel().getModified()) {
            xes.element(MT_LEVEL_ELEMENT, "" + ccCompilerConfiguration.getMTLevel().getValue());
        }
        if (ccCompilerConfiguration.getLibraryLevel().getModified()) {
            xes.element(LIBRARY_LEVEL_ELEMENT, "" + ccCompilerConfiguration.getLibraryLevel().getValue());
        }
        if (ccCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(ADDITIONAL_DEP_ELEMENT, "" + ccCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xes.elementClose(CCCOMPILERTOOL_ELEMENT2);
    }

    public static void writeFortranCompilerConfiguration(XMLEncoderStream xes, FortranCompilerConfiguration fortranCompilerConfiguration) {
        if (!fortranCompilerConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(FORTRANCOMPILERTOOL_ELEMENT);
        if (fortranCompilerConfiguration.getDevelopmentMode().getModified()) {
            xes.element(DEVELOPMENT_MODE_ELEMENT, "" + fortranCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (fortranCompilerConfiguration.getStrip().getModified()) {
            xes.element(STRIP_SYMBOLS_ELEMENT, "" + fortranCompilerConfiguration.getStrip().getValue());
        }
        if (fortranCompilerConfiguration.getSixtyfourBits().getModified()) {
            xes.element(ARCHITECTURE_ELEMENT, "" + fortranCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (fortranCompilerConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, "" + fortranCompilerConfiguration.getTool().getValue());
        }
        if (fortranCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + fortranCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        if (fortranCompilerConfiguration.getWarningLevel().getModified()) {
            xes.element(WARNING_LEVEL_ELEMENT, "" + fortranCompilerConfiguration.getWarningLevel().getValue());
        }
        if (fortranCompilerConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(ADDITIONAL_DEP_ELEMENT, "" + fortranCompilerConfiguration.getAdditionalDependencies().getValue());
        }
        xes.elementClose(FORTRANCOMPILERTOOL_ELEMENT);
    }

    public static void writeAsmCompilerConfiguration(XMLEncoderStream xes, AssemblerConfiguration asmCompilerConfiguration) {
        if (!asmCompilerConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(ASMTOOL_ELEMENT);
        if (asmCompilerConfiguration.getDevelopmentMode().getModified()) {
            xes.element(DEVELOPMENT_MODE_ELEMENT, "" + asmCompilerConfiguration.getDevelopmentMode().getValue());
        }
        if (asmCompilerConfiguration.getSixtyfourBits().getModified()) {
            xes.element(ARCHITECTURE_ELEMENT, "" + asmCompilerConfiguration.getSixtyfourBits().getValue());
        }
        if (asmCompilerConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, "" + asmCompilerConfiguration.getTool().getValue());
        }
        if (asmCompilerConfiguration.getWarningLevel().getModified()) {
            xes.element(WARNING_LEVEL_ELEMENT, "" + asmCompilerConfiguration.getWarningLevel().getValue());
        }
        if (asmCompilerConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + asmCompilerConfiguration.getCommandLineConfiguration().getValue());
        }
        xes.elementClose(ASMTOOL_ELEMENT);
    }

    public static void writeCustomToolConfiguration(XMLEncoderStream xes, CustomToolConfiguration customToolConfiguration) {
        if (!customToolConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(CUSTOMTOOL_ELEMENT);
        if (customToolConfiguration.getCommandLine().getModified()) {
            xes.element(CUSTOMTOOL_COMMANDLINE_ELEMENT, "" + customToolConfiguration.getCommandLine().getValue());
        }
        if (customToolConfiguration.getDescription().getModified()) {
            xes.element(CUSTOMTOOL_DESCRIPTION_ELEMENT, "" + customToolConfiguration.getDescription().getValue());
        }
        if (customToolConfiguration.getOutputs().getModified()) {
            xes.element(CUSTOMTOOL_OUTPUTS_ELEMENT, "" + customToolConfiguration.getOutputs().getValue());
        }
        if (customToolConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(CUSTOMTOOL_ADDITIONAL_DEP_ELEMENT, "" + customToolConfiguration.getAdditionalDependencies().getValue());
        }
        xes.elementClose(CUSTOMTOOL_ELEMENT);
    }

    public static void writeLinkerConfiguration(XMLEncoderStream xes, LinkerConfiguration linkerConfiguration) {
        if (!linkerConfiguration.getModified()) {
            return;
        }
        xes.elementOpen(LINKERTOOL_ELEMENT);
        if (linkerConfiguration.getOutput().getModified()) {
            xes.element(OUTPUT_ELEMENT, linkerConfiguration.getOutput().getValue());
        }
        if (linkerConfiguration.getAdditionalLibs().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xes, LINKER_ADD_LIB_ELEMENT, linkerConfiguration.getAdditionalLibs().getValue());
        }
        if (linkerConfiguration.getDynamicSearch().getModified()) {
            CommonConfigurationXMLCodec.writeDirectories(xes, LINKER_DYN_SERCH_ELEMENT, linkerConfiguration.getDynamicSearch().getValue());
        }
        if (linkerConfiguration.getStripOption().getModified()) {
            xes.element(STRIP_SYMBOLS_ELEMENT, "" + linkerConfiguration.getStripOption().getValue());
        }
        if (linkerConfiguration.getPICOption().getModified()) {
            xes.element(LINKER_KPIC_ELEMENT, "" + linkerConfiguration.getPICOption().getValue());
        }
        if (linkerConfiguration.getNorunpathOption().getModified()) {
            xes.element(LINKER_NORUNPATH_ELEMENT, "" + linkerConfiguration.getNorunpathOption().getValue());
        }
        if (linkerConfiguration.getNameassignOption().getModified()) {
            xes.element(LINKER_ASSIGN_ELEMENT, "" + linkerConfiguration.getNameassignOption().getValue());
        }
        if (linkerConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(ADDITIONAL_DEP_ELEMENT, "" + linkerConfiguration.getAdditionalDependencies().getValue());
        }
        if (linkerConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, linkerConfiguration.getTool().getValue());
        }
        if (linkerConfiguration.getLibrariesConfiguration().getModified()) {
            CommonConfigurationXMLCodec.writeLibrariesConfiguration(xes, linkerConfiguration.getLibrariesConfiguration());
        }
        if (linkerConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + linkerConfiguration.getCommandLineConfiguration().getValue());
        }
        xes.elementClose(LINKERTOOL_ELEMENT);
    }

    public static void writeLibrariesConfiguration(XMLEncoderStream xes, LibrariesConfiguration librariesConfiguration) {
        xes.elementOpen(LINKER_LIB_ITEMS_ELEMENT);
        List libraryItems = librariesConfiguration.getValue();
        for (LibraryItem item : libraryItems) {
            if (item instanceof LibraryItem.ProjectItem) {
                xes.elementOpen(LINKER_LIB_PROJECT_ITEM_ELEMENT);
                CommonConfigurationXMLCodec.writeMakeArtifact(xes, ((LibraryItem.ProjectItem)item).getMakeArtifact());
                xes.elementClose(LINKER_LIB_PROJECT_ITEM_ELEMENT);
                continue;
            }
            if (item instanceof LibraryItem.StdLibItem) {
                xes.element(LINKER_LIB_STDLIB_ITEM_ELEMENT, ((LibraryItem.StdLibItem)item).getName());
                continue;
            }
            if (item instanceof LibraryItem.LibItem) {
                xes.element(LINKER_LIB_LIB_ITEM_ELEMENT, ((LibraryItem.LibItem)item).getLibName());
                continue;
            }
            if (item instanceof LibraryItem.LibFileItem) {
                xes.element(LINKER_LIB_FILE_ITEM_ELEMENT, ((LibraryItem.LibFileItem)item).getPath());
                continue;
            }
            if (!(item instanceof LibraryItem.OptionItem)) continue;
            xes.element(LINKER_LIB_OPTION_ITEM_ELEMENT, ((LibraryItem.OptionItem)item).getLibraryOption());
        }
        xes.elementClose(LINKER_LIB_ITEMS_ELEMENT);
    }

    public static void writeRequiredProjects(XMLEncoderStream xes, RequiredProjectsConfiguration requiredProjectsConfiguration) {
        List projectItems = requiredProjectsConfiguration.getValue();
        if (!projectItems.isEmpty()) {
            xes.elementOpen(REQUIRED_PROJECTS_ELEMENT);
            for (LibraryItem.ProjectItem item : projectItems) {
                CommonConfigurationXMLCodec.writeMakeArtifact(xes, item.getMakeArtifact());
            }
            xes.elementClose(REQUIRED_PROJECTS_ELEMENT);
        }
    }

    private static void writePackaging(XMLEncoderStream xes, PackagingConfiguration packagingConfiguration) {
        if (!packagingConfiguration.isModified()) {
            return;
        }
        xes.elementOpen(PACK_ELEMENT);
        xes.element(PACK_TYPE_ELEMENT, "" + packagingConfiguration.getName());
        if (packagingConfiguration.getVerbose().getModified()) {
            xes.element(VERBOSE_ELEMENT, "" + packagingConfiguration.getVerbose().getValue());
        }
        if (packagingConfiguration.getOutput().getModified()) {
            xes.element(OUTPUT_ELEMENT, packagingConfiguration.getOutput().getValue());
        }
        if (packagingConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, packagingConfiguration.getTool().getValue());
        }
        if (packagingConfiguration.getOptions().getModified()) {
            xes.element(ADDITIONAL_OPTIONS_ELEMENT, packagingConfiguration.getOptions().getValue());
        }
        if (packagingConfiguration.getTopDir().getModified()) {
            xes.element(PACK_TOPDIR_ELEMENT, packagingConfiguration.getTopDir().getValue());
        }
        xes.elementOpen(PACK_FILES_LIST_ELEMENT);
        List<PackagerFileElement> filesList = packagingConfiguration.getFiles().getValue();
        for (PackagerFileElement elem : filesList) {
            xes.element(PACK_FILE_LIST_ELEMENT, new AttrValuePair[]{new AttrValuePair(TYPE_ATTR, "" + elem.getType().toString()), new AttrValuePair(TO_ATTR, "" + elem.getTo()), new AttrValuePair(FROM_ATTR, "" + elem.getFrom()), new AttrValuePair(PERM_ATTR, "" + elem.getPermission()), new AttrValuePair(OWNER_ATTR, "" + elem.getOwner()), new AttrValuePair(GROUP_ATTR, "" + elem.getGroup())});
        }
        xes.elementClose(PACK_FILES_LIST_ELEMENT);
        PackagerDescriptor packager = PackagerManager.getDefault().getPackager(packagingConfiguration.getType().getValue());
        if (packager.hasInfoList()) {
            xes.elementOpen(PACK_INFOS_LIST_ELEMENT);
            List<PackagerInfoElement> infoList = packagingConfiguration.getHeaderSubList(packagingConfiguration.getType().getValue());
            for (PackagerInfoElement elem : infoList) {
                xes.element(PACK_INFO_LIST_ELEMENT, new AttrValuePair[]{new AttrValuePair(NAME_ATTR, "" + elem.getName()), new AttrValuePair(VALUE_ATTR, "" + elem.getValue()), new AttrValuePair(MANDATORY_ATTR, "" + elem.isMandatory())});
            }
            xes.elementClose(PACK_INFOS_LIST_ELEMENT);
            if (!packagingConfiguration.getAdditionalInfo().getValue().isEmpty()) {
                CommonConfigurationXMLCodec.writeList(xes, PACK_ADDITIONAL_INFOS_LIST_ELEMENT, packagingConfiguration.getAdditionalInfo().getValue());
            }
        }
        xes.elementClose(PACK_ELEMENT);
    }

    public static void writeMakeArtifact(XMLEncoderStream xes, MakeArtifact makeArtifact) {
        xes.elementOpen(MAKE_ARTIFACT_ELEMENT, new AttrValuePair[]{new AttrValuePair(MAKE_ARTIFACT_PL_ELEMENT, makeArtifact.getProjectLocation()), new AttrValuePair(MAKE_ARTIFACT_CT_ELEMENT, "" + makeArtifact.getConfigurationType()), new AttrValuePair(MAKE_ARTIFACT_CN_ELEMENT, makeArtifact.getConfigurationName()), new AttrValuePair(MAKE_ARTIFACT_AC_ELEMENT, "" + makeArtifact.getActive()), new AttrValuePair(MAKE_ARTIFACT_BL_ELEMENT, "" + makeArtifact.getBuild()), new AttrValuePair(MAKE_ARTIFACT_WD_ELEMENT, makeArtifact.getWorkingDirectory()), new AttrValuePair(MAKE_ARTIFACT_BC_ELEMENT, makeArtifact.getBuildCommand()), new AttrValuePair(MAKE_ARTIFACT_CC_ELEMENT, makeArtifact.getCleanCommand()), new AttrValuePair(MAKE_ARTIFACT_OP_ELEMENT, makeArtifact.getStoredOutput())});
        xes.elementClose(MAKE_ARTIFACT_ELEMENT);
    }

    public static void writeArchiverConfiguration(XMLEncoderStream xes, ArchiverConfiguration archiverConfiguration) {
        xes.elementOpen(ARCHIVERTOOL_ELEMENT);
        if (archiverConfiguration.getOutput().getModified()) {
            xes.element(OUTPUT_ELEMENT, archiverConfiguration.getOutput().getValue());
        }
        if (archiverConfiguration.getRunRanlib().getModified()) {
            xes.element(ARCHIVERTOOL_RUN_RANLIB_ELEMENT, "" + archiverConfiguration.getRunRanlib().getValue());
        }
        if (archiverConfiguration.getVerboseOption().getModified()) {
            xes.element(ARCHIVERTOOL_VERBOSE_ELEMENT, "" + archiverConfiguration.getVerboseOption().getValue());
        }
        if (archiverConfiguration.getSupressOption().getModified()) {
            xes.element(ARCHIVERTOOL_SUPRESS_ELEMENT, "" + archiverConfiguration.getSupressOption().getValue());
        }
        if (archiverConfiguration.getAdditionalDependencies().getModified()) {
            xes.element(ADDITIONAL_DEP_ELEMENT, "" + archiverConfiguration.getAdditionalDependencies().getValue());
        }
        if (archiverConfiguration.getTool().getModified()) {
            xes.element(COMMANDLINE_TOOL_ELEMENT, "" + archiverConfiguration.getTool().getValue());
        }
        if (archiverConfiguration.getRanlibTool().getModified()) {
            xes.element(RANLIB_TOOL_ELEMENT, "" + archiverConfiguration.getRanlibTool().getValue());
        }
        if (archiverConfiguration.getCommandLineConfiguration().getModified()) {
            xes.element(COMMAND_LINE_ELEMENT, "" + archiverConfiguration.getCommandLineConfiguration().getValue());
        }
        xes.elementClose(ARCHIVERTOOL_ELEMENT);
    }

    private void writeCodeAssistanceConfiguration(XMLEncoderStream xes, CodeAssistanceConfiguration codeAssistanceConfiguration) {
        ArrayList<String> sortedList;
        xes.elementOpen(CODE_ASSISTANCE_ELEMENT);
        if (codeAssistanceConfiguration.getBuildAnalyzer().getModified()) {
            xes.element(BUILD_ANALAZYER_ELEMENT, "" + codeAssistanceConfiguration.getBuildAnalyzer().getValue());
        }
        if (codeAssistanceConfiguration.getTools().getModified()) {
            xes.element(BUILD_ANALAZYER_TOOLS_ELEMENT, "" + codeAssistanceConfiguration.getTools().getValue());
        }
        if (codeAssistanceConfiguration.getEnvironmentVariables().getModified()) {
            sortedList = new ArrayList<String>(codeAssistanceConfiguration.getEnvironmentVariables().getValue());
            Collections.sort(sortedList);
            CommonConfigurationXMLCodec.writeList(xes, CODE_ASSISTANCE_ENVIRONMENT_ELEMENT, sortedList);
        }
        if (codeAssistanceConfiguration.getTransientMacros().getModified()) {
            sortedList = new ArrayList<String>(codeAssistanceConfiguration.getTransientMacros().getValue());
            Collections.sort(sortedList);
            CommonConfigurationXMLCodec.writeList(xes, CODE_ASSISTANCE_TRANSIENT_MACROS_ELEMENT, sortedList);
        }
        xes.elementClose(CODE_ASSISTANCE_ELEMENT);
    }

    private static void writeSortedListWithConversion(XMLEncoderStream xes, String tag, List<String> list, StringConverter conv) {
        Collections.sort(list);
        CommonConfigurationXMLCodec.writeList(xes, tag, LIST_ELEMENT, list, conv);
    }

    private static void writeDirectoriesWithConversion(XMLEncoderStream xes, String tag, List<String> directories, StringConverter conv) {
        CommonConfigurationXMLCodec.writeList(xes, tag, PATH_ELEMENT, directories, conv);
    }

    private static void writeList(XMLEncoderStream xes, String tag, List<String> list) {
        CommonConfigurationXMLCodec.writeList(xes, tag, LIST_ELEMENT, list, EMPTY_CONVERTER);
    }

    private static void writeDirectories(XMLEncoderStream xes, String tag, List<String> directories) {
        CommonConfigurationXMLCodec.writeList(xes, tag, PATH_ELEMENT, directories, EMPTY_CONVERTER);
    }

    private static void writeList(XMLEncoderStream xes, String tag, String listTag, List<String> list, StringConverter conv) {
        if (list.isEmpty()) {
            return;
        }
        xes.elementOpen(tag);
        for (String entry : list) {
            xes.element(listTag, conv.convert(entry));
        }
        xes.elementClose(tag);
    }

    private boolean publicallyVisible(ConfigurationAuxObject auxObject) {
        if (auxObject instanceof ItemConfiguration) {
            return ((ItemConfiguration)auxObject).isVCSVisible();
        }
        if (auxObject instanceof FolderConfiguration) {
            return ((FolderConfiguration)auxObject).isVCSVisible();
        }
        return auxObject.shared();
    }

    private static StringConverter getMacroConverter(MakeConfiguration conf) {
        CodeAssistanceConfiguration caConf;
        if (conf != null && (caConf = conf.getCodeAssistanceConfiguration()) != null && caConf.getTransientMacros().getModified()) {
            return new MacroConverterImpl(caConf);
        }
        return EMPTY_CONVERTER;
    }

    private static StringConverter getIncludeConverter(MakeConfiguration conf) {
        CodeAssistanceConfiguration caConf;
        if (conf != null && (caConf = conf.getCodeAssistanceConfiguration()) != null && caConf.getEnvironmentVariables().getModified()) {
            return new IncludeConverterImpl(conf, caConf);
        }
        return EMPTY_CONVERTER;
    }

    private static final class MacroConverterImpl
    implements StringConverter {
        private final Map<String, String> replacements = new HashMap<String, String>();

        public MacroConverterImpl(CodeAssistanceConfiguration caConf) {
            for (String macroWithDefaultValue : caConf.getTransientMacros().getValue()) {
                int idx = macroWithDefaultValue.indexOf(61);
                if (idx < 0) {
                    System.err.println("macro without default value " + macroWithDefaultValue);
                    continue;
                }
                String prefix = macroWithDefaultValue.substring(0, idx);
                this.replacements.put(prefix, macroWithDefaultValue);
            }
        }

        @Override
        public String convert(String orig) {
            String out = orig;
            for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
                if (!orig.startsWith(entry.getKey())) continue;
                return entry.getValue();
            }
            return out;
        }
    }

    private static final class IncludeConverterImpl
    implements StringConverter {
        private final Map<String, String> replacements = new HashMap<String, String>();

        public IncludeConverterImpl(MakeConfiguration conf, CodeAssistanceConfiguration caConf) {
            Map environment = Collections.emptyMap();
            try {
                HostInfo hostInfo = HostInfoUtils.getHostInfo((ExecutionEnvironment)conf.getFileSystemHost());
                environment = hostInfo.getEnvironment();
            }
            catch (IOException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            if (!environment.isEmpty()) {
                for (String envVariableName : caConf.getEnvironmentVariables().getValue()) {
                    String toReplace = (String)environment.get(envVariableName);
                    if (toReplace != null && !toReplace.isEmpty() && CndPathUtilitities.isPathAbsolute((CharSequence)toReplace)) {
                        this.replacements.put(toReplace, "${" + envVariableName + "}");
                        toReplace = toReplace.replace('\\', '/');
                        this.replacements.put(toReplace, "${" + envVariableName + "}");
                        continue;
                    }
                    System.err.println("env Variable " + envVariableName + " with unexpected value: " + toReplace);
                }
            }
        }

        @Override
        public String convert(String orig) {
            String out = orig;
            int len = -1;
            for (Map.Entry<String, String> entry : this.replacements.entrySet()) {
                String key = entry.getKey();
                if (!orig.startsWith(key) || len >= key.length()) continue;
                len = key.length();
                out = entry.getValue() + orig.substring(len);
            }
            return out;
        }
    }

    private static interface StringConverter {
        public String convert(String var1);
    }
}

