/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.wizards;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.api.remote.HostInfoProvider;
import org.netbeans.modules.cnd.api.utils.PlatformInfo;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.MacroExpanderFactory;
import org.openide.util.Exceptions;

public final class CommonUtilities {
    private static final String ORIGIN = "$ORIGIN";

    private CommonUtilities() {
    }

    public static String getLdLibraryPath() {
        return CommonUtilities.getLdLibraryPath(ExecutionEnvironmentFactory.getLocal());
    }

    public static String getLdLibraryPath(ExecutionEnvironment eenv) {
        String ldLibraryPathName = CommonUtilities.getLdLibraryPathName(eenv);
        String paths = (String)HostInfoProvider.getEnv((ExecutionEnvironment)eenv).get(ldLibraryPathName);
        if (paths == null) {
            paths = "";
        }
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: {
                break;
            }
            case 4: {
                paths = paths + ":/usr/lib:/usr/local/lib:/Library/Frameworks:/System/Library/Frameworks";
                break;
            }
            default: {
                paths = paths + ":/lib:/usr/lib";
            }
        }
        return paths;
    }

    public static String getLdLibraryPath(MakeConfiguration activeConfiguration) {
        String ldLibraryPathName = CommonUtilities.getLdLibraryPathName(activeConfiguration);
        String ldLibPath = activeConfiguration.getProfile().getEnvironment().getenv(ldLibraryPathName);
        ExecutionEnvironment eenv = activeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        if (ldLibPath != null) {
            try {
                ldLibPath = MacroExpanderFactory.getExpander((ExecutionEnvironment)eenv).expandMacros(ldLibPath, HostInfoUtils.getHostInfo((ExecutionEnvironment)eenv).getEnvironment());
            }
            catch (Exception ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        }
        if (ldLibPath == null) {
            ldLibPath = (String)HostInfoProvider.getEnv((ExecutionEnvironment)eenv).get(ldLibraryPathName);
        }
        if (ldLibPath == null) {
            ldLibPath = "";
        }
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: {
                break;
            }
            case 4: {
                ldLibPath = ldLibPath + ":/usr/lib:/usr/local/lib:/Library/Frameworks:/System/Library/Frameworks";
                break;
            }
            default: {
                ldLibPath = ldLibPath + ":/lib:/usr/lib";
            }
        }
        return ldLibPath;
    }

    public static String addSearchPaths(String ldLibPath, List<String> searchPaths, String binary) {
        if (searchPaths == null) {
            return ldLibPath;
        }
        String separator = ":";
        binary = binary.replace('\\', '/');
        int i = binary.lastIndexOf(47);
        String binaryPath = "";
        if (i > 0) {
            binaryPath = binary.substring(0, i);
        }
        ArrayList<String> paths = new ArrayList<String>();
        for (String s : searchPaths) {
            if (s.indexOf(59) > 0) {
                separator = ";";
            }
            for (String path : s.split(separator)) {
                if (path.startsWith(ORIGIN)) {
                    path = binaryPath + path.substring(ORIGIN.length());
                } else if (path.startsWith(".")) {
                    path = binaryPath + "/" + path;
                }
                if (paths.contains(path)) continue;
                paths.add(path);
            }
        }
        if (!paths.isEmpty()) {
            StringBuilder buf = new StringBuilder(ldLibPath);
            for (String p : paths) {
                if (buf.length() > 0) {
                    buf.append(separator);
                }
                buf.append(p);
            }
            ldLibPath = buf.toString();
        }
        return ldLibPath;
    }

    private static String getLdLibraryPathName(ExecutionEnvironment eenv) {
        PlatformInfo platformInfo = PlatformInfo.getDefault((ExecutionEnvironment)eenv);
        switch (platformInfo.getPlatform()) {
            case 3: {
                return platformInfo.getPathName();
            }
            case 4: {
                return "DYLD_LIBRARY_PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }

    private static String getLdLibraryPathName(MakeConfiguration conf) {
        switch (conf.getDevelopmentHost().getBuildPlatform()) {
            case 3: {
                PlatformInfo pi = conf.getPlatformInfo();
                return pi.getPathName();
            }
            case 4: {
                return "DYLD_LIBRARY_PATH";
            }
        }
        return "LD_LIBRARY_PATH";
    }
}

