/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.runprofiles;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorSupport;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.picklist.DefaultPicklistModel;
import org.netbeans.modules.cnd.api.toolchain.PlatformTypes;
import org.netbeans.modules.cnd.api.xml.XMLDecoder;
import org.netbeans.modules.cnd.api.xml.XMLEncoder;
import org.netbeans.modules.cnd.makeproject.api.configurations.ComboStringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationAuxObject;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakefileConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.ComboStringNodeProp;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.ConsoleIntNodeProp;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.DirectoryChooserPanel;
import org.netbeans.modules.cnd.makeproject.api.runprofiles.Env;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.runprofiles.RunProfileXMLCodec;
import org.netbeans.modules.cnd.makeproject.runprofiles.ui.EnvPanel;
import org.netbeans.modules.cnd.utils.CndPathUtilitities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.util.ConnectionManager;
import org.netbeans.modules.nativeexecution.api.util.HostInfoUtils;
import org.netbeans.modules.nativeexecution.api.util.Path;
import org.netbeans.modules.remote.spi.FileSystemProvider;
import org.openide.explorer.propertysheet.ExPropertyEditor;
import org.openide.explorer.propertysheet.PropertyEnv;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.nodes.Node;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public final class RunProfile
implements ConfigurationAuxObject {
    private static final boolean NO_EXEPTION = Boolean.getBoolean("org.netbeans.modules.cnd.makeproject.api.runprofiles");
    public static final String PROFILE_ID = "runprofile";
    public static final String PROP_RUNARGS_CHANGED = "runargs-ch";
    public static final String PROP_RUNDIR_CHANGED = "rundir-ch";
    public static final String PROP_ENVVARS_CHANGED = "envvars-ch";
    public static final String PROP_RUNCOMMAND_CHANGED = "runcommand-ch";
    public static final String DEFAULT_RUN_COMMAND = "\"${OUTPUT_PATH}\"";
    private PropertyChangeSupport pcs = null;
    private boolean needSave = false;
    private RunProfile cloneOf;
    private boolean defaultProfile;
    private String baseDir;
    private String runDir;
    private boolean buildFirst;
    private Env environment;
    private ComboStringConfiguration runCommand;
    private DefaultPicklistModel runCommandPicklist;
    private StringConfiguration arguments;
    private String dorun;
    public static final int CONSOLE_TYPE_DEFAULT = 0;
    public static final int CONSOLE_TYPE_EXTERNAL = 1;
    public static final int CONSOLE_TYPE_OUTPUT_WINDOW = 2;
    public static final int CONSOLE_TYPE_INTERNAL = 3;
    private static final String[] consoleTypeNames = new String[]{RunProfile.getString("ConsoleType_External"), RunProfile.getString("ConsoleType_Output"), RunProfile.getString("ConsoleType_Internal")};
    private IntConfiguration consoleType;
    private IntConfiguration terminalType;
    private HashMap<String, String> termPaths;
    private HashMap<String, String> termOptions;
    private final int platform;
    public static final int REMOVE_INSTRUMENTATION_ASK = 0;
    public static final int REMOVE_INSTRUMENTATION_YES = 1;
    public static final int REMOVE_INSTRUMENTATION_NO = 2;
    private static final String[] removeInstrumentationNames = new String[]{RunProfile.getString("RemoveInstrumentation_Ask"), RunProfile.getString("RemoveInstrumentation_Yes"), RunProfile.getString("RemoveInstrumentation_No")};
    private IntConfiguration removeInstrumentation;
    private final MakeConfiguration makeConfiguration;
    private static final Logger LOGGER = Logger.getLogger("org.netbeans.modules.cnd.makeproject");
    private static Boolean hasTHAModule = null;

    private RunProfile(String baseDir, int platform, PropertyChangeSupport pcs, int initialConsoleType, MakeConfiguration makeConfiguration) {
        this.platform = platform;
        this.baseDir = baseDir;
        this.pcs = pcs;
        this.makeConfiguration = makeConfiguration;
        this.initializeImpl(initialConsoleType);
    }

    public RunProfile(String baseDir, int platform, MakeConfiguration makeConfiguration) {
        this(baseDir, platform, null, 2, makeConfiguration);
        CndUtils.assertNotNull((Object)baseDir, (String)"null baseDir");
    }

    public RunProfile(MakeConfiguration makeConfiguration, PropertyChangeSupport pcs) {
        this(null, PlatformTypes.getDefaultPlatform(), pcs, RunProfile.getDefaultConsoleType(), makeConfiguration);
        CndUtils.assertNotNull((Object)makeConfiguration, (String)"null makeConfiguration");
    }

    @Override
    public final void initialize() {
        this.initializeImpl(RunProfile.getDefaultConsoleType());
    }

    private void initializeImpl(int initialConsoleType) {
        this.environment = new Env();
        this.defaultProfile = false;
        this.runDir = "";
        this.runCommandPicklist = new DefaultPicklistModel(10);
        this.runCommandPicklist.addElement(DEFAULT_RUN_COMMAND);
        this.runCommand = new ComboStringConfiguration(null, DEFAULT_RUN_COMMAND, this.runCommandPicklist);
        this.arguments = new StringConfiguration(null, "");
        this.buildFirst = true;
        this.dorun = this.getDorunScript();
        this.termPaths = new HashMap();
        this.termOptions = new HashMap();
        this.consoleType = new IntConfiguration(null, initialConsoleType, consoleTypeNames, null);
        this.terminalType = new IntConfiguration(null, 0, this.setTerminalTypeNames(), null);
        this.removeInstrumentation = new IntConfiguration(null, 0, removeInstrumentationNames, null);
        this.clearChanged();
    }

    private String escapeDir(String dir) {
        String quote;
        if (dir != null && !(dir = dir.trim()).startsWith(quote = "\"")) {
            dir = quote + dir + quote;
        }
        return dir;
    }

    private String getDorunScript() {
        File file = InstalledFileLocator.getDefault().locate("bin/dorun.sh", "org.netbeans.modules.cnd", false);
        if (file != null && file.exists()) {
            return file.getAbsolutePath();
        }
        if (!NO_EXEPTION) {
            throw new IllegalStateException(RunProfile.getString("Err_MissingDorunScript"));
        }
        return null;
    }

    private boolean isWindows() {
        return this.platform == 3;
    }

    private String[] setTerminalTypeNames() {
        ArrayList<String> list = new ArrayList<String>();
        String def = RunProfile.getString("TerminalType_Default");
        list.add(def);
        if (this.isWindows()) {
            String term = RunProfile.getString("TerminalType_CommandWindow");
            list.add(term);
            this.termPaths.put(term, "cmd.exe");
            this.termPaths.put(def, "cmd.exe");
            this.termOptions.put(term, "/c start sh \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + " \" -f \"{0}\" {1} {2}");
            this.termOptions.put(def, "/c start sh \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + " \" -f \"{0}\" {1} {2}");
        } else {
            String name;
            String path = Path.getPathAsString() + ":/usr/X11/bin:/usr/X/bin:/usr/X11R6/bin:/opt/gnome/bin" + ":/usr/gnome/bin:/opt/kde/bin:/opt/kde4/bin:/opt/kde3/bin:/usr/kde/bin:/usr/openwin/bin";
            String termPath = this.searchPath(path, "gnome-terminal", "/usr/bin");
            if (termPath != null) {
                name = RunProfile.getString("TerminalType_GNOME");
                list.add(name);
                this.termPaths.put(name, termPath);
                this.termPaths.put(def, termPath);
                String opts = "--disable-factory --hide-menubar --title=\"{1} {3}\" -x \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" " + "-f \"{0}\" {1} {2}";
                this.termOptions.put(name, opts);
                this.termOptions.put(def, opts);
            }
            if ((termPath = this.searchPath(path, "konsole")) != null) {
                name = RunProfile.getString("TerminalType_KDE");
                list.add(name);
                this.termPaths.put(name, termPath);
                this.termOptions.put(name, "--workdir " + this.escapeDir(this.getBaseDir()) + " -e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                if (this.termPaths.get(def) == null) {
                    this.termPaths.put(def, termPath);
                    this.termOptions.put(def, "--workdir " + this.escapeDir(this.getBaseDir()) + " -e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                }
            }
            if ((termPath = this.searchPath(path, "xterm", Utilities.getOperatingSystem() == 8 ? "/usr/openwin/bin" : "/usr/bin")) != null) {
                name = RunProfile.getString("TerminalType_XTerm");
                list.add(name);
                this.termPaths.put(name, termPath);
                this.termOptions.put(name, "-e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                if (this.termPaths.get(def) == null) {
                    this.termPaths.put(def, termPath);
                    this.termOptions.put(def, "-e \"" + this.dorun + "\" -p \"" + RunProfile.getString("LBL_RunPrompt") + "\" -f \"{0}\" {1} {2}");
                }
            }
            if (this.termPaths.get(def) == null) {
                list.add(RunProfile.getString("TerminalType_None"));
            }
        }
        return list.toArray(new String[list.size()]);
    }

    private String searchPath(String path, String term) {
        return this.searchPath(path, term, null);
    }

    private String searchPath(final String path, final String term, String defaultPath) {
        File file;
        if (defaultPath != null && (file = new File(defaultPath, term)).exists()) {
            return file.getAbsolutePath();
        }
        final String[] patharray = new String[]{null};
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                StringTokenizer st = new StringTokenizer(path, ":");
                while (st.hasMoreTokens()) {
                    String dir = st.nextToken();
                    File file = new File(dir, term);
                    if (!file.exists()) continue;
                    patharray[0] = file.getAbsolutePath();
                    break;
                }
            }
        });
        thread.start();
        try {
            thread.join(5000L);
        }
        catch (InterruptedException ex) {
            // empty catch block
        }
        return patharray[0];
    }

    public String getTerminalPath() {
        return this.termPaths.get(this.getTerminalType().getName());
    }

    public String getTerminalOptions() {
        return this.termOptions.get(this.getTerminalType().getName());
    }

    @Override
    public boolean shared() {
        return false;
    }

    @Override
    public String getId() {
        return PROFILE_ID;
    }

    public void setCloneOf(RunProfile profile) {
        this.cloneOf = profile;
    }

    public RunProfile getCloneOf() {
        return this.cloneOf;
    }

    public boolean isDefault() {
        return this.defaultProfile;
    }

    public void setDefault(boolean b) {
        this.defaultProfile = b;
    }

    private int getArgIndex() {
        return this.getRunCommand().getValue().indexOf(" ");
    }

    private String getRunBinary() {
        int argIndex = this.getArgIndex();
        if (argIndex > 0) {
            return this.getRunCommand().getValue().substring(0, argIndex);
        }
        return this.getRunCommand().getValue();
    }

    private String getRunArgs() {
        int argIndex = this.getArgIndex();
        if (argIndex > 0) {
            return this.getRunCommand().getValue().substring(argIndex + 1);
        }
        return "";
    }

    public void setArgs(String argsFlat) {
        String runBinary = this.getRunBinary();
        String oldArgsFlat = this.getRunArgs();
        this.getRunCommand().setValue(runBinary + " " + argsFlat);
        this.arguments.setValue(argsFlat);
        if (this.pcs != null && !CndPathUtilitities.sameString((String)oldArgsFlat, (String)argsFlat)) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, oldArgsFlat, argsFlat);
        }
        this.needSave = true;
    }

    public void setArgs(String[] argsArray) {
        String argsFlat = "";
        for (int i = 0; i < argsArray.length; ++i) {
            argsFlat = argsFlat + CndPathUtilitities.quoteIfNecessary((String)argsArray[i]);
            if (i >= argsArray.length - 1) continue;
            argsFlat = argsFlat + " ";
        }
        this.setArgs(argsFlat);
    }

    public void setArgsRaw(String argsFlat) {
        String runBinary = this.getRunBinary();
        this.getRunCommand().setValue(runBinary + " " + argsFlat);
        this.needSave = true;
    }

    public String getArgsFlat() {
        if ("on".equals(System.getProperty("spro.dbxtool"))) {
            return this.getArguments();
        }
        return this.getRunArgs();
    }

    public String[] getArgsArray() {
        return Utilities.parseParameters((String)this.getArgsFlat());
    }

    public String getBaseDir() {
        if (this.baseDir != null) {
            return this.baseDir;
        }
        CndUtils.assertNotNullInConsole((Object)this.makeConfiguration, (String)"makeConfiguration");
        if (this.makeConfiguration != null) {
            return this.makeConfiguration.getSourceBaseDir();
        }
        return null;
    }

    public void setBaseDir(String baseDir) {
        assert (baseDir != null && CndPathUtilitities.isPathAbsolute((CharSequence)baseDir));
        this.baseDir = baseDir;
    }

    public String getRunDir() {
        if (this.runDir == null) {
            this.runDir = "";
        }
        return this.runDir;
    }

    public void setRunDir(String runDir) {
        if (runDir == null) {
            runDir = "";
        }
        if (this.runDir != null && this.runDir.equals(runDir)) {
            return;
        }
        this.runDir = runDir;
        if (this.pcs != null) {
            this.pcs.firePropertyChange(PROP_RUNDIR_CHANGED, null, this);
        }
        this.needSave = true;
    }

    public String getRunDirectory() {
        MakefileConfiguration mc;
        FileObject[] children;
        FileObject baseFO;
        String runDir2 = this.getRunDir();
        if (runDir2.length() == 0 && this.makeConfiguration != null && (baseFO = this.makeConfiguration.getBaseFSPath().getFileObject()) != null && (children = baseFO.getChildren()) != null && children.length == 1 && children[0].getNameExt().equals("nbproject") && (mc = this.makeConfiguration.getMakefileConfiguration()) != null) {
            return mc.getAbsBuildCommandWorkingDir();
        }
        if (runDir2.length() == 0) {
            runDir2 = ".";
        }
        runDir2 = runDir2.trim();
        if (this.makeConfiguration != null && (runDir2.startsWith("~/") || runDir2.startsWith("~\\") || runDir2.equals("~"))) {
            try {
                runDir2 = this.makeConfiguration.getDevelopmentHost().getExecutionEnvironment().isLocal() ? HostInfoUtils.getHostInfo((ExecutionEnvironment)this.makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getUserDirFile().getAbsolutePath() + runDir2.substring(1) : HostInfoUtils.getHostInfo((ExecutionEnvironment)this.makeConfiguration.getDevelopmentHost().getExecutionEnvironment()).getUserDir() + runDir2.substring(1);
            }
            catch (IOException ex) {
                Logger.getLogger(RunProfile.class.getName()).log(Level.INFO, "", ex);
            }
            catch (ConnectionManager.CancellationException ex) {
                Logger.getLogger(RunProfile.class.getName()).log(Level.INFO, "", ex);
            }
        }
        String runDirectory = CndPathUtilitities.isPathAbsolute((CharSequence)runDir2) ? runDir2 : this.getBaseDir() + "/" + runDir2;
        try {
            String canonicalDir = FileSystemProvider.getCanonicalPath((ExecutionEnvironment)this.makeConfiguration.getFileSystemHost(), (String)runDirectory);
            CndUtils.assertNotNullInConsole((Object)canonicalDir, (String)("Can not canonicalize " + runDirectory));
            if (canonicalDir == null) {
                return runDirectory;
            }
            return canonicalDir;
        }
        catch (IOException ex) {
            LOGGER.log(Level.INFO, "Exception when getting canonical run directory:", ex);
            return runDirectory;
        }
    }

    public void setRunDirectory(String newRunDir) {
        if (newRunDir == null || newRunDir.length() == 0) {
            newRunDir = ".";
        }
        this.setRunDir(CndPathUtilitities.toAbsoluteOrRelativePath((String)this.getBaseDir(), (String)newRunDir));
    }

    public void setBuildFirst(boolean buildFirst) {
        this.buildFirst = buildFirst;
    }

    public boolean getBuildFirst() {
        return this.buildFirst;
    }

    public Env getEnvironment() {
        return this.environment;
    }

    public void setEnvironment(Env env) {
        Env oldEnv = this.environment;
        this.environment = env;
        if (this.pcs != null && !this.environment.equals(oldEnv)) {
            this.pcs.firePropertyChange(PROP_ENVVARS_CHANGED, oldEnv, this.environment);
        }
    }

    public boolean isSimpleRunCommand() {
        String rc = this.runCommand.getValue().trim();
        if (rc.startsWith("\"${")) {
            return true;
        }
        return this.makeConfiguration != null && this.makeConfiguration.isLibraryConfiguration();
    }

    public ComboStringConfiguration getRunCommand() {
        return this.runCommand;
    }

    public void setRunCommand(ComboStringConfiguration runCommand) {
        String oldArgsFlat = this.getArgsFlat();
        this.runCommand = runCommand;
        String argsFlat = this.getArgsFlat();
        if (this.pcs != null && !CndPathUtilitities.sameString((String)oldArgsFlat, (String)argsFlat)) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, oldArgsFlat, argsFlat);
        }
    }

    public IntConfiguration getConsoleType() {
        return this.consoleType;
    }

    public void setConsoleType(IntConfiguration consoleType) {
        this.consoleType = consoleType;
    }

    public static int getDefaultConsoleType() {
        return 3;
    }

    public IntConfiguration getTerminalType() {
        if (this.terminalType.getName().equals(RunProfile.getString("TerminalType_None"))) {
            return null;
        }
        return this.terminalType;
    }

    public void setTerminalType(IntConfiguration terminalType) {
        this.terminalType = terminalType;
    }

    public IntConfiguration getRemoveInstrumentation() {
        return this.removeInstrumentation;
    }

    public void setRemoveInstrumentation(IntConfiguration removeInstrumentation) {
        this.removeInstrumentation = removeInstrumentation;
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.addPropertyChangeListener(l);
        }
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        if (this.pcs != null) {
            this.pcs.removePropertyChangeListener(l);
        }
    }

    @Override
    public XMLDecoder getXMLDecoder() {
        return new RunProfileXMLCodec(this);
    }

    @Override
    public XMLEncoder getXMLEncoder() {
        return new RunProfileXMLCodec(this);
    }

    @Override
    public boolean hasChanged() {
        return this.needSave;
    }

    @Override
    public void clearChanged() {
        this.needSave = false;
    }

    @Override
    public void assign(ConfigurationAuxObject profileAuxObject) {
        if (!(profileAuxObject instanceof RunProfile)) {
            System.err.print("Profile - assign: Profile object type expected - got " + profileAuxObject);
            return;
        }
        Env oldEnv = this.getEnvironment();
        String oldArgs = this.getArgsFlat();
        RunProfile p = (RunProfile)profileAuxObject;
        this.setDefault(p.isDefault());
        this.setBaseDir(p.getBaseDir());
        this.setRunDir(p.getRunDir());
        this.getRunCommand().assign(p.getRunCommand());
        this.setConfigurationArguments(p.getConfigurationArguments().clone());
        if (this.pcs != null && !CndPathUtilitities.sameString((String)oldArgs, (String)this.getArgsFlat())) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, oldArgs, this.getArgsFlat());
        }
        this.setBuildFirst(p.getBuildFirst());
        this.getEnvironment().assign(p.getEnvironment());
        if (this.pcs != null && !oldEnv.toString().equals(this.environment.toString())) {
            this.pcs.firePropertyChange(PROP_ENVVARS_CHANGED, oldEnv, this.environment);
        }
        this.getConsoleType().assign(p.getConsoleType());
        this.getTerminalType().assign(p.getTerminalType());
        this.getRemoveInstrumentation().assign(p.getRemoveInstrumentation());
    }

    @Override
    public RunProfile clone(Configuration conf) {
        RunProfile p = new RunProfile(this.getBaseDir(), this.platform, (MakeConfiguration)conf);
        p.setCloneOf(this);
        p.setDefault(this.isDefault());
        p.setRunDir(this.getRunDir());
        p.setRunCommand(this.getRunCommand().clone());
        p.setConfigurationArguments(this.getConfigurationArguments().clone());
        p.setBuildFirst(this.getBuildFirst());
        p.setEnvironment(this.getEnvironment().clone());
        p.setConsoleType(this.getConsoleType().clone());
        p.setTerminalType(this.getTerminalType().clone());
        p.setRemoveInstrumentation(this.getRemoveInstrumentation().clone());
        return p;
    }

    public Sheet getSheet(boolean disableConsoleTypeSelection) {
        return this.createSheet(disableConsoleTypeSelection);
    }

    public Sheet getSheet() {
        return this.createSheet(false);
    }

    private Sheet createSheet(boolean disableConsoleTypeSelection) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("General");
        set.setDisplayName(RunProfile.getString("GeneralName"));
        set.setShortDescription(RunProfile.getString("GeneralTT"));
        String runComboHintSuffix = null;
        ExecutionEnvironment targetEnv = this.makeConfiguration.getDevelopmentHost().getExecutionEnvironment();
        if (!this.isWindows() && HostInfoUtils.isHostInfoAvailable((ExecutionEnvironment)targetEnv)) {
            try {
                String shell = HostInfoUtils.getHostInfo((ExecutionEnvironment)targetEnv).getShell();
                if (shell != null) {
                    shell = CndPathUtilitities.getBaseName((String)shell);
                    runComboHintSuffix = NbBundle.getMessage(RunProfile.class, (String)"ShellSyntaxSupported", (Object)shell);
                }
            }
            catch (IOException ex) {
            }
            catch (ConnectionManager.CancellationException ex) {
                // empty catch block
            }
        }
        String runComboName = RunProfile.getString("RunCommandName");
        String runComboHint = RunProfile.getString("RunCommandHint");
        if (runComboHintSuffix != null) {
            runComboHint = runComboHint.concat("<br>").concat(runComboHintSuffix);
        }
        set.put((Node.Property)new ComboStringNodeProp(this.getRunCommand(), true, runComboName, runComboHint));
        set.put((Node.Property)new RunDirectoryNodeProp());
        StringNodeProp argumentsNodeprop = new StringNodeProp(this.getConfigurationArguments(), "", "Arguments", RunProfile.getString("ArgumentsName"), RunProfile.getString("ArgumentsHint"));
        set.put((Node.Property)argumentsNodeprop);
        argumentsNodeprop.setHidden(true);
        set.put((Node.Property)new EnvNodeProp());
        set.put((Node.Property)new BuildFirstNodeProp());
        ConsoleIntNodeProp consoleTypeNP = new ConsoleIntNodeProp(this.getConsoleType(), true, "ConsoleType", RunProfile.getString("ConsoleType_LBL"), RunProfile.getString("ConsoleType_HINT"));
        set.put((Node.Property)consoleTypeNP);
        final IntNodeProp terminalTypeNP = new IntNodeProp(this.getTerminalType(), true, "TerminalType", RunProfile.getString("TerminalType_LBL"), RunProfile.getString("TerminalType_HINT"));
        set.put((Node.Property)terminalTypeNP);
        if (disableConsoleTypeSelection) {
            terminalTypeNP.setCanWrite(false);
            consoleTypeNP.setCanWrite(false);
        } else {
            consoleTypeNP.addPropertyChangeListener(new PropertyChangeListener(){

                @Override
                public void propertyChange(PropertyChangeEvent evt) {
                    String value = (String)evt.getNewValue();
                    RunProfile.updateTerminalTypeState(terminalTypeNP, value);
                }
            });
            RunProfile.updateTerminalTypeState(terminalTypeNP, consoleTypeNames[(Integer)consoleTypeNP.getValue() - 1]);
        }
        if (RunProfile.thaSupportEnabled()) {
            set.put((Node.Property)new IntNodeProp(this.getRemoveInstrumentation(), true, "RemoveInstrumentation", RunProfile.getString("RemoveInstrumentation_LBL"), RunProfile.getString("RemoveInstrumentation_HINT")));
        }
        sheet.put(set);
        return sheet;
    }

    private static void updateTerminalTypeState(IntNodeProp terminalTypeNP, String value) {
        terminalTypeNP.setCanWrite(consoleTypeNames[0].equals(value));
    }

    private static String getString(String s) {
        return NbBundle.getMessage(RunProfile.class, (String)s);
    }

    private static synchronized boolean thaSupportEnabled() {
        if (hasTHAModule == null) {
            hasTHAModule = Boolean.FALSE;
            FileObject fsRoot = FileUtil.getConfigRoot();
            FileObject thaConfig = fsRoot.getFileObject("DLight/Configurations/THA");
            hasTHAModule = thaConfig != null && thaConfig.isFolder();
        }
        return hasTHAModule;
    }

    public StringConfiguration getConfigurationArguments() {
        return this.arguments;
    }

    public void setConfigurationArguments(StringConfiguration arguments) {
        this.arguments = arguments;
    }

    @Deprecated
    public String getArguments() {
        return this.arguments.getValue();
    }

    @Deprecated
    public void setArguments(String val) {
        String oldArgs = this.arguments.getValue();
        this.arguments.setValue(val);
        if (this.pcs != null && !CndPathUtilitities.sameString((String)oldArgs, (String)val)) {
            this.pcs.firePropertyChange(PROP_RUNARGS_CHANGED, oldArgs, val);
        }
    }

    private static class EnvEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private Env env;
        private PropertyEnv propenv;

        public EnvEditor(Env env) {
            this.env = env;
        }

        @Override
        public void setAsText(String text) {
        }

        @Override
        public String getAsText() {
            return this.env.toString();
        }

        @Override
        public Component getCustomEditor() {
            return new EnvPanel(this.env, this, this.propenv);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class EnvNodeProp
    extends PropertySupport<Env> {
        public EnvNodeProp() {
            super("Environment", Env.class, RunProfile.getString("EnvironmentName"), RunProfile.getString("EnvironmentHint"), true, true);
        }

        public Env getValue() {
            return RunProfile.this.getEnvironment();
        }

        public void setValue(Env v) {
            RunProfile.this.getEnvironment().assign(v);
        }

        public PropertyEditor getPropertyEditor() {
            return new EnvEditor(RunProfile.this.getEnvironment().clone());
        }

        public Object getValue(String attributeName) {
            if (attributeName.equals("canEditAsText")) {
                return Boolean.FALSE;
            }
            return super.getValue(attributeName);
        }
    }

    private class BuildFirstNodeProp
    extends PropertySupport<Boolean> {
        public BuildFirstNodeProp() {
            super("Build First", Boolean.class, RunProfile.getString("BuildFirstName"), RunProfile.getString("BuildFirstHint"), true, true);
        }

        public Boolean getValue() {
            return RunProfile.this.getBuildFirst();
        }

        public void setValue(Boolean v) {
            RunProfile.this.setBuildFirst(v);
        }
    }

    private class DirEditor
    extends PropertyEditorSupport
    implements ExPropertyEditor {
        private PropertyEnv propenv;
        private String seed;

        public DirEditor(String seed) {
            this.seed = seed;
        }

        @Override
        public void setAsText(String text) {
            RunProfile.this.setRunDir(text);
        }

        @Override
        public String getAsText() {
            return RunProfile.this.getRunDir();
        }

        @Override
        public Object getValue() {
            return RunProfile.this.getRunDir();
        }

        @Override
        public void setValue(Object v) {
            RunProfile.this.setRunDir((String)v);
        }

        @Override
        public boolean supportsCustomEditor() {
            return true;
        }

        @Override
        public Component getCustomEditor() {
            FileSystem fs = RunProfile.this.makeConfiguration == null ? CndFileUtils.getLocalFileSystem() : RunProfile.this.makeConfiguration.getSourceFileSystem();
            return new DirectoryChooserPanel(this.seed, this, this.propenv, fs);
        }

        public void attachEnv(PropertyEnv propenv) {
            this.propenv = propenv;
        }
    }

    private class RunDirectoryNodeProp
    extends PropertySupport<String> {
        public RunDirectoryNodeProp() {
            super("Run Directory", String.class, RunProfile.getString("RunDirectoryName"), RunProfile.getString("RunDirectoryHint"), true, true);
        }

        public String getValue() {
            return RunProfile.this.getRunDir();
        }

        public void setValue(String v) {
            String path = CndPathUtilitities.toAbsoluteOrRelativePath((String)RunProfile.this.getBaseDir(), (String)v);
            path = CndPathUtilitities.normalizeSlashes((String)path);
            RunProfile.this.setRunDir(path);
        }

        public PropertyEditor getPropertyEditor() {
            String runDir2 = RunProfile.this.getRunDir();
            if (runDir2.length() == 0) {
                runDir2 = ".";
            }
            String seed = CndPathUtilitities.isPathAbsolute((CharSequence)runDir2) ? runDir2 : RunProfile.this.getBaseDir() + File.separatorChar + runDir2;
            return new DirEditor(seed);
        }
    }
}

