/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class FortranCompilerConfiguration
extends BasicCompilerConfiguration
implements Cloneable {
    public FortranCompilerConfiguration(String baseDir, FortranCompilerConfiguration master) {
        super(baseDir, master);
    }

    public void assign(FortranCompilerConfiguration conf) {
        super.assign(conf);
    }

    public FortranCompilerConfiguration clone() {
        FortranCompilerConfiguration clone = new FortranCompilerConfiguration(this.getBaseDir(), (FortranCompilerConfiguration)this.getMaster());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        StringBuilder options = new StringBuilder("$(COMPILE.f) ");
        options.append(this.getAllOptions2(compiler)).append(' ');
        options.append(this.getCommandLineOptions(true));
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public String getFFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getFFlags(AbstractCompiler compiler) {
        String options = this.getFFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        String options = "";
        options = options + this.getFFlagsBasic(compiler) + " ";
        for (FortranCompilerConfiguration master = this; master != null; master = (FortranCompilerConfiguration)master.getMaster()) {
            options = options + master.getCommandLineConfiguration().getValue() + " ";
        }
        options = options + this.getAllOptions2(compiler) + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        FortranCompilerConfiguration master = (FortranCompilerConfiguration)this.getMaster();
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    public Sheet getGeneralSheet(MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler fortranCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.FortranCompiler);
        sheet.put(this.getBasicSet());
        if (this.getMaster() != null) {
            sheet.put(this.getInputSet());
        }
        if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
            Sheet.Set set2 = new Sheet.Set();
            set2.setName("OtherOptions");
            set2.setDisplayName(FortranCompilerConfiguration.getString("OtherOptionsTxt"));
            set2.setShortDescription(FortranCompilerConfiguration.getString("OtherOptionsHint"));
            set2.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", FortranCompilerConfiguration.getString("MultithreadingLevelTxt"), FortranCompilerConfiguration.getString("MultithreadingLevelHint")));
            sheet.put(set2);
        }
        Sheet.Set set4 = new Sheet.Set();
        set4.setName("Tool");
        set4.setDisplayName(FortranCompilerConfiguration.getString("ToolTxt1"));
        set4.setShortDescription(FortranCompilerConfiguration.getString("ToolHint1"));
        if (fortranCompiler != null) {
            set4.put((Node.Property)new StringNodeProp(this.getTool(), fortranCompiler.getName(), false, "Tool", FortranCompilerConfiguration.getString("ToolTxt2"), FortranCompilerConfiguration.getString("ToolHint2")));
        }
        sheet.put(set4);
        String[] texts = new String[]{FortranCompilerConfiguration.getString("AdditionalOptionsTxt1"), FortranCompilerConfiguration.getString("AdditionalOptionsHint"), FortranCompilerConfiguration.getString("AdditionalOptionsTxt2"), FortranCompilerConfiguration.getString("AllOptionsTxt")};
        Sheet.Set set2 = new Sheet.Set();
        set2.setName("CommandLine");
        set2.setDisplayName(FortranCompilerConfiguration.getString("CommandLineTxt"));
        set2.setShortDescription(FortranCompilerConfiguration.getString("CommandLineHint"));
        if (fortranCompiler != null) {
            set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, fortranCompiler, null, texts));
        }
        sheet.put(set2);
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(FortranCompilerConfiguration.class, (String)s);
    }
}

