/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.ArrayList;
import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.CustomizerRootNodeProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.PrioritizedCustomizerNode;
import org.openide.util.Lookup;

public class DebuggerChooserConfiguration
implements Cloneable {
    private static List<CustomizerNode> nodes = null;
    private static String[] names;
    private static int def;
    private int value;
    private boolean modified;
    private boolean dirty = false;

    public DebuggerChooserConfiguration(Lookup lookup) {
        DebuggerChooserConfiguration.init(lookup);
        this.reset();
    }

    public DebuggerChooserConfiguration(DebuggerChooserConfiguration conf) {
        this.value = conf.value;
        this.setModified(false);
    }

    private static void init(Lookup lookup) {
        if (nodes == null) {
            nodes = CustomizerRootNodeProvider.getInstance().getCustomizerNodes("Debug", lookup);
            String[] defnames = new String[]{""};
            if (nodes.size() >= 1) {
                int priority = -1;
                int idx = 0;
                ArrayList<String> n = new ArrayList<String>();
                for (CustomizerNode node : nodes) {
                    if (node instanceof PrioritizedCustomizerNode) {
                        if (((PrioritizedCustomizerNode)((Object)node)).getPriority() > priority) {
                            priority = ((PrioritizedCustomizerNode)((Object)node)).getPriority();
                            idx = n.size();
                        }
                    } else if (node.getClass().getName().toLowerCase().contains("dbx")) {
                        priority = 9999;
                        idx = n.size();
                    }
                    n.add(node.getDisplayName());
                }
                names = n.toArray(defnames);
                def = idx;
            } else {
                names = defnames;
                def = 0;
            }
        }
    }

    public void setValue(int value) {
        this.value = value;
        this.setModified(true);
    }

    public void setValue(String s) {
        if (s != null) {
            for (int i = 0; i < names.length; ++i) {
                if (!s.equals(names[i])) continue;
                this.setValue(i);
                break;
            }
        }
    }

    public int getValue() {
        return this.value;
    }

    public final void setModified(boolean b) {
        this.modified = b;
    }

    public boolean getModified() {
        return this.modified;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean getDirty() {
        return this.dirty;
    }

    public int getDefault() {
        return def;
    }

    public final void reset() {
        this.value = this.getDefault();
        this.setModified(false);
    }

    public String getName() {
        if (this.getValue() < names.length) {
            return names[this.getValue()];
        }
        return "???";
    }

    public CustomizerNode getNode() {
        if (this.getValue() < nodes.size()) {
            return nodes.get(this.getValue());
        }
        return null;
    }

    public String[] getNames() {
        return names;
    }

    public void assign(DebuggerChooserConfiguration conf) {
        this.dirty = this.getValue() != conf.getValue();
        this.setValue(conf.getValue());
        this.setModified(conf.getModified());
    }

    public DebuggerChooserConfiguration clone() {
        return new DebuggerChooserConfiguration(this);
    }
}

