/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.util.List;
import org.netbeans.modules.cnd.makeproject.api.configurations.BooleanConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.StringConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.BooleanNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringListNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.ui.utils.TokenizerFactory;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class CodeAssistanceConfiguration
implements Cloneable {
    private MakeConfiguration makeConfiguration;
    private BooleanConfiguration buildAnalyzer;
    private VectorConfiguration<String> transientMacros;
    private VectorConfiguration<String> environmentVariables;
    private StringConfiguration tools;
    private static final String DEFAULT_TOOLS = "gcc:c++:g++:clang:clang++:icc:icpc:ifort:gfortran:g77:g90:g95:cc:CC:ffortran:f77:f90:f95";

    public CodeAssistanceConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
        this.buildAnalyzer = new BooleanConfiguration(true);
        this.tools = new StringConfiguration(this.tools, DEFAULT_TOOLS);
        this.transientMacros = new VectorConfiguration(null);
        this.environmentVariables = new VectorConfiguration(null);
    }

    public boolean getModified() {
        return this.getBuildAnalyzer().getModified() || this.getTools().getModified() || this.getEnvironmentVariables().getModified() || this.getTransientMacros().getModified();
    }

    public void setMakeConfiguration(MakeConfiguration makeConfiguration) {
        this.makeConfiguration = makeConfiguration;
    }

    public MakeConfiguration getMakeConfiguration() {
        return this.makeConfiguration;
    }

    public void setBuildAnalyzer(BooleanConfiguration buildAnalyzer) {
        this.buildAnalyzer = buildAnalyzer;
    }

    public BooleanConfiguration getBuildAnalyzer() {
        return this.buildAnalyzer;
    }

    public void setTools(StringConfiguration tools) {
        this.tools = tools;
    }

    public StringConfiguration getTools() {
        return this.tools;
    }

    public VectorConfiguration<String> getTransientMacros() {
        return this.transientMacros;
    }

    public void setTransientMacros(VectorConfiguration<String> transientMacros) {
        this.transientMacros = transientMacros;
    }

    public VectorConfiguration<String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(VectorConfiguration<String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public void assign(CodeAssistanceConfiguration conf) {
        this.getBuildAnalyzer().assign(conf.getBuildAnalyzer());
        this.getTools().assign(conf.getTools());
        this.getTransientMacros().assign(conf.getTransientMacros());
        this.getEnvironmentVariables().assign(conf.getEnvironmentVariables());
    }

    public CodeAssistanceConfiguration clone() {
        CodeAssistanceConfiguration clone = new CodeAssistanceConfiguration(this.getMakeConfiguration());
        clone.setBuildAnalyzer(this.getBuildAnalyzer().clone());
        clone.setTools(this.getTools().clone());
        clone.setTransientMacros((VectorConfiguration<String>)this.getTransientMacros().clone());
        clone.setEnvironmentVariables((VectorConfiguration<String>)this.getEnvironmentVariables().clone());
        return clone;
    }

    public Sheet getGeneralSheet(MakeConfiguration conf) {
        Sheet sheet = new Sheet();
        Sheet.Set set = new Sheet.Set();
        set.setName("CodeAssistance");
        set.setDisplayName(CodeAssistanceConfiguration.getString("CodeAssistanceTxt"));
        set.setShortDescription(CodeAssistanceConfiguration.getString("CodeAssistanceHint"));
        set.put((Node.Property)new BooleanNodeProp(this.getBuildAnalyzer(), true, "BuildAnalyzer", CodeAssistanceConfiguration.getString("BuildAnalyzerTxt"), CodeAssistanceConfiguration.getString("BuildAnalyzerHint")));
        if (System.getProperty("cnd.buildtrace.tools") != null) {
            set.put((Node.Property)new StringNodeProp(this.getTools(), DEFAULT_TOOLS, "Tools", CodeAssistanceConfiguration.getString("ToolsTxt2"), CodeAssistanceConfiguration.getString("ToolsHint2")));
        }
        set.put((Node.Property)new StringListNodeProp(this.getTransientMacros(), null, new String[]{"transient-macros", CodeAssistanceConfiguration.getString("TransientMacrosTxt"), CodeAssistanceConfiguration.getString("TransientMacrosHint"), CodeAssistanceConfiguration.getString("TransientMacrosLbl"), null}, true, new HelpCtx("transient-macros")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        set.put((Node.Property)new StringListNodeProp(this.getEnvironmentVariables(), null, new String[]{"environment-variables", CodeAssistanceConfiguration.getString("EnvironmentVariablesTxt"), CodeAssistanceConfiguration.getString("EnvironmentVariablesHint"), CodeAssistanceConfiguration.getString("EnvironmentVariablesLbl"), null}, true, new HelpCtx("environment-variables")){

            @Override
            protected List<String> convertToList(String text) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToList(text);
            }

            @Override
            protected String convertToString(List<String> list) {
                return TokenizerFactory.DEFAULT_CONVERTER.convertToString(list);
            }
        });
        sheet.put(set);
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CodeAssistanceConfiguration.class, (String)s);
    }

    public String toString() {
        return "{buildAnalyzer=" + this.buildAnalyzer + " tools=" + this.tools + '}';
    }
}

