/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import java.beans.PropertyEditor;
import java.util.ArrayList;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.CompilerSet;
import org.netbeans.modules.cnd.api.toolchain.PredefinedToolKind;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.api.toolchain.ToolKind;
import org.netbeans.modules.cnd.makeproject.api.configurations.CCCCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.IntConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.VectorConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.ui.IntNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.CppUtils;
import org.netbeans.modules.cnd.makeproject.configurations.ui.OptionsNodeProp;
import org.netbeans.modules.cnd.makeproject.configurations.ui.StringNodeProp;
import org.netbeans.modules.cnd.makeproject.spi.configurations.AllOptionsProvider;
import org.netbeans.modules.cnd.makeproject.spi.configurations.CompileOptionsProvider;
import org.openide.nodes.Node;
import org.openide.nodes.Sheet;
import org.openide.util.NbBundle;

public class CCCompilerConfiguration
extends CCCCompilerConfiguration
implements Cloneable {
    public static final int STANDARD_DEFAULT = 0;
    public static final int STANDARD_CPP98 = 1;
    public static final int STANDARD_CPP11 = 2;
    public static final int STANDARD_INHERITED = 3;
    private static final String[] STANDARD_NAMES = new String[]{CCCompilerConfiguration.getString("STANDARD_DEFAULT"), CCCompilerConfiguration.getString("STANDARD_CPP98"), CCCompilerConfiguration.getString("STANDARD_CPP11"), CCCompilerConfiguration.getString("STANDARD_INHERITED")};
    private static final String[] STANDARD_NAMES_ROOT = new String[]{CCCompilerConfiguration.getString("STANDARD_DEFAULT"), CCCompilerConfiguration.getString("STANDARD_CPP98"), CCCompilerConfiguration.getString("STANDARD_CPP11")};
    private IntConfiguration cppStandard;

    public CCCompilerConfiguration(String baseDir, CCCompilerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
        this.cppStandard = master != null ? new IntConfiguration(null, 3, STANDARD_NAMES, null) : new IntConfiguration(null, 0, STANDARD_NAMES_ROOT, null);
    }

    public void fixupMasterLinks(CCCompilerConfiguration compilerConfiguration) {
        super.fixupMasterLinks(compilerConfiguration);
        this.getCppStandard().setMaster(compilerConfiguration.getCppStandard());
    }

    public IntConfiguration getCppStandard() {
        return this.cppStandard;
    }

    public int getCppStandardExternal() {
        switch (this.getCppStandard().getValue()) {
            case 0: {
                return NativeFileItem.LanguageFlavor.DEFAULT.toExternal();
            }
            case 1: {
                return NativeFileItem.LanguageFlavor.CPP.toExternal();
            }
            case 2: {
                return NativeFileItem.LanguageFlavor.CPP11.toExternal();
            }
            case 3: {
                return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
            }
        }
        return NativeFileItem.LanguageFlavor.UNKNOWN.toExternal();
    }

    public void setCppStandard(IntConfiguration cppStandard) {
        this.cppStandard = cppStandard;
    }

    public void setCppStandardExternal(int cppStandard) {
        if (cppStandard == NativeFileItem.LanguageFlavor.DEFAULT.toExternal()) {
            this.cppStandard.setValue(0);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.CPP.toExternal()) {
            this.cppStandard.setValue(1);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.CPP11.toExternal()) {
            this.cppStandard.setValue(2);
        } else if (cppStandard == NativeFileItem.LanguageFlavor.UNKNOWN.toExternal()) {
            this.cppStandard.setValue(3);
        }
    }

    public void assign(CCCompilerConfiguration conf) {
        super.assign(conf);
        this.getCppStandard().assign(conf.getCppStandard());
    }

    @Override
    public boolean getModified() {
        return super.getModified() || this.getCppStandard().getModified();
    }

    public boolean isCppStandardChanged() {
        return this.getCppStandard().getDirty() && this.getCppStandard().getPreviousValue() != this.getInheritedCppStandard();
    }

    public CCCompilerConfiguration clone() {
        CCCompilerConfiguration clone = new CCCompilerConfiguration(this.getBaseDir(), (CCCompilerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        clone.setMTLevel(this.getMTLevel().clone());
        clone.setLibraryLevel(this.getLibraryLevel().clone());
        clone.setStandardsEvolution(this.getStandardsEvolution().clone());
        clone.setLanguageExt(this.getLanguageExt().clone());
        clone.setIncludeDirectories((VectorConfiguration<String>)this.getIncludeDirectories().clone());
        clone.setInheritIncludes(this.getInheritIncludes().clone());
        clone.setPreprocessorConfiguration((VectorConfiguration<String>)this.getPreprocessorConfiguration().clone());
        clone.setInheritPreprocessor(this.getInheritPreprocessor().clone());
        clone.setUndefinedPreprocessorConfiguration((VectorConfiguration<String>)this.getUndefinedPreprocessorConfiguration().clone());
        clone.setInheritUndefinedPreprocessor(this.getInheritUndefinedPreprocessor().clone());
        clone.setUseLinkerLibraries(this.getUseLinkerLibraries().clone());
        clone.setCppStandard(this.getCppStandard().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        StringBuilder options = new StringBuilder("$(COMPILE.cc) ");
        options.append(this.getAllOptions2(compiler)).append(' ');
        options.append(this.getCommandLineOptions(true));
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public String getCCFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getMTLevelOptions(this.getMTLevel().getValue()) + " ";
        options = options + compiler.getLibraryLevelOptions(this.getLibraryLevel().getValue()) + " ";
        options = options + compiler.getStandardEvaluationOptions(this.getStandardsEvolution().getValue()) + " ";
        options = options + compiler.getLanguageExtOptions(this.getLanguageExt().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return CppUtils.reformatWhitespaces(options);
    }

    public String getCCFlags(AbstractCompiler compiler) {
        String options = this.getCCFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return CppUtils.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getCCFlagsBasic(compiler));
        options.append(" ");
        for (CCCompilerConfiguration master = this; master != null; master = (CCCompilerConfiguration)master.getMaster()) {
            options.append(master.getCommandLineConfiguration().getValue());
            options.append(" ");
        }
        options.append(this.getAllOptions2(compiler));
        options.append(" ");
        return CppUtils.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        if (this.getDevelopmentMode().getValue() != 3) {
            options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        }
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + this.getPreprocessorOptions(compiler.getCompilerSet());
        options = options + this.getIncludeDirectoriesOptions(compiler.getCompilerSet());
        options = options + this.getLibrariesFlags();
        options = options + compiler.getCppStandardOptions(this.getInheritedCppStandard());
        return CppUtils.reformatWhitespaces(options);
    }

    public int getInheritedCppStandard() {
        for (CCCompilerConfiguration master = this; master != null; master = (CCCompilerConfiguration)master.getMaster()) {
            if (master.getCppStandard().getValue() == 3) continue;
            return master.getCppStandard().getValue();
        }
        return 2;
    }

    public String getPreprocessorOptions(CompilerSet cs) {
        CCCompilerConfiguration master = (CCCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(null, this.getUserMacroFlag(cs));
        ArrayList<CCCompilerConfiguration> list = new ArrayList<CCCompilerConfiguration>();
        list.add(this);
        while (master != null && this.getInheritPreprocessor().getValue()) {
            list.add(master);
            if (master.getInheritPreprocessor().getValue()) {
                master = (CCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        StringBuilder options = new StringBuilder();
        for (int i = list.size() - 1; i >= 0; --i) {
            options.append(((CCCCompilerConfiguration)list.get(i)).getPreprocessorConfiguration().toString(visitor));
            options.append(' ');
        }
        return options.toString();
    }

    public String getIncludeDirectoriesOptions(CompilerSet cs) {
        CCCompilerConfiguration master = (CCCompilerConfiguration)this.getMaster();
        CCCCompilerConfiguration.OptionToString visitor = new CCCCompilerConfiguration.OptionToString(cs, this.getUserIncludeFlag(cs));
        StringBuilder options = new StringBuilder(this.getIncludeDirectories().toString(visitor));
        options.append(' ');
        ArrayList<CCCompilerConfiguration> list = new ArrayList<CCCompilerConfiguration>();
        while (master != null && this.getInheritIncludes().getValue()) {
            list.add(master);
            if (master.getInheritIncludes().getValue()) {
                master = (CCCompilerConfiguration)master.getMaster();
                continue;
            }
            master = null;
        }
        for (int i = list.size() - 1; i >= 0; --i) {
            options.append(((CCCCompilerConfiguration)list.get(i)).getIncludeDirectories().toString(visitor));
            options.append(' ');
        }
        return options.toString();
    }

    @Override
    protected String getUserIncludeFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getCpp().getUserIncludeFlag();
    }

    @Override
    protected String getUserMacroFlag(CompilerSet cs) {
        return cs.getCompilerFlavor().getToolchainDescriptor().getCpp().getUserMacroFlag();
    }

    public Sheet getSheet(MakeConfiguration conf, Folder folder, Item item) {
        String compileLine;
        AllOptionsProvider options;
        Sheet sheet = new Sheet();
        CompilerSet compilerSet = conf.getCompilerSet().getCompilerSet();
        AbstractCompiler ccCompiler = compilerSet == null ? null : (AbstractCompiler)compilerSet.getTool((ToolKind)PredefinedToolKind.CCCompiler);
        IntNodeProp standardProp = new IntNodeProp(this.getCppStandard(), true, "CPPStandard", CCCompilerConfiguration.getString("CPPStandardTxt"), CCCompilerConfiguration.getString("CPPStandardHint")){

            @Override
            public PropertyEditor getPropertyEditor() {
                if (this.intEditor == null) {
                    this.intEditor = new NewIntEditor();
                }
                return this.intEditor;
            }

            class NewIntEditor
            extends IntNodeProp.IntEditor {
                NewIntEditor() {
                    super(this);
                }

                @Override
                public String getAsText() {
                    if (CCCompilerConfiguration.this.getCppStandard().getValue() == 3) {
                        return NbBundle.getMessage(CCCompilerConfiguration.class, (String)"STANDARD_INHERITED_WITH_VALUE", (Object)STANDARD_NAMES[CCCompilerConfiguration.this.getInheritedCppStandard()]);
                    }
                    return super.getAsText();
                }
            }
        };
        Sheet.Set set0 = this.getSet(null, folder, item);
        sheet.put(set0);
        if (conf.isCompileConfiguration()) {
            Sheet.Set set2;
            if (folder == null) {
                Sheet.Set bset = this.getBasicSet();
                sheet.put(bset);
                if (compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler()) {
                    set2 = new Sheet.Set();
                    set2.setName("OtherOptions");
                    set2.setDisplayName(CCCompilerConfiguration.getString("OtherOptionsTxt"));
                    set2.setShortDescription(CCCompilerConfiguration.getString("OtherOptionsHint"));
                    set2.put((Node.Property)new IntNodeProp(this.getMTLevel(), this.getMaster() == null, "MultithreadingLevel", CCCompilerConfiguration.getString("MultithreadingLevelTxt"), CCCompilerConfiguration.getString("MultithreadingLevelHint")));
                    set2.put((Node.Property)new IntNodeProp(this.getLibraryLevel(), this.getMaster() == null, "LibraryLevel", CCCompilerConfiguration.getString("LibraryLevelTxt"), CCCompilerConfiguration.getString("LibraryLevelHint")));
                    set2.put((Node.Property)new IntNodeProp(this.getStandardsEvolution(), this.getMaster() == null, "StandardsEvolution", CCCompilerConfiguration.getString("StandardsEvolutionTxt"), CCCompilerConfiguration.getString("StandardsEvolutionHint")));
                    set2.put((Node.Property)new IntNodeProp(this.getLanguageExt(), this.getMaster() == null, "LanguageExtensions", CCCompilerConfiguration.getString("LanguageExtensionsTxt"), CCCompilerConfiguration.getString("LanguageExtensionsHint")));
                    sheet.put(set2);
                } else {
                    bset.put((Node.Property)standardProp);
                }
                if (this.getMaster() != null) {
                    sheet.put(this.getInputSet());
                }
                Sheet.Set set4 = new Sheet.Set();
                set4.setName("Tool");
                set4.setDisplayName(CCCompilerConfiguration.getString("ToolTxt1"));
                set4.setShortDescription(CCCompilerConfiguration.getString("ToolHint1"));
                if (ccCompiler != null) {
                    set4.put((Node.Property)new StringNodeProp(this.getTool(), ccCompiler.getName(), false, "Tool", CCCompilerConfiguration.getString("ToolTxt2"), CCCompilerConfiguration.getString("ToolHint2")));
                }
                sheet.put(set4);
            }
            String[] texts = new String[]{CCCompilerConfiguration.getString("AdditionalOptionsTxt1"), CCCompilerConfiguration.getString("AdditionalOptionsHint"), CCCompilerConfiguration.getString("AdditionalOptionsTxt2"), CCCompilerConfiguration.getString("AllOptionsTxt")};
            set2 = new Sheet.Set();
            set2.setName("CommandLine");
            set2.setDisplayName(CCCompilerConfiguration.getString("CommandLineTxt"));
            set2.setShortDescription(CCCompilerConfiguration.getString("CommandLineHint"));
            if (ccCompiler != null) {
                set2.put((Node.Property)new OptionsNodeProp(this.getCommandLineConfiguration(), null, this, ccCompiler, null, texts));
            }
            sheet.put(set2);
        } else if (conf.getConfigurationType().getValue() == 0 && item != null && ccCompiler != null && (options = CompileOptionsProvider.getDefault().getOptions(item)) != null && (compileLine = options.getAllOptions((Tool)ccCompiler)) != null) {
            int hasPath = compileLine.indexOf(35);
            if (hasPath >= 0) {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CommandLineTxt"), CCCompilerConfiguration.getString("CommandLineHint"), compileLine.substring(hasPath + 1)));
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CompileFolderTxt"), CCCompilerConfiguration.getString("CompileFolderHint"), compileLine.substring(0, hasPath)));
            } else {
                set0.put((Node.Property)new CCCCompilerConfiguration.StringRONodeProp(CCCompilerConfiguration.getString("CommandLineTxt"), CCCompilerConfiguration.getString("CommandLineHint"), compileLine));
            }
        }
        if (!(conf.getConfigurationType().getValue() != 0 || compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler())) {
            set0.put((Node.Property)standardProp);
        }
        if (!(conf.getConfigurationType().getValue() != 4 && conf.getConfigurationType().getValue() != 5 && conf.getConfigurationType().getValue() != 6 || compilerSet != null && compilerSet.getCompilerFlavor().isSunStudioCompiler())) {
            set0.put((Node.Property)standardProp);
        }
        return sheet;
    }

    private static String getString(String s) {
        return NbBundle.getMessage(CCCompilerConfiguration.class, (String)s);
    }
}

